/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.CommonImpl;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultConfiguration;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultExecutableBusinessProcess
extends SerialisablePluginDataContainer
implements ExecutableBusinessProcess {
    private static final long serialVersionUID = -3366486246206327210L;
    private final EBPType type;
    private ExecutionControlProperties executionControlProperties;
    private Configuration configuration;
    private Configuration testConfiguration;
    private HashMap<ActivityConstants.AccessType, HashMap<String, ProcessModelParameter>> parameters;

    public DefaultExecutableBusinessProcess(EBPType type, ExecutionControlProperties executionControlProperties, Configuration configuration, Configuration testConfiguration, Set<ProcessModelParameter> inputParameters, Set<ProcessModelParameter> outputParameters, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        ArgChecks.checkForNull((Object)type, "type");
        ArgChecks.checkForNull(executionControlProperties, "executionControlProperties");
        this.type = type;
        this.executionControlProperties = executionControlProperties;
        this.setConfiguration(configuration);
        this.setTestConfiguration(testConfiguration);
        this.parameters = new HashMap();
        this.setParameters(ActivityConstants.AccessType.READ, inputParameters);
        this.setParameters(ActivityConstants.AccessType.WRITE, outputParameters);
    }

    @Override
    public EBPType getType() {
        return this.type;
    }

    @Override
    public ExecutionControlProperties getExecutionControlProperties() {
        return this.executionControlProperties;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected void setConfiguration(Configuration configuration) {
        this.configuration = new DefaultConfiguration(configuration);
    }

    @Override
    public Configuration getTestConfiguration() {
        return this.testConfiguration;
    }

    protected void setTestConfiguration(Configuration testConfiguration) {
        this.testConfiguration = new DefaultConfiguration(testConfiguration);
    }

    @Override
    public ProcessModelParameter getParameter(String name, ActivityConstants.AccessType accessType) {
        ArgChecks.checkForNull(name, "name");
        ArgChecks.checkEnum((Object)accessType, "accessType", (Object[])ActivityConstants.AccessType.activityRelatedValues());
        return this.parameters.get((Object)accessType).get(name);
    }

    @Override
    public Set<ProcessModelParameter> getParameters(ActivityConstants.AccessType accessType) {
        ArgChecks.checkEnum((Object)accessType, "accessType", new Object[]{ActivityConstants.AccessType.READ, ActivityConstants.AccessType.WRITE});
        return new HashSet<ProcessModelParameter>(this.parameters.get((Object)accessType).values());
    }

    protected void setParameters(ActivityConstants.AccessType accessType, Collection<ProcessModelParameter> parameters) {
        ArgChecks.checkEnum((Object)accessType, "accessType", new Object[]{ActivityConstants.AccessType.READ, ActivityConstants.AccessType.WRITE});
        CommonImpl.setParameters(this.parameters, accessType, parameters);
    }
}

