/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceDeltaLayer;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class DefaultInstance
extends SerialisablePluginDataContainer
implements Instance {
    private static final long serialVersionUID = 79249683522864106L;
    private UUID instanceID;
    private UUID logID;
    private String name;
    protected boolean modified;
    private UUID baseTemplateID;
    protected Template template;
    protected Template originalTemplate;
    private QualifiedAgent supervisorAgent;
    private QualifiedAgent initiatorAgent;
    private long creationTime;
    private EBPInstanceReference parentReference;
    protected HashMap<Integer, NodeInformation> nodeState = new HashMap();

    protected DefaultInstance(Template template, UUID logID, UUID baseTemplateID, long creationTime) {
        this.template = template;
        this.logID = logID;
        this.baseTemplateID = baseTemplateID;
        this.creationTime = creationTime;
        for (Node node : template.getNodes()) {
            this.setNodeState(node.getID(), ProcessConstants.NodeState.NS_NOT_ACTIVATED);
        }
    }

    @Override
    public UUID getID() {
        return this.instanceID;
    }

    public void setID(UUID id) {
        this.instanceID = id;
    }

    @Override
    public UUID getLogID() {
        return this.logID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        ArgChecks.checkForNull(name, "name");
        this.name = name;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public UUID getBaseTemplateID() {
        return this.baseTemplateID;
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    protected void setDeltaLayer(InstanceDeltaLayer deltaLayer) {
        this.template = deltaLayer;
    }

    @Override
    public QualifiedAgent getSupervisorAgent() {
        return this.supervisorAgent;
    }

    public void setSupervisorAgent(QualifiedAgent supervisorAgentID) {
        this.supervisorAgent = supervisorAgentID;
    }

    @Override
    public QualifiedAgent getInitiatorAgent() {
        return this.initiatorAgent;
    }

    protected void setInitiatorAgent(QualifiedAgent initiatorAgent) {
        this.initiatorAgent = initiatorAgent;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public EBPInstanceReference getParentEBPReference() {
        return this.parentReference;
    }

    public void setParentEBPReference(EBPInstanceReference parentReference) {
        this.parentReference = parentReference;
    }

    @Override
    public ProcessConstants.NodeState getNodeState(int nodeID) {
        return this.getNodeInfo((int)nodeID).state;
    }

    @Override
    public int getNodeIteration(int nodeID) {
        return this.getNodeInfo((int)nodeID).iteration;
    }

    public void setNodeIteration(int nodeID, int iteration) {
        this.createNodeInfo((int)nodeID).iteration = iteration;
    }

    @Override
    public List<UUID> getNodeLWPInstanceID(int nodeID) {
        return Collections.unmodifiableList(this.getNodeInfo((int)nodeID).lwpInstanceID);
    }

    protected void addNodeLWPInstanceID(int nodeID, UUID lwpInstanceID) {
        this.createNodeInfo((int)nodeID).lwpInstanceID.add(lwpInstanceID);
    }

    protected void removeNodeLWPInstanceID(int nodeID, UUID lwpInstanceID) {
        this.createNodeInfo((int)nodeID).lwpInstanceID.remove(lwpInstanceID);
    }

    public void setNodeLWPInstanceID(int nodeID, List<UUID> lwpInstanceIDs) {
        this.createNodeInfo((int)nodeID).lwpInstanceID = lwpInstanceIDs == null ? new ArrayList() : new ArrayList<UUID>(lwpInstanceIDs);
    }

    @Override
    public ProcessConstants.EdgeState getEdgeState(int srcNodeID, int destNodeID, ProcessConstants.EdgeType edgeType) {
        Edge edge = this.template.getEdge(srcNodeID, destNodeID, edgeType);
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Invalid edge with sourceNode %s, destinationNode %s and EdgeType %s!", srcNodeID, destNodeID, edgeType.toString()));
        }
        NodeInformation startInfo = this.getNodeInfo(srcNodeID);
        switch (startInfo.state) {
            case NS_ENQUIRED: 
            case NS_COMPLETED: {
                if (this.template.getNodeType(srcNodeID) == ProcessConstants.NodeType.NT_XOR_SPLIT && this.template.getNodeCorrespondingBlockNodeID(srcNodeID) == destNodeID) {
                    int[] nArray = this.template.getSuccByEdgeType(srcNodeID, ProcessConstants.EdgeType.ET_CONTROL);
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int succID = nArray[n2];
                        if (this.getNodeState(succID) != ProcessConstants.NodeState.NS_SKIPPED && succID != destNodeID) {
                            return ProcessConstants.EdgeState.ES_FALSE;
                        }
                        ++n2;
                    }
                    return ProcessConstants.EdgeState.ES_TRUE;
                }
                if (this.template.getNodeType(srcNodeID) == ProcessConstants.NodeType.NT_XOR_SPLIT) {
                    if (this.getNodeState(destNodeID) == ProcessConstants.NodeState.NS_SKIPPED) {
                        return ProcessConstants.EdgeState.ES_FALSE;
                    }
                    return ProcessConstants.EdgeState.ES_TRUE;
                }
                if (this.template.getNodeType(srcNodeID) == ProcessConstants.NodeType.NT_ENDLOOP && this.template.getNodeCorrespondingBlockNodeID(srcNodeID) == destNodeID) {
                    if (!this.getNodeState(this.template.getSuccByEdgeType(srcNodeID, ProcessConstants.EdgeType.ET_CONTROL)[0]).equals((Object)ProcessConstants.NodeState.NS_NOT_ACTIVATED)) {
                        return ProcessConstants.EdgeState.ES_FALSE;
                    }
                    return ProcessConstants.EdgeState.ES_TRUE;
                }
                return ProcessConstants.EdgeState.ES_TRUE;
            }
            case NS_FAILED: 
            case NS_SKIPPED: {
                return ProcessConstants.EdgeState.ES_FALSE;
            }
        }
        return ProcessConstants.EdgeState.ES_NS;
    }

    @Override
    public QualifiedAgent getPerformingAgent(int nodeID) {
        return this.getNodeInfo((int)nodeID).agent;
    }

    public void setNodeAgent(int nodeID, QualifiedAgent agent) {
        this.createNodeInfo((int)nodeID).agent = agent;
    }

    protected void setPerformingAgent(int nodeID, QualifiedAgent performingAgent) {
        this.createNodeInfo((int)nodeID).agent = performingAgent;
    }

    @Override
    public ProcessConstants.ExecutionMode getExecutionMode(int nodeID) {
        return this.getNodeInfo((int)nodeID).executionMode;
    }

    protected void setExecutionMode(int nodeID, ProcessConstants.ExecutionMode executionMode) {
        this.createNodeInfo((int)nodeID).executionMode = executionMode;
    }

    protected NodeInformation getNodeInfo(int nodeID) {
        NodeInformation info = this.nodeState.get(nodeID);
        if (info == null) {
            throw new IllegalArgumentException("Invalid Node ID: " + nodeID);
        }
        return info;
    }

    protected void setNodeState(int nodeID, ProcessConstants.NodeState state) {
        this.createNodeInfo((int)nodeID).state = state;
    }

    protected NodeInformation createNodeInfo(int nodeID) {
        NodeInformation info;
        Integer nodeInteger = nodeID;
        if (this.nodeState.containsKey(nodeInteger)) {
            info = this.nodeState.get(nodeInteger);
        } else {
            info = new NodeInformation();
            this.nodeState.put(nodeInteger, info);
        }
        return info;
    }

    public static class NodeInformation
    implements Serializable {
        private static final long serialVersionUID = -3765459094647279902L;
        protected ProcessConstants.NodeState state = ProcessConstants.NodeState.NS_NOT_ACTIVATED;
        protected int iteration = 0;
        protected ArrayList<UUID> lwpInstanceID = new ArrayList();
        protected QualifiedAgent agent;
        protected ProcessConstants.ExecutionMode executionMode;
    }
}

