/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.InstanceDeltaLayer;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.StructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.StructuredDataEdge;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateDeltaLayer;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultDeltaLayer;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuredDataEdge;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DefaultInstanceDeltaLayer
extends DefaultDeltaLayer
implements InstanceDeltaLayer {
    private static final long serialVersionUID = 4875666854002453401L;
    private HashMap<String, String> attributeValues = new HashMap();
    private HashSet<String> deletedAttributeValues = new HashSet();
    private HashSet<String> changedAttributeValues = new HashSet();
    private HashMap<String, Set<String>> supportedPlugins = new HashMap();
    private HashSet<String> deletedPlugins = new HashSet();
    private HashSet<String> changedPlugins = new HashSet();
    private HashMap<String, PluginData> pluginData;
    private HashSet<String> deletedPluginData = new HashSet();
    private HashSet<String> changedPluginData = new HashSet();
    private HashMap<Integer, ProcessConstants.NodeType> nodeTypes = new HashMap();
    private String instanceNameTemplate = "";

    public DefaultInstanceDeltaLayer() {
    }

    public DefaultInstanceDeltaLayer(Template template) {
        super(template);
        this.supportedPlugins = new HashMap<String, Set<String>>(template.getSupportedPlugins());
        this.pluginData = new HashMap<String, PluginData>(template.getPluginDatas());
    }

    @Override
    public UUID getID() {
        return this.template.getID();
    }

    @Override
    public String getName() {
        return this.template.getName();
    }

    @Override
    public String getDescription() {
        return this.template.getDescription();
    }

    @Override
    public ConfigurationDescription getConfigurationDescription() {
        return this.template.getConfigurationDescription();
    }

    @Override
    public Configuration getConfiguration() {
        return this.template.getConfiguration();
    }

    @Override
    public Configuration getTestConfiguration() {
        return this.template.getTestConfiguration();
    }

    @Override
    public String getProcessType() {
        return this.template.getProcessType();
    }

    @Override
    public QualifiedAgent getSupervisorAgent() {
        return this.template.getSupervisorAgent();
    }

    @Override
    public Set<ProcessModelParameter> getParameters(ActivityConstants.AccessType accessType) {
        return null;
    }

    @Override
    public TemplateDeltaLayer getDeltaLayer() {
        return this.template.getDeltaLayer();
    }

    @Override
    public Node getNode(int nodeID) {
        if (this.deletedNodes.contains(nodeID)) {
            throw new RuntimeException("Tried to access Deleted Node");
        }
        Node node = (Node)this.nodes.get(nodeID);
        if (node != null) {
            return node;
        }
        return this.template.getNode(nodeID);
    }

    @Override
    public Edge getEdge(int srcNodeID, int destNodeID, ProcessConstants.EdgeType type) {
        StructuredEdge edge = this.findEdge(srcNodeID, destNodeID, type, this.deletedEdges);
        if (edge != null) {
            throw new RuntimeException("Tried to access Deleted Edge");
        }
        edge = this.findEdge(srcNodeID, destNodeID, type, this.newEdges);
        if (edge != null) {
            return edge.getEdge();
        }
        edge = this.findEdge(srcNodeID, destNodeID, type, this.changedEdges);
        if (edge != null) {
            return edge.getEdge();
        }
        return this.template.getEdge(srcNodeID, destNodeID, type);
    }

    @Override
    public DataElement getDataElement(int dataElementID) {
        if (this.deletedDataElements.contains(dataElementID)) {
            return null;
        }
        DataElement dataElement = (DataElement)this.dataElements.get(dataElementID);
        if (dataElement != null) {
            return dataElement;
        }
        return this.template.getDataElement(dataElementID);
    }

    @Override
    public DataEdge getDataEdge(int nodeID, int dataElementID, ActivityConstants.AccessType type) {
        StructuredDataEdge dataEdge = this.findDataEdge(nodeID, dataElementID, type, this.deletedDataEdges);
        if (dataEdge != null) {
            throw new RuntimeException("Tried to access Deleted Data Edge");
        }
        dataEdge = this.findDataEdge(nodeID, dataElementID, type, this.changedDataEdges);
        if (dataEdge != null) {
            return dataEdge.getDataEdge();
        }
        dataEdge = this.findDataEdge(nodeID, dataElementID, type, this.newDataEdges);
        if (dataEdge != null) {
            return dataEdge.getDataEdge();
        }
        return this.template.getDataEdge(nodeID, dataElementID, type);
    }

    @Override
    public DataElement getDataElement(int nodeID, int connector) {
        StructuredDataEdge dataEdge = this.findStructuredDataEdge(nodeID, connector, this.deletedDataEdges);
        if (dataEdge != null) {
            throw new RuntimeException("Tried to use Deleted Data Edge");
        }
        dataEdge = this.findStructuredDataEdge(nodeID, connector, this.changedDataEdges);
        if (dataEdge != null) {
            return this.getDataElement(dataEdge.getDataElementID());
        }
        dataEdge = this.findStructuredDataEdge(nodeID, connector, this.newDataEdges);
        if (dataEdge != null) {
            return this.getDataElement(dataEdge.getDataElementID());
        }
        return this.template.getDataElement(nodeID, connector);
    }

    private StructuredDataEdge findStructuredDataEdge(int nodeID, int connectorID, Collection<StructuredDataEdge> edgeList) {
        for (StructuredDataEdge dataEdge : edgeList) {
            if (dataEdge.getNodeID() != nodeID || dataEdge.getConnectorID() != connectorID) continue;
            return dataEdge;
        }
        return null;
    }

    private StructuredDataEdge findStructuredDataEdge(int nodeID, int connectorID, Map<StructuredDataEdge, DefaultDeltaLayer.ChangedDataEdge> edgeMap) {
        for (StructuredDataEdge structuredDataEdge : edgeMap.values()) {
            if (structuredDataEdge.getNodeID() != nodeID || structuredDataEdge.getConnectorID() != connectorID) continue;
            return structuredDataEdge;
        }
        return null;
    }

    @Override
    public Node getStartNode() {
        return this.template.getStartNode();
    }

    @Override
    public Node getEndNode() {
        return this.template.getEndNode();
    }

    @Override
    public Set<Node> getNodes() {
        HashSet<Node> nodes = new HashSet<Node>(this.template.getNodes());
        Iterator nodeIter = nodes.iterator();
        while (nodeIter.hasNext()) {
            Node node = (Node)nodeIter.next();
            if (this.deletedNodes.contains(node.getID())) {
                nodeIter.remove();
                continue;
            }
            if (!this.changedNodes.contains(node.getID())) continue;
            nodeIter.remove();
        }
        nodes.addAll(this.nodes.values());
        return Collections.unmodifiableSet(nodes);
    }

    @Override
    public Set<DataElement> getDataElements() {
        HashSet<DataElement> dataElements = new HashSet<DataElement>(this.template.getDataElements());
        Iterator dataElementIter = dataElements.iterator();
        while (dataElementIter.hasNext()) {
            DataElement dataElement = (DataElement)dataElementIter.next();
            if (this.deletedDataElements.contains(dataElement.getID())) {
                dataElementIter.remove();
                continue;
            }
            if (!this.changedDataElements.containsKey(dataElement.getID())) continue;
            dataElementIter.remove();
        }
        dataElements.addAll(this.dataElements.values());
        return Collections.unmodifiableSet(dataElements);
    }

    @Override
    public int getNodeTopologicalID(int nodeID) {
        if (this.deletedNodes.contains(nodeID)) {
            throw new RuntimeException("Tried to access Topological ID of deleted Node");
        }
        ProcessModelFactory.StructuralNodeData nodeData = (ProcessModelFactory.StructuralNodeData)this.nodeStructures.get(nodeID);
        if (nodeData != null) {
            return nodeData.getTopologicalID();
        }
        return this.template.getNodeTopologicalID(nodeID);
    }

    @Override
    public int getNodeBranchID(int nodeID) {
        if (this.deletedNodes.contains(nodeID)) {
            throw new RuntimeException("Tried to access Branch ID of deleted Node");
        }
        ProcessModelFactory.StructuralNodeData nodeData = (ProcessModelFactory.StructuralNodeData)this.nodeStructures.get(nodeID);
        if (nodeData != null) {
            return nodeData.getBranchID();
        }
        return this.template.getNodeBranchID(nodeID);
    }

    @Override
    public int getNodeSplitNodeID(int nodeID) {
        if (this.deletedNodes.contains(nodeID)) {
            throw new RuntimeException("Tried to access Split Node of deleted Node");
        }
        ProcessModelFactory.StructuralNodeData nodeData = (ProcessModelFactory.StructuralNodeData)this.nodeStructures.get(nodeID);
        if (nodeData != null) {
            return nodeData.getSplitNodeID();
        }
        return this.template.getNodeSplitNodeID(nodeID);
    }

    @Override
    public int getNodeCorrespondingBlockNodeID(int nodeID) {
        if (this.deletedNodes.contains(nodeID)) {
            throw new RuntimeException("Tried to access Corresponding Block of deleted Node");
        }
        ProcessModelFactory.StructuralNodeData nodeData = (ProcessModelFactory.StructuralNodeData)this.nodeStructures.get(nodeID);
        if (nodeData != null) {
            return nodeData.getCorrespondingBlockNodeID();
        }
        return this.template.getNodeCorrespondingBlockNodeID(nodeID);
    }

    @Override
    public Set<StructuredEdge> getEdgeStructure(ProcessConstants.EdgeType ... edgeTypes) {
        ProcessConstants.EdgeType edgeType;
        int n;
        int n2;
        ProcessConstants.EdgeType[] edgeTypeArray;
        Set<StructuredEdge> edges = this.template.getEdgeStructure(edgeTypes);
        Iterator<StructuredEdge> edgeIter = edges.iterator();
        while (edgeIter.hasNext()) {
            StructuredEdge edge = edgeIter.next();
            if (this.deletedEdges.contains(edge)) {
                edgeIter.remove();
                continue;
            }
            if (!this.changedEdges.containsKey(edge)) continue;
            edgeIter.remove();
        }
        if (edgeTypes.length == 0) {
            edges.addAll(this.newEdges);
        } else {
            for (StructuredEdge edge : this.newEdges) {
                edgeTypeArray = edgeTypes;
                n2 = edgeTypes.length;
                n = 0;
                while (n < n2) {
                    edgeType = edgeTypeArray[n];
                    if (edgeType.equals((Object)edge.getEdgeType())) {
                        edges.add(edge);
                    }
                    ++n;
                }
            }
        }
        if (edgeTypes.length == 0) {
            edges.addAll(this.changedEdges.values());
        } else {
            for (StructuredEdge edge : this.changedEdges.values()) {
                edgeTypeArray = edgeTypes;
                n2 = edgeTypes.length;
                n = 0;
                while (n < n2) {
                    edgeType = edgeTypeArray[n];
                    if (edgeType.equals((Object)edge.getEdgeType())) {
                        edges.add(edge);
                    }
                    ++n;
                }
            }
        }
        return Collections.unmodifiableSet(edges);
    }

    @Override
    public Set<StructuredDataEdge> getDataEdgeStructure() {
        HashSet<StructuredDataEdge> dataEdges = new HashSet<StructuredDataEdge>(this.template.getDataEdgeStructure());
        Iterator dataEdgeIter = dataEdges.iterator();
        while (dataEdgeIter.hasNext()) {
            StructuredDataEdge dataEdge = (StructuredDataEdge)dataEdgeIter.next();
            if (this.deletedDataEdges.contains(dataEdge)) {
                dataEdgeIter.remove();
                continue;
            }
            if (!this.changedDataEdges.containsKey(dataEdge)) continue;
            dataEdgeIter.remove();
        }
        dataEdges.addAll(this.newDataEdges);
        dataEdges.addAll(this.changedDataEdges.values());
        dataEdges.removeAll(this.deletedDataEdges);
        return Collections.unmodifiableSet(dataEdges);
    }

    @Override
    public int[] getAccessedDataElementIDsForNode(int nodeID, ActivityConstants.AccessType accessType) {
        return ProcessModelTools.integerToIntArray(this.getDataElementsForNode(nodeID, accessType));
    }

    protected Set<Integer> getDataElementsForNode(int nodeID, ActivityConstants.AccessType accessType) {
        HashSet<Integer> dataElements = new HashSet<Integer>();
        for (StructuredDataEdge edge : this.newDataEdges) {
            if (edge.getNodeID() != nodeID || edge.getDataEdgeType() != accessType || this.deletedDataEdges.contains(edge)) continue;
            dataElements.add(edge.getDataElementID());
        }
        for (StructuredDataEdge edge : this.template.getDataEdgeStructure()) {
            if (edge.getNodeID() != nodeID || edge.getDataEdgeType() != accessType || this.deletedDataEdges.contains(edge)) continue;
            dataElements.add(edge.getDataElementID());
        }
        return dataElements;
    }

    @Override
    public int[] getAccessingNodeIDsForDataElement(int dataElementID, ActivityConstants.AccessType accessType) {
        return ProcessModelTools.integerToIntArray(this.getNodesForDataElement(dataElementID, accessType));
    }

    protected List<Integer> getNodesForDataElement(int dataElementID, ActivityConstants.AccessType accessType) {
        ArrayList<Integer> nodes = new ArrayList<Integer>();
        for (StructuredDataEdge edge : this.newDataEdges) {
            if (edge.getDataElementID() != dataElementID || edge.getDataEdgeType() != accessType || this.deletedDataEdges.contains(edge)) continue;
            nodes.add(edge.getNodeID());
        }
        for (StructuredDataEdge edge : this.template.getDataEdgeStructure()) {
            if (edge.getDataElementID() != dataElementID || edge.getDataEdgeType() != accessType || this.deletedDataEdges.contains(edge)) continue;
            nodes.add(edge.getNodeID());
        }
        return nodes;
    }

    @Override
    public int[] getNodeIDsWithActivityTemplate(UUID activityTemplateVersionID) {
        int[] nodeList;
        HashSet<Integer> nodeSet = new HashSet<Integer>();
        int[] nArray = nodeList = this.template.getNodeIDsWithActivityTemplate(activityTemplateVersionID);
        int n = nodeList.length;
        int n2 = 0;
        while (n2 < n) {
            int node = nArray[n2];
            if (!this.deletedNodes.contains(node) && !this.changedNodes.contains(node)) {
                nodeSet.add(node);
            }
            ++n2;
        }
        for (Node node : this.nodes.values()) {
            Activity a;
            if (!(node.getExecutableBusinessProcess() instanceof Activity) || !(a = (Activity)node.getExecutableBusinessProcess()).getID().equals(activityTemplateVersionID) || this.deletedNodes.contains(node.getID())) continue;
            nodeSet.add(node.getID());
        }
        return ProcessModelTools.integerToIntArray(nodeSet);
    }

    @Override
    public int[] getSuccByEdgeType(int nodeID, ProcessConstants.EdgeType ... type) {
        return new int[0];
    }

    @Override
    public int[] getPredByEdgeType(int nodeID, ProcessConstants.EdgeType ... type) {
        return new int[0];
    }

    @Override
    public boolean isTransPredOf(int currentNodeID, int potentialPredecessorID, ProcessConstants.EdgeType ... edgeType) {
        return false;
    }

    @Override
    public int[] getMinBlock(Set<Node> nodes) {
        return new int[0];
    }

    @Override
    public String getUserAttributeValue(String attributeName) {
        String value = this.attributeValues.get(attributeName);
        if (value != null) {
            return value;
        }
        if (this.deletedAttributeValues.contains(attributeName)) {
            throw new IllegalArgumentException("Tried to access deleted UserAttribute");
        }
        return this.template.getUserAttributeValue(attributeName);
    }

    @Override
    public void setUserAttributeValue(String attributeName, String attributeValue) {
        if (this.changedAttributeValues.contains(attributeName)) {
            this.attributeValues.remove(attributeName);
        } else if (this.template.getUserAttributeValue(attributeName) != null) {
            this.changedAttributeValues.add(attributeName);
        }
        this.attributeValues.put(attributeName, attributeValue);
    }

    @Override
    public void removeUserAttributeValue(String attributeName) {
        this.deletedAttributeValues.add(attributeName);
        this.changedAttributeValues.remove(attributeName);
    }

    @Override
    public Map<String, String> getUserAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>(this.template.getUserAttributes());
        for (String s : this.deletedAttributeValues) {
            attributes.remove(s);
        }
        for (String s : this.changedAttributeValues) {
            attributes.remove(s);
        }
        attributes.putAll(this.attributeValues);
        return attributes;
    }

    @Override
    public PluginData getPluginData(String pluginID) {
        PluginData value = this.pluginData.get(pluginID);
        if (value != null) {
            return value;
        }
        if (this.deletedPluginData.contains(pluginID)) {
            throw new IllegalArgumentException("Tried to access deleted PluginData");
        }
        return this.template.getPluginData(pluginID);
    }

    @Override
    public Map<String, PluginData> getPluginDatas() {
        HashMap<String, PluginData> pluginDatas = new HashMap<String, PluginData>(this.template.getPluginDatas());
        for (String s : this.deletedPluginData) {
            pluginDatas.remove(s);
        }
        for (String s : this.changedPluginData) {
            pluginDatas.remove(s);
        }
        pluginDatas.putAll(this.pluginData);
        return pluginDatas;
    }

    @Override
    public Map<String, Set<String>> getSupportedPlugins() {
        HashMap<String, Set<String>> plugins = new HashMap<String, Set<String>>(this.template.getSupportedPlugins());
        for (String s : this.deletedPlugins) {
            plugins.remove(s);
        }
        for (String s : this.changedPlugins) {
            plugins.remove(s);
        }
        plugins.putAll(this.supportedPlugins);
        return plugins;
    }

    @Override
    public String getVersion() {
        return this.template.getVersion();
    }

    @Override
    public int getConnector(int nodeID, int dataElementID, ActivityConstants.AccessType dataEdgeType) {
        for (StructuredDataEdge dataEdge : this.newDataEdges) {
            if (dataEdge.getNodeID() != nodeID || dataEdge.getDataElementID() != dataElementID || dataEdge.getDataEdgeType() != dataEdgeType || this.deletedDataEdges.contains(new DefaultStructuredDataEdge(null, nodeID, dataEdge.getConnectorID(), dataElementID, dataEdgeType))) continue;
            return dataEdge.getConnectorID();
        }
        for (StructuredDataEdge dataEdge : this.template.getDataEdgeStructure()) {
            if (dataEdge.getNodeID() != nodeID || dataEdge.getDataElementID() != dataElementID || dataEdge.getDataEdgeType() != dataEdgeType || this.deletedDataEdges.contains(new DefaultStructuredDataEdge(null, nodeID, dataEdge.getConnectorID(), dataElementID, dataEdgeType))) continue;
            return dataEdge.getConnectorID();
        }
        throw new RuntimeException("DataEdge not found");
    }

    @Override
    public int[] getUnconnectedConnectors(int nodeID, ActivityConstants.AccessType dataEdgeType) {
        return new int[0];
    }

    @Override
    public int[] getDisabledConnectors(int nodeID, ActivityConstants.AccessType dataEdgeType) {
        return new int[0];
    }

    @Override
    public int getNodeIDForTopologicalID(int topologicalNodeID) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public int[] getNodeIDsInArea(int first, int last, boolean includeBlocks) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public ProcessConstants.NodeType getNodeType(int nodeID) {
        if (this.nodeTypes.containsKey(nodeID)) {
            return this.nodeTypes.get(nodeID);
        }
        return this.template.getNodeType(nodeID);
    }

    @Override
    public String getInstanceNameTemplate() {
        return this.instanceNameTemplate;
    }

    void setInstanceNameTemplate(String instanceNameTemplate) {
        this.instanceNameTemplate = instanceNameTemplate;
    }

    @Override
    public ConstraintEdge getConstraintEdge(int srcNodeID, int destNodeID) {
        StructuredConstraintEdge edge = this.findConstraintEdge(srcNodeID, destNodeID, this.deletedConstraintEdges);
        if (edge != null) {
            throw new RuntimeException("Tried to access Deleted Edge");
        }
        edge = this.findConstraintEdge(srcNodeID, destNodeID, this.newConstraintEdges);
        if (edge != null) {
            return edge.getConstraintEdge();
        }
        edge = this.findConstraintEdge(srcNodeID, destNodeID, this.changedConstraintEdges);
        if (edge != null) {
            return edge.getConstraintEdge();
        }
        return this.template.getConstraintEdge(srcNodeID, destNodeID);
    }

    @Override
    public Set<StructuredConstraintEdge> getConstraintEdgeStructure() {
        HashSet<StructuredConstraintEdge> constraintEdges = new HashSet<StructuredConstraintEdge>(this.template.getConstraintEdgeStructure());
        Iterator constraintEdgeIter = constraintEdges.iterator();
        while (constraintEdgeIter.hasNext()) {
            StructuredConstraintEdge constraintEdge = (StructuredConstraintEdge)constraintEdgeIter.next();
            if (this.deletedConstraintEdges.contains(constraintEdge)) {
                constraintEdgeIter.remove();
                continue;
            }
            if (!this.changedConstraintEdges.containsKey(constraintEdge)) continue;
            constraintEdgeIter.remove();
        }
        constraintEdges.addAll(this.newConstraintEdges);
        constraintEdges.addAll(this.changedConstraintEdges.values());
        constraintEdges.removeAll(this.deletedConstraintEdges);
        return Collections.unmodifiableSet(constraintEdges);
    }
}

