/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class DefaultNode
extends SerialisablePluginDataContainer
implements Node {
    private static final long serialVersionUID = -3469503452594832426L;
    private int ID = 0;
    private String name = "";
    private UUID iconID;
    private String description = "";
    private String staffAssignmentRule;
    private ExecutableBusinessProcess process;
    HashMap<String, Integer> readingParameterConnectorMap = new HashMap();
    HashMap<String, Integer> writingParameterConnectorMap = new HashMap();
    HashMap<String, Integer> systemReadingParameterConnectorMap = new HashMap();
    HashMap<String, Integer> systemWritingParameterConnectorMap = new HashMap();
    private HashMap<String, ProcessModelParameter> systemReadParameters = new HashMap();
    private HashMap<String, ProcessModelParameter> systemWriteParameters = new HashMap();
    private transient Logger logger;
    private boolean autoStart;

    public DefaultNode(int id, String name) {
        this(id, name, "");
    }

    public DefaultNode(int id, String name, String description) {
        this(id, name, description, "");
    }

    public DefaultNode(int id, String name, String description, String staffAssignmentRule) {
        this.setName(name);
        this.setID(id);
        this.setDescription(description);
        this.setStaffAssignmentRule(staffAssignmentRule);
    }

    @Override
    public int getID() {
        return this.ID;
    }

    void setID(int id) {
        this.ID = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public UUID getIconID() {
        if (this.iconID == null && this.process != null && this.process instanceof Activity) {
            return ((Activity)this.process).getIconID();
        }
        return this.iconID;
    }

    void setIconID(UUID iconID) {
        this.iconID = iconID;
    }

    @Override
    public ExecutableBusinessProcess getExecutableBusinessProcess() {
        return this.process;
    }

    void setExecutableBusinessProcess(ExecutableBusinessProcess process) {
        this.process = process;
    }

    void mapParameter(ActivityConstants.AccessType type, String name, int connector) {
        this.getParameterConnectorMapFor(type).put(name, connector);
    }

    void unmapParameter(ActivityConstants.AccessType type, String name) {
        this.getParameterConnectorMapFor(type).remove(name);
    }

    private Map<String, Integer> getParameterConnectorMapFor(ActivityConstants.AccessType type) {
        switch (type) {
            case READ: {
                return this.readingParameterConnectorMap;
            }
            case WRITE: {
                return this.writingParameterConnectorMap;
            }
            case SYSTEM_READ: {
                return this.systemReadingParameterConnectorMap;
            }
            case SYSTEM_WRITE: {
                return this.systemWritingParameterConnectorMap;
            }
        }
        throw new AssertionError((Object)"An unknown access type was found!");
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.name + ", ID: " + this.ID;
    }

    @Override
    public int getConnector(String parameterName, ActivityConstants.AccessType accessType) {
        Map<String, Integer> map = this.getParameterConnectorMapFor(accessType);
        if (!map.containsKey(parameterName)) {
            return Integer.MIN_VALUE;
        }
        return map.get(parameterName);
    }

    @Override
    public Map<String, Integer> getConnectorMapping(ActivityConstants.AccessType accessType) {
        return Collections.unmodifiableMap(this.getParameterConnectorMapFor(accessType));
    }

    @Override
    public String getParameterName(int connectorID) {
        for (String parameterName : this.readingParameterConnectorMap.keySet()) {
            if (connectorID != this.readingParameterConnectorMap.get(parameterName)) continue;
            return parameterName;
        }
        for (String parameterName : this.writingParameterConnectorMap.keySet()) {
            if (connectorID != this.writingParameterConnectorMap.get(parameterName)) continue;
            return parameterName;
        }
        for (String parameterName : this.systemReadingParameterConnectorMap.keySet()) {
            if (connectorID != this.systemReadingParameterConnectorMap.get(parameterName)) continue;
            return parameterName;
        }
        for (String parameterName : this.systemWritingParameterConnectorMap.keySet()) {
            if (connectorID != this.systemWritingParameterConnectorMap.get(parameterName)) continue;
            return parameterName;
        }
        String message = String.format("The Node '%s' has no Parameter connected with connector ID '%d'.", this, connectorID);
        this.getLogger().severe(message);
        throw new IllegalArgumentException(message);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getStaffAssignmentRule() {
        return this.staffAssignmentRule;
    }

    void setStaffAssignmentRule(String staffAssignmentRule) {
        this.staffAssignmentRule = staffAssignmentRule;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerTools.getLogger(this);
        }
        return this.logger;
    }

    @Override
    public ProcessModelParameter getSystemParameter(String paramName, ActivityConstants.AccessType accessType) {
        ProcessModelParameter param;
        switch (accessType) {
            case SYSTEM_READ: {
                param = this.systemReadParameters.get(paramName);
                break;
            }
            case SYSTEM_WRITE: {
                param = this.systemWriteParameters.get(paramName);
                break;
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
        return param;
    }

    @Override
    public Set<ProcessModelParameter> getSystemParameters(ActivityConstants.AccessType accessType) {
        HashSet<Object> params;
        switch (accessType) {
            case SYSTEM_READ: {
                if (this.systemReadParameters.size() > 0) {
                    params = new HashSet<ProcessModelParameter>(this.systemReadParameters.values());
                    break;
                }
                params = new HashSet();
                break;
            }
            case SYSTEM_WRITE: {
                if (this.systemWriteParameters.size() > 0) {
                    params = new HashSet<ProcessModelParameter>(this.systemWriteParameters.values());
                    break;
                }
                params = new HashSet();
                break;
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
        return Collections.unmodifiableSet(params);
    }

    void addSystemParameter(ActivityConstants.AccessType accessType, ProcessModelParameter param) {
        switch (accessType) {
            case SYSTEM_READ: {
                this.systemReadParameters.put(param.getName(), param);
                break;
            }
            case SYSTEM_WRITE: {
                this.systemWriteParameters.put(param.getName(), param);
                break;
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
    }

    void removeSystemParameter(String paramName, ActivityConstants.AccessType accessType) {
        switch (accessType) {
            case SYSTEM_READ: {
                this.systemReadParameters.remove(paramName);
                break;
            }
            case SYSTEM_WRITE: {
                this.systemWriteParameters.remove(paramName);
                break;
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
    }

    @Override
    public boolean isAutoStartEnabled() {
        return this.autoStart;
    }

    void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.logger = LoggerTools.getLogger(this);
    }
}

