/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import java.io.Serializable;

public class DefaultStructuredEdge
implements StructuredEdge,
Serializable {
    private static final long serialVersionUID = -4722935139432091436L;
    private Edge edge;
    private int sourceNodeID;
    private int destinationNodeID;
    private ProcessConstants.EdgeType type;

    public DefaultStructuredEdge(Edge edge, int sourceNodeID, int destinationNodeID) {
        this.edge = edge;
        this.sourceNodeID = sourceNodeID;
        this.destinationNodeID = destinationNodeID;
        this.type = edge.getType();
    }

    @Deprecated
    public DefaultStructuredEdge(Edge edge, int sourceNodeID, int destinationNodeID, ProcessConstants.EdgeType type) {
        this.edge = edge;
        this.sourceNodeID = sourceNodeID;
        this.destinationNodeID = destinationNodeID;
        this.type = type;
    }

    @Override
    public Edge getEdge() {
        return this.edge;
    }

    @Override
    public int getSourceNodeID() {
        return this.sourceNodeID;
    }

    @Override
    public int getDestinationNodeID() {
        return this.destinationNodeID;
    }

    @Override
    public ProcessConstants.EdgeType getEdgeType() {
        return this.type;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof DefaultStructuredEdge)) {
            return false;
        }
        DefaultStructuredEdge edge = (DefaultStructuredEdge)arg0;
        if (edge.type != this.type) {
            return false;
        }
        if (edge.sourceNodeID != this.sourceNodeID) {
            return false;
        }
        return edge.destinationNodeID == this.destinationNodeID;
    }

    public int hashCode() {
        return (this.sourceNodeID * 128 + this.destinationNodeID) * 128 + this.type.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.getSourceNodeID() + " -> " + this.getDestinationNodeID() + ", Edge #:" + this.getEdge();
    }
}

