/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultConfiguration;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultConfigurationDescription;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.CommonConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.StructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.StructuredDataEdge;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateDeltaLayer;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultDataElementComparator;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultNodeComparator;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuralNodeData;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuredConstraintEdgeComparator;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuredDataEdge;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuredDataEdgeComparator;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuredEdge;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuredEdgeComparator;
import de.aristaflow.adept2.model.processmodel.tools.ProcessGraphPredicates;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

public class DefaultTemplate
extends SerialisablePluginDataContainer
implements Template {
    private static final long serialVersionUID = 8764055409395539242L;
    private UUID id = CommonConstants.UUID_NOT_EXISTING;
    private String name = "";
    private String description = "";
    private ConfigurationDescription configurationDescription;
    private Configuration configuration;
    private Configuration testConfiguration;
    private String processType = "";
    private String instanceNameTemplate = "";
    private HashSet<ProcessModelParameter> inputParameters = new HashSet();
    private HashSet<ProcessModelParameter> outputParameters = new HashSet();
    HashMap<Integer, Node> nodes = new HashMap();
    HashMap<Integer, List<Integer>> nodeDisabledConnectors = new HashMap();
    HashMap<Integer, ProcessModelFactory.StructuralNodeData> nodeStructure = new HashMap();
    HashMap<Integer, DataElement> dataElements = new HashMap();
    ArrayList<StructuredEdge> edges = new ArrayList();
    HashMap<Integer, Set<StructuredEdge>> nodeToEdge = new HashMap();
    ArrayList<StructuredDataEdge> dataEdges = new ArrayList();
    ArrayList<StructuredConstraintEdge> constraintEdges = new ArrayList();
    private QualifiedAgent supervisorAgent;
    private TemplateDeltaLayer deltaLayer;
    int startNodeID;
    int endNodeID;
    private String version = "";
    int[] topIDToNodeID;

    public DefaultTemplate(UUID id, String name, String description, ConfigurationDescription configurationDescription, Configuration configuration, Configuration testConfiguration) {
        this.setID(id);
        this.setName(name);
        this.setDescription(description);
        if (configurationDescription != null) {
            this.setConfigurationDescription(configurationDescription);
        } else {
            this.setConfigurationDescription(new DefaultConfigurationDescription(new HashMap<String, ConfigurationDescription.ConfigurationEntry>()));
        }
        if (configuration != null) {
            this.setConfiguration(configuration);
        } else {
            this.setConfiguration(new DefaultConfiguration(new HashMap<String, String>(), new HashSet<String>()));
        }
        if (testConfiguration != null) {
            this.setTestConfiguration(testConfiguration);
        } else {
            this.setTestConfiguration(new DefaultConfiguration(new HashMap<String, String>(), new HashSet<String>()));
        }
    }

    @Deprecated
    public DefaultTemplate() {
    }

    @Override
    public UUID getID() {
        return this.id;
    }

    void setID(UUID id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    @Override
    public ConfigurationDescription getConfigurationDescription() {
        return this.configurationDescription;
    }

    void setConfigurationDescription(ConfigurationDescription desc) {
        ArgChecks.checkForNull(desc, "configurationDescription");
        this.configurationDescription = desc;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    void setConfiguration(Configuration conf) {
        ArgChecks.checkForNull(conf, "configuration");
        this.configuration = conf;
    }

    @Override
    public Configuration getTestConfiguration() {
        return this.testConfiguration;
    }

    void setTestConfiguration(Configuration conf) {
        ArgChecks.checkForNull(conf, "testConfiguration");
        this.testConfiguration = conf;
    }

    @Override
    public String getProcessType() {
        return this.processType;
    }

    void setProcessType(String processType) {
        this.processType = processType;
    }

    @Override
    public QualifiedAgent getSupervisorAgent() {
        return this.supervisorAgent;
    }

    void setSupervisorAgent(QualifiedAgent supervisorAgent) {
        this.supervisorAgent = supervisorAgent;
    }

    @Override
    public TemplateDeltaLayer getDeltaLayer() {
        return this.deltaLayer;
    }

    void setDeltaLayer(TemplateDeltaLayer deltaLayer) {
        this.deltaLayer = deltaLayer;
    }

    @Override
    public Node getNode(int nodeID) {
        return this.nodes.get(nodeID);
    }

    ProcessModelFactory.StructuralNodeData getStructureNode(int nodeID) {
        if (!this.nodeStructure.containsKey(nodeID)) {
            throw new IllegalArgumentException("Invalid nodeID: " + nodeID);
        }
        return this.nodeStructure.get(nodeID);
    }

    @Override
    public Edge getEdge(int srcNodeID, int destNodeID, ProcessConstants.EdgeType type) {
        for (StructuredEdge edge : this.getEdgeSet(srcNodeID)) {
            if (edge.getSourceNodeID() != srcNodeID || edge.getDestinationNodeID() != destNodeID || edge.getEdge().getType() != type) continue;
            return edge.getEdge();
        }
        return null;
    }

    @Override
    public DataElement getDataElement(int dataElementID) {
        if (this.dataElements.containsKey(dataElementID)) {
            return this.dataElements.get(dataElementID);
        }
        return null;
    }

    @Override
    public DataEdge getDataEdge(int nodeID, int dataElementID, ActivityConstants.AccessType type) {
        StructuredDataEdge sde = this.getStructuredDataEdge(nodeID, dataElementID, type);
        if (sde == null) {
            return null;
        }
        return sde.getDataEdge();
    }

    @Override
    public DataElement getDataElement(int nodeID, int connector) {
        for (StructuredDataEdge edge : this.dataEdges) {
            if (edge.getNodeID() != nodeID || edge.getConnectorID() != connector) continue;
            return this.getDataElement(edge.getDataElementID());
        }
        return null;
    }

    @Override
    public Node getStartNode() {
        return this.getNode(this.startNodeID);
    }

    void setEndNodeID(int endNodeID) {
        this.endNodeID = endNodeID;
    }

    @Override
    public Node getEndNode() {
        return this.getNode(this.endNodeID);
    }

    void setStartNodeID(int startNodeID) {
        this.startNodeID = startNodeID;
    }

    @Override
    public Set<Node> getNodes() {
        TreeSet<Node> result = new TreeSet<Node>(new DefaultNodeComparator());
        result.addAll(this.nodes.values());
        if (result.size() != this.nodes.values().size()) {
            throw new Error("Template.getNodes could not return all Nodes! There could be a problem with the DefaultNodeComparator!");
        }
        return result;
    }

    @Override
    public Set<DataElement> getDataElements() {
        TreeSet<DataElement> result = new TreeSet<DataElement>(new DefaultDataElementComparator());
        result.addAll(this.dataElements.values());
        if (result.size() != this.dataElements.values().size()) {
            throw new Error("Template.getDataElements could not return all DataElements! There could be a problem with the DefaultDataElementComparator!");
        }
        return result;
    }

    @Override
    public ProcessConstants.NodeType getNodeType(int nodeID) {
        return this.getStructureNode(nodeID).getNodeType();
    }

    @Override
    public int getNodeTopologicalID(int nodeID) {
        return this.getStructureNode(nodeID).getTopologicalID();
    }

    void setTopologicalID(int nodeID, int topologicalID) {
        ((DefaultStructuralNodeData)this.getStructureNode(nodeID)).setTopologicalID(topologicalID);
    }

    @Override
    public int getNodeIDForTopologicalID(int topologicalNodeID) {
        return this.topIDToNodeID[topologicalNodeID];
    }

    @Override
    public int getNodeBranchID(int nodeID) {
        return this.getStructureNode(nodeID).getBranchID();
    }

    void setBranchID(int nodeID, int branchID) {
        ((DefaultStructuralNodeData)this.getStructureNode(nodeID)).setBranchID(branchID);
    }

    @Override
    public int getNodeSplitNodeID(int nodeID) {
        if (nodeID == this.startNodeID || nodeID == this.endNodeID) {
            return Integer.MIN_VALUE;
        }
        return this.getStructureNode(nodeID).getSplitNodeID();
    }

    void setSplitNode(int nodeID, int splitNodeID) {
        ((DefaultStructuralNodeData)this.getStructureNode(nodeID)).setSplitNodeID(splitNodeID);
    }

    @Override
    public int getNodeCorrespondingBlockNodeID(int nodeID) {
        return this.getStructureNode(nodeID).getCorrespondingBlockNodeID();
    }

    void setCorrespondingBlockNode(int nodeID, int correspondingNodeID) {
        ((DefaultStructuralNodeData)this.getStructureNode(nodeID)).setCorrespondingBlockNodeID(correspondingNodeID);
        ((DefaultStructuralNodeData)this.getStructureNode(correspondingNodeID)).setCorrespondingBlockNodeID(nodeID);
    }

    @Override
    public int[] getAccessedDataElementIDsForNode(int nodeID, ActivityConstants.AccessType accessType) {
        HashSet<DataElement> set = new HashSet<DataElement>();
        for (StructuredDataEdge edge : this.dataEdges) {
            if (edge.getNodeID() != nodeID || edge.getDataEdgeType() != accessType) continue;
            set.add(this.getDataElement(edge.getDataElementID()));
        }
        return ProcessModelTools.intArrayDataElement(set);
    }

    @Override
    public int[] getAccessingNodeIDsForDataElement(int dataElementID, ActivityConstants.AccessType accessType) {
        return this.getNodesForDataElement(dataElementID, accessType);
    }

    int[] getNodesForDataElement(int dataElementID, ActivityConstants.AccessType accessType) {
        HashSet<Node> set = new HashSet<Node>();
        for (StructuredDataEdge edge : this.dataEdges) {
            if (edge.getDataElementID() != dataElementID || edge.getDataEdgeType() != accessType) continue;
            set.add(this.getNode(edge.getNodeID()));
        }
        return ProcessModelTools.intArrayNode(set);
    }

    @Override
    public int[] getNodeIDsWithActivityTemplate(UUID activityTemplateVersionID) {
        HashSet<Node> set = new HashSet<Node>();
        for (Node node : this.nodes.values()) {
            ExecutableBusinessProcess proc = node.getExecutableBusinessProcess();
            if (!(proc instanceof Activity) || !((Activity)proc).getID().equals(activityTemplateVersionID)) continue;
            set.add(node);
        }
        return ProcessModelTools.intArrayNode(set);
    }

    @Override
    public int[] getSuccByEdgeType(int node, ProcessConstants.EdgeType ... type) {
        HashSet<Integer> succNodes = new HashSet<Integer>();
        for (StructuredEdge edge : this.getEdgeSet(node)) {
            if (edge.getSourceNodeID() != node || !this.typeMatches(edge.getEdge(), type)) continue;
            succNodes.add(edge.getDestinationNodeID());
        }
        return ProcessModelTools.integerToIntArray(succNodes);
    }

    Set<ProcessModelFactory.StructuralNodeData> getSuccStructureNodes(int node, ProcessConstants.EdgeType ... types) {
        HashSet<ProcessModelFactory.StructuralNodeData> set = new HashSet<ProcessModelFactory.StructuralNodeData>();
        for (StructuredEdge edge : this.getEdgeSet(node)) {
            if (edge.getSourceNodeID() != node || !this.typeMatches(edge.getEdge(), types)) continue;
            set.add(this.getStructureNode(edge.getDestinationNodeID()));
        }
        return set;
    }

    boolean typeMatches(Edge element, ProcessConstants.EdgeType ... types) {
        ProcessConstants.EdgeType[] edgeTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.EdgeType et = edgeTypeArray[n2];
            if (element.getType() == et) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public int[] getPredByEdgeType(int nodeID, ProcessConstants.EdgeType ... type) {
        HashSet<Integer> predNodeSet = new HashSet<Integer>();
        for (StructuredEdge edge : this.getEdgeSet(nodeID)) {
            if (edge.getDestinationNodeID() != nodeID || !this.typeMatches(edge.getEdge(), type)) continue;
            predNodeSet.add(edge.getSourceNodeID());
        }
        return ProcessModelTools.integerToIntArray(predNodeSet);
    }

    Set<ProcessModelFactory.StructuralNodeData> getPredStructureNodes(int node, ProcessConstants.EdgeType ... types) {
        HashSet<ProcessModelFactory.StructuralNodeData> set = new HashSet<ProcessModelFactory.StructuralNodeData>();
        for (StructuredEdge edge : this.getEdgeSet(node)) {
            if (edge.getDestinationNodeID() != node || !this.typeMatches(edge.getEdge(), types)) continue;
            set.add(this.getStructureNode(edge.getSourceNodeID()));
        }
        return set;
    }

    @Override
    public boolean isTransPredOf(int currentNodeID, int potentialPredecessorID, ProcessConstants.EdgeType ... edgeType) {
        if (edgeType.length > 2) {
            throw new IllegalArgumentException("Edge type combination not supported");
        }
        ProcessConstants.EdgeType[] edgeTypeArray = edgeType;
        int n = edgeType.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.EdgeType e = edgeTypeArray[n2];
            if (!e.equals((Object)ProcessConstants.EdgeType.ET_CONTROL) && !e.equals((Object)ProcessConstants.EdgeType.ET_SYNC)) {
                throw new IllegalArgumentException("Edge type not supported");
            }
            ++n2;
        }
        boolean isPredOf = false;
        if (this.getNodeType(potentialPredecessorID).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW)) {
            return true;
        }
        if (edgeType.length == 1 && edgeType[0].equals((Object)ProcessConstants.EdgeType.ET_CONTROL)) {
            int branchID;
            if (this.getNodeTopologicalID(potentialPredecessorID) > this.getNodeTopologicalID(currentNodeID)) {
                return false;
            }
            if (this.getNodeBranchID(currentNodeID) == this.getNodeBranchID(potentialPredecessorID)) {
                return true;
            }
            HashMap<Integer, Integer> splitNodesOfCurrentNodeID = new HashMap<Integer, Integer>();
            int currentSplitNode = currentNodeID;
            do {
                branchID = this.getNodeBranchID(currentSplitNode);
                if ((currentSplitNode = this.getNodeSplitNodeID(currentSplitNode)) == potentialPredecessorID) {
                    return true;
                }
                splitNodesOfCurrentNodeID.put(currentSplitNode, branchID);
            } while (!this.getNodeType(currentSplitNode).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW));
            currentSplitNode = potentialPredecessorID;
            do {
                branchID = this.getNodeBranchID(currentSplitNode);
                if (!splitNodesOfCurrentNodeID.containsKey(currentSplitNode = this.getNodeSplitNodeID(currentSplitNode))) continue;
                int branchIDSplitWasReachedFrom = (Integer)splitNodesOfCurrentNodeID.get(currentSplitNode);
                return branchIDSplitWasReachedFrom == branchID;
            } while (!this.getNodeType(currentSplitNode).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW));
        } else {
            Set<Integer> transPreds = ProcessGraphPredicates.pred_trans(this, currentNodeID);
            return transPreds.contains(potentialPredecessorID);
        }
        return isPredOf;
    }

    @Override
    public int[] getMinBlock(Set<Node> nodes) {
        int maxNodeID;
        int[] result = new int[]{-1, -1};
        if (nodes.isEmpty()) {
            return new int[0];
        }
        int minNodeID = maxNodeID = nodes.iterator().next().getID();
        for (Node node : nodes) {
            if (this.getNodeTopologicalID(node.getID()) > this.getNodeTopologicalID(maxNodeID)) {
                maxNodeID = node.getID();
            }
            if (this.getNodeTopologicalID(node.getID()) >= this.getNodeTopologicalID(minNodeID)) continue;
            minNodeID = node.getID();
        }
        if (this.getNodeBranchID(minNodeID) == this.getNodeBranchID(maxNodeID)) {
            result[0] = minNodeID;
            result[1] = maxNodeID;
            return result;
        }
        if (minNodeID == 0 || maxNodeID == 1) {
            result[0] = 0;
            result[1] = 1;
            return result;
        }
        HashMap<Integer, Integer> splitNodesOfMinNodeID = new HashMap<Integer, Integer>();
        int currentSplitNode = minNodeID;
        HashMap<Integer, Integer> branchIDsOfSplitNodes = new HashMap<Integer, Integer>();
        do {
            int branchID = this.getNodeBranchID(currentSplitNode);
            currentSplitNode = this.getNodeSplitNodeID(currentSplitNode);
            splitNodesOfMinNodeID.put(currentSplitNode, branchID);
            branchIDsOfSplitNodes.put(this.getNodeBranchID(currentSplitNode), currentSplitNode);
        } while (!this.getNodeType(currentSplitNode).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW));
        currentSplitNode = maxNodeID;
        do {
            int oldSplitNode = currentSplitNode;
            currentSplitNode = this.getNodeSplitNodeID(currentSplitNode);
            if (this.getNodeBranchID(minNodeID) == this.getNodeBranchID(currentSplitNode)) {
                result[0] = minNodeID;
                result[1] = this.getNodeCorrespondingBlockNodeID(currentSplitNode);
                break;
            }
            if (branchIDsOfSplitNodes.containsKey(this.getNodeBranchID(oldSplitNode))) {
                result[0] = (Integer)branchIDsOfSplitNodes.get(this.getNodeBranchID(oldSplitNode));
                if (maxNodeID == oldSplitNode) {
                    result[1] = oldSplitNode;
                    break;
                }
                result[1] = this.getNodeCorrespondingBlockNodeID(oldSplitNode);
                break;
            }
            if (!splitNodesOfMinNodeID.containsKey(currentSplitNode)) continue;
            result[0] = currentSplitNode;
            result[1] = this.getNodeCorrespondingBlockNodeID(currentSplitNode);
            break;
        } while (!this.getNodeType(currentSplitNode).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW));
        return result;
    }

    void removeInputParameter(ProcessModelParameter parameter) {
        this.inputParameters.remove(parameter);
    }

    void removeOutputParameter(ProcessModelParameter parameter) {
        this.outputParameters.remove(parameter);
    }

    void insertNode(Node node, ProcessConstants.NodeType type) {
        DefaultStructuralNodeData structureNode = new DefaultStructuralNodeData(node.getID(), type, 0, 0, 0, 0);
        this.nodes.put(node.getID(), node);
        this.nodeStructure.put(node.getID(), structureNode);
    }

    void addEdge(Edge edge, int sourceID, int destinationID) {
        DefaultStructuredEdge structureEdge = new DefaultStructuredEdge(edge, sourceID, destinationID);
        this.edges.add(structureEdge);
        this.getEdgeSet(sourceID).add(structureEdge);
        this.getEdgeSet(destinationID).add(structureEdge);
    }

    Set<StructuredEdge> getEdgeSet(int nodeID) {
        if (this.nodeToEdge.containsKey(nodeID)) {
            return this.nodeToEdge.get(nodeID);
        }
        HashSet<StructuredEdge> set = new HashSet<StructuredEdge>();
        this.nodeToEdge.put(nodeID, set);
        return set;
    }

    void insertDataElement(DataElement dataElement) {
        this.dataElements.put(dataElement.getID(), dataElement);
    }

    void addDataEdge(DataEdge dataEdge, int nodeID, int dataElementID, int connectorID) {
        DefaultStructuredDataEdge structureEdge = new DefaultStructuredDataEdge(dataEdge, nodeID, connectorID, dataElementID);
        this.dataEdges.add(structureEdge);
    }

    @Override
    public Set<StructuredEdge> getEdgeStructure(ProcessConstants.EdgeType ... edgeTypes) {
        TreeSet<StructuredEdge> result = new TreeSet<StructuredEdge>(new DefaultStructuredEdgeComparator());
        if (edgeTypes.length == 0) {
            result.addAll(this.edges);
            if (result.size() != this.edges.size()) {
                throw new Error("Template.getEdgeStructure could not return all Edges! There could be a problem with the DefaultStructuredEdgeComparator!");
            }
            return result;
        }
        ProcessConstants.EdgeType[] edgeTypeArray = edgeTypes;
        int n = edgeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.EdgeType edgeType = edgeTypeArray[n2];
            if (ProcessConstants.EdgeType.ET_CONSTRAINT.equals((Object)edgeType)) {
                throw new IllegalArgumentException("EdgeType ET_CONSTRAINT not supported by this method");
            }
            ++n2;
        }
        for (StructuredEdge edge : this.edges) {
            ProcessConstants.EdgeType[] edgeTypeArray2 = edgeTypes;
            int n3 = edgeTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                ProcessConstants.EdgeType edgeType = edgeTypeArray2[n4];
                if (edgeType.equals((Object)edge.getEdgeType())) {
                    result.add(edge);
                }
                ++n4;
            }
        }
        return result;
    }

    @Override
    public Set<StructuredDataEdge> getDataEdgeStructure() {
        TreeSet<StructuredDataEdge> result = new TreeSet<StructuredDataEdge>(new DefaultStructuredDataEdgeComparator());
        result.addAll(this.dataEdges);
        if (result.size() != this.dataEdges.size()) {
            throw new Error("Template.getDataEdgeStructure could not return all DataEdges! There could be a problem with the DefaultStructuredDataEdgeComparator!");
        }
        return result;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    void setVersion(String version) {
        this.version = version;
    }

    void addNodes(Collection<Node> nodes) {
        for (Node node : nodes) {
            this.nodes.put(node.getID(), node);
        }
    }

    void addDataElements(Collection<DataElement> elements) {
        for (DataElement de : elements) {
            this.dataElements.put(de.getID(), de);
        }
    }

    void addEdges(Set<StructuredEdge> edges) {
        for (StructuredEdge se : edges) {
            if (!(se instanceof DefaultStructuredEdge)) continue;
            this.edges.add(se);
            this.getEdgeSet(se.getSourceNodeID()).add(se);
            this.getEdgeSet(se.getDestinationNodeID()).add(se);
        }
    }

    void addDataEdges(Set<StructuredDataEdge> edges) {
        for (StructuredDataEdge se : edges) {
            if (!(se instanceof DefaultStructuredDataEdge)) continue;
            this.dataEdges.add(se);
        }
    }

    void addNodeStructure(Map<Integer, ProcessModelFactory.StructuralNodeData> structuralNodeData) {
        this.topIDToNodeID = new int[structuralNodeData.size()];
        for (ProcessModelFactory.StructuralNodeData node : structuralNodeData.values()) {
            this.nodeStructure.put(node.getNodeID(), node);
            this.topIDToNodeID[node.getTopologicalID()] = node.getNodeID();
        }
    }

    @Override
    public int getConnector(int nodeID, int dataElementID, ActivityConstants.AccessType dataEdgeType) {
        StructuredDataEdge sde = this.getStructuredDataEdge(nodeID, dataElementID, dataEdgeType);
        if (sde != null) {
            return sde.getConnectorID();
        }
        return Integer.MIN_VALUE;
    }

    StructuredDataEdge getStructuredDataEdge(int nodeID, int dataElementID, ActivityConstants.AccessType dataEdgeType) {
        for (StructuredDataEdge edge : this.dataEdges) {
            if (edge.getNodeID() != nodeID || edge.getDataElementID() != dataElementID || edge.getDataEdgeType() != dataEdgeType) continue;
            return edge;
        }
        return null;
    }

    @Override
    public int[] getUnconnectedConnectors(int nodeID, ActivityConstants.AccessType dataEdgeType) {
        Node node = this.getNode(nodeID);
        ArrayList<Integer> connectors = new ArrayList<Integer>(node.getConnectorMapping(dataEdgeType).values());
        for (StructuredDataEdge dataEdge : this.dataEdges) {
            if (dataEdge.getNodeID() != nodeID || !dataEdge.getDataEdgeType().equals((Object)dataEdgeType)) continue;
            connectors.remove((Object)dataEdge.getConnectorID());
        }
        List<Integer> disabledConnectors = this.nodeDisabledConnectors.get(nodeID);
        if (disabledConnectors != null) {
            connectors.removeAll(disabledConnectors);
        }
        return ProcessModelTools.integerToIntArray(connectors);
    }

    @Override
    public int[] getDisabledConnectors(int nodeID, ActivityConstants.AccessType accessType) {
        List<Integer> disabledConnectors = this.nodeDisabledConnectors.get(nodeID);
        if (disabledConnectors == null) {
            return new int[0];
        }
        Node node = this.nodes.get(nodeID);
        if (ActivityConstants.AccessType.isActivityRelatedValue(accessType)) {
            ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
            if (ebp == null) {
                return new int[0];
            }
            Set<ProcessModelParameter> params = ebp.getParameters(accessType);
            ArrayList<Integer> connectors = new ArrayList<Integer>();
            for (ProcessModelParameter param : params) {
                int connectorID = node.getConnector(param.getName(), accessType);
                if (!disabledConnectors.contains(connectorID)) continue;
                connectors.add(connectorID);
            }
            return ProcessModelTools.integerToIntArray(connectors);
        }
        return new int[0];
    }

    @Override
    public Set<ProcessModelParameter> getParameters(ActivityConstants.AccessType accessType) {
        switch (accessType) {
            case READ: {
                return Collections.unmodifiableSet(this.inputParameters);
            }
            case WRITE: {
                return Collections.unmodifiableSet(this.outputParameters);
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                String message = String.format("Only activity related values are allowed here, %s may not be used for activities", new Object[]{accessType});
                throw new IllegalArgumentException(message);
            }
        }
        throw new AssertionError((Object)"An unknown access type was found!");
    }

    @Override
    public int[] getNodeIDsInArea(int first, int last, boolean includeBlocks) {
        return ProcessModelTools.getNodesInArea(first, last, includeBlocks, this, false);
    }

    void addNodeDisabledConnectors(Map<Integer, List<Integer>> disabledConnectors) {
        if (disabledConnectors != null) {
            this.nodeDisabledConnectors.putAll(disabledConnectors);
        }
    }

    void setNodeType(int nodeID, ProcessConstants.NodeType type) {
        ((DefaultStructuralNodeData)this.getStructureNode(nodeID)).setNodeType(type);
    }

    void addInputParameters(Set<ProcessModelParameter> inputParameters) {
        if (inputParameters == null) {
            this.inputParameters.clear();
        } else {
            this.inputParameters = new HashSet<ProcessModelParameter>(inputParameters);
        }
    }

    void addOutputParameters(Set<ProcessModelParameter> outputParameters) {
        if (outputParameters == null) {
            this.outputParameters.clear();
        } else {
            this.outputParameters = new HashSet<ProcessModelParameter>(outputParameters);
        }
    }

    @Override
    public String getInstanceNameTemplate() {
        return this.instanceNameTemplate;
    }

    void setInstanceNameTemplate(String instanceNameTemplate) {
        this.instanceNameTemplate = instanceNameTemplate;
    }

    void addConstraintEdge(ConstraintEdge edge, int sourceID, int destinationID) {
        DefaultStructuredConstraintEdge structureEdge = new DefaultStructuredConstraintEdge(edge, sourceID, destinationID);
        this.constraintEdges.add(structureEdge);
        this.getEdgeSet(sourceID).add(structureEdge);
        this.getEdgeSet(destinationID).add(structureEdge);
    }

    void addConstraintEdges(Set<StructuredConstraintEdge> edges) {
        for (StructuredConstraintEdge se : edges) {
            if (!(se instanceof DefaultStructuredConstraintEdge)) continue;
            this.constraintEdges.add(se);
            this.getEdgeSet(se.getSourceNodeID()).add(se);
            this.getEdgeSet(se.getDestinationNodeID()).add(se);
        }
    }

    StructuredConstraintEdge getStructuredConstraintEdge(int srcNodeID, int destNodeID) {
        for (StructuredConstraintEdge edge : this.constraintEdges) {
            if (edge.getSourceNodeID() != srcNodeID || edge.getDestinationNodeID() != destNodeID) continue;
            return edge;
        }
        return null;
    }

    @Override
    public ConstraintEdge getConstraintEdge(int srcNodeID, int destNodeID) {
        StructuredConstraintEdge sde = this.getStructuredConstraintEdge(srcNodeID, destNodeID);
        if (sde == null) {
            return null;
        }
        return sde.getConstraintEdge();
    }

    @Override
    public Set<StructuredConstraintEdge> getConstraintEdgeStructure() {
        TreeSet<StructuredConstraintEdge> result = new TreeSet<StructuredConstraintEdge>(new DefaultStructuredConstraintEdgeComparator());
        result.addAll(this.constraintEdges);
        if (result.size() != this.constraintEdges.size()) {
            throw new Error("Template.getConstraintEdgeStructure could not return all ConstraintEdges! There could be a problem with the DefaultStructuredConstraintEdgeComparator!");
        }
        return result;
    }
}

