/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateDeltaLayer;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultDeltaLayer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultTemplateDeltaLayer
extends DefaultDeltaLayer
implements TemplateDeltaLayer {
    private Map<Integer, Integer> parentToChildIDMapping;
    private Map<String, String> userAttributes = new HashMap<String, String>();

    public DefaultTemplateDeltaLayer() {
    }

    public DefaultTemplateDeltaLayer(Template template) {
        super(template);
    }

    @Override
    public Map<Integer, Integer> getParentToChildIDMapping() {
        return Collections.unmodifiableMap(this.parentToChildIDMapping);
    }

    @Override
    public int getChildNodeID(int parentNodeID) {
        return this.parentToChildIDMapping.get(parentNodeID);
    }

    @Override
    public int getParentNodeID(int childNodeID) {
        for (Map.Entry<Integer, Integer> p : this.parentToChildIDMapping.entrySet()) {
            if (p.getValue() != childNodeID) continue;
            return p.getKey();
        }
        return 0;
    }

    @Override
    public String getUserAttributeValue(String attributeName) {
        return this.userAttributes.get(attributeName);
    }

    @Override
    public void setUserAttributeValue(String attributeName, String attributeValue) {
        this.userAttributes.put(attributeName, attributeValue);
    }

    @Override
    public void removeUserAttributeValue(String attributeName) {
        this.userAttributes.remove(attributeName);
    }

    @Override
    public Map<String, String> getUserAttributes() {
        return Collections.unmodifiableMap(this.userAttributes);
    }

    public void setParentToChildIDMapping(Map<Integer, Integer> parentToChildIDMapping) {
        this.parentToChildIDMapping = parentToChildIDMapping;
    }

    protected void setUserAttributes(Map<String, String> userAttributes) {
        this.userAttributes = userAttributes;
    }
}

