/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DefaultTemplateReference
extends SerialisablePluginDataContainer
implements TemplateReference {
    private static final long serialVersionUID = -8193572555290158379L;
    private UUID templateID;
    private String processType;
    private String version;
    private String templateName;
    private String description;
    private QualifiedAgent supervisorAgent;
    private HashSet<ProcessModelParameter> inputParameters;
    private HashSet<ProcessModelParameter> outputParameters;
    private boolean topLevelUsable;
    private ProcessConstants.TemplateUsage usageAsSubprocess;
    private ProcessConstants.TemplateBuildtimeState buildtimeState;
    private boolean derivable;
    private boolean spOutdated;
    private boolean tlOutdated;
    private boolean spInstantiable;
    private boolean tlInstantiable;
    private boolean spMigratable;
    private boolean tlMigratable;
    private boolean spChangeable;
    private boolean tlChangeable;

    public DefaultTemplateReference(UUID templateID, String processType, String version, String name, String description, QualifiedAgent supervisorAgent, Set<ProcessModelParameter> inputParameters, Set<ProcessModelParameter> outputParameters, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginData, Map<String, String> userAttributes, boolean topLevelUsable, ProcessConstants.TemplateUsage usageAsSubprocess, ProcessConstants.TemplateBuildtimeState buildtimeState, boolean derivable, boolean spOutdated, boolean tlOutdated, boolean spInstantiable, boolean tlInstantiable, boolean spMigratable, boolean tlMigratable, boolean spChangeable, boolean tlChangeable) {
        super(supportedPlugins, pluginData, userAttributes);
        this.templateID = templateID;
        this.processType = processType;
        this.version = version;
        this.templateName = name;
        this.description = description;
        this.supervisorAgent = supervisorAgent;
        this.inputParameters = new HashSet<ProcessModelParameter>(inputParameters);
        this.outputParameters = new HashSet<ProcessModelParameter>(outputParameters);
        this.topLevelUsable = topLevelUsable;
        this.usageAsSubprocess = usageAsSubprocess;
        this.buildtimeState = buildtimeState;
        this.derivable = derivable;
        this.spOutdated = spOutdated;
        this.tlOutdated = tlOutdated;
        this.spInstantiable = spInstantiable;
        this.tlInstantiable = tlInstantiable;
        this.spMigratable = spMigratable;
        this.tlMigratable = tlMigratable;
        this.spChangeable = spChangeable;
        this.tlChangeable = tlChangeable;
    }

    @Override
    public UUID getID() {
        return this.templateID;
    }

    @Override
    public String getProcessType() {
        return this.processType;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.templateName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public QualifiedAgent getSupervisorAgent() {
        return this.supervisorAgent;
    }

    @Override
    public Set<ProcessModelParameter> getInputParameters() {
        return Collections.unmodifiableSet(this.inputParameters);
    }

    @Override
    public Set<ProcessModelParameter> getOutputParameters() {
        return Collections.unmodifiableSet(this.outputParameters);
    }

    @Override
    public boolean isTopLevelUsable() {
        return this.topLevelUsable;
    }

    @Override
    public ProcessConstants.TemplateUsage getUsageAsSubprocess() {
        return this.usageAsSubprocess;
    }

    @Override
    public ProcessConstants.TemplateBuildtimeState getBuildtimeState() {
        return this.buildtimeState;
    }

    @Override
    public boolean isDerivable() {
        return this.derivable;
    }

    @Override
    public boolean isOutdated(boolean subprocessScope) {
        if (subprocessScope) {
            return this.spOutdated;
        }
        return this.tlOutdated;
    }

    @Override
    public boolean isInstantiable(boolean subprocessScope) {
        if (subprocessScope) {
            return this.spInstantiable;
        }
        return this.tlInstantiable;
    }

    @Override
    public boolean areInstancesMigratableTo(boolean subprocessScope) {
        if (subprocessScope) {
            return this.spMigratable;
        }
        return this.tlMigratable;
    }

    @Override
    public boolean areInstancesChangeable(boolean subprocessScope) {
        if (subprocessScope) {
            return this.spChangeable;
        }
        return this.tlChangeable;
    }
}

