/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import java.util.UUID;

public class DefaultTemplateStatus
implements TemplateStatus {
    private static final long serialVersionUID = 411484820317779441L;
    protected UUID templateID;
    protected boolean topLevelUsage = true;
    protected ProcessConstants.TemplateBuildtimeState buildtimeState;
    protected boolean derivable;
    protected ProcessConstants.TemplateUsage subprocessUsage = ProcessConstants.TemplateUsage.NO_SUBPROCESS;
    protected boolean spOutdated;
    protected boolean tlOutdated;
    protected boolean spInstantiable;
    protected boolean tlInstantiable;
    protected boolean spInstanceChangeable;
    protected boolean tlInstanceChangeable;
    protected boolean tlInstanceMigratable;
    protected boolean spInstanceMigratable;
    protected String starterRule;
    protected String tlOutdatedComment;
    protected String spOutdatedComment;
    protected String tlInstantiableComment;
    protected String spInstantiableComment;
    protected String derivableComment;
    protected String tlInstancesMigratableToComment;
    protected String spInstancesMigratableToComment;
    protected String tlInstancesChangeableComment;
    protected String spInstancesChangeableComment;

    protected void setBuildtimeState(ProcessConstants.TemplateBuildtimeState buildtimeState) {
        this.buildtimeState = buildtimeState;
    }

    protected void setTemplateID(UUID templateID) {
        this.templateID = templateID;
    }

    @Override
    public ProcessConstants.TemplateBuildtimeState getBuildtimeState() {
        return this.buildtimeState;
    }

    @Override
    public UUID getTemplateID() {
        return this.templateID;
    }

    @Override
    public boolean isTopLevelUsable() {
        return this.topLevelUsage;
    }

    @Override
    public boolean isOutdated(boolean subprocessScope) {
        if (subprocessScope) {
            return this.spOutdated;
        }
        return this.tlOutdated;
    }

    @Override
    public String getOutdatedComment(boolean subprocessScope) {
        if (subprocessScope) {
            return this.spOutdatedComment;
        }
        return this.tlOutdatedComment;
    }

    @Override
    public boolean isInstantiable(boolean subprocessScope) {
        if (subprocessScope) {
            return this.spInstantiable;
        }
        return this.tlInstantiable;
    }

    @Override
    public String getInstantiableComment(boolean subprocessScope) {
        if (subprocessScope) {
            return this.spInstantiableComment;
        }
        return this.tlInstantiableComment;
    }

    @Override
    public boolean isDerivable() {
        return this.derivable;
    }

    @Override
    public String getDerivableComment() {
        return this.derivableComment;
    }

    @Override
    public ProcessConstants.TemplateUsage getUsageAsSubprocess() {
        return this.subprocessUsage;
    }

    @Override
    public boolean areInstancesMigratableTo(boolean subprocessScope) {
        if (subprocessScope) {
            return this.spInstanceMigratable;
        }
        return this.tlInstanceMigratable;
    }

    @Override
    public String getInstancesMigratableToComment(boolean subprocessScope) {
        if (subprocessScope) {
            return this.spInstancesMigratableToComment;
        }
        return this.tlInstancesMigratableToComment;
    }

    @Override
    public boolean areInstancesChangeable(boolean subprocessScope) {
        if (subprocessScope) {
            return this.spInstanceChangeable;
        }
        return this.tlInstanceChangeable;
    }

    @Override
    public String getInstancesChangeableComment(boolean subprocessScope) {
        if (subprocessScope) {
            return this.spInstancesChangeableComment;
        }
        return this.tlInstancesChangeableComment;
    }

    @Override
    public void setTopLevelUsage(boolean useAsTopLevel) {
        this.topLevelUsage = useAsTopLevel;
    }

    @Override
    public void setSubprocessUsage(ProcessConstants.TemplateUsage usage) {
        this.subprocessUsage = usage;
    }

    @Override
    public void release() throws InvalidTemplateStateException {
        if (this.buildtimeState != ProcessConstants.TemplateBuildtimeState.VALID) {
            throw new InvalidTemplateStateException("The template is not in a valid state!");
        }
        this.buildtimeState = ProcessConstants.TemplateBuildtimeState.RELEASED;
        this.derivable = true;
        this.spOutdated = false;
        this.tlOutdated = false;
        this.spInstantiable = false;
        this.tlInstantiable = false;
        this.spInstanceMigratable = false;
        this.tlInstanceMigratable = false;
        this.spInstanceChangeable = true;
        this.tlInstanceChangeable = true;
    }

    @Override
    public void setOutdated(boolean outdated, boolean subprocessScope, String comment) throws InvalidTemplateStateException {
        if (subprocessScope) {
            this.spOutdated = outdated;
            this.spOutdatedComment = comment;
        } else {
            this.tlOutdated = outdated;
            this.tlOutdatedComment = comment;
        }
    }

    @Override
    public void setDerivable(boolean derivable, String comment) throws InvalidTemplateStateException {
        this.derivable = derivable;
        this.derivableComment = comment;
    }

    @Override
    public void setInstantiable(boolean instantiable, boolean subprocessScope, String comment) throws InvalidTemplateStateException {
        if (subprocessScope) {
            this.spInstantiable = instantiable;
            this.spInstantiableComment = comment;
        } else {
            this.tlInstantiable = instantiable;
            this.tlInstantiableComment = comment;
        }
    }

    @Override
    public void setInstancesMigratableTo(boolean migratable, boolean subprocessScope, String comment) throws InvalidTemplateStateException {
        if (subprocessScope) {
            this.spInstanceMigratable = migratable;
            this.spInstancesMigratableToComment = comment;
        } else {
            this.tlInstanceMigratable = migratable;
            this.tlInstancesMigratableToComment = comment;
        }
    }

    @Override
    public void setInstancesChangeable(boolean instancesChangeable, boolean subprocessScope, String comment) throws InvalidTemplateStateException {
        if (subprocessScope) {
            this.spInstanceChangeable = instancesChangeable;
            this.spInstancesChangeableComment = comment;
        } else {
            this.tlInstanceChangeable = instancesChangeable;
            this.tlInstancesChangeableComment = comment;
        }
    }

    @Override
    public String getStarterRule() {
        return this.starterRule;
    }

    @Override
    public void setStarterRule(String starterRule) {
        this.starterRule = starterRule != null ? starterRule : "";
    }
}

