/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.systemdata;

import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.globals.SystemDataConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public enum SystemDataProducer {
    TEMPLATE_SUPERVISOR_AGENT_ID("TemplateSupervisor-AgentID", ProcessConstants.AdeptDataType.INTEGER, SystemDataConstants.IDENTIFIER_ID_TEMPLATE_SUPERVISOR_AGENT, false, "The ID of the supervising agent of the template."),
    TEMPLATE_SUPERVISOR_ORGPOSITION_ID("TemplateSupervisor-OrgPositionID", ProcessConstants.AdeptDataType.INTEGER, SystemDataConstants.IDENTIFIER_ID_TEMPLATE_SUPERVISOR_ORGPOSITION, false, "The ID of the organisational position of the template supervisor."),
    INSTANCE_SUPERVISOR_AGENT_ID("InstanceSupervisor-AgentID", ProcessConstants.AdeptDataType.INTEGER, SystemDataConstants.IDENTIFIER_ID_INSTANCE_SUPERVISOR_AGENT, false, "The ID of the supervising agent of the instance."),
    INSTANCE_SUPERVISOR_ORGPOSITION_ID("InstanceSupervisor-OrgPositionID", ProcessConstants.AdeptDataType.INTEGER, SystemDataConstants.IDENTIFIER_ID_INSTANCE_SUPERVISOR_ORGPOSITION, false, "The ID of the organisational position of the instance supervisor."),
    INSTANCE_INITIATOR_AGENT_ID("InstanceInitiator-AgentID", ProcessConstants.AdeptDataType.INTEGER, SystemDataConstants.IDENTIFIER_ID_INSTANCE_INITIATOR_AGENT, false, "The ID of the initiating agent of the instance."),
    INSTANCE_INITIATOR_ORGPOSITION_ID("InstanceInitiator-OrgPositionID", ProcessConstants.AdeptDataType.INTEGER, SystemDataConstants.IDENTIFIER_ID_INSTANCE_INITIATOR_ORGPOSITION, false, "The ID of the organisational position of the instance initiator."),
    NODE_PERFORMING_AGENT_ID("NodePerforming-AgentID", ProcessConstants.AdeptDataType.INTEGER, SystemDataConstants.IDENTIFIER_ID_NODE_PERFORMING_AGENT, false, "The ID of the performing agent of the node."),
    NODE_PERFORMING_ORGPOSITION_ID("NodePerforming-OrgPositionID", ProcessConstants.AdeptDataType.INTEGER, SystemDataConstants.IDENTIFIER_ID_NODE_PERFORMING_ORGPOSITION, false, "The ID of the organisational position of the node performer."),
    NODE_STAFF_ASSIGNMENT_RULE("Node-StaffAssignmentRule", ProcessConstants.AdeptDataType.STRING, SystemDataConstants.IDENTIFIER_ID_NODE_STAFF_ASSIGNMENT_RULE, false, "The staff assignment rule of a node."),
    INSTANCE_CREATION_DATE("InstanceCreation-Date", ProcessConstants.AdeptDataType.DATE, SystemDataConstants.IDENTIFIER_ID_INSTANCE_CREATION_DATE, false, "The date/time the instance has been created and started."),
    NODE_TERMINATION_DATE("NodeTermination-Date", ProcessConstants.AdeptDataType.DATE, SystemDataConstants.IDENTIFIER_ID_NODE_TERMINATION, false, "The date/time the node has been terminated.");

    private ProcessModelParameter parameter;

    private SystemDataProducer(final String name, final ProcessConstants.AdeptDataType type, final UUID identifierID, final boolean optional, final String description) {
        this.parameter = new ProcessModelParameter(){
            private static final long serialVersionUID = -6109341333342577091L;

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public UUID getIdentifierID() {
                return identifierID;
            }

            @Override
            public ProcessConstants.AdeptDataType getDataType() {
                return type;
            }

            @Override
            public String getUDTName() {
                return "";
            }

            @Override
            public boolean isOptional() {
                return optional;
            }

            @Override
            public boolean isVirtual() {
                return false;
            }

            @Override
            public PluginData getPluginData(String pluginID) {
                return null;
            }

            @Override
            public Map<String, PluginData> getPluginDatas() {
                return new HashMap<String, PluginData>();
            }

            @Override
            public Map<String, Set<String>> getSupportedPlugins() {
                return new HashMap<String, Set<String>>();
            }

            @Override
            public ChangeableActivityConfiguration getConfiguration() {
                return null;
            }

            @Override
            public String getDefaultValue() {
                return null;
            }

            @Override
            public boolean isFailure() {
                return false;
            }

            @Override
            public String getUserAttributeValue(String attributeName) {
                return null;
            }

            @Override
            public Map<String, String> getUserAttributes() {
                return null;
            }

            @Override
            public void removeUserAttributeValue(String attributeName) {
            }

            @Override
            public void setUserAttributeValue(String attributeName, String attributeValue) {
            }
        };
    }

    public ProcessModelParameter getParameterProperties() {
        return this.parameter;
    }

    public SystemDataProducer getCompanion() {
        SystemDataProducer ret;
        switch (this) {
            case TEMPLATE_SUPERVISOR_AGENT_ID: {
                ret = TEMPLATE_SUPERVISOR_ORGPOSITION_ID;
                break;
            }
            case TEMPLATE_SUPERVISOR_ORGPOSITION_ID: {
                ret = TEMPLATE_SUPERVISOR_AGENT_ID;
                break;
            }
            case INSTANCE_SUPERVISOR_AGENT_ID: {
                ret = INSTANCE_SUPERVISOR_ORGPOSITION_ID;
                break;
            }
            case INSTANCE_SUPERVISOR_ORGPOSITION_ID: {
                ret = INSTANCE_SUPERVISOR_AGENT_ID;
                break;
            }
            case INSTANCE_INITIATOR_AGENT_ID: {
                ret = INSTANCE_INITIATOR_ORGPOSITION_ID;
                break;
            }
            case INSTANCE_INITIATOR_ORGPOSITION_ID: {
                ret = INSTANCE_INITIATOR_AGENT_ID;
                break;
            }
            case NODE_PERFORMING_AGENT_ID: {
                ret = NODE_PERFORMING_ORGPOSITION_ID;
                break;
            }
            case NODE_PERFORMING_ORGPOSITION_ID: {
                ret = NODE_PERFORMING_AGENT_ID;
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    public static SystemDataProducer getProducerForIdentifierID(UUID identifierID) {
        ArgChecks.checkForNull(identifierID, "identifierID");
        SystemDataProducer[] systemDataProducerArray = SystemDataProducer.values();
        int n = systemDataProducerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SystemDataProducer producer = systemDataProducerArray[n2];
            if (producer.getParameterProperties().getIdentifierID().equals(identifierID)) {
                return producer;
            }
            ++n2;
        }
        return null;
    }

    public static SystemDataProducer[] startNodeProduced() {
        return new SystemDataProducer[]{TEMPLATE_SUPERVISOR_AGENT_ID, TEMPLATE_SUPERVISOR_ORGPOSITION_ID, INSTANCE_SUPERVISOR_AGENT_ID, INSTANCE_SUPERVISOR_ORGPOSITION_ID, INSTANCE_INITIATOR_AGENT_ID, INSTANCE_INITIATOR_ORGPOSITION_ID, INSTANCE_CREATION_DATE};
    }

    public static SystemDataProducer[] nodeProduced() {
        return new SystemDataProducer[]{NODE_PERFORMING_AGENT_ID, NODE_PERFORMING_ORGPOSITION_ID, NODE_STAFF_ASSIGNMENT_RULE, NODE_TERMINATION_DATE};
    }
}

