/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.tools;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Logger;

public class InducedGraph {
    protected final Logger logger;
    private final NodeRelations relations;
    private final LinkedList<Node> graphNodes;
    private final int graphSize;
    private final HashMap<Node, HashSet<Node>> allPreds = new HashMap();
    private Template template;

    public InducedGraph(Template template, NodeRelations relations, LinkedList<Node> graphNodes) {
        this.template = template;
        this.relations = relations;
        this.graphNodes = graphNodes;
        this.graphSize = graphNodes.size();
        this.logger = LoggerTools.getLogger(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public HashSet<Node> getPredecessors(Node node) {
        assert (this.graphNodes.contains(node));
        if (this.allPreds.containsKey(node)) {
            return this.allPreds.get(node);
        }
        HashSet<Node> preds = new HashSet<Node>();
        if (this.template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW)) {
            return preds;
        }
        Node splitNode = node;
        Node tmpNode = this.template.getNode(this.template.getNodeSplitNodeID(node.getID()));
        do {
            if (!this.template.getNodeType(tmpNode.getID()).equals((Object)ProcessConstants.NodeType.NT_AND_SPLIT)) continue;
            splitNode = tmpNode;
        } while ((tmpNode = this.template.getNode(this.template.getNodeSplitNodeID(tmpNode.getID()))) != null);
        int joinID = this.template.getNodeType(splitNode.getID()).equals((Object)ProcessConstants.NodeType.NT_NORMAL) ? this.template.getNodeTopologicalID(splitNode.getID()) : this.template.getNodeTopologicalID(this.template.getNodeCorrespondingBlockNodeID(splitNode.getID()));
        boolean foundAllPreds = false;
        HashSet<Node> optionalPreds = new HashSet<Node>();
        int i = this.graphSize - 1;
        while (i >= 0) {
            block20: {
                Node pred = this.graphNodes.get(i);
                if (this.template.getNodeTopologicalID(pred.getID()) < joinID) {
                    NodeRelations.NodeRelation rel = this.relations.getNodeRelation(pred.getID(), node.getID());
                    block0 : switch (rel) {
                        case EXCLUSIVE: 
                        case PARALLEL: 
                        case AFTER: {
                            break block20;
                        }
                        case ONE_BEFORE_TWO: 
                        case ONE_BEFORE_TWO_OPTIONAL: {
                            boolean contains = false;
                            int[] nArray = this.template.getPredByEdgeType(node.getID(), ProcessConstants.EdgeType.ET_CONTROL);
                            Object object = nArray;
                            int n = nArray.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) {
                                    if (!contains) break;
                                    preds.add(pred);
                                    foundAllPreds = true;
                                    break block0;
                                }
                                Object predID = object[n2];
                                if (predID == pred.getID()) {
                                    contains = true;
                                }
                                ++n2;
                            }
                            preds.add(pred);
                            Node commonSplitNode = this.template.getNode(ProcessModelTools.getCommonSplitNode(this.template, pred.getID(), node.getID()));
                            if (this.template.getNodeType(commonSplitNode.getID()).equals((Object)ProcessConstants.NodeType.NT_AND_SPLIT) && NodeRelations.nodesAreOnDifferentBranchesOfSplit(this.template, pred.getID(), node.getID(), commonSplitNode.getID())) break;
                            foundAllPreds = true;
                            break;
                        }
                        case ONE_OPTIONAL_BEFORE_TWO: 
                        case ONE_OPTIONAL_BEFORE_TWO_OPTIONAL: {
                            boolean addOptional = true;
                            block12: for (Node optionalPred : optionalPreds) {
                                NodeRelations.NodeRelation optionalRelation = this.relations.getNodeRelation(pred.getID(), optionalPred.getID());
                                switch (optionalRelation) {
                                    case EXCLUSIVE: 
                                    case PARALLEL: {
                                        break;
                                    }
                                    case AFTER: {
                                        this.logger.severe("Found an AFTER relation between two optional nodes!");
                                        assert (false);
                                        continue block12;
                                    }
                                    default: {
                                        addOptional = false;
                                    }
                                }
                            }
                            if (!addOptional) break;
                            optionalPreds.add(pred);
                            preds.add(pred);
                        }
                    }
                    if (foundAllPreds) break;
                }
            }
            --i;
        }
        this.allPreds.put(node, preds);
        return preds;
    }
}

