/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.tools;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;

public class NodeRelations {
    protected final Logger logger = LoggerTools.getLogger(this);
    private HashMap<Integer, HashMap<Integer, NodeRelation>> relations = new HashMap();
    private final Template template;
    int requests = 0;
    int cached = 0;

    public NodeRelations(Template template) {
        this.template = template;
    }

    private void put(int nodeID1, int nodeID2, NodeRelation nodeRelation) {
        HashMap<Integer, NodeRelation> innerRelation = !this.relations.containsKey(nodeID1) ? new HashMap<Integer, NodeRelation>() : this.relations.get(nodeID1);
        innerRelation.put(nodeID2, nodeRelation);
        this.relations.put(nodeID1, innerRelation);
    }

    public NodeRelation getNodeRelation(int nodeID1, int nodeID2) {
        NodeRelation newRelation;
        if (nodeID1 == nodeID2) {
            throw new IllegalArgumentException(String.format("nodeID1 and nodeID2 must not refer to the same node.", new Object[0]));
        }
        ++this.requests;
        if (this.relations.containsKey(nodeID1) && this.relations.get(nodeID1).containsKey(nodeID2)) {
            ++this.cached;
            return this.relations.get(nodeID1).get(nodeID2);
        }
        NodeRelation otherRelation = null;
        boolean node1LessThanNode2 = this.template.getNodeTopologicalID(nodeID1) < this.template.getNodeTopologicalID(nodeID2);
        ProcessConstants.NodeType nodeType1 = this.template.getNodeType(nodeID1);
        ProcessConstants.NodeType nodeType2 = this.template.getNodeType(nodeID2);
        int node1BranchID = this.template.getNodeBranchID(nodeID1);
        int node2BranchID = this.template.getNodeBranchID(nodeID2);
        int commonSplitNodeID = nodeType1 == ProcessConstants.NodeType.NT_STARTFLOW || nodeType2 == ProcessConstants.NodeType.NT_ENDFLOW ? nodeID1 : (nodeType1 == ProcessConstants.NodeType.NT_ENDFLOW || nodeType2 == ProcessConstants.NodeType.NT_STARTFLOW ? nodeID2 : ProcessModelTools.getCommonSplitNode(this.template, nodeID1, nodeID2));
        if (node1BranchID == node2BranchID) {
            this.logger.info("Case 0: node1 is on the same branch like node2 ");
            if (node1LessThanNode2) {
                newRelation = NodeRelation.ONE_BEFORE_TWO;
                otherRelation = NodeRelation.AFTER;
            } else {
                newRelation = NodeRelation.AFTER;
                otherRelation = NodeRelation.ONE_BEFORE_TWO;
            }
        } else if (this.nodeIsPartOfBranch(nodeID1, node2BranchID)) {
            this.logger.info("Case 1: node 1 is part of node 2's branch");
            boolean nodeIsExecutedOptional = this.nodeIsExecutedOptionalToBranch(nodeID1, node2BranchID);
            if (node1LessThanNode2) {
                newRelation = nodeIsExecutedOptional ? NodeRelation.ONE_OPTIONAL_BEFORE_TWO : NodeRelation.ONE_BEFORE_TWO;
                otherRelation = NodeRelation.AFTER;
            } else {
                newRelation = NodeRelation.AFTER;
                otherRelation = nodeIsExecutedOptional ? NodeRelation.ONE_BEFORE_TWO_OPTIONAL : NodeRelation.ONE_BEFORE_TWO;
            }
        } else if (this.nodeIsPartOfBranch(nodeID2, node1BranchID)) {
            this.logger.info("Case 2: node 2 is part of node ones branch");
            boolean nodeIsExecutedOptional = this.nodeIsExecutedOptionalToBranch(nodeID2, node1BranchID);
            if (node1LessThanNode2) {
                newRelation = nodeIsExecutedOptional ? NodeRelation.ONE_BEFORE_TWO_OPTIONAL : NodeRelation.ONE_BEFORE_TWO;
                otherRelation = NodeRelation.AFTER;
            } else {
                newRelation = NodeRelation.AFTER;
                otherRelation = nodeIsExecutedOptional ? NodeRelation.ONE_OPTIONAL_BEFORE_TWO : NodeRelation.ONE_BEFORE_TWO;
            }
        } else if (!NodeRelations.nodesAreOnDifferentBranchesOfSplit(this.template, nodeID1, nodeID2, commonSplitNodeID)) {
            this.logger.info("Case 3: node1 and node2 are in different blocks on the same branch (" + this.template.getNodeBranchID(commonSplitNodeID) + ")");
            int commonBranchID = Integer.MIN_VALUE;
            List<Integer> splitNodeIDs = ProcessModelTools.getSplitNodes(this.template, nodeID1);
            int i = 0;
            while (i < splitNodeIDs.size()) {
                int splitNodeID = splitNodeIDs.get(i);
                if (splitNodeID == commonSplitNodeID) {
                    int nextInnerSplitNodeID = splitNodeIDs.get(i - 1);
                    commonBranchID = this.template.getNodeBranchID(nextInnerSplitNodeID);
                }
                ++i;
            }
            assert (commonBranchID != Integer.MIN_VALUE) : "Could not find common branch?";
            boolean node1ExecutionOptional = this.nodeIsExecutedOptionalToBranch(nodeID1, commonBranchID);
            boolean node2ExecutionOptional = this.nodeIsExecutedOptionalToBranch(nodeID2, commonBranchID);
            if (node1LessThanNode2) {
                newRelation = node1ExecutionOptional && node2ExecutionOptional ? NodeRelation.ONE_OPTIONAL_BEFORE_TWO_OPTIONAL : (node1ExecutionOptional ? NodeRelation.ONE_OPTIONAL_BEFORE_TWO : (node2ExecutionOptional ? NodeRelation.ONE_BEFORE_TWO_OPTIONAL : NodeRelation.ONE_BEFORE_TWO));
                otherRelation = NodeRelation.AFTER;
            } else {
                newRelation = NodeRelation.AFTER;
                otherRelation = node1ExecutionOptional && node2ExecutionOptional ? NodeRelation.ONE_OPTIONAL_BEFORE_TWO_OPTIONAL : (node1ExecutionOptional ? NodeRelation.ONE_BEFORE_TWO_OPTIONAL : (node2ExecutionOptional ? NodeRelation.ONE_OPTIONAL_BEFORE_TWO : NodeRelation.ONE_BEFORE_TWO));
            }
        } else {
            this.logger.info("Case 4: node1 and node2 are on different branches");
            ProcessConstants.NodeType splitNodeType = this.template.getNodeType(commonSplitNodeID);
            this.logger.info("  4: splitNode is Node " + commonSplitNodeID);
            if (splitNodeType == ProcessConstants.NodeType.NT_XOR_SPLIT) {
                newRelation = NodeRelation.EXCLUSIVE;
                otherRelation = NodeRelation.EXCLUSIVE;
            } else if (splitNodeType == ProcessConstants.NodeType.NT_AND_SPLIT) {
                newRelation = this.getParallelNodeRelation(nodeID1, nodeID2, commonSplitNodeID, true);
                if (newRelation.equals((Object)NodeRelation.EXCLUSIVE) || newRelation.equals((Object)NodeRelation.PARALLEL)) {
                    otherRelation = newRelation;
                } else if (!newRelation.equals((Object)NodeRelation.AFTER)) {
                    otherRelation = NodeRelation.AFTER;
                }
            } else {
                assert (false) : "missed case? invalid graph? " + (Object)((Object)splitNodeType);
                return NodeRelation.PARALLEL;
            }
        }
        assert (newRelation != null) : "Did not get a relation between node:" + nodeID1 + " and node:" + nodeID2;
        this.put(nodeID1, nodeID2, newRelation);
        if (otherRelation != null) {
            this.put(nodeID2, nodeID1, otherRelation);
        }
        return newRelation;
    }

    private NodeRelation getParallelNodeRelation(int nodeID1, int nodeID2, int splitNodeID, boolean checkOtherDirection) {
        NodeRelation afterRelation;
        HashSet<Node> nodesWithSyncEdges2 = this.getNodesWithSyncEdgesBetweenNodes(splitNodeID, nodeID2);
        for (Node syncedA : nodesWithSyncEdges2) {
            int[] nArray = this.template.getPredByEdgeType(syncedA.getID(), ProcessConstants.EdgeType.ET_SYNC);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int syncedOID = nArray[n2];
                if (nodeID1 == syncedOID) {
                    if (nodeID2 == syncedA.getID()) {
                        this.put(nodeID2, nodeID1, NodeRelation.AFTER);
                        return this.getOptionalRelationForParallelButSyncedNodesWithSplit(nodeID1, nodeID2, splitNodeID);
                    }
                    this.put(nodeID2, nodeID1, NodeRelation.AFTER);
                    return this.getOptionalRelationForParallelButSyncedNodesWithSplit(nodeID1, nodeID2, splitNodeID);
                }
                NodeRelation syncNodeRelation = this.getNodeRelation(nodeID1, syncedOID);
                if (!(syncNodeRelation.equals((Object)NodeRelation.AFTER) || syncNodeRelation.equals((Object)NodeRelation.EXCLUSIVE) || syncNodeRelation.equals((Object)NodeRelation.PARALLEL))) {
                    this.put(nodeID2, nodeID1, NodeRelation.AFTER);
                    return this.getOptionalRelationForParallelButSyncedNodesWithSplit(nodeID1, nodeID2, splitNodeID);
                }
                ++n2;
            }
        }
        if (checkOtherDirection && !(afterRelation = this.getParallelNodeRelation(nodeID2, nodeID1, splitNodeID, false)).equals((Object)NodeRelation.AFTER) && !afterRelation.equals((Object)NodeRelation.EXCLUSIVE) && !afterRelation.equals((Object)NodeRelation.PARALLEL)) {
            this.put(nodeID2, nodeID1, afterRelation);
            return NodeRelation.AFTER;
        }
        this.put(nodeID2, nodeID1, NodeRelation.PARALLEL);
        return NodeRelation.PARALLEL;
    }

    private NodeRelation getOptionalRelationForParallelButSyncedNodesWithSplit(int predID, int succID, int splitNodeID) {
        int splitNodeBranchID = this.template.getNodeBranchID(splitNodeID);
        boolean node1IsOptional = this.nodeIsExecutedOptionalToBranch(predID, splitNodeBranchID);
        boolean node2IsOptional = this.nodeIsExecutedOptionalToBranch(succID, splitNodeBranchID);
        if (node1IsOptional && node2IsOptional) {
            return NodeRelation.ONE_OPTIONAL_BEFORE_TWO_OPTIONAL;
        }
        if (node1IsOptional) {
            return NodeRelation.ONE_OPTIONAL_BEFORE_TWO;
        }
        if (node2IsOptional) {
            return NodeRelation.ONE_BEFORE_TWO_OPTIONAL;
        }
        return NodeRelation.ONE_BEFORE_TWO;
    }

    private HashSet<Node> getNodesWithSyncEdgesBetweenNodes(int splitNodeID, int nodeID) {
        HashSet<Node> nodesWithSyncEdges = new HashSet<Node>();
        HashSet<Integer> visitedNodes = new HashSet<Integer>();
        Stack<Integer> nodeStack = new Stack<Integer>();
        nodeStack.push(nodeID);
        do {
            int predID = (Integer)nodeStack.pop();
            visitedNodes.add(predID);
            if (predID == splitNodeID) continue;
            if (this.template.getSuccByEdgeType(predID, ProcessConstants.EdgeType.ET_SYNC).length > 0 || this.template.getPredByEdgeType(predID, ProcessConstants.EdgeType.ET_SYNC).length > 0) {
                nodesWithSyncEdges.add(this.template.getNode(predID));
            }
            int[] nArray = this.template.getPredByEdgeType(predID, ProcessConstants.EdgeType.ET_CONTROL);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int predpredID = nArray[n2];
                if (!visitedNodes.contains(predpredID)) {
                    nodeStack.push(predpredID);
                }
                ++n2;
            }
        } while (!nodeStack.isEmpty());
        return nodesWithSyncEdges;
    }

    private boolean nodeIsExecutedOptionalToBranch(int nodeID, int branchID) {
        int currentNode = this.template.getNodeSplitNodeID(nodeID);
        while (currentNode != Integer.MIN_VALUE) {
            ProcessConstants.NodeType type = this.template.getNodeType(currentNode);
            if (type == ProcessConstants.NodeType.NT_XOR_SPLIT && this.template.getSuccByEdgeType(currentNode, ProcessConstants.EdgeType.ET_CONTROL).length > 1) {
                return true;
            }
            if (this.template.getNodeBranchID(currentNode) == branchID) {
                return false;
            }
            currentNode = this.template.getNodeSplitNodeID(currentNode);
        }
        return false;
    }

    protected static boolean nodesAreOnDifferentBranchesOfSplit(Template template, int nodeID1, int nodeID2, int commonSplitNodeID) {
        List<Integer> splitNode1IDs = ProcessModelTools.getSplitNodes(template, nodeID1);
        List<Integer> splitNode2IDs = ProcessModelTools.getSplitNodes(template, nodeID2);
        int splitNode1ID = 0;
        int splitNode2ID = 0;
        int i = 0;
        while (i < splitNode1IDs.size()) {
            splitNode1ID = splitNode1IDs.get(i);
            if (splitNode1ID == commonSplitNodeID) {
                assert (i > 0) : "node1 == commonSplitNode!!";
                splitNode1ID = splitNode1IDs.get(i - 1);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < splitNode2IDs.size()) {
            splitNode2ID = splitNode2IDs.get(i);
            if (splitNode2ID == commonSplitNodeID) {
                assert (i > 0) : "node2 == commonSplitNode!!";
                splitNode2ID = splitNode2IDs.get(i - 1);
                break;
            }
            ++i;
        }
        return template.getNodeBranchID(splitNode1ID) != template.getNodeBranchID(splitNode2ID);
    }

    private boolean nodeIsPartOfBranch(int origNodeID, int branchID) {
        int nodeID = origNodeID;
        do {
            if (this.template.getNodeBranchID(nodeID) != branchID) continue;
            return true;
        } while ((nodeID = this.template.getNodeSplitNodeID(nodeID)) != Integer.MIN_VALUE);
        return false;
    }

    public static boolean isBefore(NodeRelation nodeRelation) {
        return !nodeRelation.equals((Object)NodeRelation.AFTER) && !nodeRelation.equals((Object)NodeRelation.EXCLUSIVE) && !nodeRelation.equals((Object)NodeRelation.PARALLEL);
    }

    public String getStatsString() {
        int cachesize = 0;
        for (HashMap<Integer, NodeRelation> map : this.relations.values()) {
            cachesize += map.size();
        }
        return "NodeRelations: requests=" + this.requests + " thereof cached=" + this.cached + ", cache-size is " + cachesize;
    }

    public boolean atLeastOneIsExecutedBefore(HashSet<Integer> optionalPreds, int nodeID) {
        HashMap orBlockSuppliedWithBranches = new HashMap();
        HashSet<Node> blackListedOrSplits = new HashSet<Node>();
        HashSet<Node> suppliedOrSplits = new HashSet<Node>();
        Stack<Node> nodeStack = new Stack<Node>();
        for (int opID : optionalPreds) {
            nodeStack.add(this.template.getNode(opID));
        }
        while (!nodeStack.isEmpty()) {
            Node pred = (Node)nodeStack.pop();
            this.logger.info("Examining node " + pred);
            int suppliedUsingBranch = this.template.getNodeBranchID(pred.getID());
            Node split = this.template.getNode(this.template.getNodeSplitNodeID(pred.getID()));
            while (!this.template.getNodeType(split.getID()).equals((Object)ProcessConstants.NodeType.NT_XOR_SPLIT)) {
                suppliedUsingBranch = this.template.getNodeBranchID(split.getID());
                split = this.template.getNode(this.template.getNodeSplitNodeID(split.getID()));
            }
            this.logger.info("Found split " + split);
            if (suppliedOrSplits.contains(split)) {
                this.logger.warning("already supplied split found?!");
                continue;
            }
            if (blackListedOrSplits.contains(split)) continue;
            int[] splitSuccs = this.template.getSuccByEdgeType(split.getID(), ProcessConstants.EdgeType.ET_CONTROL);
            boolean contains = false;
            int[] nArray = splitSuccs;
            int n = splitSuccs.length;
            int n2 = 0;
            while (n2 < n) {
                int splitSuccID = nArray[n2];
                if (splitSuccID == this.template.getNodeCorrespondingBlockNodeID(split.getID())) {
                    contains = true;
                }
                ++n2;
            }
            if (contains) {
                this.logger.info("Adding split to black listed or splits: " + split);
                blackListedOrSplits.add(split);
                continue;
            }
            if (orBlockSuppliedWithBranches.containsKey(split) && ((List)orBlockSuppliedWithBranches.get(split)).contains(suppliedUsingBranch)) {
                this.logger.info("Found another writer on branch " + suppliedUsingBranch + " for split " + split);
            } else {
                List<Integer> branchList;
                if (orBlockSuppliedWithBranches.containsKey(split)) {
                    this.logger.info("Getting branch list for split " + split);
                    branchList = (List)orBlockSuppliedWithBranches.get(split);
                } else {
                    this.logger.info("Creating branchlist for split " + split);
                    branchList = new LinkedList();
                    orBlockSuppliedWithBranches.put(split, branchList);
                }
                branchList.add(suppliedUsingBranch);
            }
            if (this.template.getSuccByEdgeType(split.getID(), ProcessConstants.EdgeType.ET_CONTROL).length != ((List)orBlockSuppliedWithBranches.get(split)).size()) continue;
            suppliedOrSplits.add(split);
            NodeRelation splitToNodeRelation = this.getNodeRelation(split.getID(), nodeID);
            switch (splitToNodeRelation) {
                case ONE_OPTIONAL_BEFORE_TWO: 
                case ONE_OPTIONAL_BEFORE_TWO_OPTIONAL: {
                    this.logger.info("Optional, adding split to stack");
                    nodeStack.push(split);
                    break;
                }
                case ONE_BEFORE_TWO: 
                case ONE_BEFORE_TWO_OPTIONAL: {
                    this.logger.info("All supplied, returning true.");
                    return true;
                }
                case EXCLUSIVE: 
                case PARALLEL: 
                case AFTER: {
                    this.logger.warning("relation not enough? adding " + split + " to black listed... " + (Object)((Object)splitToNodeRelation));
                    blackListedOrSplits.add(split);
                    break;
                }
                default: {
                    String msg = String.format("Unsupported relation '%s'!", new Object[]{splitToNodeRelation});
                    this.logger.warning(msg);
                }
            }
        }
        return false;
    }

    public static enum NodeRelation {
        ONE_BEFORE_TWO,
        ONE_OPTIONAL_BEFORE_TWO,
        ONE_BEFORE_TWO_OPTIONAL,
        ONE_OPTIONAL_BEFORE_TWO_OPTIONAL,
        EXCLUSIVE,
        PARALLEL,
        AFTER;

    }
}

