/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.tools;

import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ProcessElementIdentifierTools {
    protected static final Logger logger = LoggerTools.getLogger(ProcessElementIdentifierTools.class);
    public static final String BASE_TYPE_DELIMITER = "-";
    public static final String PATH_ID_DELIMITER = "-";
    public static final String RANGE_DELIMITER = "-";

    public static String getType(URI elementIdentifier) {
        return elementIdentifier.getScheme();
    }

    public static URI getBase(URI elementIdentifier) {
        String baseURIStr = String.valueOf(ProcessElementIdentifierTools.getBaseType(elementIdentifier)) + "://" + elementIdentifier.getAuthority() + "/" + ProcessElementIdentifierTools.getBaseID(elementIdentifier);
        URI baseURI = null;
        try {
            baseURI = new URI(baseURIStr);
        }
        catch (URISyntaxException e) {
            String message = String.format("Failed to construct the URI '%s' of the base because of an URISyntaxException!", baseURIStr);
            logger.log(Level.SEVERE, message, e);
        }
        return baseURI;
    }

    public static String getBaseID(URI elementIdentifier) {
        int indexOfDelimiter;
        String identifierPath = ProcessElementIdentifierTools.getIdentifierPath(elementIdentifier);
        if (identifierPath.startsWith("/")) {
            identifierPath = identifierPath.replaceFirst("/", "");
        }
        if ((indexOfDelimiter = identifierPath.indexOf(47)) < 0) {
            return identifierPath;
        }
        return identifierPath.substring(0, indexOfDelimiter);
    }

    public static String getBaseType(URI elementIdentifier) {
        String type = ProcessElementIdentifierTools.getType(elementIdentifier);
        return type.substring(type.lastIndexOf("-") + 1);
    }

    public static String getElementType(URI elementIdentifier) {
        String type = ProcessElementIdentifierTools.getType(elementIdentifier);
        int lastIndexOfBASE_TYPE_DELIMITER = type.lastIndexOf("-");
        if (lastIndexOfBASE_TYPE_DELIMITER < 0) {
            return ProcessElementIdentifierTools.getBaseType(elementIdentifier);
        }
        return type.substring(0, lastIndexOfBASE_TYPE_DELIMITER);
    }

    public static String getIdentifierPath(URI elementIdentifier) {
        String identifierPath = elementIdentifier.getPath();
        while (!identifierPath.startsWith("/")) {
            identifierPath = "/" + identifierPath;
        }
        while (identifierPath.endsWith("/")) {
            identifierPath = identifierPath.substring(0, identifierPath.length() - 1);
        }
        return identifierPath;
    }

    public static String getIdentifierPathRelToBase(URI elementIdentifier) {
        int indexOfPathDelimiter;
        String identifierPath = ProcessElementIdentifierTools.getIdentifierPath(elementIdentifier);
        if (identifierPath.startsWith("/")) {
            identifierPath = identifierPath.replaceFirst("/", "");
        }
        return (indexOfPathDelimiter = identifierPath.indexOf(47)) >= 0 ? identifierPath.substring(indexOfPathDelimiter) : "";
    }

    public static String[] getTypesOfIdentifierPath(URI elementIdentifier) {
        String elementType = ProcessElementIdentifierTools.getElementType(elementIdentifier);
        String[] identifierPathRelToBase = ProcessConstants.ProcessElementIdentifierPath.getIdentifierPathRelToBase(elementType);
        String[] typesOfIdentifierPath = new String[identifierPathRelToBase.length + 1];
        typesOfIdentifierPath[0] = ProcessElementIdentifierTools.getBaseType(elementIdentifier);
        System.arraycopy(identifierPathRelToBase, 0, typesOfIdentifierPath, 1, identifierPathRelToBase.length);
        return typesOfIdentifierPath;
    }

    public static String[] getPathIDsOfIdentifierPath(URI elementIdentifier) {
        String identifierPath = ProcessElementIdentifierTools.getIdentifierPath(elementIdentifier);
        if (identifierPath.startsWith("/")) {
            identifierPath = identifierPath.replaceFirst("/", "");
        }
        return identifierPath.split("/");
    }

    public static String getElementID(URI elementIdentifier) {
        String path = elementIdentifier.getPath();
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public static String getField(URI elementIdentifier) {
        return elementIdentifier.getQuery();
    }

    public static String getRange(URI elementIdentifier) {
        return elementIdentifier.getFragment();
    }

    public static URI generateProcessElementIdentifierURI(URI baseURI, String elementType, String identifierPathRelToBase) {
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, elementType, identifierPathRelToBase, null, null);
    }

    public static URI generateProcessElementIdentifierURI(URI baseURI, String elementType, String identifierPathRelToBase, String field) {
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, elementType, identifierPathRelToBase, field, null);
    }

    public static URI generateProcessElementIdentifierURI(URI baseURI, String elementType, String identifierPathRelToBase, String field, String range) {
        URI uri;
        String type;
        String baseType = baseURI.getScheme();
        String string = type = baseType.equals(elementType) ? baseType : String.valueOf(elementType) + "-" + baseType;
        if (field == null && range != null) {
            String errorMessage = String.format("Failed to construct the URI from the parameters baseURI = '%s', elementType = '%s', identifierPathRelToBase = '%s', field = 'null', range = '%s': The field parameter must not be null if the range parameter is set!)", baseURI, elementType, identifierPathRelToBase, range);
            logger.log(Level.SEVERE, errorMessage);
            return null;
        }
        try {
            uri = new URI(type, baseURI.getUserInfo(), baseURI.getHost(), baseURI.getPort(), String.valueOf(baseURI.getPath()) + identifierPathRelToBase, field, range);
        }
        catch (URISyntaxException e) {
            String errorMessage = String.format("Failed to construct the URI from the parameters baseURI = '%s', elementType = '%s', identifierPathRelToBase = '%s', field = '%s', range = '%s': An URISyntaxException was thrown!)", baseURI, elementType, identifierPathRelToBase, field, range);
            logger.log(Level.SEVERE, errorMessage, e);
            return null;
        }
        return uri;
    }

    private static String generateIdentifierPathRelToBase(DataElement dataElement) {
        return "/" + dataElement.getID();
    }

    private static String generateIdentifierPathRelToBase(Node node) {
        return "/" + node.getID();
    }

    private static String generateIdentifierPathRelToBase(Node node, DataElement dataElement, ActivityConstants.AccessType direction) {
        return "/(" + Integer.toString(node.getID()) + "-" + dataElement.getID() + "-" + direction.name() + ")";
    }

    private static String generateIdentifierPathRelToBase(Node node, ExecutableBusinessProcess ebp) throws IllegalArgumentException {
        String identifierPathRelToBase = "/" + node.getID() + "/";
        if (ebp instanceof VariableParallelismEBP) {
            ebp = ((VariableParallelismEBP)ebp).getLightWeightProcess();
        }
        if (ebp instanceof Activity) {
            Activity activity = (Activity)ebp;
            identifierPathRelToBase = String.valueOf(identifierPathRelToBase) + activity.getID().toString();
        } else if (ebp instanceof ReferencedProcess) {
            ReferencedProcess lwp = (ReferencedProcess)ebp;
            identifierPathRelToBase = String.valueOf(identifierPathRelToBase) + lwp.getTemplateID().toString();
        } else if (ebp instanceof EmbeddedProcess) {
            EmbeddedProcess lwp = (EmbeddedProcess)ebp;
            UUID parentID = lwp.getTemplate().getID();
            identifierPathRelToBase = String.format("%s%s", identifierPathRelToBase, parentID == null ? "parentID unknown" : parentID.toString());
        } else {
            throw new IllegalArgumentException("The ebp is not of type 'Activity' or 'LightWeightProcess'");
        }
        return identifierPathRelToBase;
    }

    public static String generateIdentifierPathRelToBase(Node startNode, Node endNode) {
        return "/(" + startNode.getID() + "-" + endNode.getID() + ")";
    }

    public static String generateIdentifierPathRelToBase(Node node, ExecutableBusinessProcess ebp, ProcessModelParameter parameter) {
        return String.valueOf(ProcessElementIdentifierTools.generateIdentifierPathRelToBase(node, ebp)) + "/(" + parameter.getName() + "-" + parameter.getDataType().name() + ")";
    }

    public static URI getTemplateIdentifier(Template template, String symbolicNameOfAuthority) {
        URI uri;
        try {
            uri = new URI("template", null, symbolicNameOfAuthority, -1, "/" + template.getID(), null, null);
        }
        catch (URISyntaxException e) {
            String errorMessage = String.format("Failed to construct the process element identifier URI for the template '%s (ID = %s)' hosted by the authority '%s': An URISyntaxException was thrown!", template.getName(), template.getID(), symbolicNameOfAuthority);
            logger.log(Level.SEVERE, errorMessage, e);
            return null;
        }
        return uri;
    }

    public static URI getInstanceIdentifier(String symbolicNameOfAuthority, Instance instance) {
        URI uri;
        try {
            uri = new URI("instance", null, symbolicNameOfAuthority, -1, "/" + instance.getID(), null, null);
        }
        catch (URISyntaxException e) {
            String errorMessage = String.format("Failed to construct the process element identifier URI for the instance '%s (ID = %s)' hosted by the authority '%s': An URISyntaxException was thrown!", instance.getName(), instance.getID().toString(), symbolicNameOfAuthority);
            logger.log(Level.SEVERE, errorMessage, e);
            return null;
        }
        return uri;
    }

    public static URI getNodeIdentifier(URI baseURI, Node node) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(node);
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "node", identifierPathRelToBase);
    }

    public static URI getNodeIdentifier(URI baseURI, Node node, String field) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(node);
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "node", identifierPathRelToBase, field);
    }

    public static URI getNodeIdentifier(URI baseURI, Node node, String field, String range) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(node);
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "node", identifierPathRelToBase, field, range);
    }

    public static URI getDataElementIdentifier(URI baseURI, DataElement dataElement) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(dataElement);
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "dataelement", identifierPathRelToBase);
    }

    public static URI getDataElementIdentifier(URI baseURI, DataElement dataElement, String field) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(dataElement);
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "dataelement", identifierPathRelToBase, field);
    }

    public static URI getDataElementIdentifier(URI baseURI, DataElement dataElement, String field, String range) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(dataElement);
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "dataelement", identifierPathRelToBase, field, range);
    }

    public static URI getDataEdgeIdentifier(URI baseURI, Node node, DataElement dataElement, ActivityConstants.AccessType direction) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(node, dataElement, direction);
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "dataedge", identifierPathRelToBase);
    }

    public static URI getEBPIdentifier(URI baseURI, Node node, ExecutableBusinessProcess ebp) {
        String identifierPathRelToBase;
        try {
            identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(node, ebp);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = String.format("Failed to construct the process element identifier URI for the EBP of node '%s (ID = %s)' belonging to template/instance '%s': The activity is not of type 'Activity' or 'LightWeightProcess!", node.getName(), Integer.toString(node.getID()), baseURI);
            logger.log(Level.SEVERE, errorMessage, e);
            return null;
        }
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "ebp", identifierPathRelToBase);
    }

    public static URI getEdgeIdentifier(URI baseURI, Node startNode, Node endNode, ProcessConstants.EdgeType type) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(startNode, endNode);
        if (type == ProcessConstants.EdgeType.ET_CONTROL) {
            return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "controledge", identifierPathRelToBase);
        }
        if (type == ProcessConstants.EdgeType.ET_SYNC) {
            return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "syncedge", identifierPathRelToBase);
        }
        return null;
    }

    public static URI getConstraintEdgeIdentifier(URI baseURI, Node startNode, Node endNode) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(startNode, endNode);
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "constraintedge", identifierPathRelToBase);
    }

    public static URI getBranchIdentifier(URI baseURI, Node startNode, Node endNode) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(startNode, endNode);
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "branch", identifierPathRelToBase);
    }

    public static URI getBlockIdentifier(URI baseURI, Node startNode, Node endNode) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(startNode, endNode);
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "block", identifierPathRelToBase);
    }

    public static URI getParameterIdentifier(URI baseURI, Node node, ExecutableBusinessProcess ebp, ProcessModelParameter parameter) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(node, ebp, parameter);
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "parameter", identifierPathRelToBase);
    }

    public static URI getParameterIdentifier(URI baseURI, Node node, ExecutableBusinessProcess ebp, ProcessModelParameter parameter, String field) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(node, ebp, parameter);
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "parameter", identifierPathRelToBase, field);
    }

    public static URI getParameterIdentifier(URI baseURI, Node node, ExecutableBusinessProcess ebp, ProcessModelParameter parameter, String field, String range) {
        String identifierPathRelToBase = ProcessElementIdentifierTools.generateIdentifierPathRelToBase(node, ebp, parameter);
        return ProcessElementIdentifierTools.generateProcessElementIdentifierURI(baseURI, "parameter", identifierPathRelToBase, field, range);
    }
}

