/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.tools;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;

public class ProcessGraphPredicates {
    protected static final Logger logger = LoggerTools.getLogger(ProcessGraphPredicates.class);

    public static Set<Integer> c_succ_trans(Template template, int nodeID) {
        return ProcessGraphPredicates.pred_succ_trans(template, nodeID, true, true);
    }

    public static Set<Integer> c_pred_trans(Template template, int nodeID) {
        return ProcessGraphPredicates.pred_succ_trans(template, nodeID, false, true);
    }

    public static Set<Integer> succ_trans(Template template, int nodeID) {
        return ProcessGraphPredicates.pred_succ_trans(template, nodeID, true, false);
    }

    public static Set<Integer> pred_trans(Template template, int nodeID) {
        return ProcessGraphPredicates.pred_succ_trans(template, nodeID, false, false);
    }

    public static Set<Integer> c_succ(Template template, int nodeID) {
        return ProcessGraphPredicates.pred_succ(template, nodeID, true, true);
    }

    public static Set<Integer> c_pred(Template template, int nodeID) {
        return ProcessGraphPredicates.pred_succ(template, nodeID, false, true);
    }

    public static Set<Integer> succ(Template template, int nodeID) {
        return ProcessGraphPredicates.pred_succ(template, nodeID, true, false);
    }

    public static Set<Integer> pred(Template template, int nodeID) {
        return ProcessGraphPredicates.pred_succ(template, nodeID, false, false);
    }

    private static Set<Integer> pred_succ(Template template, int nodeID, boolean isSucc, boolean isControlOnly) {
        HashSet<Integer> result = new HashSet<Integer>();
        ProcessConstants.EdgeType[] edgeTypes = isControlOnly ? new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL} : new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL, ProcessConstants.EdgeType.ET_SYNC};
        int[] nodes = isSucc ? template.getSuccByEdgeType(nodeID, edgeTypes) : template.getPredByEdgeType(nodeID, edgeTypes);
        result.addAll(ProcessModelTools.intArrayToInteger(nodes));
        return result;
    }

    private static Set<Integer> pred_succ_trans(Template template, int nodeID, boolean isSucc, boolean isControlOnly) {
        HashSet<Integer> result = new HashSet<Integer>();
        Stack<Integer> nodeStack = new Stack<Integer>();
        nodeStack.push(nodeID);
        ProcessConstants.EdgeType[] edgeTypes = isControlOnly ? new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL} : new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL, ProcessConstants.EdgeType.ET_SYNC};
        boolean firstLoop = true;
        while (!nodeStack.isEmpty()) {
            int nextNodeID = (Integer)nodeStack.pop();
            int[] nextNodes = isSucc ? template.getSuccByEdgeType(nextNodeID, edgeTypes) : template.getPredByEdgeType(nextNodeID, edgeTypes);
            int[] nArray = nextNodes;
            int n = nextNodes.length;
            int n2 = 0;
            while (n2 < n) {
                int succID = nArray[n2];
                if (!result.contains(succID)) {
                    nodeStack.push(succID);
                }
                ++n2;
            }
            if (!firstLoop || nextNodeID != nodeID) {
                result.add(nextNodeID);
            }
            firstLoop = false;
        }
        return result;
    }

    public static int split(Template template, int nodeID) {
        return ProcessGraphPredicates.split_join(template, nodeID, true, false);
    }

    public static int join(Template template, int nodeID) {
        return ProcessGraphPredicates.split_join(template, nodeID, false, false);
    }

    public static int findSplitNode(Template template, int nodeID) {
        return ProcessGraphPredicates.split_join(template, nodeID, true, true);
    }

    private static int split_join(Template template, int nodeID, boolean isJoin, boolean findSplitNode) {
        int subBlockDeepness = 1;
        if (findSplitNode && ProcessGraphPredicates.isBlockEnd(template, nodeID)) {
            ++subBlockDeepness;
        }
        Stack<Integer> nodeStack = new Stack<Integer>();
        nodeStack.push(nodeID);
        while (!nodeStack.isEmpty()) {
            int nextNodeID = (Integer)nodeStack.pop();
            int[] nextNodes = ProcessGraphPredicates.nextNodes(template, nextNodeID, !isJoin);
            if (nextNodes.length == 0) {
                logger.warning("Length of next nodes for '" + nextNodeID + "' was 0, call was on '" + nodeID + "' with isJoin '" + isJoin + "'.");
                return Integer.MIN_VALUE;
            }
            int succPredID = nextNodes[0];
            if (isJoin && ProcessGraphPredicates.isBlockEnd(template, succPredID) || !isJoin && ProcessGraphPredicates.isBlockStart(template, succPredID)) {
                ++subBlockDeepness;
            } else if (isJoin && ProcessGraphPredicates.isBlockStart(template, succPredID) || !isJoin && ProcessGraphPredicates.isBlockEnd(template, succPredID)) {
                --subBlockDeepness;
            }
            if (subBlockDeepness == 0) {
                return succPredID;
            }
            nodeStack.push(succPredID);
        }
        logger.warning("Split / join not found, call was on '" + nodeID + "' with isJoin '" + isJoin + "'.");
        return Integer.MIN_VALUE;
    }

    public static boolean isBlockEnd(Template template, int nodeID) {
        ProcessConstants.NodeType type = template.getNodeType(nodeID);
        switch (type) {
            case NT_ENDFLOW: 
            case NT_AND_JOIN: 
            case NT_XOR_JOIN: 
            case NT_ENDLOOP: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBlockStart(Template template, int nodeID) {
        ProcessConstants.NodeType type = template.getNodeType(nodeID);
        switch (type) {
            case NT_STARTFLOW: 
            case NT_AND_SPLIT: 
            case NT_XOR_SPLIT: 
            case NT_STARTLOOP: {
                return true;
            }
        }
        return false;
    }

    private static int[] nextNodes(Template template, int nodeID, boolean isSucc) {
        if (isSucc) {
            return template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
        }
        return template.getPredByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
    }

    public static Set<Integer> splitNodes(Template template) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (Node node : template.getNodes()) {
            if (!template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_AND_SPLIT) && !template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_XOR_SPLIT)) continue;
            result.add(node.getID());
        }
        return result;
    }

    public static Set<Integer> joinNodes(Template template) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (Node node : template.getNodes()) {
            if (!template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_AND_JOIN) && !template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_XOR_JOIN)) continue;
            result.add(node.getID());
        }
        return result;
    }

    public static int[] branchNodes(Template template, int nodeID1, int nodeID2) {
        if (ProcessGraphPredicates.c_pred_trans(template, nodeID2).contains(nodeID1) || ProcessGraphPredicates.c_pred_trans(template, nodeID1).contains(nodeID2)) {
            return new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
        }
        List<Integer> pred_n1 = ProcessGraphPredicates.orderedListOfSplitPreds(template, nodeID1);
        List<Integer> pred_n2 = ProcessGraphPredicates.orderedListOfSplitPreds(template, nodeID2);
        for (int n : pred_n1) {
            for (int n_ : pred_n2) {
                if (n != n_) continue;
                return new int[]{n, ProcessGraphPredicates.join(template, n)};
            }
        }
        throw new RuntimeException();
    }

    private static List<Integer> orderedListOfSplitPreds(Template template, int nodeID) {
        LinkedList<Integer> result = new LinkedList<Integer>();
        int[] preds = ProcessGraphPredicates.nextNodes(template, nodeID, false);
        while (preds.length >= 1) {
            ProcessConstants.NodeType type = template.getNodeType(preds[0]);
            if (type == ProcessConstants.NodeType.NT_AND_SPLIT || type == ProcessConstants.NodeType.NT_XOR_SPLIT) {
                result.add(preds[0]);
            }
            preds = ProcessGraphPredicates.nextNodes(template, preds[0], false);
        }
        return result;
    }

    public static Set<Integer> loopBody(Template template, int startLoopID) {
        HashSet<Integer> result = new HashSet<Integer>();
        int endLoopID = ProcessGraphPredicates.endloop(template, startLoopID);
        Stack<Integer> nodeStack = new Stack<Integer>();
        nodeStack.push(startLoopID);
        while (!nodeStack.isEmpty()) {
            int[] succs;
            int nodeID = (Integer)nodeStack.pop();
            int[] nArray = succs = ProcessGraphPredicates.nextNodes(template, nodeID, true);
            int n = succs.length;
            int n2 = 0;
            while (n2 < n) {
                int succ = nArray[n2];
                if (!result.contains(succ) && succ != endLoopID) {
                    nodeStack.push(succ);
                }
                ++n2;
            }
            if (nodeID == startLoopID || nodeID == endLoopID) continue;
            result.add(nodeID);
        }
        return result;
    }

    public static int endloop(Template template, int startLoopID) {
        int nestingLevel = 1;
        int[] succs = ProcessGraphPredicates.nextNodes(template, startLoopID, true);
        while (succs.length > 0) {
            ProcessConstants.NodeType type = template.getNodeType(succs[0]);
            if (type.equals((Object)ProcessConstants.NodeType.NT_STARTLOOP)) {
                ++nestingLevel;
            } else if (type.equals((Object)ProcessConstants.NodeType.NT_ENDLOOP)) {
                --nestingLevel;
            }
            if (nestingLevel == 0) {
                return succs[0];
            }
            succs = ProcessGraphPredicates.nextNodes(template, succs[0], true);
        }
        return Integer.MIN_VALUE;
    }
}

