/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.tools;

import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLExport;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;

public class ProcessModelTools {
    public static int[] nodesWithSyncEdgesInArea(Template template, int firstID, int lastID, boolean includingInnerSyncEdges) {
        Set<StructuredEdge> syncEdges = template.getEdgeStructure(ProcessConstants.EdgeType.ET_SYNC);
        HashSet<Node> resultSet = new HashSet<Node>();
        int firstTopID = template.getNodeTopologicalID(firstID);
        int lastTopID = template.getNodeTopologicalID(lastID);
        for (StructuredEdge syncEdge : syncEdges) {
            int srcTopID = template.getNodeTopologicalID(syncEdge.getSourceNodeID());
            int destTopID = template.getNodeTopologicalID(syncEdge.getDestinationNodeID());
            if (srcTopID >= firstTopID && srcTopID <= lastTopID) {
                if (!includingInnerSyncEdges && destTopID >= firstTopID && destTopID <= lastTopID) continue;
                resultSet.add(template.getNode(syncEdge.getSourceNodeID()));
                continue;
            }
            if (destTopID < firstTopID || destTopID > lastTopID) continue;
            resultSet.add(template.getNode(syncEdge.getDestinationNodeID()));
        }
        return ProcessModelTools.intArrayNode(resultSet);
    }

    public static int[] intArrayNode(Set<Node> set) {
        int[] array = new int[set.size()];
        int index = 0;
        for (Node node : set) {
            array[index++] = node.getID();
        }
        return array;
    }

    public static List<Integer> getSplitNodes(Template template, int nodeID) {
        LinkedList<Integer> splitNodeIDs = new LinkedList<Integer>();
        int currentID = nodeID;
        do {
            splitNodeIDs.add(currentID);
        } while ((currentID = template.getNodeSplitNodeID(currentID)) != Integer.MIN_VALUE);
        return splitNodeIDs;
    }

    public static int getCommonSplitNode(Template template, int node1ID, int node2ID) {
        ProcessConstants.NodeType type1 = template.getNodeType(node1ID);
        ProcessConstants.NodeType type2 = template.getNodeType(node2ID);
        if (type1 == ProcessConstants.NodeType.NT_STARTFLOW || type1 == ProcessConstants.NodeType.NT_ENDFLOW || type2 == ProcessConstants.NodeType.NT_STARTFLOW || type2 == ProcessConstants.NodeType.NT_ENDFLOW) {
            throw new IllegalArgumentException("Error: START/ENDFLOW nodes used to find common split node");
        }
        List<Integer> splitNodes1 = ProcessModelTools.getSplitNodes(template, node1ID);
        int splitNodeID = node2ID;
        do {
            if (!splitNodes1.contains(splitNodeID)) continue;
            return splitNodeID;
        } while ((splitNodeID = template.getNodeSplitNodeID(splitNodeID)) != Integer.MIN_VALUE);
        assert (false) : "getCommonSplitNodes called on nodes without a common split node";
        return Integer.MIN_VALUE;
    }

    public static int getBranchEndNode(Template template, int splitNodeID, int branchID) {
        int[] preds;
        int joinNodeID = template.getNodeCorrespondingBlockNodeID(splitNodeID);
        int[] nArray = preds = template.getPredByEdgeType(joinNodeID, ProcessConstants.EdgeType.ET_CONTROL);
        int n = preds.length;
        int n2 = 0;
        while (n2 < n) {
            int pred = nArray[n2];
            if (template.getNodeBranchID(pred) == branchID) {
                return pred;
            }
            ++n2;
        }
        throw new IllegalArgumentException("branchID is not one of the branches leaving splitNode");
    }

    public static int[] getNodesInArea(int first, int last, boolean includeBlocks, Template t, boolean inTransaction) {
        if (t.getNodeBranchID(first) != t.getNodeBranchID(last)) {
            throw new IllegalArgumentException("Programming error (first and last are not on the same block-level)");
        }
        Set<Integer> result = inTransaction ? ProcessModelTools.findNodesSlow(first, last, includeBlocks, t) : ProcessModelTools.findNodes(first, last, includeBlocks, t);
        result.remove(first);
        result.remove(last);
        return ProcessModelTools.integerToIntArray(result);
    }

    protected static Set<Integer> findNodes(int first, int last, boolean includeBlocks, Template template) {
        HashSet<Integer> resultSet = new HashSet<Integer>();
        int i = template.getNodeTopologicalID(first) + 1;
        while (i < template.getNodeTopologicalID(last)) {
            resultSet.add(template.getNodeIDForTopologicalID(i));
            ++i;
        }
        if (!includeBlocks) {
            int branchID = template.getNodeBranchID(first);
            Iterator it = resultSet.iterator();
            while (it.hasNext()) {
                if (template.getNodeBranchID((Integer)it.next()) == branchID) continue;
                it.remove();
            }
        }
        return resultSet;
    }

    protected static Set<Integer> findNodesSlow(int first, int last, boolean includeBlocks, Template template) {
        if (includeBlocks) {
            return ProcessModelTools.findNodesRecursive(first, last, template);
        }
        HashSet<Integer> resultSet = new HashSet<Integer>();
        int currentNodeID = first;
        do {
            resultSet.add(currentNodeID);
            switch (template.getNodeType(currentNodeID)) {
                case NT_AND_SPLIT: 
                case NT_XOR_SPLIT: 
                case NT_STARTLOOP: {
                    currentNodeID = template.getNodeCorrespondingBlockNodeID(currentNodeID);
                    break;
                }
                default: {
                    currentNodeID = template.getSuccByEdgeType(currentNodeID, ProcessConstants.EdgeType.ET_CONTROL)[0];
                }
            }
        } while (currentNodeID != last);
        return resultSet;
    }

    protected static Set<Integer> findNodesRecursive(int startID, int endID, Template template) {
        HashSet<Integer> resultSet = new HashSet<Integer>();
        int currentNode = startID;
        while (currentNode != endID) {
            resultSet.add(currentNode);
            switch (template.getNodeType(currentNode)) {
                case NT_AND_SPLIT: 
                case NT_XOR_SPLIT: {
                    int correspondingBlockNodeID = template.getNodeCorrespondingBlockNodeID(currentNode);
                    int[] nArray = template.getSuccByEdgeType(currentNode, ProcessConstants.EdgeType.ET_CONTROL);
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int successor = nArray[n2];
                        resultSet.addAll(ProcessModelTools.findNodesRecursive(successor, correspondingBlockNodeID, template));
                        ++n2;
                    }
                    currentNode = correspondingBlockNodeID;
                    break;
                }
                default: {
                    currentNode = template.getSuccByEdgeType(currentNode, ProcessConstants.EdgeType.ET_CONTROL)[0];
                }
            }
        }
        return resultSet;
    }

    public static boolean isInParallelBranch(Template template, int nodeID) {
        boolean ret = false;
        Node current = template.getNode(nodeID);
        while (current != null && template.getNodeType(current.getID()) != ProcessConstants.NodeType.NT_STARTFLOW) {
            if (template.getNodeType(current.getID()) == ProcessConstants.NodeType.NT_AND_SPLIT) {
                ret = true;
                break;
            }
            current = template.getNode(template.getNodeSplitNodeID(current.getID()));
        }
        return ret;
    }

    public static Map<Integer, String> getWrittenDataElements(Template template, int nodeID) {
        int id;
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        int[] deIDs = template.getAccessedDataElementIDsForNode(nodeID, ActivityConstants.AccessType.WRITE);
        int i = 0;
        while (i < deIDs.length) {
            id = deIDs[i];
            ret.put(id, template.getDataElement(id).getName());
            ++i;
        }
        deIDs = template.getAccessedDataElementIDsForNode(nodeID, ActivityConstants.AccessType.SYSTEM_WRITE);
        i = 0;
        while (i < deIDs.length) {
            id = deIDs[i];
            ret.put(id, template.getDataElement(id).getName());
            ++i;
        }
        return ret;
    }

    public static Set<Integer> getDataElementIDsByName(Template template, Set<String> names) {
        HashSet<Integer> res = new HashSet<Integer>(names.size());
        block0: for (String name : names) {
            for (DataElement dataElement : template.getDataElements()) {
                if (!dataElement.getName().equals(name)) continue;
                res.add(dataElement.getID());
                continue block0;
            }
            throw new IllegalArgumentException(String.format("The data element with the name '%s' does not exist in the given template!", name));
        }
        return res;
    }

    public static int[] integerToIntArray(Collection<Integer> integerArray) {
        int[] intArray = new int[integerArray.size()];
        int counter = 0;
        for (Integer i : integerArray) {
            intArray[counter] = i;
            ++counter;
        }
        return intArray;
    }

    public static List<Integer> intArrayToInteger(int[] intArray) {
        LinkedList<Integer> integer = new LinkedList<Integer>();
        int i = 0;
        while (i < intArray.length) {
            integer.add(intArray[i]);
            ++i;
        }
        return integer;
    }

    public static int[] intArrayDataElement(Set<DataElement> set) {
        int[] array = new int[set.size()];
        int index = 0;
        for (DataElement de : set) {
            array[index++] = de.getID();
        }
        return array;
    }

    public static Template cloneTemplate(Template template, ProcessModelFactory factory) {
        Document document;
        ProcessModelXMLExport xmlExport = new ProcessModelXMLExport();
        ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(factory);
        try {
            document = xmlExport.getDocumentForTemplate(template);
        }
        catch (XMLFormatException e) {
            e.printStackTrace();
            throw new RuntimeException("Cloning the template failed due to a failed validation of a xml document!", e);
        }
        Template clonedTemplate = xmlImport.getTemplateFromDocument(document);
        return clonedTemplate;
    }

    public static TemplateStatus cloneTemplateStatus(TemplateStatus status, ProcessModelFactory factory) {
        return factory.createTemplateStatus(status.getTemplateID(), status.getBuildtimeState(), status.getUsageAsSubprocess(), status.isTopLevelUsable(), status.isDerivable(), status.getDerivableComment(), status.isOutdated(false), status.getOutdatedComment(false), status.isOutdated(true), status.getOutdatedComment(true), status.isInstantiable(false), status.getInstantiableComment(false), status.isInstantiable(true), status.getInstantiableComment(true), status.areInstancesMigratableTo(false), status.getInstancesMigratableToComment(false), status.areInstancesMigratableTo(true), status.getInstancesMigratableToComment(true), status.areInstancesChangeable(false), status.getInstancesChangeableComment(false), status.areInstancesChangeable(true), status.getInstancesChangeableComment(true), status.getStarterRule());
    }

    public static boolean isNullNode(ProcessConstants.NodeType type) {
        switch (type) {
            case NT_STARTFLOW: 
            case NT_ENDFLOW: 
            case NT_AND_SPLIT: 
            case NT_AND_JOIN: 
            case NT_XOR_JOIN: 
            case NT_STARTLOOP: {
                return true;
            }
        }
        return false;
    }

    public static TemplateStatus updateTemplateStatus(TemplateStatus status, ProcessConstants.TemplateBuildtimeState buildtimeState, ProcessModelFactory pmf) {
        return pmf.createTemplateStatus(status.getTemplateID(), buildtimeState, status.getUsageAsSubprocess(), status.isTopLevelUsable(), status.isDerivable(), status.getDerivableComment(), status.isOutdated(false), status.getOutdatedComment(false), status.isOutdated(true), status.getOutdatedComment(true), status.isInstantiable(false), status.getInstantiableComment(false), status.isInstantiable(true), status.getInstantiableComment(true), status.areInstancesMigratableTo(false), status.getInstancesMigratableToComment(false), status.areInstancesMigratableTo(true), status.getInstancesMigratableToComment(true), status.areInstancesChangeable(false), status.getInstancesChangeableComment(false), status.areInstancesChangeable(true), status.getInstancesChangeableComment(true), status.getStarterRule());
    }

    public static boolean isSystemDataElement(Template template, int dataElementID) {
        return (template.getAccessingNodeIDsForDataElement(dataElementID, ActivityConstants.AccessType.SYSTEM_READ).length != 0 || template.getAccessingNodeIDsForDataElement(dataElementID, ActivityConstants.AccessType.SYSTEM_WRITE).length != 0) && template.getAccessingNodeIDsForDataElement(dataElementID, ActivityConstants.AccessType.READ).length == 0 && template.getAccessingNodeIDsForDataElement(dataElementID, ActivityConstants.AccessType.WRITE).length == 0;
    }

    public static boolean isDecisionDataElement(Template template, int dataElementID) {
        int[] writeNodeIDs = template.getAccessingNodeIDsForDataElement(dataElementID, ActivityConstants.AccessType.WRITE);
        if (writeNodeIDs.length != 0 && template.getAccessingNodeIDsForDataElement(dataElementID, ActivityConstants.AccessType.READ).length == 0) {
            int[] nArray = writeNodeIDs;
            int n = writeNodeIDs.length;
            int n2 = 0;
            while (n2 < n) {
                int writeNodeID = nArray[n2];
                if (template.getNodeType(writeNodeID) != ProcessConstants.NodeType.NT_XOR_SPLIT && template.getNodeType(writeNodeID) != ProcessConstants.NodeType.NT_ENDLOOP) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }
}

