/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.xml;

import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLConstants;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLExportTools;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLHelperTools;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProcessModelXMLExport {
    private static final Logger logger = LoggerTools.getLogger(ProcessModelXMLExport.class);
    static final String[] shellMethods = new String[]{"writeTemplateToFile", "getXMLStringForTemplate", "getOutputStreamForTemplate", "getDocumentForTemplate", "writeInstanceToFile", "getXMLStringForInstance", "getOutputStreamForInstance", "getDocumentForInstance"};

    public void writeTemplateToFile(Template template, File file) throws IOException, XMLFormatException {
        Document doc = this.getDocumentForTemplate(template);
        XMLHelperTools.writeDocumentToFile(doc, file, ProcessModelXMLHelperTools.getSchemaForSchemaType(ProcessModelXMLConstants.SchemaType.TEMPLATE));
    }

    public void writeTemplateAndStatusToFile(Template template, TemplateStatus templateStatus, File file) throws IOException, XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createTemplateElement(document, template, templateStatus);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel template.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        XMLHelperTools.writeDocumentToFile(document, file, ProcessModelXMLHelperTools.getSchemaForSchemaType(ProcessModelXMLConstants.SchemaType.TEMPLATE));
    }

    public void writeInstanceToFile(Instance instance, File file) throws IOException, XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createInstanceElement(document, instance, true);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel instance.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        XMLHelperTools.writeDocumentToFile(document, file, ProcessModelXMLHelperTools.getSchemaForSchemaType(ProcessModelXMLConstants.SchemaType.INSTANCE));
    }

    public void writeInstanceAndStatusToFile(Instance instance, InstanceStatus instanceStatus, File file, boolean storeStructure) throws IOException, XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createInstanceElement(document, instance, storeStructure, instanceStatus);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel instance.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        XMLHelperTools.writeDocumentToFile(document, file, ProcessModelXMLHelperTools.getSchemaForSchemaType(ProcessModelXMLConstants.SchemaType.INSTANCE));
    }

    public void writeExecutableInstanceAndStatusToFile(ExecutableInstance instance, InstanceStatus instanceStatus, File file, boolean storeStructure) throws IOException, XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createExecutableInstanceElement(document, instance, storeStructure, instanceStatus);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel executableInstance.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        XMLHelperTools.writeDocumentToFile(document, file, ProcessModelXMLHelperTools.getSchemaForSchemaType(ProcessModelXMLConstants.SchemaType.EXECUTABLE_INSTANCE));
    }

    public String getXMLStringForTemplate(Template template) throws XMLFormatException, IOException {
        return XMLHelperTools.getXMLStringForDocument(this.getDocumentForTemplate(template));
    }

    public String getXMLStringForInstance(Instance instance) throws XMLFormatException, IOException {
        return XMLHelperTools.getXMLStringForDocument(this.getDocumentForInstance(instance));
    }

    public InputStream getInputStreamForTemplate(Template template) throws XMLFormatException, IOException {
        return XMLHelperTools.getInputStreamForDocument(this.getDocumentForTemplate(template));
    }

    public InputStream getInputStreamForTemplateAndStatus(Template template, TemplateStatus templateStatus) throws XMLFormatException, IOException {
        return XMLHelperTools.getInputStreamForDocument(this.getDocumentForTemplateAndStatus(template, templateStatus));
    }

    public Document getDocumentForTemplateAndStatus(Template template, TemplateStatus templateStatus) throws XMLFormatException {
        Document doc = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createTemplateElement(doc, template, templateStatus);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel template.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        doc.appendChild(root);
        try {
            ProcessModelXMLHelperTools.validateDocument(doc, ProcessModelXMLConstants.SchemaType.TEMPLATE);
        }
        catch (XMLFormatException ex) {
            String message = "The template document is not valid!";
            logger.log(Level.SEVERE, message, ex);
            throw new XMLFormatException("The template could not be exported since the document is not valid! Note: A ValidationException would be better here, but is not provided!", ex);
        }
        return doc;
    }

    public InputStream getInputStreamForInstance(Instance instance) throws XMLFormatException, IOException {
        return XMLHelperTools.getInputStreamForDocument(this.getDocumentForInstance(instance));
    }

    public Document getDocumentForExecutableInstanceAndStatus(ExecutableInstance instance, InstanceStatus instanceStatus, boolean storeStructure) {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createExecutableInstanceElement(document, instance, storeStructure, instanceStatus);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel executableInstance.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        return document;
    }

    public Document getDocumentForTemplate(Template template) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createTemplateElement(document, template);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel template.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        try {
            ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.TEMPLATE);
        }
        catch (XMLFormatException ex) {
            String message = "The template document is not valid!";
            logger.log(Level.SEVERE, message, ex);
            throw new XMLFormatException("The template could not be exported since the document is not valid! Note: A ValidationException would be better here, but is not provided!", ex);
        }
        return document;
    }

    public Document getDocumentForInstance(Instance instance) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createInstanceElement(document, instance, true);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel instance.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        try {
            ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.INSTANCE);
        }
        catch (XMLFormatException ex) {
            logger.log(Level.SEVERE, "The instance document is not valid!", ex);
            throw new XMLFormatException("The instance could not be exported since the document is not valid! Note: A ValidationException would be better here, but is not provided!", ex);
        }
        return document;
    }

    public Document getDocumentForEBP(ExecutableBusinessProcess ebp) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createExecutableBusinessProcessElement(document, ebp);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel executableBusinessProcess.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        try {
            ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.EBP);
        }
        catch (XMLFormatException ex) {
            String message = "The ebp document is not valid!";
            logger.log(Level.SEVERE, message, ex);
            throw new XMLFormatException("The ebp could not be exported since the document is not valid! Note: A ValidationException would be better here, but is not provided!", ex);
        }
        return document;
    }

    public Document getDocumentForEBPInstance(ExecutableBusinessProcessInstance ebpInstance) {
        Document document = XMLHelperTools.createDocument();
        document.appendChild(ProcessModelXMLExportTools.createExecutableBusinessProcessInstanceElement(document, ebpInstance));
        return document;
    }

    public Document getDocumentForParameter(ProcessModelParameter parameter, boolean isInputParameter) {
        Document document = XMLHelperTools.createDocument();
        if (isInputParameter) {
            document.appendChild(ProcessModelXMLExportTools.createInputParameterElement(document, parameter, false));
        } else {
            document.appendChild(ProcessModelXMLExportTools.createOutputParameterElement(document, parameter));
        }
        return document;
    }

    public Document getDocumentForParameterSet(Collection<ProcessModelParameter> parameter, boolean isInputParameter) {
        Document document = XMLHelperTools.createDocument();
        if (isInputParameter) {
            document.appendChild(ProcessModelXMLExportTools.createIndexedInputParametersElement(document, parameter, null));
        } else {
            document.appendChild(ProcessModelXMLExportTools.createOutputParametersElement(document, parameter));
        }
        return document;
    }

    public Document getDocumentDataElementList(Set<DataElement> dataElements) {
        Document document = XMLHelperTools.createDocument();
        Element root = document.createElementNS("http://www.aristaflow.de/adept2/processmodel", "dataElements");
        document.appendChild(root);
        for (DataElement dataElement : dataElements) {
            Element element = ProcessModelXMLExportTools.createDataElementElement(document, dataElement);
            root.appendChild(element);
        }
        return document;
    }

    public Document getDocumentForTemplateLocks(Map<UUID, ProcessModelXMLHelperTools.LockDescription> locks) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createTemplateLocksElement(document, locks);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel templateLocks.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        try {
            ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.TEMPLATE_LOCKS);
        }
        catch (XMLFormatException ex) {
            String message = "The template locks document is not valid!";
            logger.log(Level.SEVERE, message, ex);
            throw new XMLFormatException(message, ex);
        }
        return document;
    }

    public void writeTemplateLocksToFile(Map<UUID, ProcessModelXMLHelperTools.LockDescription> locks, File file) throws IOException, XMLFormatException {
        Document doc = this.getDocumentForTemplateLocks(locks);
        XMLHelperTools.writeDocumentToFile(doc, file, ProcessModelXMLHelperTools.getSchemaForSchemaType(ProcessModelXMLConstants.SchemaType.TEMPLATE_LOCKS));
    }

    public Document getDocumentForInstanceLocks(Map<UUID, ProcessModelXMLHelperTools.LockDescription> locks) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createInstanceLocksElement(document, locks);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel instanceLocks.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        try {
            ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.INSTANCE_LOCKS);
        }
        catch (XMLFormatException ex) {
            String message = "The instance locks document is not valid!";
            logger.log(Level.SEVERE, message, ex);
            throw new XMLFormatException(message, ex);
        }
        return document;
    }

    public void writeInstanceLocksToFile(Map<UUID, ProcessModelXMLHelperTools.LockDescription> locks, File file) throws IOException, XMLFormatException {
        Document doc = this.getDocumentForInstanceLocks(locks);
        XMLHelperTools.writeDocumentToFile(doc, file, ProcessModelXMLHelperTools.getSchemaForSchemaType(ProcessModelXMLConstants.SchemaType.INSTANCE_LOCKS));
    }

    public Document getDocumentForEmbeddedTemplateMapping(Map<UUID, UUID> mapping) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createEmbeddedTemplateMappingElement(document, mapping);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel embeddedTemplateMapping.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        try {
            ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.EMBEDDED_TEMPLATE_MAPPING);
        }
        catch (XMLFormatException ex) {
            String message = "The embedded template mapping document is not valid!";
            logger.log(Level.SEVERE, message, ex);
            throw new XMLFormatException(message, ex);
        }
        return document;
    }

    public void writeEmbeddedTemplateMappingToFile(Map<UUID, UUID> mapping, File file) throws IOException, XMLFormatException {
        Document doc = this.getDocumentForEmbeddedTemplateMapping(mapping);
        XMLHelperTools.writeDocumentToFile(doc, file, ProcessModelXMLHelperTools.getSchemaForSchemaType(ProcessModelXMLConstants.SchemaType.EMBEDDED_TEMPLATE_MAPPING));
    }

    public Document getDocumentForBaseTemplateMapping(Map<UUID, UUID> mapping) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createBaseTemplateMappingElement(document, mapping);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel baseTemplateMapping.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        try {
            ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.BASE_TEMPLATE_MAPPING);
        }
        catch (XMLFormatException ex) {
            String message = "The base template mapping document is not valid!";
            logger.log(Level.SEVERE, message, ex);
            throw new XMLFormatException(message, ex);
        }
        return document;
    }

    public void writeBaseTemplateMappingToFile(Map<UUID, UUID> mapping, File file) throws IOException, XMLFormatException {
        Document doc = this.getDocumentForBaseTemplateMapping(mapping);
        XMLHelperTools.writeDocumentToFile(doc, file, ProcessModelXMLHelperTools.getSchemaForSchemaType(ProcessModelXMLConstants.SchemaType.BASE_TEMPLATE_MAPPING));
    }

    public Document getDocumentForAdhocTemplateMapping(Map<UUID, UUID> mapping) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createAdhocTemplateMappingElement(document, mapping);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel adhocTemplateMapping.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        try {
            ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.ADHOC_TEMPLATE_MAPPING);
        }
        catch (XMLFormatException ex) {
            String message = "The adhoc template mapping document is not valid!";
            logger.log(Level.SEVERE, message, ex);
            throw new XMLFormatException(message, ex);
        }
        return document;
    }

    public void writeAdhocTemplateMappingToFile(Map<UUID, UUID> mapping, File file) throws IOException, XMLFormatException {
        Document doc = this.getDocumentForAdhocTemplateMapping(mapping);
        XMLHelperTools.writeDocumentToFile(doc, file, ProcessModelXMLHelperTools.getSchemaForSchemaType(ProcessModelXMLConstants.SchemaType.ADHOC_TEMPLATE_MAPPING));
    }

    public Document getDocumentForProcessTypes(Set<ProcessModelXMLHelperTools.SerialisableProcessType> items) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createProcessTypesElement(document, items);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel processTypes.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        try {
            ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.PROCESS_TYPES);
        }
        catch (XMLFormatException ex) {
            String message = "The process types document is not valid!";
            logger.log(Level.SEVERE, message, ex);
            throw new XMLFormatException(message, ex);
        }
        return document;
    }

    public void writeProcessTypesToFile(Set<ProcessModelXMLHelperTools.SerialisableProcessType> items, File file) throws IOException, XMLFormatException {
        Document doc = this.getDocumentForProcessTypes(items);
        XMLHelperTools.writeDocumentToFile(doc, file, ProcessModelXMLHelperTools.getSchemaForSchemaType(ProcessModelXMLConstants.SchemaType.PROCESS_TYPES));
    }

    public Document getDocumentForTemplateInformations(Map<UUID, ProcessModelXMLHelperTools.TemplateInformation> items) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = ProcessModelXMLExportTools.createTemplateInformationsElement(document, items);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/processmodel templateInformations.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        try {
            ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.TEMPLATE_INFORMATIONS);
        }
        catch (XMLFormatException ex) {
            String message = "The template informations document is not valid!";
            logger.log(Level.SEVERE, message, ex);
            throw new XMLFormatException(message, ex);
        }
        return document;
    }

    public void writeTemplateInformationsToFile(Map<UUID, ProcessModelXMLHelperTools.TemplateInformation> items, File file) throws IOException, XMLFormatException {
        Document doc = this.getDocumentForTemplateInformations(items);
        XMLHelperTools.writeDocumentToFile(doc, file, ProcessModelXMLHelperTools.getSchemaForSchemaType(ProcessModelXMLConstants.SchemaType.TEMPLATE_INFORMATIONS));
    }
}

