/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.xml;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.common.XMLExportTools;
import de.aristaflow.adept2.model.common.tools.ParameterComparator;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.DecisionActivityInstance;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.LightWeightProcessInstance;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceDeltaLayer;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.StructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.StructuredDataEdge;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLHelperTools;
import de.aristaflow.adept2.util.Base64;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProcessModelXMLExportTools
extends XMLExportTools {
    private static final String NS = "http://www.aristaflow.de/adept2/processmodel";

    static Element createIndexedInputParametersElement(Document document, Collection<ProcessModelParameter> parameters, Collection<ProcessModelParameter> indexedParameters) {
        Element inputsElement = document.createElementNS(NS, "inputParameters");
        for (ProcessModelParameter parameter : ProcessModelXMLExportTools.sortedParameters(parameters)) {
            if (indexedParameters != null && ProcessModelXMLExportTools.parameterCollectionContainsParameter(indexedParameters, parameter)) {
                inputsElement.appendChild(ProcessModelXMLExportTools.createInputParameterElement(document, parameter, true));
                continue;
            }
            inputsElement.appendChild(ProcessModelXMLExportTools.createInputParameterElement(document, parameter, false));
        }
        return inputsElement;
    }

    private static boolean parameterCollectionContainsParameter(Collection<ProcessModelParameter> indexedParameters, ProcessModelParameter parameter) {
        for (ProcessModelParameter p : indexedParameters) {
            if (!p.getName().equals(parameter.getName())) continue;
            return true;
        }
        return false;
    }

    static Element createOutputParametersElement(Document document, Collection<ProcessModelParameter> parameters) {
        Element outputsElement = document.createElementNS(NS, "outputParameters");
        for (ProcessModelParameter parameter : ProcessModelXMLExportTools.sortedParameters(parameters)) {
            outputsElement.appendChild(ProcessModelXMLExportTools.createOutputParameterElement(document, parameter));
        }
        return outputsElement;
    }

    static Element createInputParameterElement(Document document, ProcessModelParameter parameter, boolean indexed) {
        Element parameterElement = document.createElementNS(NS, "inputParameter");
        ProcessModelXMLExportTools.fillParameter(parameter, parameterElement, document, indexed);
        return parameterElement;
    }

    static Element createOutputParameterElement(Document document, ProcessModelParameter parameter) {
        Element parameterElement = document.createElementNS(NS, "outputParameter");
        ProcessModelXMLExportTools.fillParameter(parameter, parameterElement, document, false);
        return parameterElement;
    }

    private static void fillParameter(Parameter parameter, Element parameterElement, Document document, boolean indexed) {
        ProcessModelXMLExportTools.addElement(document, parameterElement, "name", parameter.getName());
        ProcessModelXMLExportTools.addElement(document, parameterElement, "description", parameter.getDescription());
        ProcessModelXMLExportTools.addElement(document, parameterElement, "type", parameter.getDataType().toString());
        ProcessModelXMLExportTools.addElement(document, parameterElement, "identifierID", parameter.getIdentifierID().toString());
        ProcessModelXMLExportTools.addElement(document, parameterElement, "isOptional", Boolean.toString(parameter.isOptional()));
        if (indexed) {
            ProcessModelXMLExportTools.addElement(document, parameterElement, "indexed", Boolean.toString(true));
        }
        if (parameter.getDataType().equals((Object)ProcessConstants.AdeptDataType.USERDEFINED)) {
            ProcessModelXMLExportTools.addElement(document, parameterElement, "udtName", parameter.getUDTName());
        }
        if (parameter.isVirtual()) {
            ProcessModelXMLExportTools.addElement(document, parameterElement, "isVirtual", Boolean.toString(parameter.isVirtual()));
        }
        if (parameter.isFailure()) {
            ProcessModelXMLExportTools.addElement(document, parameterElement, "isFailure", Boolean.toString(parameter.isFailure()));
        }
        if (parameter.getDefaultValue() != null) {
            ProcessModelXMLExportTools.addElement(document, parameterElement, "defaultValue", parameter.getDefaultValue());
        }
        if (parameter.getConfiguration().getAllEntries().size() > 0) {
            parameterElement.appendChild(ProcessModelXMLExportTools.createConfigurationElement(document, NS, parameter.getConfiguration(), "configuration", null, null));
        }
        if (parameter.getSupportedPlugins().size() > 0) {
            parameterElement.appendChild(ProcessModelXMLExportTools.createPluginDataContainerElement(document, NS, parameter));
        }
        if (parameter.getUserAttributes().size() > 0) {
            parameterElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, parameter.getUserAttributes()));
        }
    }

    static Element createDataElementElement(Document document, DataElement dataElement) {
        Element deElement = document.createElementNS(NS, "dataElement");
        deElement.setAttributeNS(null, "id", "d" + Integer.toString(dataElement.getID()));
        ProcessModelXMLExportTools.addElement(document, deElement, "type", dataElement.getDataType().toString());
        ProcessModelXMLExportTools.addElement(document, deElement, "name", dataElement.getName());
        ProcessModelXMLExportTools.addElement(document, deElement, "description", dataElement.getDescription());
        if (dataElement.getIconID() != null) {
            ProcessModelXMLExportTools.addElement(document, deElement, "iconID", dataElement.getIconID().toString());
        }
        ProcessModelXMLExportTools.addElement(document, deElement, "identifierID", dataElement.getIdentifierID().toString());
        ProcessModelXMLExportTools.addElement(document, deElement, "isPublic", Boolean.toString(dataElement.isPublic()));
        if (dataElement.getDataType().equals((Object)ProcessConstants.AdeptDataType.USERDEFINED)) {
            ProcessModelXMLExportTools.addElement(document, deElement, "udtName", dataElement.getUDTName());
        }
        if (dataElement.getSupportedPlugins().size() > 0) {
            deElement.appendChild(ProcessModelXMLExportTools.createPluginDataContainerElement(document, NS, dataElement));
        }
        if (dataElement.getUserAttributes().size() > 0) {
            deElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, dataElement.getUserAttributes()));
        }
        if (dataElement.isVirtual()) {
            ProcessModelXMLExportTools.addElement(document, deElement, "isVirtual", Boolean.toString(dataElement.isVirtual()));
        }
        return deElement;
    }

    static Element createEdgeElement(Document document, Edge edge) {
        Element edgeElement = document.createElementNS(NS, "edge");
        ProcessModelXMLExportTools.addElement(document, edgeElement, "edgeType", edge.getType().toString());
        if (edge.getEdgeCode() != Integer.MIN_VALUE) {
            ProcessModelXMLExportTools.addElement(document, edgeElement, "edgeCode", Long.toString(edge.getEdgeCode()));
        }
        if (edge.getUserAttributes().size() > 0) {
            edgeElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, edge.getUserAttributes()));
        }
        return edgeElement;
    }

    static Element createStructuredEdgeElement(Document document, Edge edge, int sourceNodeID, int destinationNodeID) {
        Element edgeElement = ProcessModelXMLExportTools.createEdgeElement(document, edge);
        edgeElement.setAttributeNS(null, "sourceNodeID", "n" + Integer.toString(sourceNodeID));
        edgeElement.setAttributeNS(null, "destinationNodeID", "n" + Integer.toString(destinationNodeID));
        edgeElement.setAttributeNS(null, "edgeType", edge.getType().toString());
        return edgeElement;
    }

    static Element createConstraintEdgeElement(Document document, ConstraintEdge edge) {
        Element edgeElement = document.createElementNS(NS, "constraintEdge");
        if (edge.getSupportedPlugins().size() > 0) {
            edgeElement.appendChild(ProcessModelXMLExportTools.createPluginDataContainerElement(document, NS, edge));
        }
        if (edge.getUserAttributes().size() > 0) {
            edgeElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, edge.getUserAttributes()));
        }
        return edgeElement;
    }

    static Element createStructuredConstraintEdgeElement(Document document, ConstraintEdge edge, int sourceNodeID, int destinationNodeID) {
        Element edgeElement = ProcessModelXMLExportTools.createConstraintEdgeElement(document, edge);
        edgeElement.setAttributeNS(null, "sourceNodeID", "n" + Integer.toString(sourceNodeID));
        edgeElement.setAttributeNS(null, "destinationNodeID", "n" + Integer.toString(destinationNodeID));
        return edgeElement;
    }

    static Element createDataEdgeElement(Document document, DataEdge dataEdge) {
        Element dataEdgeElement = document.createElementNS(NS, "dataEdge");
        ProcessModelXMLExportTools.addElement(document, dataEdgeElement, "dataEdgeType", dataEdge.getType().toString());
        ProcessModelXMLExportTools.addElement(document, dataEdgeElement, "isOptional", Boolean.toString(dataEdge.isOptional()));
        if (dataEdge.getUserAttributes().size() > 0) {
            dataEdgeElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, dataEdge.getUserAttributes()));
        }
        return dataEdgeElement;
    }

    static Element createStructuredDataEdgeElement(Document document, DataEdge dataEdge, int nodeID, int connectorID, int dataElementID) {
        Element dataEdgeElement = ProcessModelXMLExportTools.createDataEdgeElement(document, dataEdge);
        dataEdgeElement.setAttributeNS(null, "nodeID", "n" + Integer.toString(nodeID));
        dataEdgeElement.setAttributeNS(null, "connectorID", Integer.toString(connectorID));
        dataEdgeElement.setAttributeNS(null, "dataElementID", "d" + Integer.toString(dataElementID));
        dataEdgeElement.setAttributeNS(null, "dataEdgeType", dataEdge.getType().toString());
        return dataEdgeElement;
    }

    static Element createActivityElement(Document doc, Activity activity) {
        Element activityElement = doc.createElementNS(NS, "activity");
        activityElement.setAttributeNS(null, "id", activity.getID().toString());
        ProcessModelXMLExportTools.addElement(doc, activityElement, "ecName", activity.getExecutableComponentName());
        ProcessModelXMLExportTools.addElement(doc, activityElement, "operationName", activity.getOperationName());
        if (activity.getConfigurationName() != null) {
            ProcessModelXMLExportTools.addElement(doc, activityElement, "configurationName", activity.getConfigurationName());
        }
        ProcessModelXMLExportTools.addElement(doc, activityElement, "name", activity.getActivityName());
        ProcessModelXMLExportTools.addElement(doc, activityElement, "description", activity.getDescription(), activity.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.DESCRIPTION));
        ProcessModelXMLExportTools.addElement(doc, activityElement, "implementationClass", activity.getImplementationClass(), activity.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.IMPLEMENTATION_CLASS));
        if (activity.getClassPath().size() > 0) {
            activityElement.appendChild(ProcessModelXMLExportTools.createSeparatedClassPathElement(doc, NS, "classPaths", activity.getSeparatedClassPaths()));
        }
        ProcessModelXMLExportTools.addElement(doc, activityElement, "isSingleton", Boolean.toString(activity.isSingleton()), activity.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.IS_SINGLETON));
        if (activity.getSystemComponent() != null) {
            ProcessModelXMLExportTools.addElement(doc, activityElement, "systemComponent", Base64.encodeBytes(activity.getSystemComponent()), activity.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT));
        }
        ProcessModelXMLExportTools.addElement(doc, activityElement, "guiContextID", activity.getGUIContextID(), activity.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.GUI_CONTEXT_ID));
        activityElement.appendChild(ProcessModelXMLExportTools.createECPElement(doc, NS, activity.getExecutionControlProperties(), activity.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.EXECUTION_CONTROL_PROPERTIES)));
        ProcessModelXMLExportTools.addElement(doc, activityElement, "supportsViewOnly", Boolean.toString(activity.supportsViewOnly()), activity.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_VIEW_ONLY));
        ProcessModelXMLExportTools.addElement(doc, activityElement, "supportsTestExecution", Boolean.toString(activity.supportsTestExecution()), activity.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_TEST_EXECUTION));
        if (activity.getIconID() != null) {
            ProcessModelXMLExportTools.addElement(doc, activityElement, "iconID", activity.getIconID().toString(), activity.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID));
        }
        if (activity.getConfiguration().getAllEntries().size() > 0) {
            activityElement.appendChild(ProcessModelXMLExportTools.createConfigurationElement(doc, NS, activity.getConfiguration(), "configuration", null, null));
        }
        if (activity.getTestConfiguration().getAllEntries().size() > 0) {
            activityElement.appendChild(ProcessModelXMLExportTools.createConfigurationElement(doc, NS, activity.getTestConfiguration(), "testConfiguration", null, null));
        }
        ProcessModelXMLExportTools.addElement(doc, activityElement, "parameterChangePolicy", activity.getParameterChangePolicy().name());
        if (activity instanceof DecisionActivity) {
            DecisionActivity decActivity = (DecisionActivity)activity;
            ProcessModelXMLExportTools.addElement(doc, activityElement, "decisionParameter", decActivity.getDecisionParameter().getName());
            if (decActivity.getAllDecisionStatements().size() > 0) {
                activityElement.appendChild(ProcessModelXMLExportTools.createDecisionStatementsElement(doc, decActivity.getAllDecisionStatements(), decActivity));
            }
        }
        if (activity.getParameters(ActivityConstants.AccessType.READ).size() > 0) {
            activityElement.appendChild(ProcessModelXMLExportTools.createIndexedInputParametersElement(doc, activity.getParameters(ActivityConstants.AccessType.READ), null));
        }
        if (activity.getParameters(ActivityConstants.AccessType.WRITE).size() > 0) {
            activityElement.appendChild(ProcessModelXMLExportTools.createOutputParametersElement(doc, activity.getParameters(ActivityConstants.AccessType.WRITE)));
        }
        if (activity.getSupportedPlugins().size() > 0) {
            activityElement.appendChild(ProcessModelXMLExportTools.createPluginDataContainerElement(doc, NS, activity));
        }
        if (activity.getUserAttributes().size() > 0) {
            activityElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(doc, NS, activity.getUserAttributes()));
        }
        return activityElement;
    }

    static Element createActivityInstanceElement(Document document, ActivityInstance activityInstance) {
        Element activityInstanceElement = document.createElementNS(NS, "activityInstance");
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "name", activityInstance.getName());
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "id", activityInstance.getID().toString());
        activityInstanceElement.appendChild(ProcessModelXMLExportTools.createECPElement(document, NS, activityInstance.getExecutionControlProperties(), activityInstance.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.EXECUTION_CONTROL_PROPERTIES)));
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "operationName", activityInstance.getOperationName());
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "ecName", activityInstance.getExecutableComponentName());
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "configurationName", activityInstance.getConfigurationName());
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "activityName", activityInstance.getActivityName());
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "description", activityInstance.getDescription(), activityInstance.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.DESCRIPTION));
        activityInstanceElement.appendChild(ProcessModelXMLExportTools.createDataContextElement(document, activityInstance.getAttachedDataContext()));
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "processInstanceLogID", activityInstance.getProcessInstanceLogID().toString());
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "processInstanceName", activityInstance.getProcessInstanceName());
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "processTemplateName", activityInstance.getProcessTemplateName());
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "implementationClass", activityInstance.getImplementationClass(), activityInstance.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.IMPLEMENTATION_CLASS));
        if (activityInstance.getClassPath().size() > 0) {
            activityInstanceElement.appendChild(ProcessModelXMLExportTools.createSeparatedClassPathElement(document, NS, "classPaths", activityInstance.getSeparatedClassPaths()));
        }
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "isSingleton", Boolean.toString(activityInstance.isSingleton()), activityInstance.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.IS_SINGLETON));
        if (activityInstance.getSystemComponent() != null) {
            ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "systemComponent", Base64.encodeBytes(activityInstance.getSystemComponent()), activityInstance.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT));
        }
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "guiContextID", activityInstance.getGUIContextID(), activityInstance.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.GUI_CONTEXT_ID));
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "supportsViewOnly", Boolean.toString(activityInstance.supportsViewOnly()), activityInstance.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_VIEW_ONLY));
        ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "iconID", activityInstance.getIconID().toString(), activityInstance.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID));
        if (activityInstance.getConfiguration().getAllEntries().size() > 0) {
            activityInstanceElement.appendChild(ProcessModelXMLExportTools.createConfigurationElement(document, NS, activityInstance.getConfiguration(), "configuration", null, null));
        }
        if (activityInstance instanceof DecisionActivityInstance) {
            DecisionActivityInstance decActivityInstance = (DecisionActivityInstance)activityInstance;
            ProcessModelXMLExportTools.addElement(document, activityInstanceElement, "decisionParameter", decActivityInstance.getDecisionParameter().getName());
            if (decActivityInstance.getAllDecisionStatements().size() > 0) {
                activityInstanceElement.appendChild(ProcessModelXMLExportTools.createDecisionStatementsElement(document, decActivityInstance.getAllDecisionStatements(), null));
            }
        }
        if (activityInstance.getParameters(ActivityConstants.AccessType.READ).size() > 0) {
            activityInstanceElement.appendChild(ProcessModelXMLExportTools.createIndexedInputParametersElement(document, activityInstance.getParameters(ActivityConstants.AccessType.READ), null));
        }
        if (activityInstance.getParameters(ActivityConstants.AccessType.WRITE).size() > 0) {
            activityInstanceElement.appendChild(ProcessModelXMLExportTools.createOutputParametersElement(document, activityInstance.getParameters(ActivityConstants.AccessType.WRITE)));
        }
        if (activityInstance.getSupportedPlugins().size() > 0) {
            activityInstanceElement.appendChild(ProcessModelXMLExportTools.createPluginDataContainerElement(document, NS, activityInstance));
        }
        if (activityInstance.getUserAttributes().size() > 0) {
            activityInstanceElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, activityInstance.getUserAttributes()));
        }
        return activityInstanceElement;
    }

    private static Element createDecisionStatementsElement(Document document, Collection<DecisionStatement> allDecisionStatements, DecisionActivity decActivity) {
        Element decisionStatementsElement = document.createElementNS(NS, "decisionStatements");
        for (DecisionStatement ds : allDecisionStatements) {
            Element decisionStatementElement = document.createElementNS(NS, "decisionStatement");
            if (decActivity != null) {
                decisionStatementElement.setAttributeNS(null, "edgeCode", Long.toString(decActivity.getEdgeCode(ds.getDecisionID())));
            }
            ProcessModelXMLExportTools.addElement(document, decisionStatementElement, "decisionLabel", ds.getDecisionLabel());
            ProcessModelXMLExportTools.addElement(document, decisionStatementElement, "decisionStatement", ds.getDecisionStatement());
            ProcessModelXMLExportTools.addElement(document, decisionStatementElement, "decisionID", Long.toString(ds.getDecisionID()));
            decisionStatementsElement.appendChild(decisionStatementElement);
        }
        return decisionStatementsElement;
    }

    private static Element createDataContextElement(Document document, ParameterDataContext attachedDataContext) {
        Element dataContextElement = document.createElementNS(NS, "dataContext");
        for (Map.Entry<String, ProcessConstants.AdeptDataType> entry : attachedDataContext.getParameters().entrySet()) {
            Element parametersElement = document.createElementNS(NS, "parameters");
            Element paramName = document.createElementNS(NS, "name");
            paramName.setTextContent(entry.getKey());
            Element paramType = document.createElementNS(NS, "dataType");
            paramType.setTextContent(entry.getValue().toString());
            Element paramValue = document.createElementNS(NS, "value");
            String value = null;
            try {
                switch (entry.getValue()) {
                    case BOOLEAN: {
                        if (!attachedDataContext.isNull(entry.getKey())) {
                            value = Boolean.toString(attachedDataContext.retrieveBooleanParameterValue(entry.getKey()));
                        }
                        break;
                    }
                    case FLOAT: {
                        if (!attachedDataContext.isNull(entry.getKey())) {
                            value = Double.toString(attachedDataContext.retrieveFloatParameterValue(entry.getKey()));
                        }
                        break;
                    }
                    case INTEGER: {
                        if (!attachedDataContext.isNull(entry.getKey())) {
                            value = Long.toString(attachedDataContext.retrieveIntegerParameterValue(entry.getKey()));
                        }
                        break;
                    }
                    case STRING: {
                        if (!attachedDataContext.isNull(entry.getKey())) {
                            value = attachedDataContext.retrieveStringParameterValue(entry.getKey());
                        }
                        break;
                    }
                    case DATE: {
                        if (!attachedDataContext.isNull(entry.getKey())) {
                            value = Long.toString(attachedDataContext.retrieveDateParameterValue(entry.getKey()).getTime());
                        }
                        break;
                    }
                    case URI: {
                        if (!attachedDataContext.isNull(entry.getKey())) {
                            value = attachedDataContext.retrieveURIParameterValue(entry.getKey()).toString();
                        }
                        break;
                    }
                    case USERDEFINED: {
                        if (!attachedDataContext.isNull(entry.getKey())) {
                            UDTValue udt = attachedDataContext.retrieveUDTParameterValue(entry.getKey());
                            paramValue.setAttributeNS(null, "type", udt.getUserDefinedType());
                            value = Base64.encodeBytes(udt.getValueAsArray(), 2);
                        }
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown data type '" + (Object)((Object)entry.getValue()) + "' found!"));
                    }
                }
            }
            catch (NoSuchParameterException e) {
                throw new RuntimeException("NoSuchParameterException caught while trying to export an input data context!", e);
            }
            catch (InvalidDataTypeException e) {
                throw new RuntimeException("InvalidDataTypeException caught while trying to export an input data context!", e);
            }
            paramValue.setTextContent(value);
            parametersElement.appendChild(paramName);
            parametersElement.appendChild(paramType);
            parametersElement.appendChild(paramValue);
            dataContextElement.appendChild(parametersElement);
        }
        return dataContextElement;
    }

    static Element createNodeElement(Document document, Node node) {
        Element nodeElement = document.createElementNS(NS, "node");
        nodeElement.setAttributeNS(null, "id", "n" + Integer.toString(node.getID()));
        ProcessModelXMLExportTools.addElement(document, nodeElement, "name", node.getName());
        if (node.getIconID() != null) {
            ProcessModelXMLExportTools.addElement(document, nodeElement, "iconID", node.getIconID().toString());
        }
        ProcessModelXMLExportTools.addElement(document, nodeElement, "description", node.getDescription());
        ProcessModelXMLExportTools.addElement(document, nodeElement, "staffAssignmentRule", node.getStaffAssignmentRule());
        if (node.getExecutableBusinessProcess() != null) {
            nodeElement.appendChild(ProcessModelXMLExportTools.createExecutableBusinessProcessElement(document, node.getExecutableBusinessProcess()));
        }
        ProcessModelXMLExportTools.addElement(document, nodeElement, "autoStart", Boolean.toString(node.isAutoStartEnabled()));
        boolean mappingExists = false;
        Element dcpMappingsElement = document.createElementNS(NS, "connectorParameterMappings");
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            if (node.getConnectorMapping(accessType).size() > 0) {
                ProcessModelXMLExportTools.fillConnectorParameterMappings(document, dcpMappingsElement, accessType, node.getConnectorMapping(accessType));
                mappingExists = true;
            }
            ++n2;
        }
        if (mappingExists) {
            nodeElement.appendChild(dcpMappingsElement);
        }
        mappingExists = false;
        Element nodeParametersElement = document.createElementNS(NS, "nodeParameters");
        ActivityConstants.AccessType[] accessTypeArray2 = ActivityConstants.AccessType.systemRelatedValues();
        int n3 = accessTypeArray2.length;
        n = 0;
        while (n < n3) {
            ActivityConstants.AccessType accessType = accessTypeArray2[n];
            if (node.getSystemParameters(accessType).size() > 0) {
                for (ProcessModelParameter param : ProcessModelXMLExportTools.sortedParameters(node.getSystemParameters(accessType))) {
                    Element paramElement = document.createElementNS(NS, "nodeParameter");
                    ProcessModelXMLExportTools.fillParameter(param, paramElement, document, false);
                    paramElement.setAttributeNS(null, "accessType", accessType.toString());
                    nodeParametersElement.appendChild(paramElement);
                    mappingExists = true;
                }
            }
            ++n;
        }
        if (mappingExists) {
            nodeElement.appendChild(nodeParametersElement);
        }
        if (node.getSupportedPlugins().size() > 0) {
            nodeElement.appendChild(ProcessModelXMLExportTools.createPluginDataContainerElement(document, NS, node));
        }
        if (node.getUserAttributes().size() > 0) {
            nodeElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, node.getUserAttributes()));
        }
        return nodeElement;
    }

    private static void fillConnectorParameterMappings(Document document, Element parent, ActivityConstants.AccessType accessType, Map<String, Integer> mapping) {
        for (String parameterName : ProcessModelXMLExportTools.sortedKeySet(mapping.keySet())) {
            Element mapElement = ProcessModelXMLExportTools.addElement(document, parent, "connectorParameterMapping");
            mapElement.setAttributeNS(null, "connector", mapping.get(parameterName).toString());
            mapElement.setAttributeNS(null, "parameterName", parameterName);
            mapElement.setAttributeNS(null, "accessType", accessType.toString());
        }
    }

    static Element createExecutableBusinessProcessElement(Document document, ExecutableBusinessProcess ebp) {
        Element ebpElement = document.createElementNS(NS, "executableBusinessProcess");
        if (ebp instanceof Activity) {
            Activity activity = (Activity)ebp;
            ebpElement.appendChild(ProcessModelXMLExportTools.createActivityElement(document, activity));
        } else if (ebp instanceof ReferencedProcess) {
            ReferencedProcess lwp = (ReferencedProcess)ebp;
            ebpElement.appendChild(ProcessModelXMLExportTools.createReferencedProcessElement(document, lwp));
        } else if (ebp instanceof EmbeddedProcess) {
            EmbeddedProcess lwp = (EmbeddedProcess)ebp;
            ebpElement.appendChild(ProcessModelXMLExportTools.createEmbeddedProcessElement(document, lwp));
        } else if (ebp instanceof VariableParallelismEBP) {
            VariableParallelismEBP lwp = (VariableParallelismEBP)ebp;
            ebpElement.appendChild(ProcessModelXMLExportTools.createVarParEBPElement(document, lwp));
        }
        return ebpElement;
    }

    static Element createExecutableBusinessProcessInstanceElement(Document document, ExecutableBusinessProcessInstance ebpInstance) {
        Element ebpInstanceElement = document.createElementNS(NS, "executableBusinessProcessInstance");
        if (ebpInstance instanceof ActivityInstance) {
            ActivityInstance activityInstance = (ActivityInstance)ebpInstance;
            ebpInstanceElement.appendChild(ProcessModelXMLExportTools.createActivityInstanceElement(document, activityInstance));
        } else if (ebpInstance instanceof LightWeightProcessInstance) {
            LightWeightProcessInstance lwpInstance = (LightWeightProcessInstance)ebpInstance;
            ebpInstanceElement.appendChild(ProcessModelXMLExportTools.createLightWeightProcessInstanceElement(document, lwpInstance));
        }
        return ebpInstanceElement;
    }

    static Element createReferencedProcessElement(Document document, ReferencedProcess lwp) {
        Element lwpElement = document.createElementNS(NS, "referencedProcess");
        ProcessModelXMLExportTools.addElement(document, lwpElement, "templateID", lwp.getTemplateID().toString());
        lwpElement.appendChild(ProcessModelXMLExportTools.createExecutionControlPropertiesElement(document, NS, lwp.getExecutionControlProperties()));
        ProcessModelXMLExportTools.addElement(document, lwpElement, "fork", Boolean.toString(lwp.fork()));
        if (lwp.getConfiguration().getAllEntries().size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createConfigurationElement(document, NS, lwp.getConfiguration(), "configuration", null, null));
        }
        if (lwp.getTestConfiguration().getAllEntries().size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createConfigurationElement(document, NS, lwp.getTestConfiguration(), "testConfiguration", null, null));
        }
        if (lwp.getParameters(ActivityConstants.AccessType.READ).size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createIndexedInputParametersElement(document, lwp.getParameters(ActivityConstants.AccessType.READ), null));
        }
        if (lwp.getParameters(ActivityConstants.AccessType.WRITE).size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createOutputParametersElement(document, lwp.getParameters(ActivityConstants.AccessType.WRITE)));
        }
        if (lwp.getSupportedPlugins().size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createPluginDataContainerElement(document, NS, lwp));
        }
        if (lwp.getUserAttributes().size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, lwp.getUserAttributes()));
        }
        return lwpElement;
    }

    static Element createEmbeddedProcessElement(Document document, EmbeddedProcess lwp) {
        Element lwpElement = document.createElementNS(NS, "embeddedProcess");
        lwpElement.appendChild(ProcessModelXMLExportTools.createTemplateElement(document, lwp.getTemplate()));
        if (lwp.getTemplateID() != null) {
            ProcessModelXMLExportTools.addElement(document, lwpElement, "templateID", lwp.getTemplateID().toString());
        }
        lwpElement.appendChild(ProcessModelXMLExportTools.createExecutionControlPropertiesElement(document, NS, lwp.getExecutionControlProperties()));
        if (lwp.getConfiguration().getAllEntries().size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createConfigurationElement(document, NS, lwp.getConfiguration(), "configuration", null, null));
        }
        if (lwp.getTestConfiguration().getAllEntries().size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createConfigurationElement(document, NS, lwp.getTestConfiguration(), "testConfiguration", null, null));
        }
        if (lwp.getSupportedPlugins().size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createPluginDataContainerElement(document, NS, lwp));
        }
        if (lwp.getUserAttributes().size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, lwp.getUserAttributes()));
        }
        return lwpElement;
    }

    static Element createVarParEBPElement(Document document, VariableParallelismEBP varParEBP) {
        Element lwpElement = document.createElementNS(NS, "varParEBP");
        lwpElement.appendChild(ProcessModelXMLExportTools.createExecutableBusinessProcessElement(document, varParEBP.getLightWeightProcess()));
        if (varParEBP.getConfiguration().getAllEntries().size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createConfigurationElement(document, NS, varParEBP.getConfiguration(), "configuration", null, null));
        }
        if (varParEBP.getTestConfiguration().getAllEntries().size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createConfigurationElement(document, NS, varParEBP.getTestConfiguration(), "testConfiguration", null, null));
        }
        lwpElement.appendChild(ProcessModelXMLExportTools.createExecutionControlPropertiesElement(document, NS, varParEBP.getExecutionControlProperties()));
        lwpElement.appendChild(ProcessModelXMLExportTools.createIndexedInputParametersElement(document, varParEBP.getParameters(ActivityConstants.AccessType.READ), varParEBP.getIndexedInputParameters()));
        if (varParEBP.getParameters(ActivityConstants.AccessType.WRITE).size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createOutputParametersElement(document, varParEBP.getParameters(ActivityConstants.AccessType.WRITE)));
        }
        if (varParEBP.getSupportedPlugins().size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createPluginDataContainerElement(document, NS, varParEBP));
        }
        if (varParEBP.getUserAttributes().size() > 0) {
            lwpElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, varParEBP.getUserAttributes()));
        }
        return lwpElement;
    }

    static Element createLightWeightProcessInstanceElement(Document document, LightWeightProcessInstance lwpInstance) {
        Element lwpInstanceElement = document.createElementNS(NS, "lightWeightProcessInstance");
        ProcessModelXMLExportTools.addElement(document, lwpInstanceElement, "templateID", lwpInstance.getTemplateID().toString());
        ProcessModelXMLExportTools.addElement(document, lwpInstanceElement, "name", lwpInstance.getName());
        lwpInstanceElement.appendChild(ProcessModelXMLExportTools.createExecutionControlPropertiesElement(document, NS, lwpInstance.getExecutionControlProperties()));
        ProcessModelXMLExportTools.addElement(document, lwpInstanceElement, "description", lwpInstance.getDescription());
        lwpInstanceElement.appendChild(ProcessModelXMLExportTools.createDataContextElement(document, lwpInstance.getAttachedDataContext()));
        ProcessModelXMLExportTools.addElement(document, lwpInstanceElement, "processInstanceLogID", lwpInstance.getProcessInstanceLogID().toString());
        ProcessModelXMLExportTools.addElement(document, lwpInstanceElement, "processInstanceName", lwpInstance.getProcessInstanceName());
        ProcessModelXMLExportTools.addElement(document, lwpInstanceElement, "processTemplateName", lwpInstance.getProcessTemplateName());
        ProcessModelXMLExportTools.addElement(document, lwpInstanceElement, "fork", Boolean.toString(lwpInstance.fork()));
        ProcessModelXMLExportTools.addElement(document, lwpInstanceElement, "embedded", Boolean.toString(lwpInstance.isEmbedded()));
        if (lwpInstance.getConfiguration().getAllEntries().size() > 0) {
            lwpInstanceElement.appendChild(ProcessModelXMLExportTools.createConfigurationElement(document, NS, lwpInstance.getConfiguration(), "configuration", null, null));
        }
        ProcessModelXMLExportTools.addElement(document, lwpInstanceElement, "iconID", lwpInstance.getIconID().toString());
        if (lwpInstance.getParameters(ActivityConstants.AccessType.READ).size() > 0) {
            lwpInstanceElement.appendChild(ProcessModelXMLExportTools.createIndexedInputParametersElement(document, lwpInstance.getParameters(ActivityConstants.AccessType.READ), null));
        }
        if (lwpInstance.getParameters(ActivityConstants.AccessType.WRITE).size() > 0) {
            lwpInstanceElement.appendChild(ProcessModelXMLExportTools.createOutputParametersElement(document, lwpInstance.getParameters(ActivityConstants.AccessType.WRITE)));
        }
        if (lwpInstance.getSupportedPlugins().size() > 0) {
            lwpInstanceElement.appendChild(ProcessModelXMLExportTools.createPluginDataContainerElement(document, NS, lwpInstance));
        }
        if (lwpInstance.getUserAttributes().size() > 0) {
            lwpInstanceElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, lwpInstance.getUserAttributes()));
        }
        return lwpInstanceElement;
    }

    static Element createTemplateElement(Document document, Template template) {
        return ProcessModelXMLExportTools.createTemplateElement(document, template, null);
    }

    static Element createTemplateElement(Document document, Template template, TemplateStatus templateStatus) {
        Element templateElement = document.createElementNS(NS, "template");
        templateElement.setAttributeNS(null, "id", template.getID().toString());
        templateElement.setAttributeNS(null, "version", "16");
        ProcessModelXMLExportTools.addElement(document, templateElement, "name", template.getName());
        ProcessModelXMLExportTools.addElement(document, templateElement, "description", template.getDescription());
        ProcessModelXMLExportTools.addElement(document, templateElement, "processType", template.getProcessType());
        Element qualifiedAgentElement = ProcessModelXMLExportTools.addElement(document, templateElement, "supervisorAgent");
        ProcessModelXMLExportTools.fillQualifiedAgentElement(document, NS, qualifiedAgentElement, template.getSupervisorAgent());
        ProcessModelXMLExportTools.addElement(document, templateElement, "version", template.getVersion());
        Element nodesElement = ProcessModelXMLExportTools.addElement(document, templateElement, "nodes");
        ProcessModelXMLExportTools.fillNodesElement(document, nodesElement, template.getNodes());
        Element dataElementsElement = ProcessModelXMLExportTools.addElement(document, templateElement, "dataElements");
        ProcessModelXMLExportTools.fillDataElementsElement(document, dataElementsElement, template.getDataElements());
        Element edgesElement = ProcessModelXMLExportTools.addElement(document, templateElement, "edges");
        ProcessModelXMLExportTools.fillEdgesElement(document, edgesElement, template.getEdgeStructure(new ProcessConstants.EdgeType[0]));
        Element dataEdgesElement = ProcessModelXMLExportTools.addElement(document, templateElement, "dataEdges");
        ProcessModelXMLExportTools.fillDataEdgesElement(document, dataEdgesElement, template.getDataEdgeStructure());
        if (template.getConstraintEdgeStructure() != null && template.getConstraintEdgeStructure().size() > 0) {
            Element constraintEdgesElement = ProcessModelXMLExportTools.addElement(document, templateElement, "constraintEdges");
            ProcessModelXMLExportTools.fillConstraintEdgesElement(document, constraintEdgesElement, template.getConstraintEdgeStructure());
        }
        Element startElement = ProcessModelXMLExportTools.addElement(document, templateElement, "startNode");
        startElement.setTextContent("n" + template.getStartNode().getID());
        ProcessModelXMLExportTools.addElement(document, templateElement, "endNode", "n" + template.getEndNode().getID());
        Element structElement = ProcessModelXMLExportTools.addElement(document, templateElement, "structuralData");
        ProcessModelXMLExportTools.fillStructuralDataElement(document, structElement, template);
        if (template.getInstanceNameTemplate() != null) {
            ProcessModelXMLExportTools.addElement(document, templateElement, "instanceNameTemplate", template.getInstanceNameTemplate());
        }
        if (template.getConfigurationDescription().getEntries().size() > 0) {
            templateElement.appendChild(ProcessModelXMLExportTools.createConfigurationDescriptionElement(document, NS, template.getConfigurationDescription(), null, null));
        }
        if (template.getConfiguration().getAllEntries().size() > 0) {
            templateElement.appendChild(ProcessModelXMLExportTools.createConfigurationElement(document, NS, template.getConfiguration(), "configuration", null, null));
        }
        if (template.getTestConfiguration().getAllEntries().size() > 0) {
            templateElement.appendChild(ProcessModelXMLExportTools.createConfigurationElement(document, NS, template.getTestConfiguration(), "testConfiguration", null, null));
        }
        if (template.getParameters(ActivityConstants.AccessType.READ).size() > 0) {
            templateElement.appendChild(ProcessModelXMLExportTools.createIndexedInputParametersElement(document, template.getParameters(ActivityConstants.AccessType.READ), null));
        }
        if (template.getParameters(ActivityConstants.AccessType.WRITE).size() > 0) {
            templateElement.appendChild(ProcessModelXMLExportTools.createOutputParametersElement(document, template.getParameters(ActivityConstants.AccessType.WRITE)));
        }
        if (template.getSupportedPlugins().size() > 0) {
            templateElement.appendChild(ProcessModelXMLExportTools.createPluginDataContainerElement(document, NS, template));
        }
        if (template.getUserAttributes().size() > 0) {
            templateElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, template.getUserAttributes()));
        }
        template.getDeltaLayer();
        if (templateStatus != null) {
            templateElement.appendChild(ProcessModelXMLExportTools.createTemplateStatusElement(document, templateStatus));
        }
        return templateElement;
    }

    private static void fillDataEdgesElement(Document document, Element dataEdgesElement, Set<StructuredDataEdge> allDataEdges) {
        for (StructuredDataEdge sDataEdge : allDataEdges) {
            DataEdge dataEdge = sDataEdge.getDataEdge();
            Element dataEdgeElement = ProcessModelXMLExportTools.createStructuredDataEdgeElement(document, dataEdge, sDataEdge.getNodeID(), sDataEdge.getConnectorID(), sDataEdge.getDataElementID());
            dataEdgesElement.appendChild(dataEdgeElement);
        }
    }

    private static void fillEdgesElement(Document document, Element edgesElement, Set<StructuredEdge> allEdges) {
        for (StructuredEdge sEdge : allEdges) {
            Edge edge = sEdge.getEdge();
            Element edgeElement = ProcessModelXMLExportTools.createStructuredEdgeElement(document, edge, sEdge.getSourceNodeID(), sEdge.getDestinationNodeID());
            edgesElement.appendChild(edgeElement);
        }
    }

    private static void fillConstraintEdgesElement(Document document, Element constraintEdgesElement, Set<StructuredConstraintEdge> constraintEdgeStructure) {
        for (StructuredConstraintEdge ste : constraintEdgeStructure) {
            ConstraintEdge edge = ste.getConstraintEdge();
            Element timeEdges = ProcessModelXMLExportTools.createStructuredConstraintEdgeElement(document, edge, ste.getSourceNodeID(), ste.getDestinationNodeID());
            constraintEdgesElement.appendChild(timeEdges);
        }
    }

    private static void fillStructuralDataElement(Document document, Element structuralDataElement, Template template) {
        int nodeID;
        for (Node node : template.getNodes()) {
            nodeID = node.getID();
            Element sndElement = document.createElementNS(NS, "structuralNodeData");
            sndElement.setAttributeNS(null, "nodeID", "n" + nodeID);
            ProcessModelXMLExportTools.addElement(document, sndElement, "type", template.getNodeType(nodeID).toString());
            ProcessModelXMLExportTools.addElement(document, sndElement, "topologicalID", Integer.toString(template.getNodeTopologicalID(nodeID)));
            ProcessModelXMLExportTools.addElement(document, sndElement, "branchID", Integer.toString(template.getNodeBranchID(nodeID)));
            if (!template.getNodeType(nodeID).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW) && !template.getNodeType(nodeID).equals((Object)ProcessConstants.NodeType.NT_ENDFLOW)) {
                ProcessModelXMLExportTools.addElement(document, sndElement, "splitNodeID", "n" + template.getNodeSplitNodeID(nodeID));
            }
            ProcessModelXMLExportTools.addElement(document, sndElement, "correspondingBlockNodeID", "n" + template.getNodeCorrespondingBlockNodeID(nodeID));
            structuralDataElement.appendChild(sndElement);
        }
        for (Node node : template.getNodes()) {
            nodeID = node.getID();
            HashSet<Integer> disabledConnectors = new HashSet<Integer>();
            ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.AccessType accessType = accessTypeArray[n2];
                int[] nArray = template.getDisabledConnectors(nodeID, accessType);
                int n3 = nArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int connectorID = nArray[n4];
                    disabledConnectors.add(connectorID);
                    ++n4;
                }
                ++n2;
            }
            if (disabledConnectors.size() == 0) continue;
            Element dndcElement = document.createElementNS(NS, "disabledNodeConnectors");
            dndcElement.setAttributeNS(null, "nodeID", "n" + nodeID);
            for (Integer connectorID : disabledConnectors) {
                ProcessModelXMLExportTools.addElement(document, dndcElement, "connectorID", connectorID.toString());
            }
            structuralDataElement.appendChild(dndcElement);
        }
    }

    private static void fillDataElementsElement(Document document, Element dataElementsElement, Set<DataElement> dataElements) {
        for (DataElement dataElement : dataElements) {
            Element deElement = ProcessModelXMLExportTools.createDataElementElement(document, dataElement);
            dataElementsElement.appendChild(deElement);
        }
    }

    private static void fillNodesElement(Document document, Element nodesElement, Set<Node> nodes) {
        for (Node node : nodes) {
            Element nodeElement = ProcessModelXMLExportTools.createNodeElement(document, node);
            nodesElement.appendChild(nodeElement);
        }
    }

    static Element createTemplateStatusElement(Document document, TemplateStatus templateStatus) {
        Element templateStatusElement = document.createElementNS(NS, "templateStatus");
        ProcessModelXMLExportTools.addElement(document, templateStatusElement, "templateBuildtimeState", templateStatus.getBuildtimeState().toString());
        ProcessModelXMLExportTools.addElement(document, templateStatusElement, "isTopLevelUsable", Boolean.toString(templateStatus.isTopLevelUsable()));
        ProcessModelXMLExportTools.addElement(document, templateStatusElement, "usageAsSubprocess", templateStatus.getUsageAsSubprocess().toString());
        ProcessModelXMLExportTools.addElement(document, templateStatusElement, "starterRule", templateStatus.getStarterRule());
        ProcessModelXMLExportTools.addElement(document, templateStatusElement, "isDerivable", Boolean.toString(templateStatus.isDerivable()));
        if (templateStatus.getDerivableComment() != null) {
            ProcessModelXMLExportTools.addElement(document, templateStatusElement, "isDerivableComment", templateStatus.getDerivableComment());
        }
        ProcessModelXMLExportTools.addElement(document, templateStatusElement, "isInstanceable", Boolean.toString(templateStatus.isInstantiable(false)));
        if (templateStatus.getInstantiableComment(false) != null) {
            ProcessModelXMLExportTools.addElement(document, templateStatusElement, "isInstantiableComment", templateStatus.getInstantiableComment(false));
        }
        ProcessModelXMLExportTools.addElement(document, templateStatusElement, "isInstanceableSubProcess", Boolean.toString(templateStatus.isInstantiable(true)));
        if (templateStatus.getInstantiableComment(true) != null) {
            ProcessModelXMLExportTools.addElement(document, templateStatusElement, "isInstantiableCommentSubProcess", templateStatus.getInstantiableComment(true));
        }
        ProcessModelXMLExportTools.addElement(document, templateStatusElement, "isOutdated", Boolean.toString(templateStatus.isOutdated(false)));
        if (templateStatus.getOutdatedComment(false) != null) {
            ProcessModelXMLExportTools.addElement(document, templateStatusElement, "isOutdatedComment", templateStatus.getOutdatedComment(false));
        }
        ProcessModelXMLExportTools.addElement(document, templateStatusElement, "isOutdatedSubProcess", Boolean.toString(templateStatus.isOutdated(true)));
        if (templateStatus.getOutdatedComment(true) != null) {
            ProcessModelXMLExportTools.addElement(document, templateStatusElement, "isOutdatedCommentSubProcess", templateStatus.getOutdatedComment(true));
        }
        ProcessModelXMLExportTools.addElement(document, templateStatusElement, "areInstancesChangeable", Boolean.toString(templateStatus.areInstancesChangeable(false)));
        if (templateStatus.getInstancesChangeableComment(false) != null) {
            ProcessModelXMLExportTools.addElement(document, templateStatusElement, "areInstancesChangeableComment", templateStatus.getInstancesChangeableComment(false));
        }
        ProcessModelXMLExportTools.addElement(document, templateStatusElement, "areInstancesChangeableSubProcess", Boolean.toString(templateStatus.areInstancesChangeable(true)));
        if (templateStatus.getInstancesChangeableComment(true) != null) {
            ProcessModelXMLExportTools.addElement(document, templateStatusElement, "areInstancesChangeableCommentSubProcess", templateStatus.getInstancesChangeableComment(true));
        }
        ProcessModelXMLExportTools.addElement(document, templateStatusElement, "areInstancesMigratableTo", Boolean.toString(templateStatus.areInstancesMigratableTo(false)));
        if (templateStatus.getInstancesMigratableToComment(false) != null) {
            ProcessModelXMLExportTools.addElement(document, templateStatusElement, "areInstancesMigratableToComment", templateStatus.getInstancesMigratableToComment(false));
        }
        ProcessModelXMLExportTools.addElement(document, templateStatusElement, "areInstancesMigratableToSubProcess", Boolean.toString(templateStatus.areInstancesMigratableTo(true)));
        if (templateStatus.getInstancesMigratableToComment(true) != null) {
            ProcessModelXMLExportTools.addElement(document, templateStatusElement, "areInstancesMigratableToCommentSubProcess", templateStatus.getInstancesMigratableToComment(true));
        }
        return templateStatusElement;
    }

    static Element createInstanceElement(Document document, Instance instance, boolean storeStructure) {
        return ProcessModelXMLExportTools.createInstanceElement(document, instance, storeStructure, null);
    }

    static Element createInstanceElement(Document document, Instance instance, boolean storeStructure, InstanceStatus instanceStatus) {
        Element instanceElement = document.createElementNS(NS, "instance");
        instanceElement.setAttributeNS(null, "id", instance.getID().toString());
        instanceElement.setAttributeNS(null, "logID", instance.getLogID().toString());
        instanceElement.setAttributeNS(null, "version", "3");
        ProcessModelXMLExportTools.addElement(document, instanceElement, "name", instance.getName());
        Element initiatorAgentElement = ProcessModelXMLExportTools.addElement(document, instanceElement, "initiatorAgent");
        ProcessModelXMLExportTools.fillQualifiedAgentElement(document, NS, initiatorAgentElement, instance.getInitiatorAgent());
        Element supervisorAgentElement = ProcessModelXMLExportTools.addElement(document, instanceElement, "supervisorAgent");
        ProcessModelXMLExportTools.fillQualifiedAgentElement(document, NS, supervisorAgentElement, instance.getSupervisorAgent());
        ProcessModelXMLExportTools.addElement(document, instanceElement, "baseTemplateID", instance.getBaseTemplateID().toString());
        ProcessModelXMLExportTools.addElement(document, instanceElement, "creationTime", Long.toString(instance.getCreationTime()));
        ProcessModelXMLExportTools.addElement(document, instanceElement, "isModified", Boolean.toString(instance.isModified()));
        if (storeStructure) {
            if (instance.getTemplate() instanceof InstanceDeltaLayer) {
                ProcessModelXMLExportTools.addElement(document, instanceElement, "deltaLayer", null);
            } else {
                instanceElement.appendChild(ProcessModelXMLExportTools.createTemplateElement(document, instance.getTemplate()));
            }
        } else {
            ProcessModelXMLExportTools.addElement(document, instanceElement, "templateID", instance.getTemplate().getID().toString());
        }
        Element instanceElementData = ProcessModelXMLExportTools.addElement(document, instanceElement, "elementInstanceData");
        ProcessModelXMLExportTools.fillInstanceElementData(document, instanceElementData, instance);
        if (instance.getSupportedPlugins().size() > 0) {
            instanceElement.appendChild(ProcessModelXMLExportTools.createPluginDataContainerElement(document, NS, instance));
        }
        if (instance.getUserAttributes().size() > 0) {
            instanceElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, instance.getUserAttributes()));
        }
        if (instanceStatus != null) {
            instanceElement.appendChild(ProcessModelXMLExportTools.createInstanceStatusElement(document, instanceStatus));
        }
        if (instance.getParentEBPReference() != null) {
            instanceElement.appendChild(ProcessModelXMLExportTools.createEBPInstanceReferenceElement(document, NS, instance.getParentEBPReference(), false));
        }
        return instanceElement;
    }

    static Element createExecutableInstanceElement(Document document, ExecutableInstance instance, boolean storeStructure, InstanceStatus instanceStatus) {
        URI[] instanceTerminationCallback;
        Element instanceElement = document.createElementNS(NS, "executableInstance");
        instanceElement.setAttributeNS(null, "id", instance.getID().toString());
        instanceElement.setAttributeNS(null, "logID", instance.getLogID().toString());
        instanceElement.setAttributeNS(null, "version", "3");
        ProcessModelXMLExportTools.addElement(document, instanceElement, "name", instance.getName());
        ProcessModelXMLExportTools.addElement(document, instanceElement, "baseTemplateID", instance.getBaseTemplateID().toString());
        ProcessModelXMLExportTools.addElement(document, instanceElement, "creationTime", Long.toString(instance.getCreationTime()));
        ProcessModelXMLExportTools.addElement(document, instanceElement, "isModified", Boolean.toString(instance.isModified()));
        if (storeStructure) {
            if (instance.getTemplate() instanceof InstanceDeltaLayer) {
                ProcessModelXMLExportTools.addElement(document, instanceElement, "deltaLayer", null);
            } else {
                instanceElement.appendChild(ProcessModelXMLExportTools.createTemplateElement(document, instance.getTemplate()));
            }
        } else {
            ProcessModelXMLExportTools.addElement(document, instanceElement, "templateID", instance.getTemplate().getID().toString());
        }
        Element supervisorAgentElement = ProcessModelXMLExportTools.addElement(document, instanceElement, "supervisorAgent");
        ProcessModelXMLExportTools.fillQualifiedAgentElement(document, NS, supervisorAgentElement, instance.getSupervisorAgent());
        Element initiatorAgentElement = ProcessModelXMLExportTools.addElement(document, instanceElement, "initiatorAgent");
        ProcessModelXMLExportTools.fillQualifiedAgentElement(document, NS, initiatorAgentElement, instance.getInitiatorAgent());
        if (instance.getParentEBPReference() != null) {
            instanceElement.appendChild(ProcessModelXMLExportTools.createEBPInstanceReferenceElement(document, NS, instance.getParentEBPReference(), false));
        }
        if ((instanceTerminationCallback = instance.getInstanceStateListener()) != null && instanceTerminationCallback.length > 0) {
            instanceElement.appendChild(ProcessModelXMLExportTools.createURIArrayElement(document, NS, instanceTerminationCallback, "instanceTerminationCallback", false));
        }
        for (Node node : instance.getTemplate().getNodes()) {
            Element instanceElementData = ProcessModelXMLExportTools.addElement(document, instanceElement, "instanceNodeData");
            ProcessModelXMLExportTools.fillExecutableInstanceElementData(document, instanceElementData, instance, node.getID());
        }
        if (instance.getSupportedPlugins().size() > 0) {
            instanceElement.appendChild(ProcessModelXMLExportTools.createPluginDataContainerElement(document, NS, instance));
        }
        if (instance.getUserAttributes().size() > 0) {
            instanceElement.appendChild(ProcessModelXMLExportTools.createUserAttributesElement(document, NS, instance.getUserAttributes()));
        }
        if (instanceStatus != null) {
            instanceElement.appendChild(ProcessModelXMLExportTools.createInstanceStatusElement(document, instanceStatus));
        }
        return instanceElement;
    }

    static Element createInstanceStatusElement(Document document, InstanceStatus instanceStatus) {
        Element instanceStatusElement = document.createElementNS(NS, "instanceStatus");
        ProcessModelXMLExportTools.addElement(document, instanceStatusElement, "migrationStatus", instanceStatus.getMigrationStatus().name());
        if (instanceStatus.getMigrationStatusComment() != null) {
            ProcessModelXMLExportTools.addElement(document, instanceStatusElement, "migrationStatusComment", instanceStatus.getMigrationStatusComment());
        }
        ProcessModelXMLExportTools.addElement(document, instanceStatusElement, "executionStatus", instanceStatus.getExecutionStatus().name());
        if (instanceStatus.getExecutionStatusComment() != null) {
            ProcessModelXMLExportTools.addElement(document, instanceStatusElement, "executionStatusComment", instanceStatus.getExecutionStatusComment());
        }
        return instanceStatusElement;
    }

    private static void fillInstanceElementData(Document document, Element instanceElementData, Instance instance) {
        int nodeID;
        for (Node node : instance.getTemplate().getNodes()) {
            nodeID = node.getID();
            Element nodeInstDataElement = ProcessModelXMLExportTools.createInstanceNodeDataElement(document, instance, nodeID);
            instanceElementData.appendChild(nodeInstDataElement);
        }
        for (Node node : instance.getTemplate().getNodes()) {
            nodeID = node.getID();
            if (instance.getPerformingAgent(nodeID) == null) continue;
            Element activityInstDataElement = ProcessModelXMLExportTools.createInstanceActivityDataElement(document, instance, nodeID);
            instanceElementData.appendChild(activityInstDataElement);
        }
        for (Node node : instance.getTemplate().getNodes()) {
            nodeID = node.getID();
            if (node.getExecutableBusinessProcess() == null || !(node.getExecutableBusinessProcess() instanceof LightWeightProcess) || instance.getNodeLWPInstanceID(nodeID) == null || instance.getNodeLWPInstanceID(nodeID).isEmpty()) continue;
            Element lightWeightInstDataElement = ProcessModelXMLExportTools.createInstanceLwpDataElement(document, instance, nodeID);
            instanceElementData.appendChild(lightWeightInstDataElement);
        }
    }

    private static void fillExecutableInstanceElementData(Document document, Element instanceElementData, ExecutableInstance instance, int nodeID) {
        URI[] runtimeManager;
        instanceElementData.setAttributeNS(null, "nodeID", "n" + nodeID);
        ProcessModelXMLExportTools.addElement(document, instanceElementData, "nodeState", instance.getNodeState(nodeID).toString());
        ProcessModelXMLExportTools.addElement(document, instanceElementData, "iteration", Integer.toString(instance.getNodeIteration(nodeID)));
        if (instance.getExecutionMode(nodeID) != null) {
            ProcessModelXMLExportTools.addElement(document, instanceElementData, "executionMode", instance.getExecutionMode(nodeID).toString());
        }
        if (instance.getNodeLWPInstanceID(nodeID).size() > 0) {
            for (UUID instanceID : instance.getNodeLWPInstanceID(nodeID)) {
                ProcessModelXMLExportTools.addElement(document, instanceElementData, "lwpInstanceData", instanceID.toString());
            }
        }
        if (instance.getPerformingAgent(nodeID) != null) {
            Element qaElement = ProcessModelXMLExportTools.addElement(document, instanceElementData, "performingAgent");
            ProcessModelXMLExportTools.fillQualifiedAgentElement(document, NS, qaElement, instance.getPerformingAgent(nodeID));
        }
        if (instance.getCurrentEnquiries(nodeID).size() > 0) {
            for (Enquiry enq : instance.getCurrentEnquiries(nodeID)) {
                Element enqElement = ProcessModelXMLExportTools.addElement(document, instanceElementData, "currentEnquiries");
                ProcessModelXMLExportTools.fillEnquiryElement(document, enqElement, enq);
            }
        }
        if (instance.getRepliedEnquiry(nodeID) != null) {
            Element enqElement = ProcessModelXMLExportTools.addElement(document, instanceElementData, "repliedEnquiry");
            ProcessModelXMLExportTools.fillEnquiryElement(document, enqElement, instance.getRepliedEnquiry(nodeID));
        }
        if ((runtimeManager = instance.getAssignedRuntimeManager(nodeID)) != null && runtimeManager.length > 0) {
            instanceElementData.appendChild(ProcessModelXMLExportTools.createURIArrayElement(document, NS, runtimeManager, "runtimeManager", false));
        }
    }

    private static void fillEnquiryElement(Document document, Element enqElement, Enquiry enq) {
        Element origElement = ProcessModelXMLExportTools.addElement(document, enqElement, "originator");
        ProcessModelXMLExportTools.fillQualifiedAgentElement(document, NS, origElement, enq.getOriginator());
        for (QualifiedAgent recipient : enq.getRecipients()) {
            Element recElement = ProcessModelXMLExportTools.addElement(document, enqElement, "recipients");
            ProcessModelXMLExportTools.fillQualifiedAgentElement(document, NS, recElement, recipient);
        }
        ProcessModelXMLExportTools.addElement(document, enqElement, "question", enq.getQuestion());
        if (enq.getReply() != null) {
            ProcessModelXMLExportTools.addElement(document, enqElement, "reply", enq.getReply());
        }
        if (enq.getReplier() != null) {
            Element replElement = ProcessModelXMLExportTools.addElement(document, enqElement, "replier");
            ProcessModelXMLExportTools.fillQualifiedAgentElement(document, NS, replElement, enq.getReplier());
        }
    }

    private static Element createInstanceNodeDataElement(Document document, Instance instance, int nodeID) {
        Element nodeInstDataElement = document.createElementNS(NS, "nodeInstanceData");
        nodeInstDataElement.setAttributeNS(null, "nodeID", "n" + nodeID);
        ProcessModelXMLExportTools.addElement(document, nodeInstDataElement, "nodeState", instance.getNodeState(nodeID).toString());
        ProcessModelXMLExportTools.addElement(document, nodeInstDataElement, "iteration", Integer.toString(instance.getNodeIteration(nodeID)));
        if (instance.getExecutionMode(nodeID) != null) {
            ProcessModelXMLExportTools.addElement(document, nodeInstDataElement, "executionMode", instance.getExecutionMode(nodeID).toString());
        }
        return nodeInstDataElement;
    }

    private static Element createInstanceActivityDataElement(Document document, Instance instance, int nodeID) {
        Element activityInstDataElement = document.createElementNS(NS, "activityInstanceData");
        activityInstDataElement.setAttributeNS(null, "nodeID", "n" + nodeID);
        Element activityAgentElement = ProcessModelXMLExportTools.addElement(document, activityInstDataElement, "activityAgent");
        ProcessModelXMLExportTools.fillQualifiedAgentElement(document, NS, activityAgentElement, instance.getPerformingAgent(nodeID));
        return activityInstDataElement;
    }

    private static Element createInstanceLwpDataElement(Document document, Instance instance, int nodeID) {
        Element lwpInstDataElement = document.createElementNS(NS, "lwpInstanceData");
        lwpInstDataElement.setAttributeNS(null, "nodeID", "n" + nodeID);
        for (UUID instanceID : instance.getNodeLWPInstanceID(nodeID)) {
            ProcessModelXMLExportTools.addElement(document, lwpInstDataElement, "instanceID", instanceID.toString());
        }
        return lwpInstDataElement;
    }

    private static Set<ProcessModelParameter> sortedParameters(Collection<ProcessModelParameter> parameters) {
        TreeSet<Parameter> params = new TreeSet<Parameter>(new ParameterComparator());
        params.addAll(parameters);
        return params;
    }

    public static Element createTemplateLocksElement(Document document, Map<UUID, ProcessModelXMLHelperTools.LockDescription> locks) {
        Element root = document.createElementNS(NS, "templateLocks");
        root.setAttributeNS(null, "version", "1");
        for (Map.Entry<UUID, ProcessModelXMLHelperTools.LockDescription> entry : locks.entrySet()) {
            Element child = document.createElementNS(NS, "templateLock");
            ProcessModelXMLExportTools.addElement(document, child, "templateID", entry.getKey().toString());
            ProcessModelXMLExportTools.addElement(document, child, "lockCount", Integer.toString(entry.getValue().getLockCount()));
            Element qa = document.createElementNS(NS, "lockingAgent");
            ProcessModelXMLExportTools.fillQualifiedAgentElement(document, NS, qa, entry.getValue().getAgent());
            child.appendChild(qa);
            root.appendChild(child);
        }
        return root;
    }

    public static Element createInstanceLocksElement(Document document, Map<UUID, ProcessModelXMLHelperTools.LockDescription> locks) {
        Element root = document.createElementNS(NS, "instanceLocks");
        root.setAttributeNS(null, "version", "1");
        for (Map.Entry<UUID, ProcessModelXMLHelperTools.LockDescription> entry : locks.entrySet()) {
            Element child = document.createElementNS(NS, "instanceLock");
            ProcessModelXMLExportTools.addElement(document, child, "instanceID", entry.getKey().toString());
            ProcessModelXMLExportTools.addElement(document, child, "lockCount", Integer.toString(entry.getValue().getLockCount()));
            Element qa = document.createElementNS(NS, "lockingAgent");
            ProcessModelXMLExportTools.fillQualifiedAgentElement(document, NS, qa, entry.getValue().getAgent());
            child.appendChild(qa);
            root.appendChild(child);
        }
        return root;
    }

    public static Element createEmbeddedTemplateMappingElement(Document document, Map<UUID, UUID> mapping) {
        Element root = document.createElementNS(NS, "embeddedTemplateMappings");
        root.setAttributeNS(null, "version", "1");
        for (Map.Entry<UUID, UUID> entry : mapping.entrySet()) {
            Element child = document.createElementNS(NS, "embeddedTemplateMapping");
            ProcessModelXMLExportTools.addElement(document, child, "parentTemplateID", entry.getValue().toString());
            ProcessModelXMLExportTools.addElement(document, child, "embeddedTemplateID", entry.getKey().toString());
            root.appendChild(child);
        }
        return root;
    }

    public static Element createBaseTemplateMappingElement(Document document, Map<UUID, UUID> mapping) {
        Element root = document.createElementNS(NS, "baseTemplateMappings");
        root.setAttributeNS(null, "version", "1");
        for (Map.Entry<UUID, UUID> entry : mapping.entrySet()) {
            Element child = document.createElementNS(NS, "baseTemplateMapping");
            ProcessModelXMLExportTools.addElement(document, child, "templateID", entry.getKey().toString());
            ProcessModelXMLExportTools.addElement(document, child, "baseTemplateID", entry.getValue().toString());
            root.appendChild(child);
        }
        return root;
    }

    public static Element createAdhocTemplateMappingElement(Document document, Map<UUID, UUID> mapping) {
        Element root = document.createElementNS(NS, "adhocTemplateMappings");
        root.setAttributeNS(null, "version", "1");
        for (Map.Entry<UUID, UUID> entry : mapping.entrySet()) {
            Element child = document.createElementNS(NS, "adhocTemplateMapping");
            ProcessModelXMLExportTools.addElement(document, child, "templateID", entry.getKey().toString());
            ProcessModelXMLExportTools.addElement(document, child, "instanceID", entry.getValue().toString());
            root.appendChild(child);
        }
        return root;
    }

    public static Element createProcessTypesElement(Document document, Set<ProcessModelXMLHelperTools.SerialisableProcessType> items) {
        Element root = document.createElementNS(NS, "processTypes");
        root.setAttributeNS(null, "version", "1");
        for (ProcessModelXMLHelperTools.SerialisableProcessType item : items) {
            Element child = document.createElementNS(NS, "processType");
            ProcessModelXMLExportTools.addElement(document, child, "name", item.typeName);
            ProcessModelXMLExportTools.addElement(document, child, "rootTemplateID", item.rootID.toString());
            root.appendChild(child);
        }
        return root;
    }

    public static Element createTemplateInformationsElement(Document document, Map<UUID, ProcessModelXMLHelperTools.TemplateInformation> items) {
        Element root = document.createElementNS(NS, "templateInformations");
        root.setAttributeNS(null, "version", "1");
        for (Map.Entry<UUID, ProcessModelXMLHelperTools.TemplateInformation> entry : items.entrySet()) {
            Element child = document.createElementNS(NS, "templateInformation");
            ProcessModelXMLExportTools.addElement(document, child, "templateID", entry.getKey().toString());
            if (entry.getValue().parentTemplateID != null) {
                ProcessModelXMLExportTools.addElement(document, child, "parentTemplateID", entry.getValue().parentTemplateID.toString());
            }
            ProcessModelXMLExportTools.addElement(document, child, "creationTime", Long.toString(entry.getValue().creationTime));
            ProcessModelXMLExportTools.addElement(document, child, "modificationTime", Long.toString(entry.getValue().modificationTime));
            ProcessModelXMLExportTools.addElement(document, child, "internalVersion", entry.getValue().internalVersion);
            Element childIDs = document.createElementNS(NS, "childTemplateIDs");
            for (UUID id : entry.getValue().childTemplateIDs) {
                ProcessModelXMLExportTools.addElement(document, childIDs, "uuid", id.toString());
            }
            child.appendChild(childIDs);
            for (URI[] uris : entry.getValue().deployedProcessManagers) {
                Element processManagers = document.createElementNS(NS, "processManagers");
                URI[] uRIArray = uris;
                int n = uris.length;
                int n2 = 0;
                while (n2 < n) {
                    URI uri = uRIArray[n2];
                    ProcessModelXMLExportTools.addElement(document, processManagers, "processManagerURI", uri.toString());
                    ++n2;
                }
                child.appendChild(processManagers);
            }
            root.appendChild(child);
        }
        return root;
    }

    private static Element addElement(Document document, Element parent, String type) {
        return ProcessModelXMLExportTools.addElement(document, NS, parent, type);
    }

    private static void addElement(Document document, Element parent, String type, String textContent) {
        ProcessModelXMLExportTools.addElement(document, NS, parent, type, textContent);
    }

    private static void addElement(Document document, Element parent, String type, String textContent, ActivityConstants.ActivityModelEntityType entityType) {
        ProcessModelXMLExportTools.addElement(document, NS, parent, type, textContent, entityType);
    }
}

