/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.xml;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.ProcessType;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLConstants;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ProcessModelXMLHelperTools {
    protected static final Logger logger = LoggerTools.getLogger(ProcessModelXMLHelperTools.class);
    private static volatile Schema templateSchema;
    private static volatile Schema instanceSchema;
    private static volatile Schema executableInstanceSchema;
    private static volatile Schema historySchema;
    private static volatile Schema ebpSchema;
    private static volatile Schema templateLocksSchema;
    private static volatile Schema instanceLocksSchema;
    private static volatile Schema embeddedTemplateMappingSchema;
    private static volatile Schema baseTemplateMappingSchema;
    private static volatile Schema adhocTemplateMappingSchema;
    private static volatile Schema processTypesSchema;
    private static volatile Schema templateInformationsSchema;

    public static boolean isDocumentValid(Document document, ProcessModelXMLConstants.SchemaType schemaType) {
        return XMLHelperTools.isDocumentValid(document, ProcessModelXMLHelperTools.getSchemaForSchemaType(schemaType));
    }

    public static void validateDocument(Document document, ProcessModelXMLConstants.SchemaType schemaType) throws XMLFormatException {
        XMLHelperTools.validateDocument(document, ProcessModelXMLHelperTools.getSchemaForSchemaType(schemaType));
    }

    public static Schema getSchemaForSchemaType(ProcessModelXMLConstants.SchemaType schemaType) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            switch (schemaType) {
                case NO_SCHEMA: {
                    break;
                }
                case TEMPLATE: {
                    if (templateSchema == null) {
                        templateSchema = schemaFactory.newSchema(ProcessModelXMLHelperTools.class.getResource("template.xsd"));
                    }
                    schema = templateSchema;
                    break;
                }
                case INSTANCE: {
                    if (instanceSchema == null) {
                        instanceSchema = schemaFactory.newSchema(ProcessModelXMLHelperTools.class.getResource("instance.xsd"));
                    }
                    schema = instanceSchema;
                    break;
                }
                case EXECUTABLE_INSTANCE: {
                    if (executableInstanceSchema == null) {
                        executableInstanceSchema = schemaFactory.newSchema(ProcessModelXMLHelperTools.class.getResource("executableInstance.xsd"));
                    }
                    schema = executableInstanceSchema;
                    break;
                }
                case HISTORY: {
                    if (historySchema == null) {
                        historySchema = schemaFactory.newSchema(ProcessModelXMLHelperTools.class.getResource("histories.xsd"));
                    }
                    schema = historySchema;
                    break;
                }
                case EBP: {
                    if (ebpSchema == null) {
                        ebpSchema = schemaFactory.newSchema(ProcessModelXMLHelperTools.class.getResource("executableBusinessProcess.xsd"));
                    }
                    schema = ebpSchema;
                    break;
                }
                case TEMPLATE_LOCKS: {
                    if (templateLocksSchema == null) {
                        templateLocksSchema = schemaFactory.newSchema(ProcessModelXMLHelperTools.class.getResource("templateLocks.xsd"));
                    }
                    schema = templateLocksSchema;
                    break;
                }
                case INSTANCE_LOCKS: {
                    if (instanceLocksSchema == null) {
                        instanceLocksSchema = schemaFactory.newSchema(ProcessModelXMLHelperTools.class.getResource("instanceLocks.xsd"));
                    }
                    schema = instanceLocksSchema;
                    break;
                }
                case EMBEDDED_TEMPLATE_MAPPING: {
                    if (embeddedTemplateMappingSchema == null) {
                        embeddedTemplateMappingSchema = schemaFactory.newSchema(ProcessModelXMLHelperTools.class.getResource("embeddedTemplateMapping.xsd"));
                    }
                    schema = embeddedTemplateMappingSchema;
                    break;
                }
                case BASE_TEMPLATE_MAPPING: {
                    if (baseTemplateMappingSchema == null) {
                        baseTemplateMappingSchema = schemaFactory.newSchema(ProcessModelXMLHelperTools.class.getResource("baseTemplateMapping.xsd"));
                    }
                    schema = baseTemplateMappingSchema;
                    break;
                }
                case ADHOC_TEMPLATE_MAPPING: {
                    if (adhocTemplateMappingSchema == null) {
                        adhocTemplateMappingSchema = schemaFactory.newSchema(ProcessModelXMLHelperTools.class.getResource("adhocTemplateMapping.xsd"));
                    }
                    schema = adhocTemplateMappingSchema;
                    break;
                }
                case PROCESS_TYPES: {
                    if (processTypesSchema == null) {
                        processTypesSchema = schemaFactory.newSchema(ProcessModelXMLHelperTools.class.getResource("processTypes.xsd"));
                    }
                    schema = processTypesSchema;
                    break;
                }
                case TEMPLATE_INFORMATIONS: {
                    if (templateInformationsSchema == null) {
                        templateInformationsSchema = schemaFactory.newSchema(ProcessModelXMLHelperTools.class.getResource("templateInformations.xsd"));
                    }
                    schema = templateInformationsSchema;
                    break;
                }
                default: {
                    String msg = String.format("Unsupported schema type '%s'!", new Object[]{schemaType});
                    logger.warning(msg);
                    break;
                }
            }
        }
        catch (SAXException e) {
            String message = "ProcessModelXMLHelperTools::getSchemaForSchemaType: Error parsing the schema file!";
            logger.severe(message);
            throw new RuntimeException(message, e);
        }
        return schema;
    }

    public static class LockDescription {
        private final QualifiedAgent agent;
        private final int lockCount;

        public LockDescription(QualifiedAgent agent, int lockCount) {
            this.agent = agent;
            this.lockCount = lockCount;
        }

        public int getLockCount() {
            return this.lockCount;
        }

        public QualifiedAgent getAgent() {
            return this.agent;
        }
    }

    public static class SerialisableProcessType {
        public final String typeName;
        public final UUID rootID;

        public SerialisableProcessType(ProcessType processType) {
            this.typeName = processType.getName();
            this.rootID = processType.getRootTemplate().getID();
        }

        public SerialisableProcessType(String typeName, UUID rootID) {
            this.typeName = typeName;
            this.rootID = rootID;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SerialisableProcessType)) {
                return false;
            }
            return this.typeName.equals(((SerialisableProcessType)obj).typeName) && this.rootID.equals(((SerialisableProcessType)obj).rootID);
        }

        public int hashCode() {
            return this.typeName.hashCode() + this.rootID.hashCode();
        }
    }

    public static class TemplateInformation {
        public UUID parentTemplateID;
        public ArrayList<UUID> childTemplateIDs;
        public HashSet<URI[]> deployedProcessManagers;
        public long creationTime;
        public long modificationTime;
        public String internalVersion;

        public TemplateInformation(UUID parentTemplateID, long creationTime, long modificationTime, String internalVersion) {
            this.parentTemplateID = parentTemplateID;
            this.childTemplateIDs = new ArrayList();
            this.deployedProcessManagers = new HashSet();
            this.creationTime = creationTime;
            this.modificationTime = modificationTime;
            this.internalVersion = internalVersion;
        }
    }

    static class XMLDecisionStatement {
        private final DecisionStatement statement;
        private final long edgeCode;

        XMLDecisionStatement(DecisionStatement statement, long edgeCode) {
            this.statement = statement;
            this.edgeCode = edgeCode;
        }

        DecisionStatement getStatement() {
            return this.statement;
        }

        long getEdgeCode() {
            return this.edgeCode;
        }
    }

    static class XMLParameter {
        private final ProcessModelParameter parameter;
        private final boolean indexed;

        XMLParameter(ProcessModelParameter parameter, boolean indexed) {
            this.parameter = parameter;
            this.indexed = indexed;
        }

        ProcessModelParameter getParameter() {
            return this.parameter;
        }

        boolean isIndexed() {
            return this.indexed;
        }
    }
}

