/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.xml;

import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLConstants;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLHelperTools;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImportTools;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ProcessModelXMLImport
implements ErrorHandler {
    private ProcessModelFactory factory = null;
    protected final Logger logger;
    static final String[] shellMethods = new String[]{"getTemplateFromFile", "getTemplateFromStream", "getTemplateFromDocument", "getInstanceFromFile", "getInstanceFromStream", "getInstanceFromDocument"};

    public ProcessModelXMLImport(ProcessModelFactory factory) {
        this.factory = factory;
        this.logger = LoggerTools.getLogger(this);
    }

    public Template getTemplateFromFile(File file) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile(file, null, null);
        ProcessModelXMLImport.validateTemplateFormatVersion(document);
        ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.TEMPLATE);
        return this.getTemplateFromDocument(document);
    }

    public TemplateStatus getTemplateStatusFromTemplateFile(File file) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile(file, null, null);
        ProcessModelXMLImport.validateTemplateFormatVersion(document);
        ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.TEMPLATE);
        return this.getTemplateStatusFromDocument(document);
    }

    public Instance getInstanceFromFile(File file) throws VersionException, XMLFormatException, IOException {
        return this.getInstanceFromFile(file, null);
    }

    public ExecutableInstance getExecutableInstanceFromFile(ExecutionFactory executionFactory, File file) throws VersionException, XMLFormatException, IOException {
        return this.getExecutableInstanceFromFile(executionFactory, file, null);
    }

    public Instance getInstanceFromFile(File file, Template template) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile(file, null, null);
        ProcessModelXMLImport.validateInstanceFormatVersion(document);
        ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.INSTANCE);
        return this.getInstanceFromDocument(document, template);
    }

    public ExecutableInstance getExecutableInstanceFromFile(ExecutionFactory executionFactory, File file, Template template) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile(file, null, null);
        ProcessModelXMLImport.validateInstanceFormatVersion(document);
        ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.EXECUTABLE_INSTANCE);
        return this.getExecutableInstanceFromDocument(executionFactory, document, template);
    }

    public UUID getTemplateIDFromInstanceFile(File file) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile(file, null, null);
        ProcessModelXMLImport.validateInstanceFormatVersion(document);
        ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.INSTANCE);
        return this.getTemplateIDFromInstanceDocument(document);
    }

    public InstanceStatus getInstanceStatusFromInstanceFile(File file) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile(file, null, null);
        return this.getInstanceStatusFromInstanceDocument(document);
    }

    public InstanceStatus getInstanceStatusFromInstanceDocument(Document document) throws VersionException, XMLFormatException {
        ProcessModelXMLConstants.SchemaType schema;
        String schemaAttr = document.getDocumentElement().getAttribute("xsi:schemaLocation");
        ProcessModelXMLImport.validateInstanceFormatVersion(document);
        if (schemaAttr.equals("http://www.aristaflow.de/adept2/processmodel instance.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd")) {
            schema = ProcessModelXMLConstants.SchemaType.INSTANCE;
        } else if (schemaAttr.equals("http://www.aristaflow.de/adept2/processmodel executableInstance.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd")) {
            schema = ProcessModelXMLConstants.SchemaType.EXECUTABLE_INSTANCE;
        } else {
            throw new XMLFormatException("The schema could not be parsed from the document!");
        }
        ProcessModelXMLHelperTools.validateDocument(document, schema);
        InstanceStatus instanceStatus = ProcessModelXMLImportTools.getInstanceStatus(this.factory, document.getDocumentElement());
        if (instanceStatus == null) {
            throw new IllegalArgumentException("The given instance file did not contain any status information");
        }
        return instanceStatus;
    }

    public Template getTemplateFromStream(InputStream inputStream) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromStream(inputStream);
        ProcessModelXMLImport.validateTemplateFormatVersion(document);
        ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.TEMPLATE);
        return this.getTemplateFromDocument(document);
    }

    public TemplateStatus getTemplateStatusFromStream(InputStream inputStream) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromStream(inputStream);
        ProcessModelXMLImport.validateTemplateFormatVersion(document);
        ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.TEMPLATE);
        return this.getTemplateStatusFromDocument(document);
    }

    public TemplateStatus getTemplateStatusFromDocument(Document document) {
        return ProcessModelXMLImportTools.getTemplateStatus(this.factory, document.getDocumentElement());
    }

    public Instance getInstanceFromStream(InputStream inputStream) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromStream(inputStream);
        ProcessModelXMLImport.validateInstanceFormatVersion(document);
        ProcessModelXMLHelperTools.validateDocument(document, ProcessModelXMLConstants.SchemaType.INSTANCE);
        return this.getInstanceFromDocument(document, null);
    }

    public Template getTemplateFromDocument(Document document) {
        Element root = document.getDocumentElement();
        return ProcessModelXMLImportTools.getTemplate(this.factory, root);
    }

    public Instance getInstanceFromDocument(Document document, Template template) {
        Element root = document.getDocumentElement();
        return ProcessModelXMLImportTools.getInstance(this.factory, root, template);
    }

    public ExecutableInstance getExecutableInstanceFromDocument(ExecutionFactory executionFactory, Document document, Template template) {
        Element root = document.getDocumentElement();
        return ProcessModelXMLImportTools.getExecutableInstance(this.factory, executionFactory, root, template);
    }

    public UUID getTemplateIDFromInstanceDocument(Document document) {
        Element root = document.getDocumentElement();
        return ProcessModelXMLImportTools.getTemplateIDFromInstanceElement(root);
    }

    public boolean getIsModifiedFromInstanceDocument(Document document) {
        Element root = document.getDocumentElement();
        return ProcessModelXMLImportTools.getIsModifiedFromInstanceElement(root);
    }

    public static void validateTemplateFormatVersion(Document template) throws VersionException {
        int current;
        int version = Integer.parseInt(ProcessModelXMLImportTools.getTemplateVersion(template.getDocumentElement()));
        if (version < (current = Integer.parseInt("16"))) {
            throw new VersionException("The template format version is too old and can not be read. Please use the converter to update your template to the actual version.");
        }
        if (current < version) {
            throw new VersionException("The template was created/used with a newer version of AristaFlow! Please use that version to read the template.");
        }
    }

    public static void validateInstanceFormatVersion(Document instance) throws VersionException {
        int current;
        int version = Integer.parseInt(ProcessModelXMLImportTools.getInstanceVersion(instance.getDocumentElement()));
        if (version < (current = Integer.parseInt("3"))) {
            throw new VersionException("The instance format version is too old and can not be read. Please use UpdateStorage to update your instance to the actual version.");
        }
        if (current < version) {
            throw new VersionException("The instance was created/used with a newer version of AristaFlow! Please use that version to read the instance.");
        }
    }

    public ExecutableBusinessProcess getEBPForDocument(Document document) {
        return ProcessModelXMLImportTools.getExecutableBusinessProcess(this.factory, document.getDocumentElement());
    }

    public ExecutableBusinessProcessInstance getEBPInstanceForDocument(ExecutionFactory executionFactory, Document document) {
        return ProcessModelXMLImportTools.getExecutableBusinessProcessInstance(this.factory, executionFactory, document.getDocumentElement());
    }

    public ProcessModelParameter getParameterForDocument(Document document) {
        return ProcessModelXMLImportTools.getParameter(this.factory, document.getDocumentElement(), false).getParameter();
    }

    public Set<ProcessModelParameter> getParameterSetForDocument(Document document) {
        return ProcessModelXMLImportTools.getParameters(this.factory, document.getDocumentElement());
    }

    public static Map<UUID, ProcessModelXMLHelperTools.LockDescription> getTemplateLocksFromFile(File file) throws FileNotFoundException, XMLFormatException, IOException, VersionException {
        Document doc = XMLHelperTools.getDocumentFromFile(file, null, null);
        String version = ProcessModelXMLImportTools.getTemplateLocksVersion(doc.getDocumentElement());
        if (!version.equals("1")) {
            throw new VersionException("Template locks file version incorrect. Can't read the file.");
        }
        ProcessModelXMLHelperTools.validateDocument(doc, ProcessModelXMLConstants.SchemaType.TEMPLATE_LOCKS);
        return ProcessModelXMLImportTools.getTemplateLocks(doc.getDocumentElement());
    }

    public static Map<UUID, ProcessModelXMLHelperTools.LockDescription> getInstanceLocksFromFile(File file) throws FileNotFoundException, XMLFormatException, IOException, VersionException {
        Document doc = XMLHelperTools.getDocumentFromFile(file, null, null);
        String version = ProcessModelXMLImportTools.getInstanceLocksVersion(doc.getDocumentElement());
        if (!version.equals("1")) {
            throw new VersionException("Instance locks file version incorrect. Can't read the file.");
        }
        ProcessModelXMLHelperTools.validateDocument(doc, ProcessModelXMLConstants.SchemaType.INSTANCE_LOCKS);
        return ProcessModelXMLImportTools.getInstanceLocks(doc.getDocumentElement());
    }

    public static Map<UUID, UUID> getEmbeddedTemplateMappingFromFile(File file) throws FileNotFoundException, XMLFormatException, IOException, VersionException {
        Document doc = XMLHelperTools.getDocumentFromFile(file, null, null);
        String version = ProcessModelXMLImportTools.getEmbeddedTemplateMappingVersion(doc.getDocumentElement());
        if (!version.equals("1")) {
            throw new VersionException("Embedded template mapping file version incorrect. Can't read the file.");
        }
        ProcessModelXMLHelperTools.validateDocument(doc, ProcessModelXMLConstants.SchemaType.EMBEDDED_TEMPLATE_MAPPING);
        return ProcessModelXMLImportTools.getEmbeddedTemplateMapping(doc.getDocumentElement());
    }

    public static Map<UUID, UUID> getBaseTemplateMappingFromFile(File file) throws FileNotFoundException, XMLFormatException, IOException, VersionException {
        Document doc = XMLHelperTools.getDocumentFromFile(file, null, null);
        String version = ProcessModelXMLImportTools.getBaseTemplateMappingVersion(doc.getDocumentElement());
        if (!version.equals("1")) {
            throw new VersionException("Base template mapping file version incorrect. Can't read the file.");
        }
        ProcessModelXMLHelperTools.validateDocument(doc, ProcessModelXMLConstants.SchemaType.BASE_TEMPLATE_MAPPING);
        return ProcessModelXMLImportTools.getBaseTemplateMapping(doc.getDocumentElement());
    }

    public static Set<ProcessModelXMLHelperTools.SerialisableProcessType> getProcessTypesFromFile(File file) throws FileNotFoundException, XMLFormatException, IOException, VersionException {
        Document doc = XMLHelperTools.getDocumentFromFile(file, null, null);
        String version = ProcessModelXMLImportTools.getProcessTypesVersion(doc.getDocumentElement());
        if (!version.equals("1")) {
            throw new VersionException("Process type file version incorrect. Can't read the file.");
        }
        ProcessModelXMLHelperTools.validateDocument(doc, ProcessModelXMLConstants.SchemaType.PROCESS_TYPES);
        return ProcessModelXMLImportTools.getProcessTypes(doc.getDocumentElement());
    }

    public static Map<UUID, UUID> getAdhocTemplateMappingFromFile(File file) throws FileNotFoundException, XMLFormatException, IOException, VersionException {
        Document doc = XMLHelperTools.getDocumentFromFile(file, null, null);
        String version = ProcessModelXMLImportTools.getAdhocTemplateMappingVersion(doc.getDocumentElement());
        if (!version.equals("1")) {
            throw new VersionException("Adhoc template mapping file version incorrect. Can't read the file.");
        }
        ProcessModelXMLHelperTools.validateDocument(doc, ProcessModelXMLConstants.SchemaType.ADHOC_TEMPLATE_MAPPING);
        return ProcessModelXMLImportTools.getAdhocTemplateMapping(doc.getDocumentElement());
    }

    public static Map<UUID, ProcessModelXMLHelperTools.TemplateInformation> getTemplateInformationsFromFile(File file) throws FileNotFoundException, XMLFormatException, IOException, VersionException {
        Document doc = XMLHelperTools.getDocumentFromFile(file, null, null);
        String version = ProcessModelXMLImportTools.getTemplateInformationsVersion(doc.getDocumentElement());
        if (!version.equals("1")) {
            throw new VersionException("Template informations file version incorrect. Can't read the file.");
        }
        ProcessModelXMLHelperTools.validateDocument(doc, ProcessModelXMLConstants.SchemaType.TEMPLATE_INFORMATIONS);
        return ProcessModelXMLImportTools.getTemplateInformations(doc.getDocumentElement());
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        this.logger.severe(spe.toString());
        throw spe;
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXException {
        this.logger.severe(spe.toString());
        throw spe;
    }

    @Override
    public void warning(SAXParseException spe) throws SAXException {
        this.logger.severe(spe.toString());
        throw spe;
    }
}

