/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.xml;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.XMLImportTools;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.execution.LightWeightProcessInstance;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceDeltaLayer;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.StructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.StructuredDataEdge;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateDeltaLayer;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLHelperTools;
import de.aristaflow.adept2.util.Base64;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProcessModelXMLImportTools
extends XMLImportTools {
    protected static final Logger logger = LoggerTools.getLogger(ProcessModelXMLImportTools.class);

    private static int getParsedID(String nodeValue) {
        int id = 0;
        try {
            id = Integer.parseInt(nodeValue.substring(1));
        }
        catch (NumberFormatException e) {
            logger.severe("Error parsing ID from value: '" + nodeValue + "'!");
            e.printStackTrace();
        }
        return id;
    }

    private static Element nextNode(org.w3c.dom.Node node, String name) {
        if (node == null) {
            return null;
        }
        org.w3c.dom.Node current = node;
        while (!(current == null || current.getNodeType() == 1 && current.getNodeName().equals(name))) {
            current = current.getNextSibling();
        }
        return (Element)current;
    }

    static Set<ProcessModelParameter> getParameters(ProcessModelFactory factory, Element parametersElement) {
        HashSet<ProcessModelParameter> parameters = new HashSet<ProcessModelParameter>();
        Element child = ProcessModelXMLImportTools.getElement(parametersElement.getFirstChild());
        do {
            ProcessModelParameter parameter = ProcessModelXMLImportTools.getParameter(factory, child, false).getParameter();
            parameters.add(parameter);
        } while ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())) != null);
        return parameters;
    }

    static Set<ProcessModelParameter>[] getIndexedParameters(ProcessModelFactory factory, Element parametersElement) {
        Set[] parameters = new Set[]{new HashSet(), new HashSet()};
        Element child = ProcessModelXMLImportTools.getElement(parametersElement.getFirstChild());
        do {
            ProcessModelXMLHelperTools.XMLParameter parameter;
            if ((parameter = ProcessModelXMLImportTools.getParameter(factory, child, true)).isIndexed()) {
                parameters[1].add(parameter.getParameter());
            }
            parameters[0].add(parameter.getParameter());
        } while ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())) != null);
        return parameters;
    }

    static ProcessModelXMLHelperTools.XMLParameter getParameter(ProcessModelFactory factory, Element parameterElement, boolean indexed) {
        String udtName = null;
        boolean virtual = false;
        boolean failure = false;
        String defaultValue = null;
        ChangeableActivityConfiguration configuration = null;
        boolean idx = false;
        PluginDataContainer pdc = null;
        Map<String, String> userAttributes = null;
        Element child = ProcessModelXMLImportTools.getElement(parameterElement.getFirstChild());
        String name = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String description = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        ProcessConstants.AdeptDataType type = ProcessConstants.AdeptDataType.valueOf(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        UUID identifierID = UUID.fromString(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        boolean optional = Boolean.parseBoolean(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        while (child != null) {
            if (indexed && child.getTagName().equals("indexed")) {
                idx = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("udtName") && type.equals((Object)ProcessConstants.AdeptDataType.USERDEFINED)) {
                udtName = child.getTextContent();
            } else if (child.getTagName().equals("isVirtual")) {
                virtual = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("isFailure")) {
                failure = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("defaultValue")) {
                defaultValue = child.getTextContent();
            } else if (child.getTagName().equals("configuration")) {
                configuration = ProcessModelXMLImportTools.getChangeableActivityConfiguration(factory, child);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pdc = ProcessModelXMLImportTools.getPluginDataContainer(factory, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        ProcessModelParameter param = factory.createProcessModelParameter(name, description, type, udtName, identifierID, optional, virtual, failure, defaultValue, configuration, pdc, userAttributes);
        return new ProcessModelXMLHelperTools.XMLParameter(param, idx);
    }

    static DataElement getDataElement(Element deElement, ProcessModelFactory factory) {
        String udtName = null;
        UUID iconID = null;
        UUID identifierID = null;
        boolean isPublic = false;
        boolean virtual = false;
        Map<String, Set<String>> supportedPlugins = new HashMap<String, Set<String>>();
        Map<String, PluginData> pluginDatas = new HashMap<String, PluginData>();
        Map<String, String> userAttributes = new HashMap<String, String>();
        int id = ProcessModelXMLImportTools.getParsedID(deElement.getAttribute("id"));
        Element child = ProcessModelXMLImportTools.getElement(deElement.getFirstChild());
        ProcessConstants.AdeptDataType type = ProcessConstants.AdeptDataType.valueOf(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String name = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String description = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        while (child != null) {
            if (child.getTagName().equals("iconID")) {
                iconID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("identifierID")) {
                identifierID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("isPublic")) {
                isPublic = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("udtName")) {
                udtName = child.getTextContent();
            } else if (child.getTagName().equals("pluginDataContainer")) {
                PluginDataContainer pdc = ProcessModelXMLImportTools.getPluginDataContainer(factory, child);
                supportedPlugins = pdc.getSupportedPlugins();
                pluginDatas = pdc.getPluginDatas();
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
            } else if (child.getTagName().equals("isVirtual")) {
                virtual = Boolean.parseBoolean(child.getTextContent());
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return factory.createDataElement(id, name, type, description, udtName, iconID, identifierID, isPublic, virtual, supportedPlugins, pluginDatas, userAttributes);
    }

    static Edge getEdge(Element edgeElement, ProcessModelFactory factory) {
        long edgeCode = Integer.MIN_VALUE;
        Map<String, String> userAttributes = new HashMap<String, String>();
        Element child = ProcessModelXMLImportTools.getElement(edgeElement.getFirstChild());
        ProcessConstants.EdgeType type = ProcessConstants.EdgeType.valueOf(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())) != null && child.getTagName().equals("edgeCode")) {
            edgeCode = Long.parseLong(child.getTextContent());
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("userAttributes")) {
            userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
        }
        return factory.createEdge(type, edgeCode, userAttributes);
    }

    static StructuredEdge getStructuredEdge(ProcessModelFactory factory, Element edgeElement) {
        Edge edge = ProcessModelXMLImportTools.getEdge(edgeElement, factory);
        int sourceNodeID = ProcessModelXMLImportTools.getParsedID(edgeElement.getAttribute("sourceNodeID"));
        int destinationNodeID = ProcessModelXMLImportTools.getParsedID(edgeElement.getAttribute("destinationNodeID"));
        ProcessConstants.EdgeType type = ProcessConstants.EdgeType.valueOf(edgeElement.getAttribute("edgeType"));
        return factory.createStructuredEdge(edge, sourceNodeID, destinationNodeID, type);
    }

    static DataEdge getDataEdge(ProcessModelFactory factory, Element dataEdgeElement) {
        Map<String, String> userAttributes = new HashMap<String, String>();
        Element child = ProcessModelXMLImportTools.getElement(dataEdgeElement.getFirstChild());
        ActivityConstants.AccessType type = ActivityConstants.AccessType.valueOf(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        boolean optional = Boolean.parseBoolean(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())) != null && child.getTagName().equals("userAttributes")) {
            userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
        }
        return factory.createDataEdge(type, optional, userAttributes);
    }

    static StructuredDataEdge getStructuredDataEdge(ProcessModelFactory factory, Element dataEdgeElement) {
        DataEdge dataEdge = ProcessModelXMLImportTools.getDataEdge(factory, dataEdgeElement);
        int nodeID = ProcessModelXMLImportTools.getParsedID(dataEdgeElement.getAttribute("nodeID"));
        int connectorID = Integer.parseInt(dataEdgeElement.getAttribute("connectorID"));
        int dataElementID = ProcessModelXMLImportTools.getParsedID(dataEdgeElement.getAttribute("dataElementID"));
        ActivityConstants.AccessType type = ActivityConstants.AccessType.valueOf(dataEdgeElement.getAttribute("dataEdgeType"));
        return factory.createStructuredDataEdge(dataEdge, nodeID, connectorID, dataElementID, type);
    }

    static ConstraintEdge getConstraintEdge(ProcessModelFactory factory, Element constraintEdgeElement) {
        Map<String, String> userAttributes = new HashMap<String, String>();
        Map<String, Set<String>> supportedPlugins = new HashMap<String, Set<String>>();
        Map<String, PluginData> pluginDatas = new HashMap<String, PluginData>();
        Element child = ProcessModelXMLImportTools.getElement(constraintEdgeElement.getFirstChild());
        while (child != null) {
            if (child.getTagName().equals("pluginDataContainer")) {
                logger.fine("setting up plugin data container for structured time edge");
                PluginDataContainer pdc = ProcessModelXMLImportTools.getPluginDataContainer(factory, child);
                supportedPlugins = pdc.getSupportedPlugins();
                pluginDatas = pdc.getPluginDatas();
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return factory.createConstraintEdge(supportedPlugins, pluginDatas, userAttributes);
    }

    static StructuredConstraintEdge getStructuredConstraintEdge(ProcessModelFactory factory, Element constraintEdgeElement) {
        ConstraintEdge constraintEdge = ProcessModelXMLImportTools.getConstraintEdge(factory, constraintEdgeElement);
        int sourceNodeID = ProcessModelXMLImportTools.getParsedID(constraintEdgeElement.getAttribute("sourceNodeID"));
        int destinationNodeID = ProcessModelXMLImportTools.getParsedID(constraintEdgeElement.getAttribute("destinationNodeID"));
        return factory.createStructuredConstraintEdge(constraintEdge, sourceNodeID, destinationNodeID);
    }

    static Activity getActivity(ProcessModelFactory factory, Element activityElement) {
        String configurationName = null;
        String name = null;
        String description = null;
        String implementationClass = null;
        Map<ActivityConstants.ActivityModelEntityType, List<String>> classPath = null;
        boolean isSingleton = false;
        byte[] systemComponentSignature = null;
        String guiContextID = "NullContext";
        ExecutionControlProperties ecp = null;
        boolean viewOnly = false;
        boolean supportsTestExecution = false;
        UUID iconID = null;
        Map<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> attributeOrigins = ActivityConstants.LocallyOverrideableActivityAttribute.getDefaultOrigins();
        ActivityConfiguration configuration = null;
        ActivityConfiguration testConfiguration = null;
        ParameterChangePolicy parameterChangePolicy = null;
        Set<ProcessModelParameter> inputParameters = new HashSet<ProcessModelParameter>();
        Set<ProcessModelParameter> outputParameters = new HashSet<ProcessModelParameter>();
        PluginDataContainer pdc = null;
        Map<String, String> userAttributes = new HashMap<String, String>();
        boolean decision = false;
        String decisionParameterName = null;
        ProcessModelParameter decisionParameter = null;
        List<Object> decisionStatements = new ArrayList();
        UUID id = UUID.fromString(activityElement.getAttribute("id"));
        Element child = ProcessModelXMLImportTools.getElement(activityElement.getFirstChild());
        String ecName = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String operationName = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        while (child != null) {
            String origin;
            if (child.getTagName().equals("configurationName")) {
                configurationName = child.getTextContent();
            } else if (child.getTagName().equals("name")) {
                name = child.getTextContent();
            } else if (child.getTagName().equals("description")) {
                description = child.getTextContent();
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.DESCRIPTION, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("implementationClass")) {
                implementationClass = child.getTextContent();
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IMPLEMENTATION_CLASS, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("classPaths")) {
                classPath = ProcessModelXMLImportTools.getSeparatedClassPath(child);
            } else if (child.getTagName().equals("isSingleton")) {
                isSingleton = Boolean.parseBoolean(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IS_SINGLETON, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("systemComponent")) {
                systemComponentSignature = Base64.decode(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("guiContextID")) {
                guiContextID = child.getTextContent();
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.GUI_CONTEXT_ID, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("executionControlProperties")) {
                ecp = ProcessModelXMLImportTools.getExecutionControlProperties(child);
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.EXECUTION_CONTROL_PROPERTIES, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("supportsViewOnly")) {
                viewOnly = Boolean.parseBoolean(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_VIEW_ONLY, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("supportsTestExecution")) {
                supportsTestExecution = Boolean.parseBoolean(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_TEST_EXECUTION, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("iconID")) {
                iconID = UUID.fromString(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("configuration")) {
                configuration = ProcessModelXMLImportTools.getActivityConfiguration(factory, child);
            } else if (child.getTagName().equals("testConfiguration")) {
                testConfiguration = ProcessModelXMLImportTools.getActivityConfiguration(factory, child);
            } else if (child.getTagName().equals("parameterChangePolicy")) {
                parameterChangePolicy = ParameterChangePolicy.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("inputParameters")) {
                inputParameters = ProcessModelXMLImportTools.getParameters(factory, child);
            } else if (child.getTagName().equals("outputParameters")) {
                outputParameters = ProcessModelXMLImportTools.getParameters(factory, child);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pdc = ProcessModelXMLImportTools.getPluginDataContainer(factory, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
            } else if (child.getTagName().equals("decisionParameter")) {
                decision = true;
                decisionParameterName = child.getTextContent();
            } else if (child.getTagName().equals("decisionStatements")) {
                decisionStatements = ProcessModelXMLImportTools.getDecisionStatements(factory, child);
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        Activity act = factory.createActivity(id, ecName, operationName, configurationName, name, description, implementationClass, classPath, isSingleton, systemComponentSignature, guiContextID, ecp, viewOnly, supportsTestExecution, iconID, attributeOrigins, configuration, testConfiguration, parameterChangePolicy, inputParameters, outputParameters, pdc, userAttributes);
        if (decision) {
            for (ProcessModelParameter p : outputParameters) {
                if (!p.getName().equals(decisionParameterName)) continue;
                decisionParameter = p;
            }
            HashMap<Long, Collection<DecisionStatement>> decisionMapping = new HashMap<Long, Collection<DecisionStatement>>();
            for (ProcessModelXMLHelperTools.XMLDecisionStatement statement : decisionStatements) {
                Long key = statement.getEdgeCode();
                Collection value = decisionMapping.containsKey(key) ? (Collection)decisionMapping.get(key) : new HashSet();
                value.add(statement.getStatement());
                decisionMapping.put(key, value);
            }
            act = factory.createDecisionActivity(act, decisionParameter, decisionMapping);
        }
        return act;
    }

    private static ActivityInstance getActivityInstance(ProcessModelFactory pmf, ExecutionFactory factory, Element activityInstanceElement) {
        String implementationClass = null;
        Map<ActivityConstants.ActivityModelEntityType, List<String>> classPath = null;
        boolean isSingleton = false;
        byte[] systemComponentSignature = null;
        String guiContextID = null;
        boolean supportsViewOnly = false;
        UUID iconID = null;
        Map<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> attributeOrigins = ActivityConstants.LocallyOverrideableActivityAttribute.getDefaultOrigins();
        ActivityConfiguration configuration = null;
        Set<ProcessModelParameter> inputParameters = null;
        Set<ProcessModelParameter> outputParameters = new HashSet<ProcessModelParameter>();
        PluginDataContainer pdc = null;
        Map<String, String> userAttributes = null;
        boolean decision = false;
        String decisionParameterName = null;
        ProcessModelParameter decisionParameter = null;
        List<Object> xmlDecisionStatements = new ArrayList();
        Element child = ProcessModelXMLImportTools.getElement(activityInstanceElement.getFirstChild());
        String name = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        UUID id = UUID.fromString(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        ExecutionControlProperties ecp = ProcessModelXMLImportTools.getExecutionControlProperties(child);
        String origin = child.getAttribute("origin");
        if (origin.length() > 0) {
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.EXECUTION_CONTROL_PROPERTIES, ActivityConstants.ActivityModelEntityType.valueOf(origin));
        }
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String operationName = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String ecName = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String configurationName = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String activityName = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String description = child.getTextContent();
        origin = child.getAttribute("origin");
        if (origin.length() > 0) {
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.DESCRIPTION, ActivityConstants.ActivityModelEntityType.valueOf(origin));
        }
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        ParameterDataContext dataContext = ProcessModelXMLImportTools.getDataContext(factory, child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        UUID instanceLogID = UUID.fromString(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String processInstanceName = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String processTemplateName = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        while (child != null) {
            if (child.getTagName().equals("implementationClass")) {
                implementationClass = child.getTextContent();
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IMPLEMENTATION_CLASS, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("classPaths")) {
                classPath = ProcessModelXMLImportTools.getSeparatedClassPath(child);
            } else if (child.getTagName().equals("isSingleton")) {
                isSingleton = Boolean.parseBoolean(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IS_SINGLETON, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("systemComponent")) {
                systemComponentSignature = Base64.decode(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("guiContextID")) {
                guiContextID = child.getTextContent();
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.GUI_CONTEXT_ID, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("supportsViewOnly")) {
                supportsViewOnly = Boolean.parseBoolean(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_VIEW_ONLY, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("iconID")) {
                iconID = UUID.fromString(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("configuration")) {
                configuration = ProcessModelXMLImportTools.getActivityConfiguration(pmf, child);
            } else if (child.getTagName().equals("inputParameters")) {
                inputParameters = ProcessModelXMLImportTools.getParameters(pmf, child);
            } else if (child.getTagName().equals("outputParameters")) {
                outputParameters = ProcessModelXMLImportTools.getParameters(pmf, child);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pdc = ProcessModelXMLImportTools.getPluginDataContainer(pmf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
            } else if (child.getTagName().equals("decisionParameter")) {
                decision = true;
                decisionParameterName = child.getTextContent();
            } else if (child.getTagName().equals("decisionStatements")) {
                xmlDecisionStatements = ProcessModelXMLImportTools.getDecisionStatements(pmf, child);
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        ActivityInstance act = factory.createActivityInstance(id, processTemplateName, processInstanceName, instanceLogID, ecName, operationName, configurationName, activityName, name, description, implementationClass, classPath, isSingleton, systemComponentSignature, guiContextID, ecp, supportsViewOnly, iconID, attributeOrigins, configuration, inputParameters, outputParameters, dataContext, pdc, userAttributes);
        if (decision) {
            for (ProcessModelParameter p : outputParameters) {
                if (!p.getName().equals(decisionParameterName)) continue;
                decisionParameter = p;
                break;
            }
            ArrayList<DecisionStatement> decisionStatements = new ArrayList<DecisionStatement>();
            for (ProcessModelXMLHelperTools.XMLDecisionStatement statement : xmlDecisionStatements) {
                decisionStatements.add(statement.getStatement());
            }
            act = factory.createDecisionActivityInstance(act, decisionParameter, decisionStatements);
        }
        return act;
    }

    private static List<ProcessModelXMLHelperTools.XMLDecisionStatement> getDecisionStatements(ProcessModelFactory factory, Element dsListElement) {
        ArrayList<ProcessModelXMLHelperTools.XMLDecisionStatement> dsList = new ArrayList<ProcessModelXMLHelperTools.XMLDecisionStatement>();
        Element dsChild = ProcessModelXMLImportTools.getElement(dsListElement.getFirstChild());
        while (dsChild != null && dsChild.getTagName().equals("decisionStatement")) {
            long edgeCode = Long.valueOf(dsChild.getAttribute("edgeCode"));
            Element child = ProcessModelXMLImportTools.getElement(dsChild.getFirstChild());
            String decisionLabel = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            String decisionStatement = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            long decisionID = Long.parseLong(child.getTextContent());
            DecisionStatement statement = factory.createDecisionStatement(decisionLabel, decisionStatement, decisionID);
            dsList.add(new ProcessModelXMLHelperTools.XMLDecisionStatement(statement, edgeCode));
            dsChild = ProcessModelXMLImportTools.getElement(dsChild.getNextSibling());
        }
        return dsList;
    }

    private static ParameterDataContext getDataContext(ExecutionFactory factory, Element dataContextElement) {
        HashMap<String, ProcessConstants.AdeptDataType> types = new HashMap<String, ProcessConstants.AdeptDataType>();
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        Element parametersElement = ProcessModelXMLImportTools.getElement(dataContextElement.getFirstChild());
        while (parametersElement != null) {
            Object value;
            Element paramElement = ProcessModelXMLImportTools.getElement(parametersElement.getFirstChild());
            String paramName = paramElement.getTextContent();
            Element typeElement = ProcessModelXMLImportTools.getElement(paramElement.getNextSibling());
            ProcessConstants.AdeptDataType type = ProcessConstants.AdeptDataType.valueOf(typeElement.getTextContent());
            Element valueElement = ProcessModelXMLImportTools.getElement(typeElement.getNextSibling());
            switch (type) {
                case BOOLEAN: {
                    value = Boolean.valueOf(valueElement.getTextContent());
                    break;
                }
                case INTEGER: {
                    value = Long.valueOf(valueElement.getTextContent());
                    break;
                }
                case FLOAT: {
                    value = Double.valueOf(valueElement.getTextContent());
                    break;
                }
                case STRING: {
                    value = valueElement.getTextContent();
                    break;
                }
                case DATE: {
                    value = new Date(Long.valueOf(valueElement.getTextContent()));
                    break;
                }
                case URI: {
                    value = URI.create(valueElement.getTextContent());
                    break;
                }
                case USERDEFINED: {
                    String udtName = valueElement.getAttribute("type");
                    byte[] bytes = Base64.decode(valueElement.getTextContent());
                    value = new ADEPT2UDTValue(udtName, bytes);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown data type '" + (Object)((Object)type) + "' found!"));
                }
            }
            parameters.put(paramName, (Serializable)value);
            types.put(paramName, type);
            parametersElement = ProcessModelXMLImportTools.getElement(parametersElement.getNextSibling());
        }
        return factory.createParameterDataContext(types, parameters);
    }

    static Node getNode(ProcessModelFactory factory, Element nodeElement) {
        String description = null;
        String staffAssignmentRule = null;
        UUID iconID = null;
        ExecutableBusinessProcess executableBusinessProcess = null;
        boolean autoStart = false;
        Map<ActivityConstants.AccessType, Map<String, Integer>> parameterConnectorMapping = new HashMap<ActivityConstants.AccessType, Map<String, Integer>>();
        Map<ActivityConstants.AccessType, Set<ProcessModelParameter>> nodeParameters = new HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>>();
        Map<String, Set<String>> supportedPlugins = new HashMap<String, Set<String>>();
        Map<String, PluginData> pluginDatas = new HashMap<String, PluginData>();
        Map<String, String> userAttributes = new HashMap<String, String>();
        int id = ProcessModelXMLImportTools.getParsedID(nodeElement.getAttribute("id"));
        Element child = ProcessModelXMLImportTools.getElement(nodeElement.getFirstChild());
        String name = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        while (child != null) {
            if (child.getTagName().equals("iconID")) {
                iconID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("description")) {
                description = child.getTextContent();
            } else if (child.getTagName().equals("staffAssignmentRule")) {
                staffAssignmentRule = child.getTextContent();
            } else if (child.getTagName().equals("executableBusinessProcess")) {
                executableBusinessProcess = ProcessModelXMLImportTools.getExecutableBusinessProcess(factory, child);
            } else if (child.getTagName().equals("autoStart")) {
                autoStart = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("connectorParameterMappings")) {
                parameterConnectorMapping = ProcessModelXMLImportTools.getParameterConnectorMappings(child);
            } else if (child.getTagName().equals("nodeParameters")) {
                nodeParameters = ProcessModelXMLImportTools.getNodeParameters(factory, child);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                PluginDataContainer pdc = ProcessModelXMLImportTools.getPluginDataContainer(factory, child);
                supportedPlugins = pdc.getSupportedPlugins();
                pluginDatas = pdc.getPluginDatas();
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return factory.createNode(id, name, description, staffAssignmentRule, executableBusinessProcess, autoStart, iconID, parameterConnectorMapping, nodeParameters, supportedPlugins, pluginDatas, userAttributes);
    }

    private static Map<ActivityConstants.AccessType, Set<ProcessModelParameter>> getNodeParameters(ProcessModelFactory factory, Element nodeParameters) {
        HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>> ret = new HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>>();
        Element parameterElement = ProcessModelXMLImportTools.getElement(nodeParameters.getFirstChild());
        while (parameterElement != null) {
            ActivityConstants.AccessType accessType = ActivityConstants.AccessType.valueOf(parameterElement.getAttribute("accessType"));
            Set paramSet = ret.containsKey((Object)accessType) ? (Set)ret.get((Object)accessType) : new HashSet();
            ProcessModelParameter param = ProcessModelXMLImportTools.getParameter(factory, parameterElement, false).getParameter();
            paramSet.add(param);
            ret.put(accessType, paramSet);
            parameterElement = ProcessModelXMLImportTools.getElement(parameterElement.getNextSibling());
        }
        return ret;
    }

    private static Map<ActivityConstants.AccessType, Map<String, Integer>> getParameterConnectorMappings(Element pmcMappingsElement) {
        HashMap<ActivityConstants.AccessType, Map<String, Integer>> mappings = new HashMap<ActivityConstants.AccessType, Map<String, Integer>>();
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            mappings.put(accessType, new HashMap());
            ++n2;
        }
        Element child = ProcessModelXMLImportTools.getElement(pmcMappingsElement.getFirstChild());
        while (child != null) {
            int connector = Integer.parseInt(child.getAttribute("connector"));
            String parameter = child.getAttribute("parameterName");
            ActivityConstants.AccessType accessType = ActivityConstants.AccessType.valueOf(child.getAttribute("accessType"));
            ((Map)mappings.get((Object)accessType)).put(parameter, connector);
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return mappings;
    }

    static ExecutableBusinessProcess getExecutableBusinessProcess(ProcessModelFactory factory, Element ebpElement) {
        Element child = ProcessModelXMLImportTools.getElement(ebpElement.getFirstChild());
        if (child.getTagName().equals("activity")) {
            return ProcessModelXMLImportTools.getActivity(factory, child);
        }
        if (child.getTagName().equals("referencedProcess")) {
            return ProcessModelXMLImportTools.getReferencedProcess(factory, child);
        }
        if (child.getTagName().equals("embeddedProcess")) {
            return ProcessModelXMLImportTools.getEmbeddedProcess(factory, child);
        }
        if (child.getTagName().equals("varParEBP")) {
            return ProcessModelXMLImportTools.getVarParEBP(factory, child);
        }
        return null;
    }

    static ExecutableBusinessProcessInstance getExecutableBusinessProcessInstance(ProcessModelFactory pmf, ExecutionFactory factory, Element ebpInstanceElement) {
        Element child = ProcessModelXMLImportTools.getElement(ebpInstanceElement.getFirstChild());
        if (child.getTagName().equals("activityInstance")) {
            return ProcessModelXMLImportTools.getActivityInstance(pmf, factory, child);
        }
        if (child.getTagName().equals("lightWeightProcessInstance")) {
            return ProcessModelXMLImportTools.getLightWeightProcessInstance(pmf, factory, child);
        }
        return null;
    }

    static ReferencedProcess getReferencedProcess(ProcessModelFactory factory, Element lwpElement) {
        Configuration configuration = null;
        Configuration testConfiguration = null;
        Set<ProcessModelParameter> inputParameters = new HashSet<ProcessModelParameter>();
        Set<ProcessModelParameter> outputParameters = new HashSet<ProcessModelParameter>();
        PluginDataContainer pdc = null;
        Map<String, String> userAttributes = new HashMap<String, String>();
        Element child = ProcessModelXMLImportTools.getElement(lwpElement.getFirstChild());
        UUID templateID = UUID.fromString(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        ExecutionControlProperties ecp = ProcessModelXMLImportTools.getExecutionControlProperties(child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        boolean fork = Boolean.parseBoolean(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        while (child != null) {
            if (child.getTagName().equals("configuration")) {
                configuration = ProcessModelXMLImportTools.getConfiguration(factory, child);
            } else if (child.getTagName().equals("testConfiguration")) {
                testConfiguration = ProcessModelXMLImportTools.getConfiguration(factory, child);
            } else if (child.getTagName().equals("inputParameters")) {
                inputParameters = ProcessModelXMLImportTools.getParameters(factory, child);
            } else if (child.getTagName().equals("outputParameters")) {
                outputParameters = ProcessModelXMLImportTools.getParameters(factory, child);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pdc = ProcessModelXMLImportTools.getPluginDataContainer(factory, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return factory.createReferencedProcess(templateID, fork, configuration, testConfiguration, ecp, inputParameters, outputParameters, pdc, userAttributes);
    }

    static EmbeddedProcess getEmbeddedProcess(ProcessModelFactory factory, Element lwpElement) {
        UUID ownInternalID = null;
        Configuration configuration = null;
        Configuration testConfiguration = null;
        ExecutionControlProperties executionControlProperties = null;
        PluginDataContainer pdc = null;
        Map<String, String> userAttributes = new HashMap<String, String>();
        Element child = ProcessModelXMLImportTools.getElement(lwpElement.getFirstChild());
        Template embeddedTemplate = ProcessModelXMLImportTools.getTemplate(factory, child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        UUID parentTemplateID = embeddedTemplate.getID();
        while (child != null) {
            if (child.getTagName().equals("templateID")) {
                ownInternalID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("configuration")) {
                configuration = ProcessModelXMLImportTools.getConfiguration(factory, child);
            } else if (child.getTagName().equals("testConfiguration")) {
                testConfiguration = ProcessModelXMLImportTools.getConfiguration(factory, child);
            } else if (child.getTagName().equals("executionControlProperties")) {
                executionControlProperties = ProcessModelXMLImportTools.getExecutionControlProperties(child);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pdc = ProcessModelXMLImportTools.getPluginDataContainer(factory, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return factory.createEmbeddedProcess(embeddedTemplate, parentTemplateID, ownInternalID, configuration, testConfiguration, executionControlProperties, pdc, userAttributes);
    }

    static VariableParallelismEBP getVarParEBP(ProcessModelFactory factory, Element varParElement) {
        LightWeightProcess lwp = null;
        Set<ProcessModelParameter> indexedInputParameters = null;
        Configuration configuration = null;
        Configuration testConfiguration = null;
        ExecutionControlProperties ecp = null;
        Set<ProcessModelParameter> inputParameters = null;
        Set<ProcessModelParameter> outputParameters = null;
        PluginDataContainer pdc = null;
        Map<String, String> userAttributes = null;
        Set<ProcessModelParameter>[] indexedParameters = null;
        Element child = ProcessModelXMLImportTools.getElement(varParElement.getFirstChild());
        while (child != null) {
            if (child.getTagName().equals("executableBusinessProcess")) {
                Element lwpChild = ProcessModelXMLImportTools.getElement(child.getFirstChild());
                if (lwpChild.getTagName().equals("referencedProcess")) {
                    lwp = ProcessModelXMLImportTools.getReferencedProcess(factory, lwpChild);
                } else if (lwpChild.getTagName().equals("embeddedProcess")) {
                    lwp = ProcessModelXMLImportTools.getEmbeddedProcess(factory, lwpChild);
                }
            } else if (child.getTagName().equals("configuration")) {
                configuration = ProcessModelXMLImportTools.getConfiguration(factory, child);
            } else if (child.getTagName().equals("testConfiguration")) {
                testConfiguration = ProcessModelXMLImportTools.getConfiguration(factory, child);
            } else if (child.getTagName().equals("executionControlProperties")) {
                ecp = ProcessModelXMLImportTools.getExecutionControlProperties(child);
            } else if (child.getTagName().equals("inputParameters")) {
                indexedParameters = ProcessModelXMLImportTools.getIndexedParameters(factory, child);
            } else if (child.getTagName().equals("outputParameters")) {
                outputParameters = ProcessModelXMLImportTools.getParameters(factory, child);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pdc = ProcessModelXMLImportTools.getPluginDataContainer(factory, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        if (indexedParameters != null) {
            inputParameters = indexedParameters[0];
            indexedInputParameters = indexedParameters[1];
        }
        return factory.createVariableParallelismEBP(lwp, indexedInputParameters, configuration, testConfiguration, ecp, inputParameters, outputParameters, pdc, userAttributes);
    }

    static LightWeightProcessInstance getLightWeightProcessInstance(ProcessModelFactory pmf, ExecutionFactory factory, Element lwpInstanceElement) {
        UUID iconID = null;
        Configuration configuration = null;
        Set<ProcessModelParameter> inputParameters = null;
        Set<ProcessModelParameter> outputParameters = null;
        PluginDataContainer pdc = null;
        Map<String, String> userAttributes = null;
        Element child = ProcessModelXMLImportTools.getElement(lwpInstanceElement.getFirstChild());
        UUID templateID = UUID.fromString(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String name = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        ExecutionControlProperties ecp = ProcessModelXMLImportTools.getExecutionControlProperties(child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String description = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        ParameterDataContext dataContext = ProcessModelXMLImportTools.getDataContext(factory, child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        UUID instanceLogID = UUID.fromString(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String processInstanceName = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String processTemplateName = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        boolean fork = Boolean.parseBoolean(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        boolean embedded = Boolean.parseBoolean(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        while (child != null) {
            if (child.getTagName().equals("iconID")) {
                iconID = UUID.fromString(child.getTextContent());
            }
            if (child.getTagName().equals("configuration")) {
                configuration = ProcessModelXMLImportTools.getConfiguration(pmf, child);
            }
            if (child.getTagName().equals("inputParameters")) {
                inputParameters = ProcessModelXMLImportTools.getParameters(pmf, child);
            }
            if (child.getTagName().equals("outputParameters")) {
                outputParameters = ProcessModelXMLImportTools.getParameters(pmf, child);
            }
            if (child.getTagName().equals("pluginDataContainer")) {
                pdc = ProcessModelXMLImportTools.getPluginDataContainer(pmf, child);
            }
            if (child.getTagName().equals("userAttributes")) {
                userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return factory.createLightWeightProcessInstance(templateID, processTemplateName, processInstanceName, instanceLogID, name, description, iconID, ecp, configuration, inputParameters, outputParameters, dataContext, pdc, userAttributes, fork, embedded);
    }

    static String getTemplateVersion(Element templateElement) {
        if (templateElement.hasAttribute("version")) {
            return templateElement.getAttribute("version");
        }
        return "";
    }

    static String getInstanceVersion(Element instanceElement) {
        if (instanceElement.hasAttribute("version")) {
            return instanceElement.getAttribute("version");
        }
        return "";
    }

    static Template getTemplate(ProcessModelFactory factory, Element templateElement) {
        String description = "";
        ConfigurationDescription configurationDescription = null;
        Configuration configuration = null;
        Configuration testConfiguration = null;
        Set<ProcessModelParameter> inputParameters = new HashSet<ProcessModelParameter>();
        Set<ProcessModelParameter> outputParameters = new HashSet<ProcessModelParameter>();
        TemplateDeltaLayer deltaLayer = null;
        HashSet<StructuredConstraintEdge> constraintEdges = new HashSet();
        String instanceNameTemplate = null;
        Map<String, Set<String>> supportedPlugins = new HashMap<String, Set<String>>();
        Map<String, PluginData> pluginDatas = new HashMap<String, PluginData>();
        Map<String, String> userAttributes = new HashMap<String, String>();
        UUID id = UUID.fromString(templateElement.getAttribute("id"));
        Element child = ProcessModelXMLImportTools.getElement(templateElement.getFirstChild());
        String name = child.getTextContent();
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())).getTagName().equals("description")) {
            description = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        String processType = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        QualifiedAgent supervisorAgent = ProcessModelXMLImportTools.getQualifiedAgent(child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String version = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        Set<Node> nodes = ProcessModelXMLImportTools.getTemplateNodes(factory, child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        Set<DataElement> dataElements = ProcessModelXMLImportTools.getTemplateDataElements(factory, child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        Set<StructuredEdge> edges = ProcessModelXMLImportTools.getTemplateEdges(factory, child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        Set<StructuredDataEdge> dataEdges = ProcessModelXMLImportTools.getTemplateDataEdges(factory, child);
        if ("constraintEdges".equals((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())).getTagName())) {
            constraintEdges = ProcessModelXMLImportTools.getTemplateConstraintEdges(factory, child);
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        int startNodeID = ProcessModelXMLImportTools.getParsedID(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        int endNodeID = ProcessModelXMLImportTools.getParsedID(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        Map<Integer, ProcessModelFactory.StructuralNodeData> structuralNodeData = ProcessModelXMLImportTools.getTemplateStructuralNodeData(factory, child);
        Map<Integer, List<Integer>> disabledNodeConnectors = ProcessModelXMLImportTools.getTemplateDisabledNodeConnectors(child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        while (child != null) {
            if (child.getTagName().equals("instanceNameTemplate")) {
                instanceNameTemplate = child.getTextContent();
            } else if (child.getTagName().equals("configurationDescription")) {
                configurationDescription = ProcessModelXMLImportTools.getConfigurationDescription(factory, child);
            } else if (child.getTagName().equals("configuration")) {
                configuration = ProcessModelXMLImportTools.getConfiguration(factory, child);
            } else if (child.getTagName().equals("testConfiguration")) {
                testConfiguration = ProcessModelXMLImportTools.getConfiguration(factory, child);
            } else if (child.getTagName().equals("inputParameters")) {
                inputParameters = ProcessModelXMLImportTools.getParameters(factory, child);
            } else if (child.getTagName().equals("outputParameters")) {
                outputParameters = ProcessModelXMLImportTools.getParameters(factory, child);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                PluginDataContainer pdc = ProcessModelXMLImportTools.getPluginDataContainer(factory, child);
                supportedPlugins = pdc.getSupportedPlugins();
                pluginDatas = pdc.getPluginDatas();
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
            } else if (child.getTagName().equals("deltaLayer")) {
                deltaLayer = ProcessModelXMLImportTools.getTemplateDeltaLayer(factory, child);
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return factory.createTemplate(id, name, description, configurationDescription, configuration, testConfiguration, processType, supervisorAgent, version, inputParameters, outputParameters, deltaLayer, nodes, dataElements, edges, dataEdges, constraintEdges, structuralNodeData, disabledNodeConnectors, startNodeID, endNodeID, instanceNameTemplate, supportedPlugins, pluginDatas, userAttributes);
    }

    static Instance getInstance(ProcessModelFactory factory, Element instanceElement, Template origTemplate) {
        EBPInstanceReference ebpInstanceReference = null;
        HashMap<Integer, ProcessConstants.NodeState> nodeStates = new HashMap<Integer, ProcessConstants.NodeState>();
        HashMap<Integer, Integer> nodeIterations = new HashMap<Integer, Integer>();
        HashMap<Integer, ProcessConstants.ExecutionMode> nodeExecutionModes = new HashMap<Integer, ProcessConstants.ExecutionMode>();
        HashMap<Integer, List<UUID>> nodeLWPInstanceIDs = new HashMap<Integer, List<UUID>>();
        HashMap<Integer, QualifiedAgent> activityAgents = new HashMap<Integer, QualifiedAgent>();
        HashMap<String, Set<String>> supportedPlugins = new HashMap();
        HashMap<String, PluginData> pluginDatas = new HashMap();
        HashMap<String, String> userAttributes = new HashMap();
        Template template = origTemplate;
        UUID id = UUID.fromString(instanceElement.getAttribute("id"));
        UUID logID = UUID.fromString(instanceElement.getAttribute("logID"));
        Element child = ProcessModelXMLImportTools.getElement(instanceElement.getFirstChild());
        String name = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        QualifiedAgent initiatorAgent = ProcessModelXMLImportTools.getQualifiedAgent(child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        QualifiedAgent supervisorAgent = ProcessModelXMLImportTools.getQualifiedAgent(child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        UUID baseTemplateID = UUID.fromString(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        long creationTime = Long.valueOf(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        boolean isModified = Boolean.parseBoolean(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())).getTagName().equals("templateID")) {
            if (template == null) {
                throw new NullArgumentException("The provided instance file references a template, but the template parameter is null.");
            }
            UUID templateUUID = UUID.fromString(child.getTextContent());
            if (!templateUUID.equals(template.getID())) {
                throw new IllegalArgumentException("The UUIDs of the provided template does not match the stored ID.");
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        } else if (child.getTagName().equals("deltaLayer")) {
            template = ProcessModelXMLImportTools.getInstanceDeltaLayer(factory, child);
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        } else {
            template = ProcessModelXMLImportTools.getTemplate(factory, child);
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        Element elementInstanceDataChild = ProcessModelXMLImportTools.getElement(child.getFirstChild());
        while (elementInstanceDataChild != null) {
            Integer nodeID;
            if (elementInstanceDataChild.getTagName().equals("nodeInstanceData")) {
                nodeID = ProcessModelXMLImportTools.getParsedID(elementInstanceDataChild.getAttribute("nodeID"));
                Element nodeInstanceDataChild = ProcessModelXMLImportTools.getElement(elementInstanceDataChild.getFirstChild());
                ProcessConstants.NodeState nodeState = ProcessConstants.NodeState.valueOf(nodeInstanceDataChild.getTextContent());
                nodeStates.put(nodeID, nodeState);
                nodeInstanceDataChild = ProcessModelXMLImportTools.getElement(nodeInstanceDataChild.getNextSibling());
                Integer iteration = Integer.valueOf(nodeInstanceDataChild.getTextContent());
                nodeIterations.put(nodeID, iteration);
                nodeInstanceDataChild = ProcessModelXMLImportTools.getElement(nodeInstanceDataChild.getNextSibling());
                if (nodeInstanceDataChild != null && nodeInstanceDataChild.getTagName().equals("executionMode")) {
                    ProcessConstants.ExecutionMode executionMode = ProcessConstants.ExecutionMode.valueOf(nodeInstanceDataChild.getTextContent());
                    nodeExecutionModes.put(nodeID, executionMode);
                }
            } else if (elementInstanceDataChild.getTagName().equals("activityInstanceData")) {
                nodeID = ProcessModelXMLImportTools.getParsedID(elementInstanceDataChild.getAttribute("nodeID"));
                Element instanceActivityChild = ProcessModelXMLImportTools.getElement(elementInstanceDataChild.getFirstChild());
                QualifiedAgent agent = ProcessModelXMLImportTools.getQualifiedAgent(instanceActivityChild);
                activityAgents.put(nodeID, agent);
            } else if (elementInstanceDataChild.getTagName().equals("lwpInstanceData")) {
                ArrayList<UUID> value = new ArrayList<UUID>();
                nodeID = ProcessModelXMLImportTools.getParsedID(elementInstanceDataChild.getAttribute("nodeID"));
                Element instanceLwpChild = ProcessModelXMLImportTools.getElement(elementInstanceDataChild.getFirstChild());
                while (instanceLwpChild != null) {
                    UUID lwpInstanceID = UUID.fromString(instanceLwpChild.getTextContent());
                    if (nodeIterations.get(nodeID) != null) {
                        value.add(lwpInstanceID);
                    }
                    instanceLwpChild = ProcessModelXMLImportTools.getElement(instanceLwpChild.getNextSibling());
                }
                nodeLWPInstanceIDs.put(nodeID, value);
            }
            elementInstanceDataChild = ProcessModelXMLImportTools.getElement(elementInstanceDataChild.getNextSibling());
        }
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())) != null && child.getTagName().equals("pluginDataContainer")) {
            PluginDataContainer pdc = ProcessModelXMLImportTools.getPluginDataContainer(factory, child);
            supportedPlugins = pdc.getSupportedPlugins();
            pluginDatas = pdc.getPluginDatas();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("userAttributes")) {
            userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("executionHistory")) {
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("changeHistory")) {
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("instanceStatus")) {
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("ebpInstanceReference")) {
            ebpInstanceReference = ProcessModelXMLImportTools.getEBPInstanceReference(child);
        }
        return factory.createInstance(id, logID, name, isModified, baseTemplateID, template, supervisorAgent, initiatorAgent, ebpInstanceReference, creationTime, nodeStates, nodeIterations, nodeExecutionModes, nodeLWPInstanceIDs, activityAgents, supportedPlugins, pluginDatas, userAttributes);
    }

    static ExecutableInstance getExecutableInstance(ProcessModelFactory factory, ExecutionFactory executionFactory, Element instanceElement, Template origTemplate) {
        Template template = origTemplate;
        EBPInstanceReference parentReference = null;
        HashMap<Integer, ProcessConstants.NodeState> nodeStates = new HashMap<Integer, ProcessConstants.NodeState>();
        HashMap<Integer, ProcessConstants.ExecutionMode> executionModes = new HashMap<Integer, ProcessConstants.ExecutionMode>();
        HashMap<Integer, Integer> nodeIterations = new HashMap<Integer, Integer>();
        HashMap<Integer, List<UUID>> nodeLWPInstanceIDs = new HashMap<Integer, List<UUID>>();
        HashMap<Integer, QualifiedAgent> nodePerformingAgents = new HashMap<Integer, QualifiedAgent>();
        HashMap<Integer, List<Enquiry>> currentEnquiries = new HashMap<Integer, List<Enquiry>>();
        HashMap<Integer, Enquiry> repliedEnquiries = new HashMap<Integer, Enquiry>();
        URI[] instanceTerminationCallbackURIs = null;
        HashMap<Integer, URI[]> runtimeManagerURIs = new HashMap<Integer, URI[]>();
        HashMap<String, Set<String>> supportedPlugins = new HashMap();
        HashMap<String, PluginData> pluginDatas = new HashMap();
        HashMap<String, String> userAttributes = new HashMap();
        UUID instanceID = UUID.fromString(instanceElement.getAttribute("id"));
        UUID logID = UUID.fromString(instanceElement.getAttribute("logID"));
        Element child = ProcessModelXMLImportTools.getElement(instanceElement.getFirstChild());
        String instanceName = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        UUID baseTemplateID = UUID.fromString(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        long creationTime = Long.valueOf(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        boolean modified = Boolean.parseBoolean(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())).getTagName().equals("templateID")) {
            if (template == null) {
                throw new NullArgumentException("The provided instance file references a template, but the template parameter is null.");
            }
            UUID templateUUID = UUID.fromString(child.getTextContent());
            if (!templateUUID.equals(template.getID())) {
                throw new IllegalArgumentException("The UUIDs of the provided template does not match the stored ID.");
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        } else if (child.getTagName().equals("deltaLayer")) {
            template = ProcessModelXMLImportTools.getInstanceDeltaLayer(factory, child);
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        } else {
            template = ProcessModelXMLImportTools.getTemplate(factory, child);
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        QualifiedAgent supervisorAgent = ProcessModelXMLImportTools.getQualifiedAgent(child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        QualifiedAgent initiatorAgent = ProcessModelXMLImportTools.getQualifiedAgent(child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        if (child != null && child.getTagName().equals("ebpInstanceReference")) {
            parentReference = ProcessModelXMLImportTools.getEBPInstanceReference(child);
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("instanceTerminationCallback")) {
            instanceTerminationCallbackURIs = ProcessModelXMLImportTools.getURIs(child);
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        while (child != null && child.getTagName().equals("instanceNodeData")) {
            Integer nodeID = ProcessModelXMLImportTools.getParsedID(child.getAttribute("nodeID"));
            Element nodeDataChild = ProcessModelXMLImportTools.getElement(child.getFirstChild());
            ProcessConstants.NodeState nodeState = ProcessConstants.NodeState.valueOf(nodeDataChild.getTextContent());
            nodeStates.put(nodeID, nodeState);
            nodeDataChild = ProcessModelXMLImportTools.getElement(nodeDataChild.getNextSibling());
            Integer nodeIteration = Integer.valueOf(nodeDataChild.getTextContent());
            nodeIterations.put(nodeID, nodeIteration);
            nodeDataChild = ProcessModelXMLImportTools.getElement(nodeDataChild.getNextSibling());
            if (nodeDataChild != null && nodeDataChild.getTagName().equals("executionMode")) {
                ProcessConstants.ExecutionMode executionMode = ProcessConstants.ExecutionMode.valueOf(nodeDataChild.getTextContent());
                executionModes.put(nodeID, executionMode);
                nodeDataChild = ProcessModelXMLImportTools.getElement(nodeDataChild.getNextSibling());
            }
            ArrayList<UUID> lwpInstanceIDs = new ArrayList<UUID>();
            while (nodeDataChild != null && nodeDataChild.getTagName().equals("lwpInstanceData")) {
                lwpInstanceIDs.add(UUID.fromString(nodeDataChild.getTextContent()));
                nodeDataChild = ProcessModelXMLImportTools.getElement(nodeDataChild.getNextSibling());
            }
            if (lwpInstanceIDs.size() > 0) {
                nodeLWPInstanceIDs.put(nodeID, lwpInstanceIDs);
            }
            if (nodeDataChild != null && nodeDataChild.getTagName().equals("performingAgent")) {
                QualifiedAgent performingAgent = ProcessModelXMLImportTools.getQualifiedAgent(nodeDataChild);
                nodePerformingAgents.put(nodeID, performingAgent);
                nodeDataChild = ProcessModelXMLImportTools.getElement(nodeDataChild.getNextSibling());
            }
            ArrayList<Enquiry> nodeCurrentEnquiries = new ArrayList<Enquiry>();
            while (nodeDataChild != null && nodeDataChild.getTagName().equals("currentEnquiries")) {
                nodeCurrentEnquiries.add(ProcessModelXMLImportTools.getEnquiry(executionFactory, nodeDataChild));
                nodeDataChild = ProcessModelXMLImportTools.getElement(nodeDataChild.getNextSibling());
            }
            if (nodeCurrentEnquiries.size() > 0) {
                currentEnquiries.put(nodeID, nodeCurrentEnquiries);
            }
            if (nodeDataChild != null && nodeDataChild.getTagName().equals("repliedEnquiry")) {
                Enquiry nodeRepliedEnquiry = ProcessModelXMLImportTools.getEnquiry(executionFactory, nodeDataChild);
                repliedEnquiries.put(nodeID, nodeRepliedEnquiry);
                nodeDataChild = ProcessModelXMLImportTools.getElement(nodeDataChild.getNextSibling());
            }
            if (nodeDataChild != null && nodeDataChild.getTagName().equals("runtimeManager")) {
                URI[] runtimeManager = ProcessModelXMLImportTools.getURIs(nodeDataChild);
                runtimeManagerURIs.put(nodeID, runtimeManager);
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("pluginDataContainer")) {
            PluginDataContainer pdc = ProcessModelXMLImportTools.getPluginDataContainer(factory, child);
            supportedPlugins = pdc.getSupportedPlugins();
            pluginDatas = pdc.getPluginDatas();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("userAttributes")) {
            userAttributes = ProcessModelXMLImportTools.getUserAttributes(child);
        }
        return executionFactory.createExecutableInstance(instanceID, logID, instanceName, modified, baseTemplateID, template, supervisorAgent, initiatorAgent, parentReference, creationTime, nodeStates, executionModes, nodeIterations, nodeLWPInstanceIDs, nodePerformingAgents, currentEnquiries, repliedEnquiries, instanceTerminationCallbackURIs, runtimeManagerURIs, supportedPlugins, pluginDatas, userAttributes);
    }

    static UUID getTemplateIDFromInstanceElement(Element root) {
        Element templateIDNode = ProcessModelXMLImportTools.nextNode(root.getFirstChild(), "templateID");
        if (templateIDNode == null) {
            throw new IllegalArgumentException("The template is stored inline.");
        }
        return UUID.fromString(templateIDNode.getTextContent());
    }

    static boolean getIsModifiedFromInstanceElement(Element root) {
        Element isModifiedNode = ProcessModelXMLImportTools.nextNode(root.getFirstChild(), "isModified");
        if (isModifiedNode == null) {
            throw new IllegalArgumentException("Invalid instance: isModified element is missing.");
        }
        return Boolean.parseBoolean(isModifiedNode.getTextContent());
    }

    private static Map<Integer, List<Integer>> getTemplateDisabledNodeConnectors(Element child) {
        HashMap<Integer, List<Integer>> disabledNodeConnectors = new HashMap<Integer, List<Integer>>();
        Element current = ProcessModelXMLImportTools.getElement(child.getFirstChild());
        while (current != null) {
            if (!current.getTagName().equals("disabledNodeConnectors")) {
                current = ProcessModelXMLImportTools.getElement(current.getNextSibling());
                continue;
            }
            Integer nodeID = ProcessModelXMLImportTools.getParsedID(current.getAttribute("nodeID"));
            if (disabledNodeConnectors.containsKey(nodeID)) {
                logger.severe("Duplicate entry for disabled node connectors, ignoring.");
                continue;
            }
            LinkedList<Integer> connectors = new LinkedList<Integer>();
            Element connectorElement = ProcessModelXMLImportTools.getElement(current.getFirstChild());
            while (connectorElement != null) {
                Integer connectorID = Integer.valueOf(connectorElement.getTextContent());
                connectors.add(connectorID);
                connectorElement = ProcessModelXMLImportTools.getElement(connectorElement.getNextSibling());
            }
            disabledNodeConnectors.put(nodeID, connectors);
            current = ProcessModelXMLImportTools.getElement(current.getNextSibling());
        }
        return disabledNodeConnectors;
    }

    private static Map<Integer, ProcessModelFactory.StructuralNodeData> getTemplateStructuralNodeData(ProcessModelFactory factory, Element structuralData) {
        HashMap<Integer, ProcessModelFactory.StructuralNodeData> nodesStruct = new HashMap<Integer, ProcessModelFactory.StructuralNodeData>();
        Element child = ProcessModelXMLImportTools.getElement(structuralData.getFirstChild());
        while (child != null) {
            if (!child.getTagName().equals("structuralNodeData")) {
                child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
                continue;
            }
            int splitNodeID = Integer.MIN_VALUE;
            int correspondingBlockNodeID = 0;
            int nodeID = ProcessModelXMLImportTools.getParsedID(child.getAttribute("nodeID"));
            Element nodeDataChild = ProcessModelXMLImportTools.getElement(child.getFirstChild());
            ProcessConstants.NodeType type = ProcessConstants.NodeType.valueOf(nodeDataChild.getTextContent());
            nodeDataChild = ProcessModelXMLImportTools.getElement(nodeDataChild.getNextSibling());
            int topologicalID = Integer.parseInt(nodeDataChild.getTextContent());
            nodeDataChild = ProcessModelXMLImportTools.getElement(nodeDataChild.getNextSibling());
            int branchID = Integer.parseInt(nodeDataChild.getTextContent());
            if ((nodeDataChild = ProcessModelXMLImportTools.getElement(nodeDataChild.getNextSibling())) != null && nodeDataChild.getTagName().equals("splitNodeID")) {
                splitNodeID = ProcessModelXMLImportTools.getParsedID(nodeDataChild.getTextContent());
                nodeDataChild = ProcessModelXMLImportTools.getElement(nodeDataChild.getNextSibling());
            }
            if (nodeDataChild != null && nodeDataChild.getTagName().equals("correspondingBlockNodeID")) {
                correspondingBlockNodeID = ProcessModelXMLImportTools.getParsedID(nodeDataChild.getTextContent());
            }
            ProcessModelFactory.StructuralNodeData snd = factory.createStructuralNodeData(nodeID, type, topologicalID, branchID, splitNodeID, correspondingBlockNodeID);
            nodesStruct.put(nodeID, snd);
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return nodesStruct;
    }

    private static Set<StructuredDataEdge> getTemplateDataEdges(ProcessModelFactory factory, Element dataEdgesElement) {
        HashSet<StructuredDataEdge> structuredDataEdges = new HashSet<StructuredDataEdge>();
        Element child = ProcessModelXMLImportTools.getElement(dataEdgesElement.getFirstChild());
        while (child != null) {
            StructuredDataEdge sde = ProcessModelXMLImportTools.getStructuredDataEdge(factory, child);
            structuredDataEdges.add(sde);
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return structuredDataEdges;
    }

    private static Set<StructuredEdge> getTemplateEdges(ProcessModelFactory factory, Element edgesElement) {
        HashSet<StructuredEdge> structuredEdges = new HashSet<StructuredEdge>();
        Element child = ProcessModelXMLImportTools.getElement(edgesElement.getFirstChild());
        while (child != null) {
            StructuredEdge sde = ProcessModelXMLImportTools.getStructuredEdge(factory, child);
            structuredEdges.add(sde);
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return structuredEdges;
    }

    private static Set<StructuredConstraintEdge> getTemplateConstraintEdges(ProcessModelFactory factory, Element timeEdgesElement) {
        HashSet<StructuredConstraintEdge> constraintEdges = new HashSet<StructuredConstraintEdge>();
        Element child = ProcessModelXMLImportTools.getElement(timeEdgesElement.getFirstChild());
        while (child != null) {
            StructuredConstraintEdge ce = ProcessModelXMLImportTools.getStructuredConstraintEdge(factory, child);
            constraintEdges.add(ce);
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return constraintEdges;
    }

    private static Set<DataElement> getTemplateDataElements(ProcessModelFactory factory, Element dataElementsElement) {
        HashSet<DataElement> dataElements = new HashSet<DataElement>();
        Element child = ProcessModelXMLImportTools.getElement(dataElementsElement.getFirstChild());
        while (child != null) {
            dataElements.add(ProcessModelXMLImportTools.getDataElement(child, factory));
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return dataElements;
    }

    private static Set<Node> getTemplateNodes(ProcessModelFactory factory, Element nodesElement) {
        HashSet<Node> nodes = new HashSet<Node>();
        Element child = ProcessModelXMLImportTools.getElement(nodesElement.getFirstChild());
        while (child != null) {
            nodes.add(ProcessModelXMLImportTools.getNode(factory, child));
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        return nodes;
    }

    static TemplateDeltaLayer getTemplateDeltaLayer(ProcessModelFactory factory, Element templateDeltaLayerElement) {
        return null;
    }

    static InstanceDeltaLayer getInstanceDeltaLayer(ProcessModelFactory factory, Element instanceDeltaLayerElement) {
        return null;
    }

    static TemplateStatus getTemplateStatus(ProcessModelFactory factory, Element templateStatusElement, UUID templateID) {
        String derivableComment = null;
        String tlOutdatedComment = null;
        String spOutdatedComment = null;
        String tlInstantiableComment = null;
        String spInstantiableComment = null;
        String tlInstancesMigratableComment = null;
        String spInstancesMigratableComment = null;
        String tlInstancesChangeableComment = null;
        String spInstancesChangeableComment = null;
        Element child = ProcessModelXMLImportTools.getElement(templateStatusElement.getFirstChild());
        ProcessConstants.TemplateBuildtimeState buildtimeState = ProcessConstants.TemplateBuildtimeState.valueOf(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        boolean topLevelUsage = Boolean.parseBoolean(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        ProcessConstants.TemplateUsage subprocessUsage = ProcessConstants.TemplateUsage.valueOf(child.getTextContent());
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String starterRule = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        boolean derivable = Boolean.parseBoolean(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())).getTagName().equals("isDerivableComment")) {
            derivableComment = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        boolean tlInstantiable = Boolean.parseBoolean(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())).getTagName().equals("isInstantiableComment")) {
            tlInstantiableComment = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        boolean spInstantiable = Boolean.parseBoolean(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())).getTagName().equals("isInstantiableCommentSubProcess")) {
            spInstantiableComment = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        boolean tlOutdated = Boolean.parseBoolean(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())).getTagName().equals("isOutdatedComment")) {
            tlOutdatedComment = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        boolean spOutdated = Boolean.parseBoolean(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())).getTagName().equals("isOutdatedCommentSubProcess")) {
            spOutdatedComment = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        boolean tlInstancesChangeable = Boolean.parseBoolean(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())).getTagName().equals("areInstancesChangeableComment")) {
            tlInstancesChangeableComment = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        boolean spInstancesChangeable = Boolean.parseBoolean(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())).getTagName().equals("areInstancesChangeableCommentSubProcess")) {
            spInstancesChangeableComment = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        boolean tlInstancesMigratableTo = Boolean.parseBoolean(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())).getTagName().equals("areInstancesMigratableToComment")) {
            tlInstancesMigratableComment = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        boolean spInstancesMigratableTo = Boolean.parseBoolean(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())) != null && child.getTagName().equals("areInstancesMigratableToCommentSubProcess")) {
            spInstancesMigratableComment = child.getTextContent();
        }
        return factory.createTemplateStatus(templateID, buildtimeState, subprocessUsage, topLevelUsage, derivable, derivableComment, tlOutdated, tlOutdatedComment, spOutdated, spOutdatedComment, tlInstantiable, tlInstantiableComment, spInstantiable, spInstantiableComment, tlInstancesMigratableTo, tlInstancesMigratableComment, spInstancesMigratableTo, spInstancesMigratableComment, tlInstancesChangeable, tlInstancesChangeableComment, spInstancesChangeable, spInstancesChangeableComment, starterRule);
    }

    static InstanceStatus getInstanceStatus(ProcessModelFactory factory, Element instanceStatusElement, UUID instanceID) {
        String migrationsStatusComment = null;
        ProcessConstants.InstanceExecutionStatus executionStatus = null;
        String executionStatusComment = null;
        Element child = ProcessModelXMLImportTools.getElement(instanceStatusElement.getFirstChild());
        ProcessConstants.InstanceMigrationStatus migrationStatus = ProcessConstants.InstanceMigrationStatus.valueOf(child.getTextContent());
        if ((child = ProcessModelXMLImportTools.getElement(child.getNextSibling())) != null && child.getTagName().equals("migrationStatusComment")) {
            migrationsStatusComment = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("executionStatus")) {
            executionStatus = ProcessConstants.InstanceExecutionStatus.valueOf(child.getTextContent());
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("executionStatusComment")) {
            executionStatusComment = child.getTextContent();
        }
        return factory.createInstanceStatus(instanceID, migrationStatus, migrationsStatusComment, executionStatus, executionStatusComment);
    }

    static TemplateStatus getTemplateStatus(ProcessModelFactory factory, Element templateElement) {
        UUID templateID = UUID.fromString(templateElement.getAttribute("id"));
        NodeList nodeList = templateElement.getElementsByTagName("templateStatus");
        if (nodeList.getLength() != 1) {
            logger.info("Found " + nodeList.getLength() + " template status elements," + "expected 1!");
            return null;
        }
        Element templateStatusElement = ProcessModelXMLImportTools.getElement(nodeList.item(0));
        return ProcessModelXMLImportTools.getTemplateStatus(factory, templateStatusElement, templateID);
    }

    static InstanceStatus getInstanceStatus(ProcessModelFactory factory, Element instanceElement) {
        UUID instanceID = UUID.fromString(instanceElement.getAttribute("id"));
        NodeList nodeList = instanceElement.getElementsByTagName("instanceStatus");
        if (nodeList.getLength() != 1) {
            logger.info("Found " + nodeList.getLength() + " instance status elements," + "expected 1!");
            return null;
        }
        Element instanceStatusElement = ProcessModelXMLImportTools.getElement(nodeList.item(0));
        return ProcessModelXMLImportTools.getInstanceStatus(factory, instanceStatusElement, instanceID);
    }

    private static Enquiry getEnquiry(ExecutionFactory factory, Element enquiryChild) {
        Element child = ProcessModelXMLImportTools.getElement(enquiryChild.getFirstChild());
        QualifiedAgent originator = ProcessModelXMLImportTools.getQualifiedAgent(child);
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        HashSet<QualifiedAgent> recipients = new HashSet<QualifiedAgent>();
        while (child.getTagName().equals("recipients")) {
            recipients.add(ProcessModelXMLImportTools.getQualifiedAgent(child));
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        String question = child.getTextContent();
        child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        String reply = null;
        if (child != null && child.getTagName().equals("reply")) {
            reply = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
        }
        QualifiedAgent replier = null;
        if (child != null && child.getTagName().equals("replier")) {
            replier = ProcessModelXMLImportTools.getQualifiedAgent(child);
        }
        return factory.createEnquiry(originator, recipients, question, reply, replier);
    }

    public static Map<UUID, ProcessModelXMLHelperTools.LockDescription> getTemplateLocks(Element root) {
        HashMap<UUID, ProcessModelXMLHelperTools.LockDescription> res = new HashMap<UUID, ProcessModelXMLHelperTools.LockDescription>();
        Element lockElement = ProcessModelXMLImportTools.getElement(root.getFirstChild());
        while (lockElement != null) {
            Element child = ProcessModelXMLImportTools.getElement(lockElement.getFirstChild());
            UUID id = UUID.fromString(child.getTextContent());
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            int lockCount = Integer.parseInt(child.getTextContent());
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            QualifiedAgent agent = ProcessModelXMLImportTools.getQualifiedAgent(child);
            lockElement = ProcessModelXMLImportTools.getElement(lockElement.getNextSibling());
            res.put(id, new ProcessModelXMLHelperTools.LockDescription(agent, lockCount));
        }
        return res;
    }

    public static String getTemplateLocksVersion(Element root) {
        if (!root.hasAttribute("version")) {
            return null;
        }
        return root.getAttribute("version");
    }

    public static Map<UUID, ProcessModelXMLHelperTools.LockDescription> getInstanceLocks(Element root) {
        HashMap<UUID, ProcessModelXMLHelperTools.LockDescription> res = new HashMap<UUID, ProcessModelXMLHelperTools.LockDescription>();
        Element lockElement = ProcessModelXMLImportTools.getElement(root.getFirstChild());
        while (lockElement != null) {
            Element child = ProcessModelXMLImportTools.getElement(lockElement.getFirstChild());
            UUID id = UUID.fromString(child.getTextContent());
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            int lockCount = Integer.parseInt(child.getTextContent());
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            QualifiedAgent agent = ProcessModelXMLImportTools.getQualifiedAgent(child);
            lockElement = ProcessModelXMLImportTools.getElement(lockElement.getNextSibling());
            res.put(id, new ProcessModelXMLHelperTools.LockDescription(agent, lockCount));
        }
        return res;
    }

    public static String getInstanceLocksVersion(Element root) {
        if (!root.hasAttribute("version")) {
            return null;
        }
        return root.getAttribute("version");
    }

    public static Map<UUID, UUID> getEmbeddedTemplateMapping(Element root) {
        HashMap<UUID, UUID> res = new HashMap<UUID, UUID>();
        Element mappingElement = ProcessModelXMLImportTools.getElement(root.getFirstChild());
        while (mappingElement != null) {
            Element child = ProcessModelXMLImportTools.getElement(mappingElement.getFirstChild());
            UUID parentID = UUID.fromString(child.getTextContent());
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            UUID embeddedID = UUID.fromString(child.getTextContent());
            res.put(embeddedID, parentID);
            mappingElement = ProcessModelXMLImportTools.getElement(mappingElement.getNextSibling());
        }
        return res;
    }

    public static String getEmbeddedTemplateMappingVersion(Element root) {
        if (!root.hasAttribute("version")) {
            return null;
        }
        return root.getAttribute("version");
    }

    public static Map<UUID, UUID> getBaseTemplateMapping(Element root) {
        HashMap<UUID, UUID> res = new HashMap<UUID, UUID>();
        Element mappingElement = ProcessModelXMLImportTools.getElement(root.getFirstChild());
        while (mappingElement != null) {
            Element child = ProcessModelXMLImportTools.getElement(mappingElement.getFirstChild());
            UUID templateID = UUID.fromString(child.getTextContent());
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            UUID baseTemplateID = UUID.fromString(child.getTextContent());
            res.put(templateID, baseTemplateID);
            mappingElement = ProcessModelXMLImportTools.getElement(mappingElement.getNextSibling());
        }
        return res;
    }

    public static String getBaseTemplateMappingVersion(Element root) {
        if (!root.hasAttribute("version")) {
            return null;
        }
        return root.getAttribute("version");
    }

    public static Map<UUID, UUID> getAdhocTemplateMapping(Element root) {
        HashMap<UUID, UUID> res = new HashMap<UUID, UUID>();
        Element mappingElement = ProcessModelXMLImportTools.getElement(root.getFirstChild());
        while (mappingElement != null) {
            Element child = ProcessModelXMLImportTools.getElement(mappingElement.getFirstChild());
            UUID templateID = UUID.fromString(child.getTextContent());
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            UUID instanceID = UUID.fromString(child.getTextContent());
            res.put(templateID, instanceID);
            mappingElement = ProcessModelXMLImportTools.getElement(mappingElement.getNextSibling());
        }
        return res;
    }

    public static String getAdhocTemplateMappingVersion(Element root) {
        if (!root.hasAttribute("version")) {
            return null;
        }
        return root.getAttribute("version");
    }

    public static Set<ProcessModelXMLHelperTools.SerialisableProcessType> getProcessTypes(Element root) {
        HashSet<ProcessModelXMLHelperTools.SerialisableProcessType> res = new HashSet<ProcessModelXMLHelperTools.SerialisableProcessType>();
        Element itemElement = ProcessModelXMLImportTools.getElement(root.getFirstChild());
        while (itemElement != null) {
            Element child = ProcessModelXMLImportTools.getElement(itemElement.getFirstChild());
            String name = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            UUID rootTemplateID = UUID.fromString(child.getTextContent());
            res.add(new ProcessModelXMLHelperTools.SerialisableProcessType(name, rootTemplateID));
            itemElement = ProcessModelXMLImportTools.getElement(itemElement.getNextSibling());
        }
        return res;
    }

    public static String getProcessTypesVersion(Element root) {
        if (!root.hasAttribute("version")) {
            return null;
        }
        return root.getAttribute("version");
    }

    public static Map<UUID, ProcessModelXMLHelperTools.TemplateInformation> getTemplateInformations(Element root) {
        HashMap<UUID, ProcessModelXMLHelperTools.TemplateInformation> res = new HashMap<UUID, ProcessModelXMLHelperTools.TemplateInformation>();
        Element itemElement = ProcessModelXMLImportTools.getElement(root.getFirstChild());
        while (itemElement != null) {
            Element cur;
            Element child = ProcessModelXMLImportTools.getElement(itemElement.getFirstChild());
            UUID templateID = UUID.fromString(child.getTextContent());
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            UUID parentTemplateID = null;
            if (child.getTagName().equals("parentTemplateID")) {
                parentTemplateID = UUID.fromString(child.getTextContent());
                child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            }
            long creationTime = Long.parseLong(child.getTextContent());
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            long modificationTime = Long.parseLong(child.getTextContent());
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            String internalVersion = child.getTextContent();
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            HashSet<UUID> childIDs = new HashSet<UUID>();
            if (child.hasChildNodes()) {
                cur = ProcessModelXMLImportTools.getElement(child.getFirstChild());
                while (cur != null) {
                    UUID id = UUID.fromString(cur.getTextContent());
                    childIDs.add(id);
                    cur = ProcessModelXMLImportTools.getElement(cur.getNextSibling());
                }
            }
            child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            ArrayList processManagers = new ArrayList();
            while (child != null) {
                cur = ProcessModelXMLImportTools.getElement(child.getFirstChild());
                ArrayList<URI> uris = new ArrayList<URI>();
                while (cur != null) {
                    URI uRI = URI.create(cur.getTextContent());
                    uris.add(uRI);
                    cur = ProcessModelXMLImportTools.getElement(cur.getNextSibling());
                }
                processManagers.add(uris);
                child = ProcessModelXMLImportTools.getElement(child.getNextSibling());
            }
            ProcessModelXMLHelperTools.TemplateInformation ti = new ProcessModelXMLHelperTools.TemplateInformation(parentTemplateID, creationTime, modificationTime, internalVersion);
            ti.childTemplateIDs.addAll(childIDs);
            for (List list : processManagers) {
                URI[] u = new URI[list.size()];
                list.toArray(u);
                ti.deployedProcessManagers.add(u);
            }
            res.put(templateID, ti);
            itemElement = ProcessModelXMLImportTools.getElement(itemElement.getNextSibling());
        }
        return res;
    }

    public static String getTemplateInformationsVersion(Element root) {
        if (!root.hasAttribute("version")) {
            return null;
        }
        return root.getAttribute("version");
    }
}

