/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.runtimeenvironment;

import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import java.net.URI;
import java.util.Date;

public class FailingDataContext
implements DataContext {
    private final DataContext dc;

    public FailingDataContext(DataContext dc) {
        this.dc = dc;
    }

    @Override
    public void ignoreValue(String parameterName) {
        try {
            this.dc.ignoreValue(parameterName);
        }
        catch (NoSuchParameterException e) {
            String message = String.format("Expected parameter '%s' to exist.", parameterName);
            throw new ApplicationEnvironmentException(message, -401000L, e);
        }
    }

    @Override
    public boolean ignoredValue(String parameterName) {
        try {
            return this.dc.ignoredValue(parameterName);
        }
        catch (NoSuchParameterException e) {
            String message = String.format("Expected parameter '%s' to exist.", parameterName);
            throw new ApplicationEnvironmentException(message, -401000L, e);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.dc.isReadOnly();
    }

    @Override
    public void storeBooleanParameterValue(String parameterName, boolean value) {
        this.storeObject(parameterName, ProcessConstants.AdeptDataType.BOOLEAN, value);
    }

    @Override
    public void storeDateParameterValue(String parameterName, Date value) {
        this.storeObject(parameterName, ProcessConstants.AdeptDataType.DATE, value);
    }

    @Override
    public void storeFloatParameterValue(String parameterName, double value) {
        this.storeObject(parameterName, ProcessConstants.AdeptDataType.FLOAT, value);
    }

    @Override
    public void storeIntegerParameterValue(String parameterName, long value) {
        this.storeObject(parameterName, ProcessConstants.AdeptDataType.INTEGER, value);
    }

    @Override
    public void storeStringParameterValue(String parameterName, String value) {
        this.storeObject(parameterName, ProcessConstants.AdeptDataType.STRING, value);
    }

    @Override
    public void storeUDTParameterValue(String parameterName, UDTValue value) {
        this.storeObject(parameterName, ProcessConstants.AdeptDataType.USERDEFINED, value);
    }

    @Override
    public void storeURIParameterValue(String parameterName, URI value) {
        this.storeObject(parameterName, ProcessConstants.AdeptDataType.URI, value);
    }

    @Override
    public boolean storedBooleanParameterValue(String parameterName) {
        return (Boolean)this.getStoredObject(parameterName, ProcessConstants.AdeptDataType.BOOLEAN);
    }

    @Override
    public Date storedDateParameterValue(String parameterName) {
        return (Date)this.getStoredObject(parameterName, ProcessConstants.AdeptDataType.DATE);
    }

    @Override
    public double storedFloatParameterValue(String parameterName) {
        return (Double)this.getStoredObject(parameterName, ProcessConstants.AdeptDataType.FLOAT);
    }

    @Override
    public long storedIntegerParameterValue(String parameterName) {
        return (Long)this.getStoredObject(parameterName, ProcessConstants.AdeptDataType.INTEGER);
    }

    @Override
    public String storedStringParameterValue(String parameterName) {
        return (String)this.getStoredObject(parameterName, ProcessConstants.AdeptDataType.STRING);
    }

    @Override
    public UDTValue storedUDTParameterValue(String parameterName) {
        return (UDTValue)this.getStoredObject(parameterName, ProcessConstants.AdeptDataType.USERDEFINED);
    }

    @Override
    public URI storedURIParameterValue(String parameterName) {
        return (URI)this.getStoredObject(parameterName, ProcessConstants.AdeptDataType.URI);
    }

    @Override
    public boolean isNull(String parameterName) {
        try {
            return this.dc.isNull(parameterName);
        }
        catch (NoSuchParameterException e) {
            String message = String.format("Expected parameter '%s' to exist.", parameterName);
            throw new ApplicationEnvironmentException(message, -401000L, e);
        }
    }

    @Override
    public boolean retrieveBooleanParameterValue(String parameterName) {
        return (Boolean)this.retrieveObject(parameterName, ProcessConstants.AdeptDataType.BOOLEAN);
    }

    @Override
    public Date retrieveDateParameterValue(String parameterName) {
        return (Date)this.retrieveObject(parameterName, ProcessConstants.AdeptDataType.DATE);
    }

    @Override
    public double retrieveFloatParameterValue(String parameterName) {
        return (Double)this.retrieveObject(parameterName, ProcessConstants.AdeptDataType.FLOAT);
    }

    @Override
    public long retrieveIntegerParameterValue(String parameterName) {
        return (Long)this.retrieveObject(parameterName, ProcessConstants.AdeptDataType.INTEGER);
    }

    @Override
    public String retrieveStringParameterValue(String parameterName) {
        return (String)this.retrieveObject(parameterName, ProcessConstants.AdeptDataType.STRING);
    }

    @Override
    public UDTValue retrieveUDTParameterValue(String parameterName) {
        return (UDTValue)this.retrieveObject(parameterName, ProcessConstants.AdeptDataType.USERDEFINED);
    }

    @Override
    public URI retrieveURIParameterValue(String parameterName) {
        return (URI)this.retrieveObject(parameterName, ProcessConstants.AdeptDataType.URI);
    }

    protected void storeObject(String parameterName, ProcessConstants.AdeptDataType type, Object value) {
        try {
            switch (type) {
                case BOOLEAN: {
                    this.dc.storeBooleanParameterValue(parameterName, (Boolean)value);
                    break;
                }
                case DATE: {
                    this.dc.storeDateParameterValue(parameterName, (Date)value);
                    break;
                }
                case FLOAT: {
                    this.dc.storeFloatParameterValue(parameterName, (Double)value);
                    break;
                }
                case INTEGER: {
                    this.dc.storeIntegerParameterValue(parameterName, (Long)value);
                    break;
                }
                case STRING: {
                    this.dc.storeStringParameterValue(parameterName, (String)value);
                    break;
                }
                case URI: {
                    this.dc.storeURIParameterValue(parameterName, (URI)value);
                    break;
                }
                case USERDEFINED: {
                    this.dc.storeUDTParameterValue(parameterName, (UDTValue)value);
                    break;
                }
                default: {
                    String message = String.format("Parameter '%s' has an unknown data type ('%s').", new Object[]{parameterName, type});
                    throw new ApplicationEnvironmentException(message, -401001L);
                }
            }
        }
        catch (InvalidDataTypeException e) {
            String message = String.format("Parameter '%s' has wrong type, expected %s.", new Object[]{parameterName, type});
            throw new ApplicationEnvironmentException(message, -401001L, e);
        }
        catch (NoSuchParameterException e) {
            String message = String.format("Expected parameter '%s' to exist.", parameterName);
            throw new ApplicationEnvironmentException(message, -401000L, e);
        }
    }

    protected Object getStoredObject(String parameterName, ProcessConstants.AdeptDataType type) {
        try {
            switch (type) {
                case BOOLEAN: {
                    return this.dc.storedBooleanParameterValue(parameterName);
                }
                case DATE: {
                    return this.dc.storedDateParameterValue(parameterName);
                }
                case FLOAT: {
                    return this.dc.storedFloatParameterValue(parameterName);
                }
                case INTEGER: {
                    return this.dc.storedIntegerParameterValue(parameterName);
                }
                case STRING: {
                    return this.dc.storedStringParameterValue(parameterName);
                }
                case URI: {
                    return this.dc.storedURIParameterValue(parameterName);
                }
                case USERDEFINED: {
                    return this.dc.storedUDTParameterValue(parameterName);
                }
            }
            String message = String.format("Parameter '%s' has an unknown data type ('%s').", new Object[]{parameterName, type});
            throw new ApplicationEnvironmentException(message, -401001L);
        }
        catch (InvalidDataTypeException e) {
            String message = String.format("Parameter '%s' has wrong type, expected %s.", new Object[]{parameterName, type});
            throw new ApplicationEnvironmentException(message, -401001L, e);
        }
        catch (NoSuchParameterException e) {
            String message = String.format("Expected parameter '%s' to exist.", parameterName);
            throw new ApplicationEnvironmentException(message, -401000L, e);
        }
    }

    protected Object retrieveObject(String parameterName, ProcessConstants.AdeptDataType type) {
        try {
            switch (type) {
                case BOOLEAN: {
                    return this.dc.retrieveBooleanParameterValue(parameterName);
                }
                case DATE: {
                    return this.dc.retrieveDateParameterValue(parameterName);
                }
                case FLOAT: {
                    return this.dc.retrieveFloatParameterValue(parameterName);
                }
                case INTEGER: {
                    return this.dc.retrieveIntegerParameterValue(parameterName);
                }
                case STRING: {
                    return this.dc.retrieveStringParameterValue(parameterName);
                }
                case URI: {
                    return this.dc.retrieveURIParameterValue(parameterName);
                }
                case USERDEFINED: {
                    return this.dc.retrieveUDTParameterValue(parameterName);
                }
            }
            String message = String.format("Parameter '%s' has an unknown data type ('%s').", new Object[]{parameterName, type});
            throw new ApplicationEnvironmentException(message, -401001L);
        }
        catch (InvalidDataTypeException e) {
            String message = String.format("Parameter '%s' has wrong type, expected %s.", new Object[]{parameterName, type});
            throw new ApplicationEnvironmentException(message, -401001L, e);
        }
        catch (NoSuchParameterException e) {
            String message = String.format("Expected parameter '%s' to exist.", parameterName);
            throw new ApplicationEnvironmentException(message, -401000L, e);
        }
    }
}

