/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.runtimeenvironment;

import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SettableDataContext
implements DataContext,
Serializable {
    private static final long serialVersionUID = 2194464382554050559L;
    protected final HashMap<String, Serializable> values;
    protected final HashMap<String, ProcessModelParameter> inputParams;
    protected final HashMap<String, ProcessModelParameter> outputParams;

    public SettableDataContext() {
        this.values = new HashMap();
        this.inputParams = new HashMap();
        this.outputParams = new HashMap();
    }

    public SettableDataContext(Map<String, Serializable> values, Map<String, ProcessModelParameter> inputParams, Map<String, ProcessModelParameter> outputParams) {
        this.values = new HashMap<String, Serializable>(values);
        this.inputParams = new HashMap<String, ProcessModelParameter>(inputParams);
        this.outputParams = new HashMap<String, ProcessModelParameter>(outputParams);
    }

    public void addInputParameter(ProcessModelParameter param, Serializable value) {
        this.checkType(value, param.getDataType());
        this.inputParams.put(param.getName(), param);
        this.values.put(param.getName(), value);
    }

    public void addOutputParameter(ProcessModelParameter param) {
        this.outputParams.put(param.getName(), param);
    }

    public Map<String, Serializable> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    protected void checkType(Object value, ProcessConstants.AdeptDataType expectedType) {
        switch (expectedType) {
            case INTEGER: {
                Long cfr_ignored_0 = (Long)value;
                break;
            }
            case FLOAT: {
                Double cfr_ignored_1 = (Double)value;
                break;
            }
            case BOOLEAN: {
                Boolean cfr_ignored_2 = (Boolean)value;
                break;
            }
            case STRING: {
                String cfr_ignored_3 = (String)value;
                break;
            }
            case DATE: {
                Date cfr_ignored_4 = (Date)value;
                break;
            }
            case URI: {
                URI cfr_ignored_5 = (URI)value;
                break;
            }
            case USERDEFINED: {
                UDTValue cfr_ignored_6 = (UDTValue)value;
                break;
            }
            default: {
                String msg = String.format("Data type %s is not yet supported. This seems to be a programming error.", new Object[]{expectedType});
                throw new AssertionError((Object)msg);
            }
        }
    }

    @Override
    public boolean isNull(String parameterName) throws NoSuchParameterException {
        this.checkInputExistence(parameterName);
        return this.values.get(parameterName) == null;
    }

    @Override
    public long retrieveIntegerParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkInputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.INTEGER);
        return (Long)this.values.get(parameterName);
    }

    @Override
    public double retrieveFloatParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkInputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.FLOAT);
        return (Double)this.values.get(parameterName);
    }

    @Override
    public boolean retrieveBooleanParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkInputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.BOOLEAN);
        return (Boolean)this.values.get(parameterName);
    }

    @Override
    public String retrieveStringParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkInputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.STRING);
        return (String)((Object)this.values.get(parameterName));
    }

    @Override
    public Date retrieveDateParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkInputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.DATE);
        return (Date)this.values.get(parameterName);
    }

    @Override
    public URI retrieveURIParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkInputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.URI);
        return (URI)this.values.get(parameterName);
    }

    @Override
    public UDTValue retrieveUDTParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkInputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.USERDEFINED);
        return (UDTValue)this.values.get(parameterName);
    }

    protected void checkInputExistence(String parameterName) throws NoSuchParameterException {
        if (!this.inputParams.containsKey(parameterName)) {
            String msg = String.format("Input parameter '%s' is unknown.", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    protected void checkInputExistenceAndType(String parameterName, ProcessConstants.AdeptDataType expectedType) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.inputParams.containsKey(parameterName)) {
            String msg = String.format("Input parameter '%s' of type %s is unknown.", new Object[]{parameterName, expectedType});
            throw new NoSuchParameterException(msg, parameterName);
        }
        if (this.inputParams.containsKey(parameterName) && this.inputParams.get(parameterName).getDataType() != expectedType) {
            throw new InvalidDataTypeException(parameterName, expectedType, this.inputParams.get(parameterName).getDataType());
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void ignoreValue(String parameterName) throws NoSuchParameterException {
        this.checkOutputExistence(parameterName);
        this.values.put(parameterName, null);
    }

    @Override
    public boolean ignoredValue(String parameterName) throws NoSuchParameterException {
        this.checkOutputExistence(parameterName);
        return this.values.get(parameterName) == null;
    }

    @Override
    public void storeIntegerParameterValue(String parameterName, long value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.INTEGER);
        this.values.put(parameterName, Long.valueOf(value));
    }

    @Override
    public long storedIntegerParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        long ret = Integer.MIN_VALUE;
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.INTEGER);
        if (this.values.containsKey(parameterName)) {
            ret = (Long)this.values.get(parameterName);
        }
        return ret;
    }

    @Override
    public void storeFloatParameterValue(String parameterName, double value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.FLOAT);
        this.values.put(parameterName, Double.valueOf(value));
    }

    @Override
    public double storedFloatParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        double ret = Double.NaN;
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.FLOAT);
        if (this.values.containsKey(parameterName)) {
            ret = (Double)this.values.get(parameterName);
        }
        return ret;
    }

    @Override
    public void storeBooleanParameterValue(String parameterName, boolean value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.BOOLEAN);
        this.values.put(parameterName, Boolean.valueOf(value));
    }

    @Override
    public boolean storedBooleanParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        boolean ret = false;
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.BOOLEAN);
        if (this.values.containsKey(parameterName)) {
            ret = (Boolean)this.values.get(parameterName);
        }
        return ret;
    }

    @Override
    public void storeStringParameterValue(String parameterName, String value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.STRING);
        this.values.put(parameterName, (Serializable)((Object)value));
    }

    @Override
    public String storedStringParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.STRING);
        return (String)((Object)this.values.get(parameterName));
    }

    @Override
    public void storeDateParameterValue(String parameterName, Date value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.DATE);
        this.values.put(parameterName, value);
    }

    @Override
    public Date storedDateParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.DATE);
        return (Date)this.values.get(parameterName);
    }

    @Override
    public void storeURIParameterValue(String parameterName, URI value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.URI);
        this.values.put(parameterName, value);
    }

    @Override
    public URI storedURIParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.URI);
        return (URI)this.values.get(parameterName);
    }

    @Override
    public void storeUDTParameterValue(String parameterName, UDTValue value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.USERDEFINED);
        this.values.put(parameterName, value);
    }

    @Override
    public UDTValue storedUDTParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkOutputExistenceAndType(parameterName, ProcessConstants.AdeptDataType.USERDEFINED);
        return (UDTValue)this.values.get(parameterName);
    }

    protected void checkOutputExistence(String parameterName) throws NoSuchParameterException {
        if (!this.outputParams.containsKey(parameterName)) {
            String msg = String.format("Output parameter '%s' is unknown.", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    protected void checkOutputExistenceAndType(String parameterName, ProcessConstants.AdeptDataType expectedType) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.outputParams.containsKey(parameterName)) {
            String msg = String.format("Output parameter '%s' of type %s is unknown.", new Object[]{parameterName, expectedType});
            throw new NoSuchParameterException(msg, parameterName);
        }
        if (this.outputParams.containsKey(parameterName) && this.outputParams.get(parameterName).getDataType() != expectedType) {
            throw new InvalidDataTypeException(parameterName, expectedType, this.outputParams.get(parameterName).getDataType());
        }
    }
}

