/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.runtimeenvironment;

import de.aristaflow.adept2.model.runtimeenvironment.ActivityState;

public class TerminatedActivityState
extends ActivityState {
    private final TerminatedState terminatedState;
    private final Long suspendTimeout;
    private final String errorMessage;
    private final String errorState;
    private final Long errorCode;

    public TerminatedActivityState(TerminatedState state) {
        super(ActivityState.State.TERMINATED);
        this.terminatedState = state;
        this.suspendTimeout = null;
        this.errorMessage = null;
        this.errorState = null;
        this.errorCode = null;
    }

    public TerminatedActivityState(long suspendTimeout) {
        super(ActivityState.State.TERMINATED);
        this.terminatedState = TerminatedState.SUSPENDED;
        this.suspendTimeout = suspendTimeout;
        this.errorMessage = null;
        this.errorState = null;
        this.errorCode = null;
    }

    public TerminatedActivityState(int signalledSignal) {
        super(ActivityState.State.TERMINATED, signalledSignal);
        this.terminatedState = TerminatedState.SIGNALLED;
        this.suspendTimeout = null;
        this.errorMessage = null;
        this.errorState = null;
        this.errorCode = null;
    }

    public TerminatedActivityState(String errorMessage, String errorState, long errorCode) {
        super(ActivityState.State.TERMINATED);
        this.terminatedState = TerminatedState.FAILED;
        this.suspendTimeout = null;
        this.errorMessage = errorMessage;
        this.errorState = errorState;
        this.errorCode = errorCode;
    }

    public TerminatedState getTerminatedState() {
        return this.terminatedState;
    }

    public Long getSuspendTimeout() {
        return this.suspendTimeout;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorState() {
        return this.errorState;
    }

    public Long getErrorCode() {
        return this.errorCode;
    }

    public static enum TerminatedState {
        CLOSED,
        SUSPENDED,
        RESET,
        SIGNALLED,
        FAILED;

    }
}

