/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.runtimeenvironment.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.model.runtimeenvironment.InvalidExecutorThreadException;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.Date;
import java.util.logging.Logger;

public class DefaultDataContext
implements DataContext {
    protected final Logger logger;
    private final Thread componentThread;
    private final DataContainer dataContainer;
    private final ClientSessionFactory sessionFactory;

    public DefaultDataContext(ClientSessionFactory sessionFactory, DataContainer dataContainer, Thread componentThread) {
        this.sessionFactory = sessionFactory;
        this.dataContainer = dataContainer;
        this.componentThread = componentThread;
        this.logger = LoggerTools.getLogger(this);
    }

    private void checkValidExecutorThread() throws InvalidExecutorThreadException {
        if (!Thread.currentThread().equals(this.componentThread)) {
            this.logger.severe("Invalid Executor Thread: " + Thread.currentThread().getName());
            throw new InvalidExecutorThreadException();
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.dataContainer.isReadOnly();
    }

    @Override
    public boolean isNull(String parameterName) throws NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        return this.dataContainer.isNull(session, parameterName);
    }

    @Override
    public boolean retrieveBooleanParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        return this.dataContainer.retrieveBoolean(session, parameterName);
    }

    @Override
    public long retrieveIntegerParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        return this.dataContainer.retrieveInteger(session, parameterName);
    }

    @Override
    public double retrieveFloatParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        return this.dataContainer.retrieveFloat(session, parameterName);
    }

    @Override
    public String retrieveStringParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        return this.dataContainer.retrieveString(session, parameterName);
    }

    @Override
    public Date retrieveDateParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        return this.dataContainer.retrieveDate(session, parameterName);
    }

    @Override
    public UDTValue retrieveUDTParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        return this.dataContainer.retrieveUDT(session, parameterName);
    }

    @Override
    public URI retrieveURIParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        return this.dataContainer.retrieveURI(session, parameterName);
    }

    @Override
    public void ignoreValue(String parameterName) throws NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        this.dataContainer.ignoreValue(session, parameterName);
    }

    @Override
    public void storeBooleanParameterValue(String parameterName, boolean value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        this.dataContainer.storeBoolean(session, parameterName, value);
    }

    @Override
    public void storeIntegerParameterValue(String parameterName, long value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        this.dataContainer.storeInteger(session, parameterName, value);
    }

    @Override
    public void storeFloatParameterValue(String parameterName, double value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        this.dataContainer.storeFloat(session, parameterName, value);
    }

    @Override
    public void storeStringParameterValue(String parameterName, String value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        this.dataContainer.storeString(session, parameterName, value);
    }

    @Override
    public void storeDateParameterValue(String parameterName, Date value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        this.dataContainer.storeDate(session, parameterName, value);
    }

    @Override
    public void storeUDTParameterValue(String parameterName, UDTValue value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        this.dataContainer.storeUDT(session, parameterName, value);
    }

    @Override
    public void storeURIParameterValue(String parameterName, URI value) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        SessionToken session = this.sessionFactory.getSessionToken();
        this.dataContainer.storeURI(session, parameterName, value);
    }

    @Override
    public boolean storedBooleanParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        return this.dataContainer.storedBoolean(parameterName);
    }

    @Override
    public double storedFloatParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        return this.dataContainer.storedFloat(parameterName);
    }

    @Override
    public long storedIntegerParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        return this.dataContainer.storedInteger(parameterName);
    }

    @Override
    public String storedStringParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        return this.dataContainer.storedString(parameterName);
    }

    @Override
    public Date storedDateParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        return this.dataContainer.storedDate(parameterName);
    }

    @Override
    public UDTValue storedUDTParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        return this.dataContainer.storedUDT(parameterName);
    }

    @Override
    public URI storedURIParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkValidExecutorThread();
        return this.dataContainer.storedURI(parameterName);
    }

    @Override
    public boolean ignoredValue(String parameterName) throws NoSuchParameterException {
        this.checkValidExecutorThread();
        return this.dataContainer.ignoredValue(parameterName);
    }
}

