/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.runtimeenvironment.defaultimplementation;

import de.aristaflow.adept2.model.runtimeenvironment.InvalidExecutorThreadException;
import de.aristaflow.adept2.model.runtimeenvironment.ProgressMonitor;
import de.aristaflow.adept2.model.runtimeenvironment.TaskState;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;

public class DefaultProgressMonitor
implements ProgressMonitor {
    protected final Logger logger;
    private final Thread componentThread;
    protected int overallWorkUnits;
    protected int currentWorkUnits;
    protected boolean started;
    protected TaskState taskState;

    public DefaultProgressMonitor(Thread componentThread) {
        this.componentThread = componentThread;
        this.taskState = TaskState.BLOCKED;
        this.currentWorkUnits = 0;
        this.logger = LoggerTools.getLogger(this);
    }

    protected void checkValidExecutorThread() throws InvalidExecutorThreadException {
        if (!Thread.currentThread().equals(this.componentThread)) {
            this.logger.severe("Invalid Executor Thread: " + Thread.currentThread().getName());
            throw new InvalidExecutorThreadException();
        }
    }

    @Override
    public void beginTask() {
        this.checkValidExecutorThread();
        if (!this.started) {
            this.overallWorkUnits = Integer.MIN_VALUE;
            this.taskState = TaskState.RUNNING;
            this.started = true;
        }
    }

    @Override
    public void beginTask(int overallWorkUnits) {
        this.checkValidExecutorThread();
        if (!this.started) {
            this.overallWorkUnits = overallWorkUnits;
            this.taskState = TaskState.RUNNING;
            this.started = true;
        }
    }

    @Override
    public void endTask() {
        this.checkValidExecutorThread();
        this.currentWorkUnits = this.overallWorkUnits;
        this.taskState = TaskState.FINISHED;
    }

    @Override
    public void progress() {
        this.checkValidExecutorThread();
        ++this.currentWorkUnits;
    }

    @Override
    public void setTaskState(TaskState taskState) {
        this.checkValidExecutorThread();
        this.taskState = taskState;
    }

    public float getProgress() {
        float ret = this.overallWorkUnits == Integer.MIN_VALUE ? 0.0f : (float)this.currentWorkUnits / (float)this.overallWorkUnits;
        return ret;
    }

    public TaskState getTaskState() {
        return this.taskState;
    }
}

