/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.runtimeenvironment.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultUserAttributeContainer;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.model.runtimeenvironment.GUIContext;
import de.aristaflow.adept2.model.runtimeenvironment.InvalidExecutorThreadException;
import de.aristaflow.adept2.model.runtimeenvironment.ProgressMonitor;
import de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironment;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;

public class DefaultSessionContext
extends DefaultUserAttributeContainer
implements SessionContext {
    private final ClientSessionFactory sessionFactory;
    protected final Logger logger;
    private final String sessionID;
    private final EBPInstanceReference ebpInstanceReference;
    private final DataContext dataContext;
    private final GUIContext guiContext;
    private final RuntimeEnvironment runtimeEnvironment;
    private final ProgressMonitor progressMonitor;
    private final ProcessConstants.ExecutionMode executionMode;
    private final Enquiry currentEnquiry;
    private final Enquiry repliedEnquiry;
    private final Thread componentThread;

    public DefaultSessionContext(ClientSessionFactory sessionFactory, String sessionID, EBPInstanceReference ebpInstanceReference, DataContext dataContext, GUIContext guiContext, RuntimeEnvironment runtimeEnvironment, ProgressMonitor progressMonitor, ProcessConstants.ExecutionMode executionMode, Enquiry currentEnquiry, Enquiry repliedEnquiry, Thread componentThread) {
        this.sessionFactory = sessionFactory;
        this.sessionID = sessionID;
        this.ebpInstanceReference = ebpInstanceReference;
        this.dataContext = dataContext;
        this.guiContext = guiContext;
        this.runtimeEnvironment = runtimeEnvironment;
        this.progressMonitor = progressMonitor;
        this.executionMode = executionMode;
        this.currentEnquiry = currentEnquiry;
        this.repliedEnquiry = repliedEnquiry;
        this.componentThread = componentThread;
        this.logger = LoggerTools.getLogger(this);
    }

    private void checkValidExecutorThread() throws InvalidExecutorThreadException {
        if (!Thread.currentThread().equals(this.componentThread)) {
            this.logger.severe("Invalid Executor Thread: " + Thread.currentThread().getName());
            throw new InvalidExecutorThreadException();
        }
    }

    @Override
    public ClientSessionFactory getClientSessionFactory() {
        this.checkValidExecutorThread();
        return this.sessionFactory;
    }

    @Override
    public String getSessionID() {
        this.checkValidExecutorThread();
        return this.sessionID;
    }

    @Override
    public EBPInstanceReference getEBPInstanceReference() {
        this.checkValidExecutorThread();
        return this.ebpInstanceReference;
    }

    @Override
    public DataContext getDataContext() {
        this.checkValidExecutorThread();
        return this.dataContext;
    }

    @Override
    public GUIContext getGUIContext() {
        this.checkValidExecutorThread();
        return this.guiContext;
    }

    @Override
    public RuntimeEnvironment getRuntimeEnvironment() {
        this.checkValidExecutorThread();
        return this.runtimeEnvironment;
    }

    @Override
    public ProgressMonitor getProgressMonitor() {
        this.checkValidExecutorThread();
        return this.progressMonitor;
    }

    @Override
    public boolean isTestMode() {
        boolean ret;
        this.checkValidExecutorThread();
        switch (this.executionMode) {
            case SUBSTITUTED_TEST: 
            case COMPONENT_TEST: {
                ret = true;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    @Override
    public boolean isViewOnly() {
        boolean ret;
        this.checkValidExecutorThread();
        switch (this.executionMode) {
            case VIEW_ONLY: {
                ret = true;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    @Override
    public Enquiry getCurrentEnquiry() {
        return this.currentEnquiry;
    }

    @Override
    public Enquiry getRepliedEnquiry() {
        return this.repliedEnquiry;
    }
}

