/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.runtimeenvironment.defaultimplementation;

import de.aristaflow.adept2.model.common.defaultimplementation.DefaultUserAttributeContainer;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.SerialisableDataContext;
import de.aristaflow.adept2.model.runtimeenvironment.SimpleSessionContext;
import java.util.Map;

public class DefaultSimpleSessionContext
extends DefaultUserAttributeContainer
implements SimpleSessionContext {
    private static final long serialVersionUID = -935570888705385568L;
    protected final String sessionID;
    protected final boolean resumed;
    protected final int savepointID;
    protected final EBPInstanceReference ebpIR;
    protected final SerialisableDataContext dataContext;
    protected final ActivityInstance activity;
    protected final ProcessConstants.ExecutionMode executionMode;
    protected final Enquiry currentEnquiry;
    protected final Enquiry repliedEnquiry;

    public DefaultSimpleSessionContext(String sessionID, EBPInstanceReference ebpIR, SerialisableDataContext dataContext, ActivityInstance activity, ProcessConstants.ExecutionMode executionMode, Enquiry currentEnquiry, Enquiry repliedEnquiry, Map<String, String> userAttributes) {
        super(userAttributes);
        this.sessionID = sessionID;
        this.resumed = false;
        this.savepointID = Integer.MIN_VALUE;
        this.ebpIR = ebpIR;
        this.dataContext = dataContext;
        this.activity = activity;
        this.executionMode = executionMode;
        this.currentEnquiry = currentEnquiry;
        this.repliedEnquiry = repliedEnquiry;
    }

    public DefaultSimpleSessionContext(String sessionID, int savepointID, EBPInstanceReference ebpIR, SerialisableDataContext dataContext, ActivityInstance activity, ProcessConstants.ExecutionMode executionMode, Enquiry currentEnquiry, Enquiry repliedEnquiry, Map<String, String> userAttributes) {
        super(userAttributes);
        this.sessionID = sessionID;
        this.resumed = true;
        this.savepointID = savepointID;
        this.ebpIR = ebpIR;
        this.dataContext = dataContext;
        this.activity = activity;
        this.executionMode = executionMode;
        this.currentEnquiry = currentEnquiry;
        this.repliedEnquiry = repliedEnquiry;
    }

    @Override
    public String getSessionID() {
        return this.sessionID;
    }

    @Override
    public boolean isResumed() {
        return this.resumed;
    }

    @Override
    public int getSavepointID() {
        return this.savepointID;
    }

    @Override
    public EBPInstanceReference getEBPInstanceReference() {
        return this.ebpIR;
    }

    @Override
    public SerialisableDataContext getDataContext() {
        return this.dataContext;
    }

    @Override
    public ActivityInstance getActivityInstance() {
        return this.activity;
    }

    @Override
    public boolean isTestMode() {
        boolean ret = false;
        if (this.executionMode != null) {
            switch (this.executionMode) {
                case SUBSTITUTED_TEST: 
                case COMPONENT_TEST: {
                    ret = true;
                    break;
                }
                default: {
                    ret = false;
                }
            }
        }
        return ret;
    }

    @Override
    public boolean isViewOnly() {
        return this.executionMode == ProcessConstants.ExecutionMode.VIEW_ONLY;
    }

    @Override
    public Enquiry getCurrentEnquiry() {
        return this.currentEnquiry;
    }

    @Override
    public Enquiry getRepliedEnquiry() {
        return this.repliedEnquiry;
    }
}

