/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.runtimeenvironment.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.defaultimplementation.DefaultParameterDataContext;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.SerialisableDataContext;
import de.aristaflow.adept2.util.HashCalc;
import de.aristaflow.adept2.util.Pair;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MemoryBasedDataContext
extends DefaultParameterDataContext
implements SerialisableDataContext {
    private static final long serialVersionUID = 3921772200812846070L;
    protected final boolean readOnly;
    private final HashMap<String, ProcessConstants.AdeptDataType> outputTypes;
    private final HashMap<String, Serializable> outputValues;

    public MemoryBasedDataContext(boolean readOnly, Map<String, ProcessConstants.AdeptDataType> inputTypes, Map<String, Serializable> inputValues, Map<String, ProcessConstants.AdeptDataType> outputTypes, Map<String, Serializable> outputValues) {
        super(inputTypes, inputValues);
        this.readOnly = readOnly;
        this.outputTypes = outputTypes == null ? new HashMap() : new HashMap<String, ProcessConstants.AdeptDataType>(outputTypes);
        this.outputValues = outputValues == null ? new HashMap() : new HashMap<String, Serializable>(outputValues);
    }

    public MemoryBasedDataContext(SessionToken session, DataContainer container, ExecutableBusinessProcessInstance ebp) throws NoSuchParameterException, InvalidDataTypeException {
        super((Map<String, ProcessConstants.AdeptDataType>)MemoryBasedDataContext.getInputParameters(session, ebp.getParameters(ActivityConstants.AccessType.READ), container).getFirst(), (Map<String, Serializable>)MemoryBasedDataContext.getInputParameters(session, ebp.getParameters(ActivityConstants.AccessType.READ), container).getSecond());
        this.readOnly = container.isReadOnly();
        Pair<HashMap<String, ProcessConstants.AdeptDataType>, HashMap<String, Serializable>> outputParams = MemoryBasedDataContext.getOutputParameters(ebp.getParameters(ActivityConstants.AccessType.WRITE), container);
        this.outputTypes = outputParams.getFirst();
        this.outputValues = outputParams.getSecond();
    }

    @Override
    public Map<String, ProcessConstants.AdeptDataType> getOutputParameters() {
        return Collections.unmodifiableMap(this.outputTypes);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void ignoreValue(String parameterName) throws NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        this.outputValues.remove(parameterName);
    }

    @Override
    public boolean ignoredValue(String parameterName) throws NoSuchParameterException {
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        return this.outputValues.get(parameterName) == null;
    }

    @Override
    public void storeIntegerParameterValue(String parameterName, long value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.INTEGER) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.INTEGER, this.outputTypes.get(parameterName));
        }
        this.outputValues.put(parameterName, Long.valueOf(value));
    }

    @Override
    public void storeFloatParameterValue(String parameterName, double value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.FLOAT) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.FLOAT, this.outputTypes.get(parameterName));
        }
        this.outputValues.put(parameterName, Double.valueOf(value));
    }

    @Override
    public void storeStringParameterValue(String parameterName, String value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.STRING) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.STRING, this.outputTypes.get(parameterName));
        }
        this.outputValues.put(parameterName, (Serializable)((Object)value));
    }

    @Override
    public void storeBooleanParameterValue(String parameterName, boolean value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.BOOLEAN) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.BOOLEAN, this.outputTypes.get(parameterName));
        }
        this.outputValues.put(parameterName, Boolean.valueOf(value));
    }

    @Override
    public void storeDateParameterValue(String parameterName, Date value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.DATE) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.DATE, this.outputTypes.get(parameterName));
        }
        this.outputValues.put(parameterName, value);
    }

    @Override
    public void storeURIParameterValue(String parameterName, URI value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.URI) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.URI, this.outputTypes.get(parameterName));
        }
        this.outputValues.put(parameterName, value);
    }

    @Override
    public void storeUDTParameterValue(String parameterName, UDTValue value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.USERDEFINED) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.USERDEFINED, this.outputTypes.get(parameterName));
        }
        this.outputValues.put(parameterName, value);
    }

    @Override
    public long storedIntegerParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.INTEGER) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.INTEGER, this.outputTypes.get(parameterName));
        }
        return (Long)this.outputValues.get(parameterName);
    }

    @Override
    public double storedFloatParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.FLOAT) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.FLOAT, this.outputTypes.get(parameterName));
        }
        return (Double)this.outputValues.get(parameterName);
    }

    @Override
    public String storedStringParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.STRING) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.STRING, this.outputTypes.get(parameterName));
        }
        return (String)((Object)this.outputValues.get(parameterName));
    }

    @Override
    public boolean storedBooleanParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.BOOLEAN) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.BOOLEAN, this.outputTypes.get(parameterName));
        }
        return (Boolean)this.outputValues.get(parameterName);
    }

    @Override
    public Date storedDateParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.DATE) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.DATE, this.outputTypes.get(parameterName));
        }
        return (Date)this.outputValues.get(parameterName);
    }

    @Override
    public URI storedURIParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.URI) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.URI, this.outputTypes.get(parameterName));
        }
        return (URI)this.outputValues.get(parameterName);
    }

    @Override
    public UDTValue storedUDTParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.outputTypes.containsKey(parameterName)) {
            throw new NoSuchParameterException("Output parameter does not exist.", parameterName);
        }
        if (this.outputTypes.get(parameterName) != ProcessConstants.AdeptDataType.USERDEFINED) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.USERDEFINED, this.outputTypes.get(parameterName));
        }
        return (UDTValue)this.outputValues.get(parameterName);
    }

    protected static Pair<HashMap<String, ProcessConstants.AdeptDataType>, HashMap<String, Serializable>> getInputParameters(SessionToken session, Collection<ProcessModelParameter> params, DataContainer container) throws NoSuchParameterException, InvalidDataTypeException {
        HashMap<String, ProcessConstants.AdeptDataType> types = new HashMap<String, ProcessConstants.AdeptDataType>(params.size());
        HashMap<String, Object> values = new HashMap<String, Object>(params.size());
        Pair<HashMap<String, ProcessConstants.AdeptDataType>, HashMap<String, Serializable>> ret = new Pair<HashMap<String, ProcessConstants.AdeptDataType>, HashMap<String, Serializable>>(types, values);
        block9: for (ProcessModelParameter param : params) {
            String name = param.getName();
            switch (param.getDataType()) {
                case INTEGER: {
                    types.put(name, ProcessConstants.AdeptDataType.INTEGER);
                    if (container.isNull(session, name)) continue block9;
                    Object value = container.retrieveInteger(session, name);
                    values.put(name, value);
                    break;
                }
                case FLOAT: {
                    types.put(name, ProcessConstants.AdeptDataType.FLOAT);
                    if (container.isNull(session, name)) continue block9;
                    Object value = container.retrieveFloat(session, name);
                    values.put(name, value);
                    break;
                }
                case STRING: {
                    types.put(name, ProcessConstants.AdeptDataType.STRING);
                    if (container.isNull(session, name)) continue block9;
                    Object value = container.retrieveString(session, name);
                    values.put(name, value);
                    break;
                }
                case BOOLEAN: {
                    types.put(name, ProcessConstants.AdeptDataType.BOOLEAN);
                    if (container.isNull(session, name)) continue block9;
                    Object value = container.retrieveBoolean(session, name);
                    values.put(name, value);
                    break;
                }
                case DATE: {
                    types.put(name, ProcessConstants.AdeptDataType.DATE);
                    if (container.isNull(session, name)) continue block9;
                    Object value = container.retrieveDate(session, name);
                    values.put(name, value);
                    break;
                }
                case URI: {
                    types.put(name, ProcessConstants.AdeptDataType.URI);
                    if (container.isNull(session, name)) continue block9;
                    Object value = container.retrieveURI(session, name);
                    values.put(name, value);
                    break;
                }
                case USERDEFINED: {
                    types.put(name, ProcessConstants.AdeptDataType.USERDEFINED);
                    if (container.isNull(session, name)) continue block9;
                    Object value = container.retrieveUDT(session, name);
                    values.put(name, value);
                    break;
                }
                default: {
                    throw new InvalidDataTypeException(name, null, param.getDataType());
                }
            }
        }
        return ret;
    }

    protected static Pair<HashMap<String, ProcessConstants.AdeptDataType>, HashMap<String, Serializable>> getOutputParameters(Collection<ProcessModelParameter> params, DataContainer container) throws NoSuchParameterException, InvalidDataTypeException {
        HashMap<String, ProcessConstants.AdeptDataType> types = new HashMap<String, ProcessConstants.AdeptDataType>(params.size());
        HashMap<String, Object> values = new HashMap<String, Object>(params.size());
        Pair<HashMap<String, ProcessConstants.AdeptDataType>, HashMap<String, Serializable>> ret = new Pair<HashMap<String, ProcessConstants.AdeptDataType>, HashMap<String, Serializable>>(types, values);
        block9: for (ProcessModelParameter param : params) {
            String name = param.getName();
            switch (param.getDataType()) {
                case INTEGER: {
                    types.put(name, ProcessConstants.AdeptDataType.INTEGER);
                    if (container.ignoredValue(name)) continue block9;
                    Object value = container.storedInteger(name);
                    values.put(name, value);
                    break;
                }
                case FLOAT: {
                    types.put(name, ProcessConstants.AdeptDataType.FLOAT);
                    if (container.ignoredValue(name)) continue block9;
                    Object value = container.storedFloat(name);
                    values.put(name, value);
                    break;
                }
                case STRING: {
                    types.put(name, ProcessConstants.AdeptDataType.STRING);
                    if (container.ignoredValue(name)) continue block9;
                    Object value = container.storedString(name);
                    values.put(name, value);
                    break;
                }
                case BOOLEAN: {
                    types.put(name, ProcessConstants.AdeptDataType.BOOLEAN);
                    if (container.ignoredValue(name)) continue block9;
                    Object value = container.storedBoolean(name);
                    values.put(name, value);
                    break;
                }
                case DATE: {
                    types.put(name, ProcessConstants.AdeptDataType.DATE);
                    if (container.ignoredValue(name)) continue block9;
                    Object value = container.storedDate(name);
                    values.put(name, value);
                    break;
                }
                case URI: {
                    types.put(name, ProcessConstants.AdeptDataType.URI);
                    if (container.ignoredValue(name)) continue block9;
                    Object value = container.storedURI(name);
                    values.put(name, value);
                    break;
                }
                case USERDEFINED: {
                    types.put(name, ProcessConstants.AdeptDataType.USERDEFINED);
                    if (container.ignoredValue(name)) continue block9;
                    Object value = container.storedUDT(name);
                    values.put(name, value);
                    break;
                }
                default: {
                    throw new InvalidDataTypeException(name, null, param.getDataType());
                }
            }
        }
        return ret;
    }

    @Override
    public boolean equals(Object other) {
        boolean ret = super.equals(other);
        if (ret && other instanceof MemoryBasedDataContext) {
            MemoryBasedDataContext otherDC = (MemoryBasedDataContext)other;
            ret &= this.isReadOnly() == otherDC.isReadOnly();
            ret &= this.outputTypes.equals(otherDC.outputTypes);
            ret &= this.outputValues.equals(otherDC.outputValues);
        }
        return ret;
    }

    @Override
    public int hashCode() {
        HashCalc hash = new HashCalc(MemoryBasedDataContext.class);
        hash.feed(super.hashCode());
        hash.feed(this.readOnly);
        hash.feed(this.outputTypes);
        hash.feed(this.outputValues);
        return hash.hashCode();
    }
}

