/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel;

import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import java.net.URI;
import java.util.Map;
import java.util.UUID;

public class ADEPT2ActivityReference
extends ADEPT2EBPReference {
    private static final long serialVersionUID = -1869204438062587718L;
    private final boolean supportsViewOnly;
    private final String executableComponentName;
    private final String guiContextID;

    public ADEPT2ActivityReference(UUID instanceID, UUID baseTemplateID, int nodeID, int iteration, String executableComponentName, String guiContextID, boolean supportsViewOnly, URI[] executionManagerURIs, URI[] runtimeManagerURIs, ExecutionControlProperties executionControlProperties, Map<String, String> userAttributes) {
        super(ADEPT2ActivityReference.getEBPTypeForECName(executableComponentName), instanceID, baseTemplateID, nodeID, iteration, executionManagerURIs, runtimeManagerURIs, executionControlProperties, "de.aristaflow.ADEPT2ActivityReference", userAttributes);
        this.executableComponentName = executableComponentName;
        this.guiContextID = guiContextID;
        this.supportsViewOnly = supportsViewOnly;
    }

    private static EBPType getEBPTypeForECName(String executableComponentName) {
        return "de.aristaflow.rules.XOR".equals(executableComponentName) ? EBPType.DECISION_ACTIVITY : EBPType.ACTIVITY;
    }

    public ADEPT2ActivityReference(UUID instanceID, UUID baseTemplateID, int nodeID, int iteration, String executableComponentName, String guiContextID, URI[] executionManagerURIs, ExecutionControlProperties executionControlProperties, Map<String, String> userAttributes, boolean supportsViewOnly) {
        super(EBPType.ACTIVITY, instanceID, baseTemplateID, nodeID, iteration, executionManagerURIs, executionControlProperties, "de.aristaflow.ADEPT2ActivityReference", userAttributes);
        this.executableComponentName = executableComponentName;
        this.guiContextID = guiContextID;
        this.supportsViewOnly = supportsViewOnly;
    }

    public ADEPT2ActivityReference(EBPInstanceReference ebpInstanceReference, ActivityInstance activityInstance, Map<String, String> userAttributes) {
        super(ebpInstanceReference, activityInstance, "de.aristaflow.ADEPT2ActivityReference", userAttributes);
        this.executableComponentName = activityInstance.getExecutableComponentName();
        this.guiContextID = activityInstance.getGUIContextID();
        this.supportsViewOnly = activityInstance.supportsViewOnly();
    }

    @Override
    public boolean isActivity() {
        return true;
    }

    @Override
    public String getExecutableComponentName() {
        return this.executableComponentName;
    }

    @Override
    public String getGUIContextID() {
        return this.guiContextID;
    }

    public boolean supportsViewOnly() {
        return this.supportsViewOnly;
    }
}

