/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel;

import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultUserAttributeContainer;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;

public abstract class ADEPT2EBPReference
extends DefaultUserAttributeContainer
implements EBPInstanceReference,
ActivityReference {
    private final UUID instanceID;
    private final UUID baseTemplateID;
    private final int nodeID;
    private final int iteration;
    private final EBPType type;
    private final URI[] executionManagerURIs;
    private final ExecutionControlProperties executionControlProperties;
    private URI[] runtimeManagerURIs = null;
    private final String activityReferenceType;

    public ADEPT2EBPReference(EBPType type, UUID instanceID, UUID baseTemplateID, int nodeID, int iteration, URI[] executionManagerURIs, URI[] runtimeManagerURIs, ExecutionControlProperties executionControlProperties, String activityReferenceType, Map<String, String> userAttributes) {
        super(userAttributes);
        this.activityReferenceType = activityReferenceType;
        this.instanceID = instanceID;
        this.baseTemplateID = baseTemplateID;
        this.nodeID = nodeID;
        this.iteration = iteration;
        this.type = type;
        this.executionManagerURIs = executionManagerURIs != null ? (URI[])executionManagerURIs.clone() : null;
        if (runtimeManagerURIs != null) {
            this.runtimeManagerURIs = (URI[])runtimeManagerURIs.clone();
        }
        this.executionControlProperties = executionControlProperties;
    }

    public ADEPT2EBPReference(EBPType type, UUID instanceID, UUID baseTemplateID, int nodeID, int iteration, URI[] executionManagerURIs, ExecutionControlProperties executionControlProperties, String activityReferenceType, Map<String, String> userAttributes) {
        this(type, instanceID, baseTemplateID, nodeID, iteration, executionManagerURIs, null, executionControlProperties, activityReferenceType, userAttributes);
    }

    public ADEPT2EBPReference(EBPInstanceReference ebpIR, ExecutableBusinessProcessInstance ebpInstance, String activityReferenceType, Map<String, String> userAttributes) {
        this(ebpIR.getType(), ebpIR.getInstanceID(), ebpIR.getBaseTemplateID(), ebpIR.getNodeID(), ebpIR.getNodeIteration(), ebpIR.getExecutionManagerURIs(), ebpIR.getRuntimeManagerURIs(), ebpInstance.getExecutionControlProperties(), activityReferenceType, userAttributes);
    }

    @Override
    public String getActivityReferenceType() {
        return this.activityReferenceType;
    }

    @Override
    public int getNodeIteration() {
        return this.iteration;
    }

    @Override
    public int getNodeID() {
        return this.nodeID;
    }

    @Override
    public UUID getInstanceID() {
        return this.instanceID;
    }

    @Override
    public UUID getBaseTemplateID() {
        return this.baseTemplateID;
    }

    @Override
    public EBPType getType() {
        return this.type;
    }

    @Override
    public URI[] getExecutionManagerURIs() {
        URI[] ret = null;
        if (this.executionManagerURIs != null) {
            ret = (URI[])this.executionManagerURIs.clone();
        }
        return ret;
    }

    @Override
    public URI[] getRuntimeManagerURIs() {
        URI[] ret = null;
        if (this.runtimeManagerURIs != null) {
            ret = (URI[])this.runtimeManagerURIs.clone();
        }
        return ret;
    }

    @Override
    public void setRuntimeManagerURIs(URI[] runtimeManagerURI) {
        if (runtimeManagerURI != null) {
            this.runtimeManagerURIs = (URI[])runtimeManagerURI.clone();
        }
    }

    public ExecutionControlProperties getExecutionControlProperties() {
        return this.executionControlProperties;
    }

    @Override
    public abstract boolean isActivity();

    public abstract String getExecutableComponentName();

    public abstract String getGUIContextID();

    @Override
    public boolean equals(Object otherObject) {
        boolean ret = false;
        if (otherObject instanceof EBPInstanceReference) {
            EBPInstanceReference otherEBP = (EBPInstanceReference)otherObject;
            ret = this.instanceID.equals(otherEBP.getInstanceID()) && this.baseTemplateID.equals(otherEBP.getBaseTemplateID()) && this.nodeID == otherEBP.getNodeID() && this.iteration == otherEBP.getNodeIteration() && this.isActivity() == otherEBP.isActivity() && this.type == otherEBP.getType() && Arrays.equals(this.executionManagerURIs, otherEBP.getExecutionManagerURIs());
        }
        return ret;
    }

    @Override
    public int hashCode() {
        int ret = this.instanceID.hashCode() ^ this.baseTemplateID.hashCode() ^ this.nodeID ^ this.iteration ^ Boolean.valueOf(this.isActivity()).hashCode() ^ this.type.hashCode() ^ Arrays.hashCode(this.executionManagerURIs);
        return ret;
    }

    public String toString() {
        return String.format("%1$s, instanceID: %2$s, nodeID: %3$s, iteration: %4$s, ExecutionManager: %5$s", this.getClass().getSimpleName(), this.getInstanceID(), this.getNodeID(), this.getNodeIteration(), Arrays.toString(this.getExecutionManagerURIs()));
    }
}

