/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel;

import de.aristaflow.adept2.model.common.defaultimplementation.DefaultUserAttributeContainer;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import de.aristaflow.adept2.util.ArgChecks;
import java.net.URI;
import java.util.Map;
import java.util.UUID;

public class TLPInstanceReference
extends DefaultUserAttributeContainer
implements ActivityReference {
    private static final long serialVersionUID = 5962100832809848202L;
    private final UUID instanceID;
    private final URI[] executionManagerURIs;
    private UUID baseTemplateID;

    @Deprecated
    public TLPInstanceReference(UUID instanceID, URI[] executionManagerURIs, UUID baseTemplateID) {
        ArgChecks.checkForNull(instanceID, "instanceID");
        ArgChecks.checkForNulls(executionManagerURIs, "executionManagerURIs");
        this.instanceID = instanceID;
        this.executionManagerURIs = executionManagerURIs != null ? (URI[])executionManagerURIs.clone() : new URI[0];
        this.baseTemplateID = baseTemplateID;
    }

    public TLPInstanceReference(UUID instanceID, URI[] executionManagerURIs, UUID baseTemplateID, Map<String, String> userAttributes) {
        super(userAttributes);
        ArgChecks.checkForNull(instanceID, "instanceID");
        ArgChecks.checkForNulls(executionManagerURIs, "executionManagerURIs");
        this.instanceID = instanceID;
        this.executionManagerURIs = executionManagerURIs != null ? (URI[])executionManagerURIs.clone() : new URI[0];
        this.baseTemplateID = baseTemplateID;
    }

    @Override
    public String getActivityReferenceType() {
        return "de.aristaflow.TLPInstanceReference";
    }

    public UUID getInstanceID() {
        return this.instanceID;
    }

    public URI[] getExecutionManagerURIs() {
        URI[] ret = null;
        if (this.executionManagerURIs != null) {
            ret = (URI[])this.executionManagerURIs.clone();
        }
        return ret;
    }

    public UUID getBaseTemplateID() {
        return this.baseTemplateID;
    }
}

