/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.AdministrativeWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.defaultimplementation.DefaultWorklistItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DefaultAdministrativeWorklistItem
extends DefaultWorklistItem
implements AdministrativeWorklistItem {
    private static final long serialVersionUID = 8439285406356491472L;
    private final ParameterDataContext parameterDataContext;
    private final String delegationHandlingProcedureID;
    private final String distributionHandlingProcedureID;
    private final String escalationHandlingProcedureID;
    private final String staffAssignmentRule;
    private final UUID[] worklistIDs;
    private final ArrayList<WorklistItem.Delegation> delegationHistory;
    private final ArrayList<Enquiry> enquiries;

    public DefaultAdministrativeWorklistItem(UUID worklistItemID, UUID[] worklistIDs, String title, String description, ActivityReference activityReference, UUID iconID, int priority, long dueDate, long escalationDate, WorklistConstants.WorklistItemState state, QualifiedAgent assignedAgent, int escalationLevel, String escalationHandlingProcedureID, String distributionHandlingProcedureID, String staffAssignmentRule, long activationDate, long assignmentDate, long complexity, int delegationLevel, List<WorklistItem.Delegation> delegationHistory, String delegationHandlingProcedureID, Enquiry repliedEnquiry, List<Enquiry> enquiries, String processTemplateName, String processInstanceName, ParameterDataContext parameterDataContext, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginDatas, Map<String, String> userAttributes) {
        super(worklistItemID, title, description, activityReference, iconID, priority, dueDate, escalationDate, state, assignedAgent, escalationLevel, activationDate, assignmentDate, complexity, delegationLevel, repliedEnquiry, processTemplateName, processInstanceName, supportedPlugins, pluginDatas, userAttributes);
        this.worklistIDs = worklistIDs != null ? (UUID[])worklistIDs.clone() : new UUID[0];
        this.parameterDataContext = parameterDataContext;
        this.delegationHandlingProcedureID = delegationHandlingProcedureID;
        this.distributionHandlingProcedureID = distributionHandlingProcedureID;
        this.escalationHandlingProcedureID = escalationHandlingProcedureID;
        this.staffAssignmentRule = staffAssignmentRule;
        this.delegationHistory = new ArrayList<WorklistItem.Delegation>(delegationHistory);
        this.enquiries = new ArrayList<Enquiry>(enquiries);
    }

    @Override
    public ParameterDataContext getAttachedDataContext() {
        return this.parameterDataContext;
    }

    @Override
    public String getDelegationHandlingProcedureID() {
        return this.delegationHandlingProcedureID;
    }

    @Override
    public List<WorklistItem.Delegation> getDelegationHistory() {
        return this.delegationHistory;
    }

    @Override
    public String getDistributionHandlingProcedureID() {
        return this.distributionHandlingProcedureID;
    }

    @Override
    public String getEscalationHandlingProcedureID() {
        return this.escalationHandlingProcedureID;
    }

    @Override
    public String getStaffAssignmentRule() {
        return this.staffAssignmentRule;
    }

    @Override
    public UUID[] getWorklistIDs() {
        UUID[] ret = new UUID[]{};
        if (this.worklistIDs != null) {
            ret = (UUID[])this.worklistIDs.clone();
        }
        return ret;
    }

    @Override
    public WorklistItem.Delegation getCurrentDelegation() {
        if (this.delegationHistory.size() == 0) {
            return null;
        }
        return this.delegationHistory.get(this.delegationHistory.size() - 1);
    }

    @Override
    public Enquiry getCurrentEnquiry() {
        if (this.enquiries.size() == 0) {
            return null;
        }
        return this.enquiries.get(this.enquiries.size() - 1);
    }
}

