/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklist;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistListener;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdate;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.model.worklistmodel.defaultimplementation.DefaultWorklist;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;

public class DefaultClientWorklist
extends DefaultWorklist<ClientWorklistItem>
implements ClientWorklist,
Runnable {
    private static final long serialVersionUID = -4760001519333361683L;
    private static final String VM_ERROR_OUTPUT = "VirtualMachineError in ClientWorklistUpdateNotifier.";
    private WorklistUpdateConfiguration worklistConfiguration;
    private transient Set<ClientWorklistListener> listeners;
    private transient Thread notifyThread;
    private transient BlockingQueue<WorklistUpdate> updateQueue;

    public DefaultClientWorklist(UUID worklistID, QualifiedAgent agent, WorklistUpdateConfiguration worklistConfiguration, long revision, Map<String, String> userAttributes) {
        super(worklistID, agent, new ArrayList(), revision, userAttributes);
        this.worklistConfiguration = worklistConfiguration;
        this.listeners = new HashSet<ClientWorklistListener>();
        this.updateQueue = new LinkedBlockingQueue<WorklistUpdate>();
    }

    private void startNotifyThread() {
        this.notifyThread = new Thread(null, this, "Client-WorklistUpdateNotifier", 128L);
        this.notifyThread.setPriority(4);
        this.notifyThread.setDaemon(true);
        this.notifyThread.start();
    }

    private void terminateNotifyThread() {
        this.notifyThread.interrupt();
        this.notifyThread = null;
    }

    @Override
    public void updateWorklist(WorklistUpdate update) {
        if (update == null) {
            return;
        }
        if (!this.getID().equals(update.getWorklistID())) {
            throw new IllegalArgumentException(String.format("Worklist ID of the WorklistUpdate doesn't match the Worklist's ID. Expected '%1$s' but was '%2$s'.", this.getID(), update.getWorklistID()));
        }
        this.updateLock.writeLock().lock();
        String msg = "Received worklist update for client worklist '%s' from revision %s to revision %s, current revision %s";
        this.logger.fine(String.format(msg, this.worklistID, update.getSourceRevision(), update.getTargetRevision(), this.revision));
        msg = "Received worklist update for client worklist '%s': %s.";
        this.logger.finer(String.format(msg, this.worklistID, update));
        try {
            if (this.getRevision() != update.getSourceRevision() && update.getSourceRevision() != 0L) {
                if (this.getRevision() >= update.getTargetRevision()) {
                    this.logger.info("WorklistUpdate skipped because it's Target Revision is older than the Client Worklists current Revision");
                    return;
                }
                throw new IllegalStateException("Worklist Update has different Source Revision the Worklist");
            }
            if (update.getSourceRevision() == 0L) {
                for (ClientWorklistItem item : update.getItemUpdates().keySet()) {
                    int index = this.worklistItems.indexOf(item);
                    if (index >= 0) {
                        this.worklistItems.set(index, item);
                        msg = "Updated item '%s' in client worklist '%s'.";
                        this.logger.finest(String.format(msg, item, this.worklistID));
                        continue;
                    }
                    this.worklistItems.add(item);
                    msg = "Added item '%s' to client worklist '%s'.";
                    this.logger.finest(String.format(msg, item, this.worklistID));
                }
                this.worklistItems.retainAll(update.getItemUpdates().keySet());
                msg = "Removing all items except '%s' from client worklist '%s'.";
                this.logger.finest(String.format(msg, update.getItemUpdates().keySet(), this.worklistID));
            } else {
                for (Map.Entry<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType> updateEntry : update.getItemUpdates().entrySet()) {
                    ClientWorklistItem item = updateEntry.getKey();
                    switch (updateEntry.getValue()) {
                        case ADDED: {
                            this.worklistItems.add(item);
                            msg = "Added item '%s' (state %s) to client worklist '%s'.";
                            this.logger.finest(String.format(msg, new Object[]{item, updateEntry.getValue(), this.worklistID}));
                            break;
                        }
                        case CHANGED: {
                            int index = this.worklistItems.indexOf(item);
                            if (index >= 0) {
                                this.worklistItems.set(index, item);
                                msg = "Updated item '%s' (state %s) in client worklist '%s'.";
                                this.logger.finest(String.format(msg, new Object[]{item, updateEntry.getValue(), this.worklistID}));
                                break;
                            }
                            this.worklistItems.add(item);
                            msg = "Added item '%s' (state %s) to client worklist '%s'.";
                            this.logger.finest(String.format(msg, new Object[]{item, updateEntry.getValue(), this.worklistID}));
                            break;
                        }
                        case REMOVED: {
                            this.worklistItems.remove(item);
                            msg = "Removed item '%s' (state %s) from client worklist '%s'.";
                            this.logger.finest(String.format(msg, new Object[]{item, updateEntry.getValue(), this.worklistID}));
                            break;
                        }
                        default: {
                            msg = String.format("Unsupported worklist item update type '%s'!", new Object[]{updateEntry.getValue()});
                            this.logger.warning(msg);
                        }
                    }
                }
            }
            this.revision = update.getTargetRevision();
            this.updateQueue.offer(update);
        }
        finally {
            this.updateLock.writeLock().unlock();
        }
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                WorklistUpdate update = this.updateQueue.take();
                ClientWorklistListener[] clientWorklistListenerArray = this.getWorklistListeners();
                int n = clientWorklistListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClientWorklistListener listener = clientWorklistListenerArray[n2];
                    try {
                        listener.worklistUpdated(this, update);
                    }
                    catch (RuntimeException re) {
                        this.logger.log(Level.WARNING, "An unexpected exception occured while notifying a registered client worklist listener about a worklist update. Continuing notification.", re);
                    }
                    catch (VirtualMachineError vme) {
                        LoggerTools.logVirtualMachineErrorSafely(vme, VM_ERROR_OUTPUT);
                    }
                    ++n2;
                }
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public WorklistUpdateConfiguration getWorklistUpdateConfiguration() {
        return this.worklistConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWorklistListener(ClientWorklistListener listener) {
        Set<ClientWorklistListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
            if (this.listeners.size() == 1) {
                this.startNotifyThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientWorklistListener[] getWorklistListeners() {
        Set<ClientWorklistListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.toArray(new ClientWorklistListener[this.listeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWorklistListener(ClientWorklistListener listener) {
        Set<ClientWorklistListener> set = this.listeners;
        synchronized (set) {
            boolean removed = this.listeners.remove(listener);
            if (removed && this.listeners.size() <= 0) {
                this.terminateNotifyThread();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.updateLock.readLock().lock();
        try {
            out.defaultWriteObject();
            out.writeObject(this.agent);
            out.writeObject(this.worklistID);
            out.writeObject(this.worklistItems);
            out.writeLong(this.revision);
            out.writeObject(this.userAttributes);
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.logger = LoggerTools.getLogger(this);
        this.listeners = Collections.synchronizedSet(new HashSet());
        this.updateQueue = new LinkedBlockingQueue<WorklistUpdate>();
        this.updateLock = new ReentrantReadWriteLock();
        this.agent = (QualifiedAgent)in.readObject();
        this.worklistID = (UUID)in.readObject();
        this.worklistItems = (List)in.readObject();
        this.revision = in.readLong();
        this.userAttributes = (HashMap)in.readObject();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

