/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.defaultimplementation.DefaultWorklistItem;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DefaultClientWorklistItem
extends DefaultWorklistItem
implements ClientWorklistItem {
    private static final long serialVersionUID = -4738882143149961214L;
    private final UUID worklistID;
    protected volatile int personalPriority;
    private volatile long personalEscalationDate;
    protected volatile long personalDueDate;
    private volatile String escalationHandlingProcedureID;
    private long resubmissionDate;
    private final WorklistItem.Delegation currentDelegation;
    private final Enquiry currentEnquiry;
    protected final HashMap<String, Set<String>> globalSupportedPlugins;
    protected final HashMap<String, PluginData> globalPluginData;
    protected final HashMap<String, String> globalAttributes;
    protected String personalTitle;

    public DefaultClientWorklistItem(UUID worklistItemID, UUID worklistID, String title, String description, ActivityReference activityReference, UUID iconID, int priority, long dueDate, long escalationDate, WorklistConstants.WorklistItemState state, QualifiedAgent assignedAgent, int escalationLevel, String personalTitle, int personalPriority, long personalEscalationDate, long personalDueDate, String escalationHandlingProcedureID, long activationDate, long assignmentDate, long resubmissionDate, long complexity, int delegationLevel, WorklistItem.Delegation currentDelegation, Enquiry repliedEnquiry, Enquiry currentEnquiry, String processTemplateName, String processInstanceName, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginDatas, Map<String, String> userAttributes, Map<String, Set<String>> individualSupportedPlugins, Map<String, PluginData> individualPluginDatas, Map<String, String> individualUserAttributes) {
        super(worklistItemID, title, description, activityReference, iconID, priority, dueDate, escalationDate, state, assignedAgent, escalationLevel, activationDate, assignmentDate, complexity, delegationLevel, repliedEnquiry, processTemplateName, processInstanceName, individualSupportedPlugins, individualPluginDatas, individualUserAttributes);
        this.worklistID = worklistID;
        this.personalPriority = personalPriority;
        this.personalEscalationDate = personalEscalationDate;
        this.personalDueDate = personalDueDate;
        this.personalTitle = personalTitle;
        this.escalationHandlingProcedureID = escalationHandlingProcedureID;
        this.resubmissionDate = resubmissionDate;
        this.currentDelegation = currentDelegation;
        this.currentEnquiry = currentEnquiry;
        this.globalAttributes = new HashMap<String, String>(userAttributes);
        this.globalPluginData = new HashMap<String, PluginData>(pluginDatas);
        this.globalSupportedPlugins = new HashMap<String, Set<String>>(supportedPlugins);
    }

    @Override
    public synchronized void setIndividualTitle(String title) {
        this.personalTitle = title;
    }

    @Override
    public synchronized void setDescription(String description) {
        ArgChecks.checkForNull(description, "description");
        this.description = description;
    }

    @Override
    public synchronized int getIndividualPriority() {
        return this.personalPriority;
    }

    @Override
    public synchronized long getIndividualDueDate() {
        return this.personalDueDate;
    }

    @Override
    public synchronized String getIndividualEscalationHandlingProcedureID() {
        return this.escalationHandlingProcedureID;
    }

    @Override
    public UUID getWorklistID() {
        return this.worklistID;
    }

    @Override
    public void setIndividualDueDate(long individualDueDate) {
        this.personalDueDate = individualDueDate;
    }

    @Override
    public synchronized void setIndividualPriority(int individualPriority) {
        this.personalPriority = individualPriority;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClientWorklistItem) {
            ClientWorklistItem other = (ClientWorklistItem)obj;
            return other.getID().equals(this.getID()) && other.getWorklistID().equals(this.getWorklistID());
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.getID().hashCode() ^ this.getWorklistID().hashCode();
    }

    @Override
    public synchronized long getResubmissionDate() {
        return this.resubmissionDate;
    }

    @Override
    public synchronized void setResubmissionDate(long resubmissionDate) {
        this.resubmissionDate = resubmissionDate;
    }

    @Override
    public WorklistItem.Delegation getCurrentDelegation() {
        return this.currentDelegation;
    }

    @Override
    public Enquiry getCurrentEnquiry() {
        return this.currentEnquiry;
    }

    @Override
    public long getIndividualEscalationDate() {
        return this.personalEscalationDate;
    }

    @Override
    public synchronized void setIndividualEscalation(long timestamp, String escalationHandlingProcedureID) {
        this.personalEscalationDate = timestamp;
        this.escalationHandlingProcedureID = escalationHandlingProcedureID;
    }

    @Override
    public PluginData getPluginData(String pluginID) {
        if (super.getPluginDatas().containsKey(pluginID)) {
            return super.getPluginData(pluginID);
        }
        return this.globalPluginData.get(pluginID);
    }

    @Override
    public Map<String, PluginData> getPluginDatas() {
        HashMap<String, PluginData> res = new HashMap<String, PluginData>(this.globalPluginData);
        res.putAll(super.getPluginDatas());
        return Collections.unmodifiableMap(res);
    }

    @Override
    public Map<String, Set<String>> getSupportedPlugins() {
        HashMap<String, Set<String>> res = new HashMap<String, Set<String>>(this.globalSupportedPlugins);
        res.putAll(super.getSupportedPlugins());
        return res;
    }

    @Override
    public Map<String, String> getUserAttributes() {
        HashMap<String, String> res = new HashMap<String, String>(this.globalAttributes);
        res.putAll(super.getUserAttributes());
        return res;
    }

    @Override
    public String getUserAttributeValue(String attributeName) {
        if (super.getUserAttributes().containsKey(attributeName)) {
            return super.getUserAttributeValue(attributeName);
        }
        return this.globalAttributes.get(attributeName);
    }

    @Override
    public Map<String, PluginData> getIndividualPluginDatas() {
        return super.getPluginDatas();
    }

    @Override
    public Map<String, Set<String>> getIndividualSupportedPlugins() {
        return super.getSupportedPlugins();
    }

    @Override
    public Map<String, String> getIndividualUserAttributes() {
        return super.getUserAttributes();
    }

    @Override
    public void setIndividualPluginData(PluginData pluginData) {
        this.pluginData.put(pluginData.getPluginID(), pluginData);
    }

    @Override
    public String getIndividualTitle() {
        return this.personalTitle;
    }
}

