/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel.defaultimplementation;

import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginDataContainer;
import de.aristaflow.adept2.model.worklistmodel.IndividualWorklistItemSettings;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class DefaultIndividualWorklistItemSettings
extends DefaultPluginDataContainer
implements IndividualWorklistItemSettings {
    private final UUID worklistID;
    private String description;
    private long individualDueDate;
    private long individualEscalationDate;
    private String individualDueDateEscalationID;
    private int individualPriority;
    private String individualTitle;
    private long resubmissionDate;

    public DefaultIndividualWorklistItemSettings(UUID worklistID, String title, String description) {
        ArgChecks.checkForNull(description, "description");
        this.worklistID = worklistID;
        this.individualTitle = title;
        this.description = description;
        this.individualDueDate = 0L;
        this.individualEscalationDate = 0L;
        this.individualDueDateEscalationID = null;
        this.individualPriority = 0;
        this.resubmissionDate = 0L;
    }

    public DefaultIndividualWorklistItemSettings(IndividualWorklistItemSettings item) {
        this(item.getWorklistID(), item.getIndividualTitle(), item.getDescription(), item.getIndividualEscalationDate(), item.getIndividualDueDate(), item.getIndividualEscalationHandlingProcedureID(), item.getIndividualPriority(), item.getResubmissionDate(), item.getSupportedPlugins(), item.getPluginDatas(), item.getUserAttributes());
    }

    public DefaultIndividualWorklistItemSettings(UUID worklistID, String title, String description, long individualEscalationDate, long individualDueDate, String individualDueDateEscalationID, int individualPriority, long resubmissionDate, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginDatas, Map<String, String> userAttributes) {
        super(supportedPlugins, pluginDatas, userAttributes);
        this.worklistID = worklistID;
        this.individualTitle = title;
        this.description = description;
        this.individualDueDate = individualDueDate;
        this.individualEscalationDate = individualEscalationDate;
        this.individualDueDateEscalationID = individualDueDateEscalationID;
        this.individualPriority = individualPriority;
        this.resubmissionDate = resubmissionDate;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public long getIndividualDueDate() {
        return this.individualDueDate;
    }

    @Override
    public String getIndividualEscalationHandlingProcedureID() {
        return this.individualDueDateEscalationID;
    }

    @Override
    public int getIndividualPriority() {
        return this.individualPriority;
    }

    @Override
    public String getIndividualTitle() {
        return this.individualTitle;
    }

    @Override
    public UUID getWorklistID() {
        return this.worklistID;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setIndividualDueDate(long individualDueDate) {
        this.individualDueDate = individualDueDate;
    }

    @Override
    public void setIndividualPriority(int individualPriority) {
        this.individualPriority = individualPriority;
    }

    @Override
    public void setIndividualTitle(String title) {
        this.individualTitle = title;
    }

    @Override
    public long getResubmissionDate() {
        return this.resubmissionDate;
    }

    @Override
    public void setResubmissionDate(long resubmissionDate) {
        this.resubmissionDate = resubmissionDate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IndividualWorklistItemSettings) {
            IndividualWorklistItemSettings other = (IndividualWorklistItemSettings)obj;
            if (!this.getWorklistID().equals(other.getWorklistID())) {
                return false;
            }
            if (this.getIndividualTitle() != null ? !this.getIndividualTitle().equals(other.getIndividualTitle()) : other.getIndividualTitle() != null) {
                return false;
            }
            if (this.getDescription() != null ? !this.getDescription().equals(other.getDescription()) : other.getDescription() != null) {
                return false;
            }
            if (this.getIndividualEscalationDate() != other.getIndividualEscalationDate()) {
                return false;
            }
            if (this.getIndividualDueDate() != other.getIndividualDueDate()) {
                return false;
            }
            if (this.getIndividualEscalationHandlingProcedureID() != null ? !this.getIndividualEscalationHandlingProcedureID().equals(other.getIndividualEscalationHandlingProcedureID()) : other.getIndividualEscalationHandlingProcedureID() != null) {
                return false;
            }
            if (this.getIndividualPriority() != other.getIndividualPriority()) {
                return false;
            }
            return this.getResubmissionDate() == other.getResubmissionDate();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.worklistID.hashCode();
    }

    @Override
    public long getIndividualEscalationDate() {
        return this.individualEscalationDate;
    }

    @Override
    public void setIndividualEscalation(long timestamp, String escalationHandlingProcedureID) {
        this.individualEscalationDate = timestamp;
        this.individualDueDateEscalationID = escalationHandlingProcedureID;
    }

    @Override
    public Map<String, PluginData> getIndividualPluginDatas() {
        return super.getPluginDatas();
    }

    @Override
    public Map<String, Set<String>> getIndividualSupportedPlugins() {
        return super.getSupportedPlugins();
    }

    @Override
    public Map<String, String> getIndividualUserAttributes() {
        return super.getUserAttributes();
    }

    @Override
    public void setIndividualPluginData(PluginData pluginData) {
        this.pluginData.put(pluginData.getPluginID(), pluginData);
    }
}

