/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklist;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.IndividualWorklistItemSettings;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdate;
import de.aristaflow.adept2.model.worklistmodel.defaultimplementation.DefaultWorklist;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public class DefaultInternalWorklist
extends DefaultWorklist<InternalWorklistItem>
implements InternalWorklist<InternalWorklistItem> {
    private static final int MAX_UPDATE_HISTORY_SIZE = 500;
    private final Map<ClientWorklist, Long> clientWorklists;
    private long absentFrom;
    private long absentTo;
    private String substitutionRule;
    private AtomicLong nextClientWorklistID = new AtomicLong(Long.MIN_VALUE);
    private final List<UpdateEntry> updates;
    private final WorklistModelFactory worklistModelFactory;
    private final long initialisationDate;

    public DefaultInternalWorklist(WorklistModelFactory worklistModelFactory, UUID worklistID, QualifiedAgent agent, long revision, List<InternalWorklistItem> worklistItems, String substitutionRule, long absenceFrom, long absenceTo, Map<String, String> userAttributes) {
        super(worklistID, agent, worklistItems, revision, userAttributes);
        ArgChecks.checkForNull(substitutionRule, "substitutionRule");
        this.worklistModelFactory = worklistModelFactory;
        this.clientWorklists = Collections.synchronizedMap(new HashMap());
        this.initialisationDate = System.currentTimeMillis();
        this.substitutionRule = substitutionRule;
        this.absentFrom = absenceFrom;
        this.absentTo = absenceTo;
        this.updates = new ArrayList<UpdateEntry>();
    }

    public DefaultInternalWorklist(WorklistModelFactory worklistModelFactory, UUID worklistID, QualifiedAgent agent, long revision, List<InternalWorklistItem> worklistItems, String substitutionRule, long absenceFrom, long absenceTo, Map<String, String> userAttributes, Map<ClientWorklist, Long> clientWorklists) {
        super(worklistID, agent, worklistItems, revision, userAttributes);
        ArgChecks.checkForNull(substitutionRule, "substitutionRule");
        this.worklistModelFactory = worklistModelFactory;
        this.clientWorklists = Collections.synchronizedMap(new HashMap<ClientWorklist, Long>(clientWorklists));
        this.initialisationDate = System.currentTimeMillis();
        this.substitutionRule = substitutionRule;
        this.absentFrom = absenceFrom;
        this.absentTo = absenceTo;
        this.updates = new ArrayList<UpdateEntry>();
    }

    @Override
    public void addWorklistItem(InternalWorklistItem item) {
        this.updateLock.writeLock().lock();
        try {
            this.logger.info("Adding Worklist Item (" + item.getID() + ") to Worklist '" + this.getID() + "'");
            if (this.worklistItems.contains(item)) {
                this.logger.info("Tried to add Worklist Item (" + item.getID() + ") to Worklist '" + this.getID() + "' which was already in the Worklist. " + "Updating Item instead!");
                this.updateWorklistItem(item);
            } else {
                this.worklistItems.add(item);
                this.doUpdate(new UpdateEntry(item, WorklistConstants.WorklistItemUpdateType.ADDED));
            }
        }
        finally {
            this.updateLock.writeLock().unlock();
        }
    }

    @Override
    public void updateWorklistItem(InternalWorklistItem item) {
        this.updateLock.writeLock().lock();
        try {
            this.logger.info("Updating Worklist Item (" + item.getID() + ") in Worklist '" + this.getID() + "'");
            int index = this.worklistItems.indexOf(item);
            if (index >= 0) {
                this.worklistItems.set(index, item);
                this.doUpdate(new UpdateEntry(item, WorklistConstants.WorklistItemUpdateType.CHANGED));
            } else {
                this.logger.info("Tried to update Worklist Item " + item.getID() + " which didn't exists in the Worklist " + this.getID() + ". Adding the Item instead!");
                this.addWorklistItem(item);
            }
        }
        finally {
            this.updateLock.writeLock().unlock();
        }
    }

    @Override
    public void removeWorklistItem(InternalWorklistItem item) {
        this.updateLock.writeLock().lock();
        try {
            this.logger.info("Removing Worklist Item (" + item.getID() + ") from Worklist '" + this.getID() + "'");
            if (this.worklistItems.remove(item)) {
                this.doUpdate(new UpdateEntry(item, WorklistConstants.WorklistItemUpdateType.REMOVED));
            } else {
                this.logger.info("Tried to remove Worklist Item (" + item.getID() + ") from Worklist '" + this.getID() + "' which didn't contain the Item!");
            }
        }
        finally {
            this.updateLock.writeLock().unlock();
        }
    }

    protected void doUpdate(UpdateEntry updateEntry) {
        this.updateLock.writeLock().lock();
        try {
            this.updates.add(updateEntry);
            ++this.revision;
            this.logger.finest(String.format("Adding Update (%s) as revision %d in update position %d to worklist %s", updateEntry, this.revision, this.updates.size() - 1, this.getID()));
            if (this.updates.size() > 500) {
                UpdateEntry removed = this.updates.remove(0);
                this.logger.finest(String.format("Removed Update entry (%s) from Worklist %s because Max History Size has been reached", removed, this.getID()));
            }
        }
        finally {
            this.updateLock.writeLock().unlock();
        }
    }

    @Override
    public WorklistUpdate getUpdates(long sinceRevision, Filter worklistFilter) {
        this.updateLock.readLock().lock();
        this.logger.finer(String.format("Requested update for internal worklist '%s' from revision %d (current revision %d).", this.getID(), sinceRevision, this.getRevision()));
        try {
            ClientWorklistItem clientWorklistItem;
            Object result = null;
            if (this.revision < sinceRevision) {
                throw new IllegalArgumentException("Since Revision cannot be bigger than the current Revision");
            }
            if (this.revision == sinceRevision) {
                this.logger.finer(String.format("Creating empty update for worklist '%s'", this.getID()));
                result = this.worklistModelFactory.createWorklistUpdate(this.getID(), this.revision, this.revision, this.initialisationDate, WorklistConstants.Priority.NORMAL.getPriority(), new HashMap<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType>(), new HashMap<String, String>());
            } else if (this.revision - sinceRevision <= (long)this.updates.size()) {
                int start = this.updates.size() - (int)(this.revision - sinceRevision);
                this.logger.finer(String.format("Creating update from revision %d to %d of worklist %s, using update entries %d to %d", sinceRevision, this.revision, this.getID(), start, this.updates.size()));
                HashMap<InternalWorklistItem, WorklistConstants.WorklistItemUpdateType> rawItemUpdates = new HashMap<InternalWorklistItem, WorklistConstants.WorklistItemUpdateType>();
                if (worklistFilter == null) {
                    int i = start;
                    while (i < this.updates.size()) {
                        UpdateEntry entry = this.updates.get(i);
                        this.logger.finest(String.format("Processing Update (%s) (Worklist %s)", entry, this.getID()));
                        WorklistConstants.WorklistItemUpdateType oldState = (WorklistConstants.WorklistItemUpdateType)((Object)rawItemUpdates.remove(entry.item));
                        if (oldState != null) {
                            if (oldState == WorklistConstants.WorklistItemUpdateType.ADDED && entry.state == WorklistConstants.WorklistItemUpdateType.CHANGED) {
                                rawItemUpdates.put(entry.item, WorklistConstants.WorklistItemUpdateType.ADDED);
                            } else if (oldState != WorklistConstants.WorklistItemUpdateType.ADDED || entry.state != WorklistConstants.WorklistItemUpdateType.REMOVED) {
                                if (oldState == WorklistConstants.WorklistItemUpdateType.CHANGED && entry.state == WorklistConstants.WorklistItemUpdateType.CHANGED) {
                                    rawItemUpdates.put(entry.item, WorklistConstants.WorklistItemUpdateType.CHANGED);
                                } else if (oldState == WorklistConstants.WorklistItemUpdateType.CHANGED && entry.state == WorklistConstants.WorklistItemUpdateType.REMOVED) {
                                    rawItemUpdates.put(entry.item, WorklistConstants.WorklistItemUpdateType.REMOVED);
                                } else if (oldState == WorklistConstants.WorklistItemUpdateType.REMOVED && entry.state == WorklistConstants.WorklistItemUpdateType.ADDED) {
                                    rawItemUpdates.put(entry.item, WorklistConstants.WorklistItemUpdateType.CHANGED);
                                } else {
                                    this.logger.severe(String.format("Unexpected combination of Worklist Item Update States: %s -> %s. Omitting last Change! (Worklist %s)", new Object[]{oldState, entry.state, this.getID()}));
                                }
                            }
                        } else {
                            rawItemUpdates.put(entry.item, entry.state);
                        }
                        ++i;
                    }
                } else {
                    UpdateEntry entry;
                    HashMap<InternalWorklistItem, Boolean> visibleNows = new HashMap<InternalWorklistItem, Boolean>();
                    int i = this.updates.size() - 1;
                    while (i >= start) {
                        entry = this.updates.get(i);
                        if (!visibleNows.containsKey(entry.item)) {
                            if (entry.state == WorklistConstants.WorklistItemUpdateType.REMOVED) {
                                visibleNows.put(entry.item, Boolean.FALSE);
                            } else {
                                visibleNows.put(entry.item, worklistFilter.matches(entry.item));
                            }
                        }
                        --i;
                    }
                    while (i >= 0) {
                        entry = this.updates.get(i);
                        if (visibleNows.containsKey(entry.item)) {
                            boolean visibleThen = entry.state == WorklistConstants.WorklistItemUpdateType.REMOVED ? false : worklistFilter.matches(entry.item);
                            boolean visibleNow = (Boolean)visibleNows.remove(entry.item);
                            if (visibleNow) {
                                if (visibleThen) {
                                    rawItemUpdates.put(entry.item, WorklistConstants.WorklistItemUpdateType.CHANGED);
                                } else {
                                    rawItemUpdates.put(entry.item, WorklistConstants.WorklistItemUpdateType.ADDED);
                                }
                            } else if (visibleThen) {
                                rawItemUpdates.put(entry.item, WorklistConstants.WorklistItemUpdateType.REMOVED);
                            }
                        }
                        --i;
                    }
                    if (visibleNows.size() > 0) {
                        rawItemUpdates = null;
                    }
                }
                if (rawItemUpdates != null) {
                    HashMap<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType> itemUpdates = new HashMap<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType>();
                    int maxPriority = this.worklistItems.size() > 0 ? Integer.MIN_VALUE : WorklistConstants.Priority.NORMAL.getPriority();
                    for (Map.Entry mapEntry : rawItemUpdates.entrySet()) {
                        clientWorklistItem = this.createClientWorklistItem((InternalWorklistItem)mapEntry.getKey());
                        itemUpdates.put(clientWorklistItem, (WorklistConstants.WorklistItemUpdateType)((Object)mapEntry.getValue()));
                        maxPriority = Math.max(maxPriority, clientWorklistItem.getPriority());
                    }
                    result = this.worklistModelFactory.createWorklistUpdate(this.getID(), sinceRevision, this.revision, this.initialisationDate, maxPriority, itemUpdates, new HashMap<String, String>());
                }
            }
            if (result == null) {
                this.logger.finer(String.format("Creating full Update for Worklist %s (requested update from %d to %d)", this.getID(), sinceRevision, this.revision));
                HashMap<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType> itemUpdates = new HashMap<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType>();
                int maxPriority = this.worklistItems.size() > 0 ? Integer.MIN_VALUE : WorklistConstants.Priority.NORMAL.getPriority();
                for (InternalWorklistItem item : this.worklistItems) {
                    if (worklistFilter != null && !worklistFilter.matches(item)) continue;
                    clientWorklistItem = this.createClientWorklistItem(item);
                    itemUpdates.put(clientWorklistItem, WorklistConstants.WorklistItemUpdateType.ADDED);
                    maxPriority = Math.max(maxPriority, clientWorklistItem.getPriority());
                }
                result = this.worklistModelFactory.createWorklistUpdate(this.getID(), 0L, this.revision, this.initialisationDate, maxPriority, itemUpdates, new HashMap<String, String>());
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(String.format("Returning Worklist Update for %s: %s", this.getID(), result.toString()));
            }
            Object object = result;
            return object;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    protected ClientWorklistItem createClientWorklistItem(InternalWorklistItem item) {
        IndividualWorklistItemSettings settings = item.getIndividualWorklistItemSettings(this.getID());
        ClientWorklistItem clientWorklistItem = this.worklistModelFactory.createClientWorklistItem(this.getID(), item, settings);
        return clientWorklistItem;
    }

    @Override
    public void updateIndividualSettings(ClientWorklistItem clientWorklistItem) {
        this.updateLock.writeLock().lock();
        try {
            this.logger.info("Updating Settings of Client Worklist Item (" + clientWorklistItem.getID() + ") from Worklist " + "'" + this.getID() + "'");
            int i = this.worklistItems.indexOf(clientWorklistItem);
            if (i >= 0) {
                InternalWorklistItem item = (InternalWorklistItem)this.worklistItems.get(i);
                this.doUpdate(new UpdateEntry(item, WorklistConstants.WorklistItemUpdateType.CHANGED));
            } else {
                this.logger.warning(String.format("Client Worklist Item '%1$s' in Worklist '%2$s' has been updated but the Worklist no longercontains the corresponding  Internal Worklist Item. Droping Update!", clientWorklistItem.getID(), clientWorklistItem.getWorklistID()));
            }
        }
        finally {
            this.updateLock.writeLock().unlock();
        }
    }

    @Override
    public long addUpdateableClientWorklist(ClientWorklist clientWorklist) {
        long clientWorklistID = this.nextClientWorklistID.getAndIncrement();
        this.clientWorklists.put(clientWorklist, clientWorklistID);
        return clientWorklistID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ClientWorklist, Long> getUpdateableClientWorklists() {
        Map<ClientWorklist, Long> map = this.clientWorklists;
        synchronized (map) {
            return new HashMap<ClientWorklist, Long>(this.clientWorklists);
        }
    }

    @Override
    public void removeUpdateableClientWorklist(ClientWorklist clientWorklist) {
        this.clientWorklists.remove(clientWorklist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdateableClientWorklist(long clientWorklistID) {
        Map<ClientWorklist, Long> map = this.clientWorklists;
        synchronized (map) {
            this.clientWorklists.values().remove(clientWorklistID);
        }
    }

    @Override
    public String getSubstitutionRule() {
        return this.substitutionRule;
    }

    @Override
    public void setAbsent(long from, long to, String substitutionRule) {
        ArgChecks.checkForNegative(from, "from");
        ArgChecks.checkForNegative(to, "to");
        ArgChecks.checkForEmpty(substitutionRule, "substitutionRule");
        this.absentFrom = from;
        this.absentTo = to;
        this.substitutionRule = substitutionRule;
    }

    @Override
    public void setPresent() {
        this.absentFrom = -1L;
        this.absentTo = -1L;
        this.substitutionRule = "";
    }

    @Override
    public long getAbsenceFromDate() {
        return this.absentFrom;
    }

    @Override
    public long getAbsenceToDate() {
        return this.absentTo;
    }

    @Override
    public boolean isPresentNow() {
        boolean present;
        if (this.getAbsenceFromDate() >= 0L) {
            long currentTime;
            long from = this.getAbsenceFromDate();
            long to = this.getAbsenceToDate();
            if (to == 0L) {
                to = Long.MAX_VALUE;
            }
            present = (currentTime = System.currentTimeMillis()) < from || currentTime > to;
        } else {
            present = true;
        }
        return present;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private static class UpdateEntry {
        public final InternalWorklistItem item;
        public final WorklistConstants.WorklistItemUpdateType state;

        UpdateEntry(InternalWorklistItem item, WorklistConstants.WorklistItemUpdateType state) {
            this.item = item;
            this.state = state;
        }

        public String toString() {
            return this.item.getID() + " => " + (Object)((Object)this.state);
        }
    }
}

