/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.IndividualWorklistItemSettings;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.defaultimplementation.DefaultIndividualWorklistItemSettings;
import de.aristaflow.adept2.model.worklistmodel.defaultimplementation.DefaultWorklistItem;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DefaultInternalWorklistItem
extends DefaultWorklistItem
implements InternalWorklistItem {
    private static final long serialVersionUID = -8187719967265037576L;
    protected final HashSet<UUID> worklistIDs;
    protected final ReadWriteLock worklistIDLock = new ReentrantReadWriteLock();
    protected String escalationHandlingProcedureID;
    protected final String delegationHandlingProcedureID;
    protected final String distributionHandlingProcedureID;
    protected final String staffAssignmentRule;
    protected ParameterDataContext parameterDataContext;
    protected final ArrayList<WorklistItem.Delegation> delegations;
    protected final ArrayList<Enquiry> enquiries;
    private final HashMap<UUID, IndividualWorklistItemSettings> itemSettings;
    private final ReentrantReadWriteLock itemSettingsLock;
    private UUID[] availableStateWorklistIDs = null;

    public DefaultInternalWorklistItem(UUID id, String title, String description, String staffAssignmentRule, ActivityReference activityReference, UUID iconID, int priority, long dueDate, long escalationDate, WorklistConstants.WorklistItemState worklistItemState, QualifiedAgent assignedAgent, int currentEscalationLevel, UUID[] worklistIDs, UUID[] availableStateWorklistIDs, int availableStateDelegationIndex, Set<IndividualWorklistItemSettings> itemSettings, String escalationProcedureID, String distributionHandlingProcedureID, String delegationHandlingProcedureID, long activationDate, long assignmentDate, long complexity, int delegationLevel, List<WorklistItem.Delegation> delegations, Enquiry repliedEnquiry, List<Enquiry> enquiries, ParameterDataContext parameterDataContext, String processTemplateName, String processInstanceName, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginDatas, Map<String, String> userAttributes) {
        super(id, title, description, activityReference, iconID, priority, dueDate, escalationDate, worklistItemState, assignedAgent, currentEscalationLevel, activationDate, assignmentDate, complexity, delegationLevel, repliedEnquiry, processTemplateName, processInstanceName, supportedPlugins, pluginDatas, userAttributes);
        this.worklistIDs = new HashSet(Math.max(worklistIDs.length, 16));
        UUID[] uUIDArray = worklistIDs;
        int n = worklistIDs.length;
        int n2 = 0;
        while (n2 < n) {
            UUID worklistID = uUIDArray[n2];
            this.worklistIDs.add(worklistID);
            ++n2;
        }
        if (availableStateWorklistIDs != null) {
            this.availableStateWorklistIDs = (UUID[])availableStateWorklistIDs.clone();
        }
        this.escalationHandlingProcedureID = escalationProcedureID;
        this.distributionHandlingProcedureID = distributionHandlingProcedureID;
        this.delegationHandlingProcedureID = delegationHandlingProcedureID;
        this.staffAssignmentRule = staffAssignmentRule;
        this.parameterDataContext = parameterDataContext;
        this.enquiries = new ArrayList<Enquiry>(enquiries);
        this.delegations = new ArrayList<WorklistItem.Delegation>(delegations);
        this.itemSettingsLock = new ReentrantReadWriteLock();
        this.itemSettings = new HashMap();
        for (IndividualWorklistItemSettings setting : itemSettings) {
            this.itemSettings.put(setting.getWorklistID(), setting);
        }
    }

    @Override
    public UUID[] getWorklistIDs() {
        this.worklistIDLock.readLock().lock();
        try {
            UUID[] uUIDArray = this.worklistIDs.toArray(new UUID[this.worklistIDs.size()]);
            return uUIDArray;
        }
        finally {
            this.worklistIDLock.readLock().unlock();
        }
    }

    @Override
    public void addedToWorklist(UUID worklistID) {
        this.worklistIDLock.writeLock().lock();
        try {
            this.worklistIDs.add(worklistID);
        }
        finally {
            this.worklistIDLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void escalated() {
        DefaultInternalWorklistItem defaultInternalWorklistItem = this;
        synchronized (defaultInternalWorklistItem) {
            ++this.escalationLevel;
        }
    }

    @Override
    public String getDelegationHandlingProcedureID() {
        return this.delegationHandlingProcedureID;
    }

    @Override
    public String getDistributionHandlingProcedureID() {
        return this.distributionHandlingProcedureID;
    }

    @Override
    public synchronized String getEscalationHandlingProcedureID() {
        return this.escalationHandlingProcedureID;
    }

    @Override
    public String getStaffAssignmentRule() {
        return this.staffAssignmentRule;
    }

    @Override
    public void removedFromWorklist(UUID worklistID) {
        this.worklistIDLock.writeLock().lock();
        try {
            this.worklistIDs.remove(worklistID);
        }
        finally {
            this.worklistIDLock.writeLock().unlock();
        }
    }

    @Override
    public void setAssignedAgent(QualifiedAgent agent) {
        this.assignedAgent = agent;
    }

    @Override
    public void setAssignmentDate(long timestamp) {
        this.assignmentDate = timestamp;
    }

    @Override
    public void setDescription(String description) {
        ArgChecks.checkForNull(description, "description");
        this.description = description;
    }

    @Override
    public void setDueDate(long timestamp) {
        this.dueDate = timestamp;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public void setState(WorklistConstants.WorklistItemState state) {
        this.state = state;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public ParameterDataContext getAttachedDataContext() {
        return this.parameterDataContext;
    }

    @Override
    public void setAttachedDataContext(ParameterDataContext dataContext) {
        this.parameterDataContext = dataContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delegateTo(Set<QualifiedAgent> delegationRecipients, QualifiedAgent delegator, String comment) {
        HashSet<QualifiedAgent> recipients = new HashSet<QualifiedAgent>(delegationRecipients);
        DefaultDelegation delegation = new DefaultDelegation(delegator, recipients, comment);
        DefaultInternalWorklistItem defaultInternalWorklistItem = this;
        synchronized (defaultInternalWorklistItem) {
            this.delegations.add(delegation);
            ++this.currentDelegationLevel;
        }
    }

    @Override
    public synchronized List<WorklistItem.Delegation> getDelegationHistory() {
        return Collections.unmodifiableList(new ArrayList<WorklistItem.Delegation>(this.delegations));
    }

    @Override
    public synchronized List<Enquiry> getEnquiryStack() {
        return Collections.unmodifiableList(new ArrayList<Enquiry>(this.enquiries));
    }

    @Override
    public synchronized void enquireItem(Enquiry enquiry) {
        this.enquiries.add(enquiry);
        this.repliedEnquiry = null;
    }

    @Override
    public synchronized void replyEnquiry(Enquiry reply) {
        this.enquiries.remove(this.enquiries.size() - 1);
        this.repliedEnquiry = reply;
    }

    @Override
    public WorklistItem.Delegation getCurrentDelegation() {
        if (this.delegations.size() == 0) {
            return null;
        }
        return this.delegations.get(this.delegations.size() - 1);
    }

    @Override
    public Enquiry getCurrentEnquiry() {
        if (this.enquiries.size() == 0) {
            return null;
        }
        return this.enquiries.get(this.enquiries.size() - 1);
    }

    @Override
    public synchronized void setEscalation(long timestamp, String escalationHandlingProcedureID) {
        this.escalationDate = timestamp;
        this.escalationHandlingProcedureID = escalationHandlingProcedureID;
    }

    @Override
    public synchronized int getAvailableStateDelegationIndex() {
        return 0;
    }

    @Override
    public synchronized UUID[] getAvailableStateWorklistIDs() {
        if (this.availableStateWorklistIDs == null) {
            return null;
        }
        return (UUID[])this.availableStateWorklistIDs.clone();
    }

    @Override
    public synchronized void restoreAvailableState() {
        this.worklistIDLock.writeLock().lock();
        try {
            this.worklistIDs.clear();
            UUID[] uUIDArray = this.availableStateWorklistIDs;
            int n = this.availableStateWorklistIDs.length;
            int n2 = 0;
            while (n2 < n) {
                UUID worklistID = uUIDArray[n2];
                this.worklistIDs.add(worklistID);
                ++n2;
            }
        }
        finally {
            this.worklistIDLock.writeLock().unlock();
        }
        this.availableStateWorklistIDs = null;
    }

    @Override
    public synchronized void storeCurrentState(boolean delegated) {
        if (this.state != WorklistConstants.WorklistItemState.AVAILABLE && !delegated) {
            return;
        }
        this.worklistIDLock.readLock().lock();
        try {
            this.availableStateWorklistIDs = this.worklistIDs.toArray(new UUID[this.worklistIDs.size()]);
        }
        finally {
            this.worklistIDLock.readLock().unlock();
        }
    }

    @Override
    public IndividualWorklistItemSettings getIndividualWorklistItemSettings(UUID worklistID) {
        IndividualWorklistItemSettings settings;
        this.itemSettingsLock.readLock().lock();
        try {
            settings = this.itemSettings.get(worklistID);
            if (settings == null) {
                settings = new DefaultIndividualWorklistItemSettings(worklistID, null, this.getDescription());
            }
        }
        finally {
            this.itemSettingsLock.readLock().unlock();
        }
        return settings;
    }

    @Override
    public Set<IndividualWorklistItemSettings> getIndividualWorklistItemSettings() {
        this.itemSettingsLock.readLock().lock();
        try {
            HashSet<IndividualWorklistItemSettings> hashSet = new HashSet<IndividualWorklistItemSettings>(this.itemSettings.values());
            return hashSet;
        }
        finally {
            this.itemSettingsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateIndividualWorklistItemSettings(IndividualWorklistItemSettings individualWorklistItemSettings) {
        HashMap<UUID, IndividualWorklistItemSettings> hashMap = this.itemSettings;
        synchronized (hashMap) {
            boolean changes = false;
            this.itemSettingsLock.writeLock().lock();
            try {
                IndividualWorklistItemSettings settings = this.itemSettings.get(individualWorklistItemSettings.getWorklistID());
                if (settings == null) {
                    this.itemSettings.put(individualWorklistItemSettings.getWorklistID(), new DefaultIndividualWorklistItemSettings(individualWorklistItemSettings));
                    changes = true;
                } else {
                    if (settings.getIndividualTitle() != null && !settings.getIndividualTitle().equals(individualWorklistItemSettings.getIndividualTitle()) || settings.getIndividualTitle() == null && individualWorklistItemSettings.getIndividualTitle() != null) {
                        settings.setIndividualTitle(individualWorklistItemSettings.getIndividualTitle());
                        changes = true;
                    }
                    if (settings.getDescription() == null && individualWorklistItemSettings.getDescription() != null || settings.getDescription() != null && !settings.getDescription().equals(individualWorklistItemSettings.getDescription())) {
                        settings.setDescription(individualWorklistItemSettings.getDescription());
                        changes = true;
                    }
                    if (settings.getIndividualEscalationDate() != individualWorklistItemSettings.getIndividualEscalationDate() || !this.equals(settings.getIndividualEscalationHandlingProcedureID(), individualWorklistItemSettings.getIndividualEscalationHandlingProcedureID())) {
                        settings.setIndividualEscalation(individualWorklistItemSettings.getIndividualEscalationDate(), individualWorklistItemSettings.getIndividualEscalationHandlingProcedureID());
                        changes = true;
                    }
                    if (settings.getIndividualDueDate() != individualWorklistItemSettings.getIndividualDueDate()) {
                        settings.setIndividualDueDate(individualWorklistItemSettings.getIndividualDueDate());
                        changes = true;
                    }
                    if (settings.getIndividualPriority() != individualWorklistItemSettings.getIndividualPriority()) {
                        settings.setIndividualPriority(individualWorklistItemSettings.getIndividualPriority());
                        changes = true;
                    }
                    if (settings.getResubmissionDate() != individualWorklistItemSettings.getResubmissionDate()) {
                        settings.setResubmissionDate(individualWorklistItemSettings.getResubmissionDate());
                        changes = true;
                    }
                    Map<String, String> ua1 = individualWorklistItemSettings.getIndividualUserAttributes();
                    Map<String, String> ua2 = settings.getIndividualUserAttributes();
                    for (Map.Entry<String, String> entry : ua1.entrySet()) {
                        if (ua2.containsKey(entry.getKey())) {
                            if (this.equals(ua2.get(entry.getKey()), entry.getValue())) continue;
                            settings.setUserAttributeValue(entry.getKey(), entry.getValue());
                            changes = true;
                            continue;
                        }
                        settings.setUserAttributeValue(entry.getKey(), entry.getValue());
                        changes = true;
                    }
                    for (String string : ua2.keySet()) {
                        if (ua1.containsKey(string)) continue;
                        settings.removeUserAttributeValue(string);
                    }
                    Map<String, PluginData> map = individualWorklistItemSettings.getIndividualPluginDatas();
                    Map<String, PluginData> pd2 = settings.getIndividualPluginDatas();
                    for (Map.Entry<String, PluginData> data : map.entrySet()) {
                        if (map.containsKey(data.getKey())) {
                            if (this.equals(pd2.get(data.getKey()), data.getValue())) continue;
                            settings.setIndividualPluginData(data.getValue());
                            changes = true;
                            continue;
                        }
                        settings.setIndividualPluginData(data.getValue());
                        changes = true;
                    }
                }
            }
            finally {
                this.itemSettingsLock.writeLock().unlock();
            }
            return changes;
        }
    }

    private boolean equals(PluginData pluginData1, PluginData pluginData2) {
        if (pluginData1 == null) {
            return pluginData2 == null;
        }
        if (pluginData2 == null) {
            return false;
        }
        return pluginData1.getPluginID().equals(pluginData2.getPluginID()) && pluginData1.getPluginData().equals(pluginData2.getPluginData());
    }

    @Override
    public synchronized void setPluginData(PluginData pluginData) {
        this.pluginData.put(pluginData.getPluginID(), pluginData);
    }

    private boolean equals(String string1, String string2) {
        if (string1 == null) {
            return string2 == null;
        }
        return string1.equals(string2);
    }

    public static class DefaultDelegation
    implements WorklistItem.Delegation {
        private static final long serialVersionUID = 3162401040694670765L;
        private final String comment;
        private final QualifiedAgent delegator;
        private final HashSet<QualifiedAgent> recipients;

        public DefaultDelegation(QualifiedAgent delegator, Set<QualifiedAgent> recipients, String comment) {
            this.recipients = new HashSet<QualifiedAgent>(recipients);
            this.delegator = delegator;
            this.comment = comment;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public QualifiedAgent getDelegator() {
            return this.delegator;
        }

        @Override
        public Set<QualifiedAgent> getRecipients() {
            return this.recipients;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WorklistItem.Delegation) {
                WorklistItem.Delegation other = (WorklistItem.Delegation)obj;
                return this.delegator.equals(other.getDelegator()) && this.comment.equals(other.getComment()) && this.recipients.equals(other.getRecipients());
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.delegator.hashCode() ^ this.comment.hashCode();
        }
    }
}

