/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultUserAttributeContainer;
import de.aristaflow.adept2.model.worklistmodel.Worklist;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

public class DefaultWorklist<T extends WorklistItem>
extends DefaultUserAttributeContainer
implements Worklist<T> {
    protected transient Logger logger;
    protected UUID worklistID;
    protected QualifiedAgent agent;
    protected List<T> worklistItems;
    protected transient ReentrantReadWriteLock updateLock;
    protected long revision;

    DefaultWorklist() {
    }

    protected DefaultWorklist(UUID worklistID, QualifiedAgent agent, List<T> worklistItems, long revision, Map<String, String> userAttributes) {
        super(userAttributes);
        this.logger = LoggerTools.getLogger(this);
        this.worklistID = worklistID;
        this.agent = agent;
        this.updateLock = new ReentrantReadWriteLock();
        this.worklistItems = new ArrayList<T>(worklistItems);
        this.revision = revision;
    }

    @Override
    public UUID getID() {
        return this.worklistID;
    }

    @Override
    public QualifiedAgent getAgent() {
        return this.agent;
    }

    @Override
    public long getRevision() {
        this.updateLock.readLock().lock();
        try {
            long l = this.revision;
            return l;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public T getWorklistItem(UUID itemID) {
        WorklistItem ret = null;
        this.updateLock.readLock().lock();
        try {
            for (WorklistItem item : this.worklistItems) {
                if (!item.getID().equals(itemID)) continue;
                ret = item;
                break;
            }
            WorklistItem worklistItem = ret;
            return (T)worklistItem;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public List<T> getWorklistItems() {
        this.updateLock.readLock().lock();
        try {
            ArrayList<T> arrayList = new ArrayList<T>(this.worklistItems);
            return arrayList;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Worklist) {
            Worklist other = (Worklist)obj;
            return this.getID().equals(other.getID());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.worklistID.hashCode();
    }
}

