/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel.defaultimplementation;

import de.aristaflow.adept2.model.common.defaultimplementation.DefaultUserAttributeContainer;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DefaultWorklistConfiguration
extends DefaultUserAttributeContainer
implements WorklistUpdateConfiguration {
    private static final long serialVersionUID = -6083683590012954143L;
    protected final int updateModeThreshold;
    protected final HashMap<Integer, Long> updateInterval;
    protected final int[] updateIntervalKeys;
    protected final Filter worklistFilter;

    protected DefaultWorklistConfiguration(int updateModeThreshold, Map<Integer, Long> updateInterval, Filter worklistFilter, Map<String, String> userAttributes) {
        super(userAttributes);
        this.updateInterval = new HashMap<Integer, Long>(updateInterval);
        this.updateModeThreshold = updateModeThreshold;
        this.updateIntervalKeys = this.toIntArray(updateInterval.keySet());
        Arrays.sort(this.updateIntervalKeys);
        this.worklistFilter = worklistFilter;
    }

    @Override
    public int getUpdateModeThreshold() {
        return this.updateModeThreshold;
    }

    @Override
    public long getUpdateInterval(int priority) {
        if (this.updateIntervalKeys.length == 0) {
            if (priority >= this.updateModeThreshold) {
                return 0L;
            }
            return -1L;
        }
        int idx = Arrays.binarySearch(this.updateIntervalKeys, priority);
        if (idx >= 0) {
            return this.updateInterval.get(this.updateIntervalKeys[idx]);
        }
        if ((idx = -idx - 2) == -1) {
            idx = 0;
        }
        return this.updateInterval.get(this.updateIntervalKeys[idx]);
    }

    @Override
    public int[] getUpdateIntervalThresholds() {
        int[] result = new int[this.updateIntervalKeys.length];
        System.arraycopy(this.updateIntervalKeys, 0, result, 0, this.updateIntervalKeys.length);
        return result;
    }

    @Override
    public Filter getWorklistFilter() {
        return this.worklistFilter;
    }

    private int[] toIntArray(Set<Integer> iSet) {
        int[] ret = new int[iSet.size()];
        int i = 0;
        Iterator<Integer> iterator = iSet.iterator();
        while (iterator.hasNext()) {
            int val;
            ret[i] = val = iterator.next().intValue();
            ++i;
        }
        return ret;
    }
}

