/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class DefaultWorklistItem
extends SerialisablePluginDataContainer
implements WorklistItem {
    private static final long serialVersionUID = -721491528418405904L;
    protected final UUID worklistItemID;
    protected volatile String title;
    protected volatile String description;
    protected final ActivityReference activityReference;
    protected volatile UUID iconID;
    protected volatile int priority;
    protected volatile WorklistConstants.WorklistItemState state;
    protected volatile QualifiedAgent assignedAgent;
    protected volatile long dueDate;
    protected volatile int escalationLevel;
    protected volatile long activationDate;
    protected volatile long assignmentDate;
    protected final long complexity;
    protected volatile int currentDelegationLevel;
    protected Enquiry repliedEnquiry;
    protected final String processInstanceName;
    protected final String processTemplateName;
    protected volatile long escalationDate;

    protected DefaultWorklistItem(UUID worklistItemID, String title, String description, ActivityReference activityReference, UUID iconID, int priority, long dueDate, long escalationDate, WorklistConstants.WorklistItemState state, QualifiedAgent assignedAgent, int escalationLevel, long activationDate, long assignmentDate, long complexity, int delegationLevel, Enquiry repliedEnquiry, String processTemplateName, String processInstanceName, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginData, Map<String, String> userAttributes) {
        super(supportedPlugins, pluginData, userAttributes);
        ArgChecks.checkForNull(description, "description");
        this.worklistItemID = worklistItemID;
        this.title = title;
        this.description = description;
        this.activityReference = activityReference;
        this.iconID = iconID;
        this.priority = priority;
        this.dueDate = dueDate;
        this.escalationDate = escalationDate;
        this.state = state;
        this.assignedAgent = assignedAgent;
        this.escalationLevel = escalationLevel;
        this.activationDate = activationDate;
        this.assignmentDate = assignmentDate;
        this.complexity = complexity;
        this.currentDelegationLevel = delegationLevel;
        this.processInstanceName = processInstanceName;
        this.processTemplateName = processTemplateName;
        this.repliedEnquiry = repliedEnquiry;
    }

    @Override
    public UUID getID() {
        return this.worklistItemID;
    }

    @Override
    public synchronized String getTitle() {
        return this.title;
    }

    @Override
    public synchronized String getDescription() {
        return this.description;
    }

    @Override
    public ActivityReference getActivityReference() {
        return this.activityReference;
    }

    @Override
    public UUID getIconID() {
        return this.iconID;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public WorklistConstants.WorklistItemState getState() {
        return this.state;
    }

    @Override
    public QualifiedAgent getAssignedAgent() {
        return this.assignedAgent;
    }

    @Override
    public long getDueDate() {
        return this.dueDate;
    }

    @Override
    public int getCurrentEscalationLevel() {
        return this.escalationLevel;
    }

    @Override
    public long getActivationDate() {
        return this.activationDate;
    }

    @Override
    public long getAssignmentDate() {
        return this.assignmentDate;
    }

    @Override
    public long getComplexity() {
        return this.complexity;
    }

    @Override
    public int getCurrentDelegationLevel() {
        return this.currentDelegationLevel;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof WorklistItem) {
            WorklistItem other = (WorklistItem)obj;
            return this.getID().equals(other.getID());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.worklistItemID.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getTitle()) + " (" + this.getID() + ")";
    }

    @Override
    public synchronized Enquiry getRepliedEnquiry() {
        return this.repliedEnquiry;
    }

    @Override
    public String getProcessInstanceName() {
        return this.processInstanceName;
    }

    @Override
    public String getProcessTemplateName() {
        return this.processTemplateName;
    }

    @Override
    public long getEscalationDate() {
        return this.escalationDate;
    }
}

