/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel.defaultimplementation;

import de.aristaflow.adept2.model.common.defaultimplementation.DefaultUserAttributeContainer;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class DefaultWorklistUpdate
extends DefaultUserAttributeContainer
implements WorklistUpdate {
    private static final long serialVersionUID = 6552170062295538696L;
    protected final UUID worklistID;
    protected final long oldRevision;
    protected final long newRevision;
    protected final int maxPriority;
    protected final HashMap<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType> itemUpdates;
    private final long initialisingDate;

    protected DefaultWorklistUpdate(UUID worklistID, long oldRevision, long newRevision, long initialisingDate, int maxPriority, Map<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType> itemUpdates, Map<String, String> userAttributes) {
        super(userAttributes);
        this.worklistID = worklistID;
        this.oldRevision = oldRevision;
        this.newRevision = newRevision;
        this.initialisingDate = initialisingDate;
        this.maxPriority = maxPriority;
        this.itemUpdates = new HashMap<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType>(itemUpdates);
    }

    @Override
    public UUID getWorklistID() {
        return this.worklistID;
    }

    @Override
    public long getSourceRevision() {
        return this.oldRevision;
    }

    @Override
    public long getTargetRevision() {
        return this.newRevision;
    }

    @Override
    public int getMaxPriority() {
        return this.maxPriority;
    }

    @Override
    public Map<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType> getItemUpdates() {
        return Collections.unmodifiableMap(this.itemUpdates);
    }

    @Override
    public long getInitialisingDate() {
        return this.initialisingDate;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("Update for Worklist %1$s from revision %2$d to %3$d: [", this.worklistID, this.oldRevision, this.newRevision));
        String delim = "";
        for (Map.Entry<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType> entry : this.itemUpdates.entrySet()) {
            result.append(delim);
            result.append(String.format("(%s (current item state: %s), %s)", new Object[]{entry.getKey(), entry.getKey().getState(), entry.getValue()}));
            delim = " ,";
        }
        result.append("]");
        return result.toString();
    }
}

