/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel.xml;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.XMLExportTools;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.IndividualWorklistItemSettings;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLConstants;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLHelperTools;
import de.aristaflow.adept2.util.Base64;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WorklistModelXMLExport
extends XMLExportTools {
    private static final String NS = "http://www.aristaflow.de/adept2/worklistmodel";
    private final Logger logger = LoggerTools.getLogger(WorklistModelXMLExport.class);

    public void writeWorklistToFile(InternalWorklist<InternalWorklistItem> worklist, WorklistUpdateConfiguration mailingClientWorklistConfig, Map<String, String> worklistConfiguration, File file) throws IOException, XMLFormatException {
        Document doc = this.getDocumentForWorklist(worklist, mailingClientWorklistConfig, worklistConfiguration);
        XMLHelperTools.writeDocumentToFile(doc, file, WorklistModelXMLHelperTools.getSchema(WorklistModelXMLConstants.SchemaType.WORKLIST));
    }

    public void writeWorklistItemToFile(InternalWorklistItem worklistItem, EBPInstanceReference ebpInstanceReference, File file) throws IOException, XMLFormatException {
        Document doc = this.getDocumentForWorklistItem(worklistItem, ebpInstanceReference);
        XMLHelperTools.writeDocumentToFile(doc, file, WorklistModelXMLHelperTools.getSchema(WorklistModelXMLConstants.SchemaType.WORKLIST_ITEM));
    }

    public void writeAgentAndClientsToFile(QualifiedAgent agent, List<URI[]> clients, File file) throws IOException, XMLFormatException {
        Document doc = this.getDocumentForAgentAndClients(agent, clients);
        XMLHelperTools.writeDocumentToFile(doc, file, WorklistModelXMLHelperTools.getSchema(WorklistModelXMLConstants.SchemaType.CLIENTS));
    }

    public Document getDocumentForAgentAndClients(QualifiedAgent agent, List<URI[]> clients) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = this.createAgentAndClientsElement(document, agent, clients);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/worklistmodel clients.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        try {
            XMLHelperTools.validateDocument(document, WorklistModelXMLHelperTools.getSchema(WorklistModelXMLConstants.SchemaType.CLIENTS));
        }
        catch (XMLFormatException ex) {
            String message = "The document is not valid!";
            this.logger.log(Level.SEVERE, message, ex);
            throw new XMLFormatException("The document could not be exported since it is not valid! Note: A ValidationException would be better here, but is not provided!", ex);
        }
        return document;
    }

    public Document getDocumentForUserAttributes(Map<String, String> attributes) {
        Document document = XMLHelperTools.createDocument();
        Element uaElement = WorklistModelXMLExport.createUserAttributesElement(document, NS, attributes);
        document.appendChild(uaElement);
        return document;
    }

    public Document getDocumentForWorklistConfig(Map<String, String> config) {
        Document document = XMLHelperTools.createDocument();
        Element configElement = this.createConfigurationsElement(document, config);
        document.appendChild(configElement);
        return document;
    }

    public Document getDocumentForParameterDataContext(ParameterDataContext context) {
        Document document = XMLHelperTools.createDocument();
        Element contextElement = this.createParameterDataContext(document, context);
        document.appendChild(contextElement);
        return document;
    }

    public Document getDocumentForSupportedPlugins(Map<String, Set<String>> plugins) {
        Document document = XMLHelperTools.createDocument();
        Element supportedPluginElement = this.createSupportedPlugins(document, plugins);
        document.appendChild(supportedPluginElement);
        return document;
    }

    public Document getDocumentForPluginDatas(Map<String, PluginData> pluginDatas) {
        Document document = XMLHelperTools.createDocument();
        Element pluginDataElement = this.createPluginDatas(document, pluginDatas);
        document.appendChild(pluginDataElement);
        return document;
    }

    public Document getDocumentForURIs(URI[] uris, String tagName) {
        Document document = XMLHelperTools.createDocument();
        Element urisElement = document.createElementNS(NS, tagName);
        if (uris != null) {
            URI[] uRIArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                Element uriElement = document.createElementNS(NS, "uri");
                uriElement.setTextContent(uri.toString());
                urisElement.appendChild(uriElement);
                ++n2;
            }
        }
        document.appendChild(urisElement);
        return document;
    }

    public Document getDocumentForExecutionMangerURIs(URI[] uris) {
        return this.getDocumentForURIs(uris, "executionManagerURIs");
    }

    public Document getDocumentForRuntimeMangerURIs(URI[] uris) {
        return this.getDocumentForURIs(uris, "runtimeManagerURIs");
    }

    public Document getDocumentForWorklistItem(InternalWorklistItem worklistItem, EBPInstanceReference ebpInstanceReference) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = this.createWorklistItemElement(document, worklistItem, ebpInstanceReference);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/worklistmodel worklistitem.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        try {
            XMLHelperTools.validateDocument(document, WorklistModelXMLHelperTools.getSchema(WorklistModelXMLConstants.SchemaType.WORKLIST_ITEM));
        }
        catch (XMLFormatException ex) {
            String message = "The document is not valid!";
            this.logger.log(Level.SEVERE, message, ex);
            throw new XMLFormatException("The document could not be exported since it is not valid! Note: A ValidationException would be better here, but is not provided!", ex);
        }
        return document;
    }

    public Document getDocumentForWorklist(InternalWorklist<InternalWorklistItem> worklist, WorklistUpdateConfiguration mailingClientWorklistConfig, Map<String, String> worklistConfiguration) throws XMLFormatException {
        Document document = XMLHelperTools.createDocument();
        Element root = this.createWorklistElement(document, worklist, mailingClientWorklistConfig, worklistConfiguration);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.aristaflow.de/adept2/worklistmodel worklist.xsd http://www.w3.org/2000/09/xmldsig# xmldsig-core-schema.xsd");
        document.appendChild(root);
        try {
            XMLHelperTools.validateDocument(document, WorklistModelXMLHelperTools.getSchema(WorklistModelXMLConstants.SchemaType.WORKLIST));
        }
        catch (XMLFormatException ex) {
            String message = "The worklist document is not valid!";
            this.logger.log(Level.SEVERE, message, ex);
            throw new XMLFormatException("The worklist could not be exported since the document is not valid! Note: A ValidationException would be better here, but is not provided!", ex);
        }
        return document;
    }

    private Element createAgentAndClientsElement(Document document, QualifiedAgent agent, List<URI[]> clients) {
        Element clientsElement = document.createElementNS(NS, "clients");
        clientsElement.setAttributeNS(null, "version", "0");
        clientsElement.appendChild(this.createQualifiedAgentElement(document, agent));
        Element clientURIsElement = WorklistModelXMLExport.addElement(document, clientsElement, "clientURIs");
        for (URI[] client : clients) {
            clientURIsElement.appendChild(WorklistModelXMLExport.createURIArrayElement(document, NS, client, "client", false));
        }
        return clientsElement;
    }

    private Element createWorklistElement(Document document, InternalWorklist<InternalWorklistItem> worklist, WorklistUpdateConfiguration mailingClientWorklistConfig, Map<String, String> worklistConfiguration) {
        Element worklistElement = document.createElementNS(NS, "worklist");
        worklistElement.setAttributeNS(null, "id", worklist.getID().toString());
        worklistElement.setAttributeNS(null, "version", "0");
        Element agentElement = WorklistModelXMLExport.addElement(document, worklistElement, "agent");
        WorklistModelXMLExport.fillQualifiedAgentElement(document, NS, agentElement, worklist.getAgent());
        if (!worklist.getSubstitutionRule().equals("")) {
            WorklistModelXMLExport.addElement(document, worklistElement, "substitutionRule", worklist.getSubstitutionRule());
            WorklistModelXMLExport.addElement(document, worklistElement, "absenceFrom", "" + worklist.getAbsenceFromDate());
            WorklistModelXMLExport.addElement(document, worklistElement, "absenceTo", "" + worklist.getAbsenceToDate());
        }
        if (worklist.getUserAttributes().size() > 0) {
            worklistElement.appendChild(WorklistModelXMLExport.createUserAttributesElement(document, NS, worklist.getUserAttributes()));
        }
        if (mailingClientWorklistConfig != null) {
            Element mailingConfigElement = document.createElementNS(NS, "mailingClientWorklist");
            this.fillWorklistUpdateConfigurationElement(document, mailingConfigElement, mailingClientWorklistConfig);
            worklistElement.appendChild(mailingConfigElement);
        }
        if (worklistConfiguration != null && worklistConfiguration.size() > 0) {
            worklistElement.appendChild(this.createWorklistConfigurationElement(document, worklistConfiguration));
        }
        return worklistElement;
    }

    private Element createWorklistConfigurationElement(Document document, Map<String, String> worklistConfiguration) {
        Element configElement = document.createElementNS(NS, "configurations");
        this.fillStringMapElement(document, configElement, "configuration", "name", worklistConfiguration);
        return configElement;
    }

    private void fillStringMapElement(Document document, Element mapElement, String tagName, String keyName, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Element eelement = document.createElementNS(NS, tagName);
            eelement.setAttributeNS(null, keyName, entry.getKey());
            eelement.setTextContent(entry.getValue());
            mapElement.appendChild(eelement);
        }
    }

    private void fillWorklistUpdateConfigurationElement(Document document, Element element, WorklistUpdateConfiguration mailingClientWorklistConfig) {
        WorklistModelXMLExport.addElement(document, element, "updateModeThreshold", Integer.toString(mailingClientWorklistConfig.getUpdateModeThreshold()));
        Element thresholds = WorklistModelXMLExport.addElement(document, element, "updateIntervalThresholds");
        int[] nArray = mailingClientWorklistConfig.getUpdateIntervalThresholds();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int priority = nArray[n2];
            Element threshold = WorklistModelXMLExport.addElement(document, thresholds, "threshold");
            threshold.setAttributeNS(null, "priority", Integer.toString(priority));
            threshold.setTextContent(Long.toString(mailingClientWorklistConfig.getUpdateInterval(priority)));
            ++n2;
        }
        if (mailingClientWorklistConfig.getUserAttributes().size() > 0) {
            element.appendChild(WorklistModelXMLExport.createUserAttributesElement(document, NS, mailingClientWorklistConfig.getUserAttributes()));
        }
    }

    private Element createWorklistItemElement(Document document, InternalWorklistItem worklistItem, EBPInstanceReference ebpInstanceReference) {
        Element worklistItemElement = document.createElementNS(NS, "worklistItem");
        worklistItemElement.setAttributeNS(null, "id", worklistItem.getID().toString());
        worklistItemElement.setAttributeNS(null, "version", "0");
        WorklistModelXMLExport.addElement(document, worklistItemElement, "title", worklistItem.getTitle());
        WorklistModelXMLExport.addElement(document, worklistItemElement, "description", worklistItem.getDescription());
        if (worklistItem.getIconID() != null) {
            WorklistModelXMLExport.addElement(document, worklistItemElement, "iconID", worklistItem.getIconID().toString());
        }
        WorklistModelXMLExport.addElement(document, worklistItemElement, "escalationHandlingProcedureID", worklistItem.getEscalationHandlingProcedureID());
        WorklistModelXMLExport.addElement(document, worklistItemElement, "escalationLevel", Integer.toString(worklistItem.getCurrentEscalationLevel()));
        WorklistModelXMLExport.addElement(document, worklistItemElement, "delegationHandlingProcedureID", worklistItem.getDelegationHandlingProcedureID());
        WorklistModelXMLExport.addElement(document, worklistItemElement, "delegationLevel", Integer.toString(worklistItem.getCurrentDelegationLevel()));
        WorklistModelXMLExport.addElement(document, worklistItemElement, "distributionHandlingProcedureID", worklistItem.getDistributionHandlingProcedureID());
        WorklistModelXMLExport.addElement(document, worklistItemElement, "processTemplateName", worklistItem.getProcessTemplateName());
        WorklistModelXMLExport.addElement(document, worklistItemElement, "processInstanceName", worklistItem.getProcessInstanceName());
        Element contextElement = this.createParameterDataContext(document, worklistItem.getAttachedDataContext());
        worklistItemElement.appendChild(contextElement);
        Element worklistIDsElement = WorklistModelXMLExport.addElement(document, worklistItemElement, "worklistIDs");
        UUID[] uUIDArray = worklistItem.getWorklistIDs();
        int n = uUIDArray.length;
        int n2 = 0;
        while (n2 < n) {
            UUID worklistID = uUIDArray[n2];
            WorklistModelXMLExport.addElement(document, worklistIDsElement, "worklistID", worklistID.toString());
            ++n2;
        }
        if (worklistItem.getAvailableStateWorklistIDs() != null) {
            Element availableStateWorklistIDsElement = WorklistModelXMLExport.addElement(document, worklistItemElement, "availableStateWorklistIDs");
            UUID[] uUIDArray2 = worklistItem.getAvailableStateWorklistIDs();
            int n3 = uUIDArray2.length;
            n = 0;
            while (n < n3) {
                UUID worklistID = uUIDArray2[n];
                WorklistModelXMLExport.addElement(document, availableStateWorklistIDsElement, "worklistID", worklistID.toString());
                ++n;
            }
            WorklistModelXMLExport.addElement(document, worklistItemElement, "availableStateDelegationIndex", Integer.toString(worklistItem.getAvailableStateDelegationIndex()));
        }
        if (worklistItem.getIndividualWorklistItemSettings().size() > 0) {
            Element settingsElement = WorklistModelXMLExport.addElement(document, worklistItemElement, "individualWorklistItemSettings");
            for (IndividualWorklistItemSettings setting : worklistItem.getIndividualWorklistItemSettings()) {
                settingsElement.appendChild(this.createIndividualWorklistItemSettingsElement(document, setting));
            }
        }
        WorklistModelXMLExport.addElement(document, worklistItemElement, "priority", Integer.toString(worklistItem.getPriority()));
        WorklistModelXMLExport.addElement(document, worklistItemElement, "complexity", Long.toString(worklistItem.getComplexity()));
        WorklistModelXMLExport.addElement(document, worklistItemElement, "activationDate", Long.toString(worklistItem.getActivationDate()));
        WorklistModelXMLExport.addElement(document, worklistItemElement, "escalationDate", Long.toString(worklistItem.getEscalationDate()));
        WorklistModelXMLExport.addElement(document, worklistItemElement, "dueDate", Long.toString(worklistItem.getDueDate()));
        WorklistModelXMLExport.addElement(document, worklistItemElement, "assignmentDate", Long.toString(worklistItem.getAssignmentDate()));
        worklistItemElement.appendChild(XMLExportTools.createEBPInstanceReferenceElement(document, NS, ebpInstanceReference, false));
        if (worklistItem.getDelegationHistory().size() > 0) {
            worklistItemElement.appendChild(this.createDelegationHistoryElement(document, worklistItem.getDelegationHistory()));
        }
        if (worklistItem.getSupportedPlugins().size() > 0) {
            worklistItemElement.appendChild(WorklistModelXMLExport.createPluginDataContainerElement(document, NS, worklistItem));
        }
        if (worklistItem.getUserAttributes().size() > 0) {
            worklistItemElement.appendChild(WorklistModelXMLExport.createUserAttributesElement(document, NS, worklistItem.getUserAttributes()));
        }
        return worklistItemElement;
    }

    private Node createIndividualWorklistItemSettingsElement(Document document, IndividualWorklistItemSettings settings) {
        Element settingsElement = document.createElementNS(NS, "individualWorklistItemSetting");
        settingsElement.setAttributeNS(null, "id", settings.getWorklistID().toString());
        if (settings.getIndividualTitle() != null) {
            WorklistModelXMLExport.addElement(document, settingsElement, "individualTitle", settings.getIndividualTitle());
        }
        if (settings.getDescription() != null) {
            WorklistModelXMLExport.addElement(document, settingsElement, "description", settings.getDescription());
        }
        WorklistModelXMLExport.addElement(document, settingsElement, "escalationDate", Long.toString(settings.getIndividualEscalationDate()));
        WorklistModelXMLExport.addElement(document, settingsElement, "dueDate", Long.toString(settings.getIndividualDueDate()));
        if (settings.getIndividualEscalationHandlingProcedureID() != null) {
            WorklistModelXMLExport.addElement(document, settingsElement, "dueDateEscalationID", settings.getIndividualEscalationHandlingProcedureID());
        }
        WorklistModelXMLExport.addElement(document, settingsElement, "priority", Integer.toString(settings.getIndividualPriority()));
        WorklistModelXMLExport.addElement(document, settingsElement, "resubmissionDate", Long.toString(settings.getResubmissionDate()));
        if (settings.getSupportedPlugins().size() > 0) {
            settingsElement.appendChild(WorklistModelXMLExport.createPluginDataContainerElement(document, NS, settings));
        }
        if (settings.getUserAttributes().size() > 0) {
            settingsElement.appendChild(WorklistModelXMLExport.createUserAttributesElement(document, NS, settings.getUserAttributes()));
        }
        return settingsElement;
    }

    private Element createQualifiedAgentElement(Document document, QualifiedAgent agent) {
        Element qualifiedAgentElement = document.createElementNS(NS, "qualifiedAgent");
        WorklistModelXMLExport.fillQualifiedAgentElement(document, NS, qualifiedAgentElement, agent);
        return qualifiedAgentElement;
    }

    private Element createParameterDataContext(Document document, ParameterDataContext context) {
        Element contextElement = document.createElementNS(NS, "parameterDataContext");
        for (String name : context.getParameters().keySet()) {
            Element parameterElement = this.createParameterElement(document, name, context);
            contextElement.appendChild(parameterElement);
        }
        return contextElement;
    }

    private Node createDelegationHistoryElement(Document document, List<WorklistItem.Delegation> delegations) {
        Element delHistElem = document.createElementNS(NS, "delegationHistory");
        for (WorklistItem.Delegation del : delegations) {
            Element delElem = document.createElementNS(NS, "delegation");
            Element delegatorElem = WorklistModelXMLExport.addElement(document, delElem, "delegator");
            WorklistModelXMLExport.fillQualifiedAgentElement(document, NS, delegatorElem, del.getDelegator());
            for (QualifiedAgent recipient : del.getRecipients()) {
                Element recipientElem = WorklistModelXMLExport.addElement(document, delElem, "recipients");
                WorklistModelXMLExport.fillQualifiedAgentElement(document, NS, recipientElem, recipient);
            }
            if (del.getComment() != null) {
                WorklistModelXMLExport.addElement(document, delElem, "comment", del.getComment());
            }
            delHistElem.appendChild(delElem);
        }
        return delHistElem;
    }

    private Element createSupportedPlugins(Document document, Map<String, Set<String>> plugins) {
        Element supportedPluginsElement = document.createElementNS(NS, "supportedPlugins");
        for (Map.Entry<String, Set<String>> extensionPointEntry : plugins.entrySet()) {
            Element extensionPointElement = this.createExtensionPointElement(document, extensionPointEntry.getKey(), extensionPointEntry.getValue());
            supportedPluginsElement.appendChild(extensionPointElement);
        }
        return supportedPluginsElement;
    }

    private Element createPluginDatas(Document document, Map<String, PluginData> pluginDatas) {
        Element pluginDatasElement = document.createElementNS(NS, "pluginDatas");
        for (Map.Entry<String, PluginData> pluginEntry : pluginDatas.entrySet()) {
            Element pluginElement = this.createPluginElement(document, pluginEntry.getKey(), pluginEntry.getValue());
            pluginDatasElement.appendChild(pluginElement);
        }
        return pluginDatasElement;
    }

    private Element createParameterElement(Document document, String name, ParameterDataContext context) {
        Element element = document.createElementNS(NS, "parameter");
        ProcessConstants.AdeptDataType adt = context.getParameters().get(name);
        String type = adt.toString();
        String value = null;
        element.setAttributeNS(null, "parameterName", name);
        element.setAttributeNS(null, "parameterType", type);
        try {
            if (!context.isNull(name)) {
                switch (adt) {
                    case BOOLEAN: {
                        boolean bool = context.retrieveBooleanParameterValue(name);
                        value = Boolean.valueOf(bool).toString();
                        break;
                    }
                    case DATE: {
                        Date date = context.retrieveDateParameterValue(name);
                        value = Long.valueOf(date.getTime()).toString();
                        break;
                    }
                    case FLOAT: {
                        double doub = context.retrieveFloatParameterValue(name);
                        value = Double.valueOf(doub).toString();
                        break;
                    }
                    case INTEGER: {
                        long num = context.retrieveIntegerParameterValue(name);
                        value = Long.valueOf(num).toString();
                        break;
                    }
                    case STRING: {
                        value = context.retrieveStringParameterValue(name);
                        break;
                    }
                    case URI: {
                        URI uri = context.retrieveURIParameterValue(name);
                        value = uri.toString();
                        break;
                    }
                    case USERDEFINED: {
                        UDTValue udt = context.retrieveUDTParameterValue(name);
                        value = Base64.encodeBytes(udt.getValueAsArray(), 2);
                        element.setAttributeNS(null, "parameterUDT", udt.getUserDefinedType());
                        break;
                    }
                    default: {
                        String msg = String.format("Unsupported data type '%s'!", new Object[]{adt});
                        this.logger.warning(msg);
                        break;
                    }
                }
            }
        }
        catch (InvalidDataTypeException e) {
            String msg = String.format("Error with XML representation of parameter '%s' in the storage: The data type '%s' is invalid.", name, type);
            this.logger.log(Level.WARNING, msg, e);
        }
        catch (NoSuchParameterException e) {
            String msg = String.format("Error with XML representation of parameter '%s' in the storage: The parameter does not exist.", name);
            this.logger.log(Level.WARNING, msg, e);
        }
        if (value != null) {
            element.setTextContent(value);
        } else {
            element.setAttributeNS(null, "isNull", "true");
        }
        return element;
    }

    private Element createExtensionPointElement(Document document, String extensionPointID, Set<String> plugins) {
        Element extensionPointElemenet = document.createElementNS(NS, "extensionPoint");
        extensionPointElemenet.setTextContent(extensionPointID);
        for (String pluginID : plugins) {
            Element pluginElement = document.createElementNS(NS, "plugin");
            pluginElement.setTextContent(pluginID);
            extensionPointElemenet.appendChild(pluginElement);
        }
        return extensionPointElemenet;
    }

    private Element createPluginElement(Document document, String pluginID, PluginData pluginData) {
        Element pluginElement = document.createElementNS(NS, "plugin");
        pluginElement.setTextContent(pluginID);
        for (String key : pluginData.getPluginData().keySet()) {
            Element pluginDataElement = document.createElementNS(NS, "pluginData");
            pluginDataElement.setTextContent(key);
            pluginDataElement.setAttributeNS(null, "value", pluginData.getPluginDataEntry(key));
            pluginElement.appendChild(pluginDataElement);
        }
        return pluginElement;
    }

    private Element createConfigurationsElement(Document document, Map<String, String> configs) {
        Element confElement = document.createElementNS(NS, "configurations");
        if (configs == null) {
            return confElement;
        }
        for (String key : WorklistModelXMLExport.sortedKeySet(configs.keySet())) {
            confElement.appendChild(this.createWorklistConfigElement(document, key, configs.get(key)));
        }
        return confElement;
    }

    private Element createWorklistConfigElement(Document document, String key, String value) {
        Element confElement = document.createElementNS(NS, "configuration");
        confElement.setAttributeNS(null, "name", key);
        confElement.setTextContent(value);
        return confElement;
    }

    private static Element addElement(Document document, Element parent, String type) {
        return WorklistModelXMLExport.addElement(document, NS, parent, type);
    }

    private static void addElement(Document document, Element parent, String type, String textContent) {
        WorklistModelXMLExport.addElement(document, NS, parent, type, textContent);
    }
}

