/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel.xml;

import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLConstants;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public abstract class WorklistModelXMLHelperTools {
    protected static final Logger logger = LoggerTools.getLogger(WorklistModelXMLHelperTools.class);
    private static volatile Schema worklistSchema;
    private static volatile Schema worklistItemSchema;
    private static volatile Schema ebpInstanceReferenceSchema;
    private static volatile Schema clientsSchema;

    public static Schema getSchema(WorklistModelXMLConstants.SchemaType schemaType) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            switch (schemaType) {
                case NO_SCHEMA: {
                    break;
                }
                case WORKLIST: {
                    if (worklistSchema == null) {
                        worklistSchema = schemaFactory.newSchema(WorklistModelXMLHelperTools.class.getResource("worklist.xsd"));
                    }
                    schema = worklistSchema;
                    break;
                }
                case WORKLIST_ITEM: {
                    if (worklistItemSchema == null) {
                        worklistItemSchema = schemaFactory.newSchema(WorklistModelXMLHelperTools.class.getResource("worklistItem.xsd"));
                    }
                    schema = worklistItemSchema;
                    break;
                }
                case EBP_INSTANCE_REFERENCE: {
                    if (ebpInstanceReferenceSchema == null) {
                        ebpInstanceReferenceSchema = schemaFactory.newSchema(WorklistModelXMLHelperTools.class.getResource("worklistItem.xsd"));
                    }
                    schema = ebpInstanceReferenceSchema;
                    break;
                }
                case CLIENTS: {
                    if (clientsSchema == null) {
                        clientsSchema = schemaFactory.newSchema(WorklistModelXMLHelperTools.class.getResource("clients.xsd"));
                    }
                    schema = clientsSchema;
                    break;
                }
                default: {
                    String msg = String.format("Unsupported schema type '%s'!", new Object[]{schemaType});
                    logger.warning(msg);
                    break;
                }
            }
        }
        catch (SAXException e) {
            String message = "WorklistModelXMLHelperTools::getSchema: Error parsing the schema file!";
            logger.severe(message);
            throw new RuntimeException(message, e);
        }
        return schema;
    }
}

