/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.worklistmodel.xml;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.XMLImportTools;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.execution.defaultimplementation.DefaultParameterDataContext;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.IndividualWorklistItemSettings;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistFilters;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.model.worklistmodel.defaultimplementation.DefaultInternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLConstants;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLHelperTools;
import de.aristaflow.adept2.util.Base64;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WorklistModelXMLImport
extends XMLImportTools
implements ErrorHandler {
    protected final Logger logger;
    private final WorklistModelFactory factory;
    private final FilterFactory filterFactory;

    public WorklistModelXMLImport(WorklistModelFactory factory, FilterFactory filterFactory) {
        this.factory = factory;
        this.filterFactory = filterFactory;
        this.logger = LoggerTools.getLogger(this);
    }

    public InternalWorklist<InternalWorklistItem> getWorklistFromFile(File file) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile(file, null, null);
        this.validateWorklistFormatVersion(document);
        XMLHelperTools.validateDoc(document, WorklistModelXMLHelperTools.getSchema(WorklistModelXMLConstants.SchemaType.WORKLIST));
        return this.getWorklistFromDocument(document);
    }

    public InternalWorklist<InternalWorklistItem> getWorklistFromDocument(Document document) {
        Element root = document.getDocumentElement();
        return this.getWorklist(this.factory, root);
    }

    public Map<String, String> getWorklistConfigurationsFromFile(File file) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile(file, null, null);
        this.validateWorklistFormatVersion(document);
        XMLHelperTools.validateDoc(document, WorklistModelXMLHelperTools.getSchema(WorklistModelXMLConstants.SchemaType.WORKLIST));
        return this.getWorklistConfigurationFromWorklistElement(document.getDocumentElement());
    }

    public Map<String, String> getWorklistConfigurationFromInputStream(InputStream stream) {
        Document doc;
        HashMap<String, String> res = new HashMap<String, String>();
        try {
            InputStream checkedStream = this.checkStreamForData(stream);
            if (checkedStream == null) {
                return res;
            }
            doc = XMLHelperTools.getDocumentFromStream(checkedStream);
        }
        catch (XMLFormatException xMLFormatException) {
            return res;
        }
        catch (IOException iOException) {
            return res;
        }
        Element root = doc.getDocumentElement();
        if (!root.getTagName().equals("configurations")) {
            return res;
        }
        return this.getWorklistConfiguration(root);
    }

    @Deprecated
    public Map<String, String> getWorklistConfigurationFromDocument(Document document) {
        return this.getWorklistConfiguration(document.getDocumentElement());
    }

    public WorklistUpdateConfiguration getMailingWorklistConfigurationFromFile(File file) throws XMLFormatException, VersionException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile(file, null, null);
        this.validateWorklistFormatVersion(document);
        XMLHelperTools.validateDoc(document, WorklistModelXMLHelperTools.getSchema(WorklistModelXMLConstants.SchemaType.WORKLIST));
        return this.getMailingWorklistConfigurationFromDocument(document);
    }

    public WorklistUpdateConfiguration getMailingWorklistConfigurationFromDocument(Document document) {
        Element root = document.getDocumentElement();
        return this.getMailingWorklistConfigurationFromWorklistElement(this.factory, root);
    }

    public InternalWorklistItem getWorklistItemFromFile(File file, ActivityReference activityReference, String staffAssignmentRule, WorklistConstants.WorklistItemState worklistItemState, QualifiedAgent assignedAgent) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile(file, null, null);
        this.validateWorklistItemFormatVersion(document);
        XMLHelperTools.validateDoc(document, WorklistModelXMLHelperTools.getSchema(WorklistModelXMLConstants.SchemaType.WORKLIST_ITEM));
        return this.getWorklistItemFromDocument(document, activityReference, staffAssignmentRule, worklistItemState, assignedAgent);
    }

    public InternalWorklistItem getWorklistItemFromDocument(Document document, ActivityReference activityReference, String staffAssignmentRule, WorklistConstants.WorklistItemState worklistItemState, QualifiedAgent assignedAgent) {
        Element root = document.getDocumentElement();
        return this.getWorklistItem(this.factory, root, activityReference, staffAssignmentRule, worklistItemState, assignedAgent);
    }

    public EBPInstanceReference getEBPInstanceReferenceFromWorklistItemFile(File file) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile(file, null, null);
        this.validateWorklistItemFormatVersion(document);
        XMLHelperTools.validateDoc(document, WorklistModelXMLHelperTools.getSchema(WorklistModelXMLConstants.SchemaType.EBP_INSTANCE_REFERENCE));
        return this.getEBPInstanceReferenceFromWorklistItemDocument(document);
    }

    public EBPInstanceReference getEBPInstanceReferenceFromWorklistItemDocument(Document document) {
        Element root = document.getDocumentElement();
        return this.getEBPInstanceReferenceFromWorklistItemElement(this.factory, root);
    }

    public Map<String, String> getStringMapFromInputStream(InputStream stream) {
        Document doc;
        HashMap<String, String> res = new HashMap<String, String>();
        try {
            InputStream checkedStream = this.checkStreamForData(stream);
            if (checkedStream == null) {
                return res;
            }
            doc = XMLHelperTools.getDocumentFromStream(checkedStream);
        }
        catch (XMLFormatException xMLFormatException) {
            return res;
        }
        catch (IOException iOException) {
            return res;
        }
        Element root = doc.getDocumentElement();
        if (!root.getTagName().equals("userAttributes")) {
            return res;
        }
        return WorklistModelXMLImport.getUserAttributes(root);
    }

    public ParameterDataContext getParameterDataContextFromInputStream(InputStream stream) {
        String msg = "Error while restoring the parameter data context of a worklist item";
        try {
            InputStream checkedStream = this.checkStreamForData(stream);
            if (checkedStream != null) {
                Document doc = XMLHelperTools.getDocumentFromStream(checkedStream);
                Element root = doc.getDocumentElement();
                return this.getParameterDataContext(root);
            }
        }
        catch (XMLFormatException e) {
            this.logger.log(Level.WARNING, msg, e);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, msg, e);
        }
        return new DefaultParameterDataContext(new HashMap<String, ProcessConstants.AdeptDataType>(), new HashMap<String, Serializable>());
    }

    public URI[] getURIsFromInputStream(InputStream stream) {
        String msg = "Error while restoring the URIs of an activity reference.";
        try {
            InputStream checkedStream = this.checkStreamForData(stream);
            if (checkedStream != null) {
                Document doc = XMLHelperTools.getDocumentFromStream(checkedStream);
                Element root = doc.getDocumentElement();
                return WorklistModelXMLImport.getURIs(root);
            }
        }
        catch (XMLFormatException e) {
            this.logger.log(Level.WARNING, msg, e);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, msg, e);
        }
        return new URI[0];
    }

    public Map<String, Set<String>> getSupportedPluginsFromStream(InputStream stream) {
        try {
            InputStream checkedStream = this.checkStreamForData(stream);
            if (checkedStream != null) {
                Document doc = XMLHelperTools.getDocumentFromStream(checkedStream);
                Element root = doc.getDocumentElement();
                return this.getSupportedPlugins(root);
            }
        }
        catch (XMLFormatException xMLFormatException) {
            this.logger.warning("error while restoring the supported plugins of an individual worklist item setting");
        }
        catch (IOException iOException) {
            this.logger.warning("error while restoring the supported plugins of an individual worklist item setting");
        }
        return new HashMap<String, Set<String>>();
    }

    public Map<String, PluginData> getPluginDatasFromStream(InputStream stream) {
        try {
            InputStream checkedStream = this.checkStreamForData(stream);
            if (checkedStream != null) {
                Document doc = XMLHelperTools.getDocumentFromStream(checkedStream);
                Element root = doc.getDocumentElement();
                return this.getPluginDatas(root);
            }
        }
        catch (XMLFormatException xMLFormatException) {
            this.logger.warning("error while restoring the supported plugins of an individual worklist item setting");
        }
        catch (IOException iOException) {
            this.logger.warning("error while restoring the supported plugins of an individual worklist item setting");
        }
        return new HashMap<String, PluginData>();
    }

    public List<URI[]> getClientsFromAgentFile(File file) throws VersionException, XMLFormatException, IOException {
        Document document = XMLHelperTools.getDocumentFromFile(file, null, null);
        this.validateClientsFormatVersion(document);
        XMLHelperTools.validateDoc(document, WorklistModelXMLHelperTools.getSchema(WorklistModelXMLConstants.SchemaType.CLIENTS));
        return this.getClientsFromAgentDocument(document);
    }

    public List<URI[]> getClientsFromAgentDocument(Document document) {
        Element root = document.getDocumentElement();
        return this.getClientsFromAgentElement(root);
    }

    private List<URI[]> getClientsFromAgentElement(Element clientsElement) {
        NodeList nodeList = clientsElement.getElementsByTagName("clientURIs");
        if (nodeList.getLength() != 1) {
            this.logger.info("Found " + nodeList.getLength() + " clients elements,expected 1!");
            return null;
        }
        Element clientURIsElement = WorklistModelXMLImport.getElement(nodeList.item(0));
        List<URI[]> result = this.getClientsURIs(clientURIsElement);
        return result;
    }

    private List<URI[]> getClientsURIs(Element clientURIsElement) {
        Element child = WorklistModelXMLImport.getElement(clientURIsElement.getFirstChild());
        ArrayList<URI[]> result = new ArrayList<URI[]>();
        while (child != null && child.getTagName().equals("client")) {
            result.add(WorklistModelXMLImport.getURIs(child));
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        return result;
    }

    private EBPInstanceReference getEBPInstanceReferenceFromWorklistItemElement(WorklistModelFactory factory, Element worklistItemElement) {
        NodeList nodeList = worklistItemElement.getElementsByTagName("ebpInstanceReference");
        if (nodeList.getLength() != 1) {
            this.logger.info("Found " + nodeList.getLength() + " EBPInstanceReference elements, expected 1!");
            return null;
        }
        Element ebpElement = WorklistModelXMLImport.getElement(nodeList.item(0));
        return XMLImportTools.getEBPInstanceReference(ebpElement);
    }

    private InternalWorklist<InternalWorklistItem> getWorklist(WorklistModelFactory factory, Element worklistElement) {
        String substitutionRule = "";
        long absenceFrom = -1L;
        long absenceTo = -1L;
        HashMap<String, String> userAttributes = new HashMap();
        UUID worklistID = UUID.fromString(worklistElement.getAttribute("id"));
        Element child = WorklistModelXMLImport.getElement(worklistElement.getFirstChild());
        QualifiedAgent agent = WorklistModelXMLImport.getQualifiedAgent(child);
        if ((child = WorklistModelXMLImport.getElement(child.getNextSibling())) != null && child.getTagName().equals("substitutionRule")) {
            substitutionRule = child.getTextContent();
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("absenceFrom")) {
            absenceFrom = Long.parseLong(child.getTextContent());
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("absenceTo")) {
            absenceTo = Long.parseLong(child.getTextContent());
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("userAttributes")) {
            userAttributes = WorklistModelXMLImport.getUserAttributes(child);
        }
        return factory.createInternalWorklist(worklistID, agent, 0L, new ArrayList<InternalWorklistItem>(), substitutionRule, absenceFrom, absenceTo, userAttributes);
    }

    private Map<String, String> getWorklistConfigurationFromWorklistElement(Element root) {
        NodeList nodeList = root.getElementsByTagName("configurations");
        if (nodeList.getLength() > 1) {
            this.logger.info("Found " + nodeList.getLength() + " Configuration elements, expected 1!");
            return null;
        }
        if (nodeList.getLength() == 0) {
            return new HashMap<String, String>();
        }
        Element configElement = WorklistModelXMLImport.getElement(nodeList.item(0));
        return this.getWorklistConfiguration(configElement);
    }

    private Map<String, String> getWorklistConfiguration(Element configElement) {
        Element child = WorklistModelXMLImport.getElement(configElement.getFirstChild());
        HashMap<String, String> result = new HashMap<String, String>();
        while (child != null && child.getTagName().equals("configuration")) {
            String key = child.getAttribute("name");
            String value = child.getTextContent();
            result.put(key, value);
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        return result;
    }

    private WorklistUpdateConfiguration getMailingWorklistConfigurationFromWorklistElement(WorklistModelFactory factory, Element root) {
        NodeList nodeList = root.getElementsByTagName("mailingClientWorklist");
        if (nodeList.getLength() > 1) {
            this.logger.info("Found " + nodeList.getLength() + " Configuration elements,expected 1!");
            return null;
        }
        if (nodeList.getLength() == 0) {
            return null;
        }
        Element configElement = WorklistModelXMLImport.getElement(nodeList.item(0));
        return this.getWorklistUpdateConfiguration(factory, configElement);
    }

    private WorklistUpdateConfiguration getWorklistUpdateConfiguration(WorklistModelFactory factory, Element configElement) {
        HashMap<Integer, Long> updateInterval = new HashMap();
        HashMap<String, String> userAttributes = new HashMap();
        Element child = WorklistModelXMLImport.getElement(configElement.getFirstChild());
        int updateModeThreshold = Integer.valueOf(child.getTextContent());
        if ((child = WorklistModelXMLImport.getElement(child.getNextSibling())) != null && child.getTagName().equals("updateIntervalThresholds")) {
            updateInterval = this.getUpdateIntervallThresolds(child);
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("userAttributes")) {
            userAttributes = WorklistModelXMLImport.getUserAttributes(child);
        }
        Filter filter = WorklistFilters.noTopLevelInstances(this.filterFactory);
        return factory.createWorklistConfiguration(updateModeThreshold, updateInterval, filter, userAttributes);
    }

    private Map<Integer, Long> getUpdateIntervallThresolds(Element element) {
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        Element child = WorklistModelXMLImport.getElement(element.getFirstChild());
        while (child != null && child.getTagName().equals("threshold")) {
            Integer priority = Integer.valueOf(child.getAttribute("priority"));
            Long updateInterval = Long.valueOf(child.getTextContent());
            result.put(priority, updateInterval);
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        return result;
    }

    private void validateWorklistFormatVersion(Document worklist) throws VersionException {
        String version = this.getWorklistVersion(worklist.getDocumentElement());
        if (!"0".equals(version)) {
            throw new VersionException("The worklist item format version is too old and can not be read. Please use the converter to update your worklist item to the actual version.");
        }
    }

    private void validateClientsFormatVersion(Document clients) throws VersionException {
        String version = this.getClientsVersion(clients.getDocumentElement());
        if (!"0".equals(version)) {
            throw new VersionException("The clientformat version is too old and can not be read. Please use the converter to update your client to the actual version.");
        }
    }

    private void validateWorklistItemFormatVersion(Document worklist) throws VersionException {
        String version = this.getWorklistItemVersion(worklist.getDocumentElement());
        if (!"0".equals(version)) {
            throw new VersionException("The worklist item format version is too old and can not be read. Please use the converter to update your worklist item to the actual version.");
        }
    }

    private String getWorklistItemVersion(Element documentElement) {
        if (documentElement.hasAttribute("version")) {
            return documentElement.getAttribute("version");
        }
        return "";
    }

    private String getClientsVersion(Element documentElement) {
        if (documentElement.hasAttribute("version")) {
            return documentElement.getAttribute("version");
        }
        return "";
    }

    private String getWorklistVersion(Element documentElement) {
        if (documentElement.hasAttribute("version")) {
            return documentElement.getAttribute("version");
        }
        return "";
    }

    private InternalWorklistItem getWorklistItem(WorklistModelFactory factory, Element worklistItemElement, ActivityReference activityReference, String staffAssignmentRule, WorklistConstants.WorklistItemState worklistItemState, QualifiedAgent assignedAgent) {
        UUID iconID = null;
        int escalationLevel = 0;
        int delegationLevel = 0;
        int availableStateDelegationIndex = -1;
        UUID[] availableStateWorklistIDs = null;
        HashSet<IndividualWorklistItemSettings> itemSettings = new HashSet();
        ArrayList<WorklistItem.Delegation> delegationHistory = new ArrayList();
        HashMap<String, Set<String>> supportedPlugins = new HashMap();
        HashMap<String, PluginData> pluginDatas = new HashMap();
        HashMap<String, String> userAttributes = new HashMap();
        UUID id = UUID.fromString(worklistItemElement.getAttribute("id"));
        Element child = WorklistModelXMLImport.getElement(worklistItemElement.getFirstChild());
        String title = child.getTextContent();
        child = WorklistModelXMLImport.getElement(child.getNextSibling());
        String description = child.getTextContent();
        if (XMLHelperTools.hasTagName(child = WorklistModelXMLImport.getElement(child.getNextSibling()), "iconID")) {
            iconID = UUID.fromString(child.getTextContent());
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        String escalationHandlingProcedureID = child.getTextContent();
        if (XMLHelperTools.hasTagName(child = WorklistModelXMLImport.getElement(child.getNextSibling()), "escalationLevel")) {
            escalationLevel = Integer.parseInt(child.getTextContent());
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        String delegationHandlingProcedureID = child.getTextContent();
        if (XMLHelperTools.hasTagName(child = WorklistModelXMLImport.getElement(child.getNextSibling()), "delegationLevel")) {
            delegationLevel = Integer.parseInt(child.getTextContent());
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        String distributionHandlingProcedureID = child.getTextContent();
        child = WorklistModelXMLImport.getElement(child.getNextSibling());
        String processTemplateName = child.getTextContent();
        child = WorklistModelXMLImport.getElement(child.getNextSibling());
        String processInstanceName = child.getTextContent();
        child = WorklistModelXMLImport.getElement(child.getNextSibling());
        ParameterDataContext parameterDataContext = this.getParameterDataContext(child);
        child = WorklistModelXMLImport.getElement(child.getNextSibling());
        UUID[] worklistIDs = this.getWorklistIDs(child);
        if (XMLHelperTools.hasTagName(child = WorklistModelXMLImport.getElement(child.getNextSibling()), "availableStateWorklistIDs")) {
            availableStateWorklistIDs = this.getWorklistIDs(child);
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        if (XMLHelperTools.hasTagName(child, "availableStateDelegationIndex")) {
            availableStateDelegationIndex = Integer.parseInt(child.getTextContent());
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        if (XMLHelperTools.hasTagName(child, "individualWorklistItemSettings")) {
            itemSettings = this.getIndividualWorklistItemSettings(factory, child);
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        int priority = Integer.parseInt(child.getTextContent());
        child = WorklistModelXMLImport.getElement(child.getNextSibling());
        long complexity = Long.parseLong(child.getTextContent());
        child = WorklistModelXMLImport.getElement(child.getNextSibling());
        long activationDate = Long.parseLong(child.getTextContent());
        child = WorklistModelXMLImport.getElement(child.getNextSibling());
        long escalationDate = Long.parseLong(child.getTextContent());
        child = WorklistModelXMLImport.getElement(child.getNextSibling());
        long dueDate = Long.parseLong(child.getTextContent());
        child = WorklistModelXMLImport.getElement(child.getNextSibling());
        long assignmentDate = Long.parseLong(child.getTextContent());
        child = WorklistModelXMLImport.getElement(child.getNextSibling());
        if ((child = WorklistModelXMLImport.getElement(child.getNextSibling())) != null && XMLHelperTools.hasTagName(child, "delegationHistory")) {
            delegationHistory = this.getDelegationHistory(child);
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        if (child != null && XMLHelperTools.hasTagName(child, "pluginDataContainer")) {
            PluginDataContainer pdc = WorklistModelXMLImport.getPluginDataContainer(factory, child);
            supportedPlugins = pdc.getSupportedPlugins();
            pluginDatas = pdc.getPluginDatas();
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        if (child != null && XMLHelperTools.hasTagName(child, "userAttributes")) {
            userAttributes = WorklistModelXMLImport.getUserAttributes(child);
        }
        return factory.createInternalWorklistItem(id, title, description, activityReference, iconID, staffAssignmentRule, worklistItemState, worklistIDs, availableStateWorklistIDs, availableStateDelegationIndex, itemSettings, priority, complexity, activationDate, assignmentDate, assignedAgent, escalationDate, dueDate, escalationLevel, escalationHandlingProcedureID, delegationLevel, delegationHandlingProcedureID, delegationHistory, null, new ArrayList<Enquiry>(), distributionHandlingProcedureID, processTemplateName, processInstanceName, supportedPlugins, pluginDatas, parameterDataContext, userAttributes);
    }

    private Set<IndividualWorklistItemSettings> getIndividualWorklistItemSettings(WorklistModelFactory factory, Element settingsElement) {
        Element child = WorklistModelXMLImport.getElement(settingsElement.getFirstChild());
        HashSet<IndividualWorklistItemSettings> result = new HashSet<IndividualWorklistItemSettings>();
        while (child != null && child.getTagName().equals("individualWorklistItemSetting")) {
            result.add(this.getIndividualWorklistItemSetting(factory, child));
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        return result;
    }

    private IndividualWorklistItemSettings getIndividualWorklistItemSetting(WorklistModelFactory factory, Element settingElement) {
        String title = null;
        String description = null;
        String individualDueDateEscalationID = null;
        HashMap<String, Set<String>> supportedPlugins = new HashMap();
        Map<String, PluginData> pluginDatas = new HashMap<String, PluginData>();
        HashMap<String, String> userAttributes = new HashMap();
        UUID worklistID = UUID.fromString(settingElement.getAttribute("id"));
        Element child = WorklistModelXMLImport.getElement(settingElement.getFirstChild());
        if (child.getTagName().equals("individualTitle")) {
            title = child.getTextContent();
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        if (child.getTagName().equals("description")) {
            description = child.getTextContent();
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        long individualEscalationDate = Long.parseLong(child.getTextContent());
        child = WorklistModelXMLImport.getElement(child.getNextSibling());
        long individualDueDate = Long.parseLong(child.getTextContent());
        if ((child = WorklistModelXMLImport.getElement(child.getNextSibling())).getTagName().equals("dueDateEscalationID")) {
            individualDueDateEscalationID = child.getTextContent();
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        int individualPriority = Integer.parseInt(child.getTextContent());
        child = WorklistModelXMLImport.getElement(child.getNextSibling());
        long resubmissionDate = Long.parseLong(child.getTextContent());
        if ((child = WorklistModelXMLImport.getElement(child.getNextSibling())) != null && child.getTagName().equals("pluginDataContainer")) {
            PluginDataContainer pdc = WorklistModelXMLImport.getPluginDataContainer(factory, child);
            supportedPlugins = pdc.getSupportedPlugins();
            pluginDatas = pdc.getPluginDatas();
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        if (child != null && child.getTagName().equals("userAttributes")) {
            userAttributes = WorklistModelXMLImport.getUserAttributes(child);
        }
        return factory.createIndividualWorklistItemSettings(worklistID, title, description, individualEscalationDate, individualDueDate, individualDueDateEscalationID, individualPriority, resubmissionDate, supportedPlugins, pluginDatas, userAttributes);
    }

    private UUID[] getWorklistIDs(Element uuids) {
        Element child = WorklistModelXMLImport.getElement(uuids.getFirstChild());
        ArrayList<UUID> worklistIDs = new ArrayList<UUID>();
        while (child != null && child.getTagName().equals("worklistID")) {
            worklistIDs.add(UUID.fromString(child.getTextContent()));
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        return worklistIDs.toArray(new UUID[worklistIDs.size()]);
    }

    private ParameterDataContext getParameterDataContext(Element element) {
        HashMap<String, ProcessConstants.AdeptDataType> types = new HashMap<String, ProcessConstants.AdeptDataType>();
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        Element child = WorklistModelXMLImport.getElement(element.getFirstChild());
        while (child != null) {
            String name = child.getAttribute("parameterName");
            String typeAttr = child.getAttribute("parameterType");
            ProcessConstants.AdeptDataType type = ProcessConstants.AdeptDataType.valueOf(typeAttr);
            Serializable value = this.getParameterValue(type, child);
            types.put(name, type);
            values.put(name, value);
            child = WorklistModelXMLImport.getElement(child.getNextSibling());
        }
        return new DefaultParameterDataContext(types, values);
    }

    private ArrayList<WorklistItem.Delegation> getDelegationHistory(Element child) {
        ArrayList<WorklistItem.Delegation> delegationHistory = new ArrayList<WorklistItem.Delegation>();
        Element delElem = WorklistModelXMLImport.getElement(child.getFirstChild());
        while (delElem != null) {
            Element delegatorElem = WorklistModelXMLImport.getElement(delElem.getFirstChild());
            QualifiedAgent delgator = WorklistModelXMLImport.getQualifiedAgent(delegatorElem);
            Element element = WorklistModelXMLImport.getElement(delegatorElem.getNextSibling());
            HashSet<QualifiedAgent> recipients = new HashSet<QualifiedAgent>();
            while (element.getTagName().equals("recipients")) {
                recipients.add(WorklistModelXMLImport.getQualifiedAgent(element));
                element = WorklistModelXMLImport.getElement(element.getNextSibling());
            }
            String comment = null;
            if (element.getTagName().equals("comment")) {
                comment = element.getTextContent();
            }
            DefaultInternalWorklistItem.DefaultDelegation del = new DefaultInternalWorklistItem.DefaultDelegation(delgator, recipients, comment);
            delegationHistory.add(del);
            delElem = WorklistModelXMLImport.getElement(delElem.getNextSibling());
        }
        return delegationHistory;
    }

    private Map<String, Set<String>> getSupportedPlugins(Element element) {
        Element extensionPoint = WorklistModelXMLImport.getElement(element.getFirstChild());
        HashMap<String, Set<String>> res = new HashMap<String, Set<String>>();
        while (extensionPoint != null) {
            String name = extensionPoint.getFirstChild().getTextContent();
            if (!res.containsKey(name)) {
                res.put(name, new HashSet());
            }
            NodeList childs = extensionPoint.getElementsByTagName("plugin");
            int i = 0;
            while (i < childs.getLength()) {
                String pluginID = childs.item(i).getFirstChild().getTextContent();
                ((Set)res.get(name)).add(pluginID);
                ++i;
            }
            extensionPoint = WorklistModelXMLImport.getElement(extensionPoint.getNextSibling());
        }
        return res;
    }

    private Map<String, PluginData> getPluginDatas(Element element) {
        HashMap<String, PluginData> res = new HashMap<String, PluginData>();
        NodeList plugins = element.getElementsByTagName("plugin");
        int i = 0;
        while (i < plugins.getLength()) {
            Element plugin = WorklistModelXMLImport.getElement(plugins.item(i));
            String pluginID = plugin.getFirstChild().getTextContent();
            if (!res.containsKey(pluginID)) {
                HashMap<String, String> data = new HashMap<String, String>();
                NodeList plugindDatas = plugin.getElementsByTagName("pluginData");
                int j = 0;
                while (j < plugindDatas.getLength()) {
                    Element pluginData = WorklistModelXMLImport.getElement(plugindDatas.item(j));
                    String key = pluginData.getTextContent();
                    String value = pluginData.getAttribute("value");
                    data.put(key, value);
                    ++j;
                }
                DefaultPluginData pluginData = new DefaultPluginData(pluginID, data);
                res.put(pluginID, pluginData);
            }
            ++i;
        }
        return res;
    }

    private Serializable getParameterValue(ProcessConstants.AdeptDataType type, Element child) {
        Object value = null;
        if (!Boolean.parseBoolean(child.getAttribute("isNull"))) {
            try {
                switch (type) {
                    case BOOLEAN: {
                        value = Boolean.valueOf(child.getTextContent());
                        break;
                    }
                    case DATE: {
                        value = new Date(Long.parseLong(child.getTextContent()));
                        break;
                    }
                    case FLOAT: {
                        value = Double.valueOf(child.getTextContent());
                        break;
                    }
                    case INTEGER: {
                        value = Long.valueOf(child.getTextContent());
                        break;
                    }
                    case STRING: {
                        value = child.getTextContent();
                        break;
                    }
                    case URI: {
                        value = URI.create(child.getTextContent());
                        break;
                    }
                    case USERDEFINED: {
                        String ud_type = child.getAttribute("parameterUDT");
                        value = new ADEPT2UDTValue(ud_type, Base64.decode(child.getTextContent()));
                        break;
                    }
                    default: {
                        String msg = String.format("Unsupported data type '%s'!", new Object[]{type});
                        this.logger.warning(msg);
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.warning("Error while restoring a parameter of a worklist item.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.warning("Error while restoring a parameter of a worklist item.");
            }
        }
        return value;
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        this.logger.severe(spe.toString());
        throw spe;
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXException {
        this.logger.severe(spe.toString());
        throw spe;
    }

    @Override
    public void warning(SAXParseException spe) throws SAXException {
        this.logger.severe(spe.toString());
        throw spe;
    }

    private InputStream checkStreamForData(InputStream is) {
        try {
            int fir = is.read();
            int sec = is.read();
            if (sec != -1) {
                PushbackInputStream pis = new PushbackInputStream(is, 2);
                pis.unread(sec);
                pis.unread(fir);
                return pis;
            }
            is.close();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "An IOException occurred while trying to check whether the input stream contains XML data.", e);
        }
        return null;
    }
}

