/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.components;

import de.aristaflow.adept2.Activator;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelException;
import de.aristaflow.adept2.model.logmanagement.LogEntry;
import de.aristaflow.adept2.model.logmanagement.LogEntrySet;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.ListUIComponent;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.widgets.Composite;

public class InstanceHistoryUIComponent
extends ListUIComponent {
    protected Logger logger = LoggerTools.getLogger(this);

    public InstanceHistoryUIComponent(Composite parent, int style) {
        super(parent, 0x10000 | style);
    }

    @Override
    protected void registerColumns() {
        String key = "timestamp";
        this.registerColumn(key, key, 0, new ColumnData(), (CellLabelProvider)new ExecutionHistoryLabelProvider(key), null);
        key = "stateChange";
        this.registerColumn(key, key, 0, new ColumnData(), (CellLabelProvider)new ExecutionHistoryLabelProvider(key), null);
        key = "nodeName";
        this.registerColumn(key, key, 0, new ColumnData(), (CellLabelProvider)new ExecutionHistoryLabelProvider(key), null);
        key = "nodeID";
        this.registerColumn(key, key, 0, new ColumnData(), (CellLabelProvider)new ExecutionHistoryLabelProvider(key), null);
        key = "iteration";
        this.registerColumn(key, key, 0, new ColumnData(), (CellLabelProvider)new ExecutionHistoryLabelProvider(key), null);
        key = "agentID";
        this.registerColumn(key, key, 0, new ColumnData(), (CellLabelProvider)new ExecutionHistoryLabelProvider(key), null);
        key = "agentOrgPositionID";
        this.registerColumn(key, key, 0, new ColumnData(), (CellLabelProvider)new ExecutionHistoryLabelProvider(key), null);
    }

    @Override
    public void setInput(Object input) {
        if (!(input instanceof LogEntrySet)) {
            String msg = "only accepts an instance history in the form of a LogEntrySet";
            throw new IllegalArgumentException(msg);
        }
        LogEntrySet instanceHistory = (LogEntrySet)input;
        LogEntry[] logEntries = new LogEntry[instanceHistory.getEntryCount()];
        int i = 0;
        while (i < instanceHistory.getEntryCount()) {
            logEntries[i] = instanceHistory.getCursor(i);
            ++i;
        }
        super.setInput(logEntries);
    }

    private class ExecutionHistoryLabelProvider
    extends ColumnLabelProvider {
        private String columnName;

        public ExecutionHistoryLabelProvider(String columnName) {
            ArgChecks.checkForNull(columnName, "columnName");
            this.columnName = columnName;
        }

        public String getText(Object element) {
            LogEntry logEntry = (LogEntry)element;
            if (this.columnName.equals("stateChange")) {
                return ExecutionHistory.StateChange.valueOf(logEntry.getByte("stateChange")).toString();
            }
            if (this.columnName.equals("agentOrgPositionID")) {
                Object orgpositionIDO = logEntry.get("agentOrgPositionID");
                if (orgpositionIDO == null) {
                    return "";
                }
                long orgpositionID = (Long)orgpositionIDO;
                try {
                    Entity orgPos = Activator.getAdministrationService().getOrgModelManager().getModelExplorer().getEntity(Activator.getAdministrationService().getSessionToken(), EntityType.ORG_POSITION, orgpositionID, new String[0]);
                    return String.valueOf(orgPos.getString("name")) + " (" + orgpositionID + ")";
                }
                catch (OrgModelException e) {
                    InstanceHistoryUIComponent.this.logger.log(Level.WARNING, "Unable to retrieve entity from orgmodel, ID: " + orgpositionID, e);
                    return "" + orgpositionID;
                }
                catch (DataSourceException dataSourceException) {
                    return "" + orgpositionID;
                }
            }
            if (this.columnName.equals("agentID")) {
                Object agentIDO = logEntry.get("agentID");
                if (agentIDO == null) {
                    return "";
                }
                long agentID = (Long)agentIDO;
                try {
                    Entity agent = Activator.getAdministrationService().getOrgModelManager().getModelExplorer().getEntity(Activator.getAdministrationService().getSessionToken(), EntityType.AGENT, agentID, new String[0]);
                    return String.valueOf(agent.getString("username")) + " (" + agentID + ")";
                }
                catch (OrgModelException orgModelException) {
                    return "" + agentID;
                }
                catch (DataSourceException dataSourceException) {
                    return "" + agentID;
                }
            }
            Object value = logEntry.get(this.columnName);
            if (value == null) {
                return "";
            }
            return value.toString();
        }
    }
}

