/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.components;

import de.aristaflow.adept2.Activator;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.AttributeFactory;
import de.aristaflow.adept2.model.filter.ComparisonFilter;
import de.aristaflow.adept2.model.filter.ComparisonOperator;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.filter.MultipleFilterFilter;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.AdeptFilterWrapper;
import de.aristaflow.adept2.ui.util.list.FilteredListUIComponent;
import de.aristaflow.adept2.ui.util.list.QuickSearchFilterProvider;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class InstanceReferenceListUIComponent
extends FilteredListUIComponent {
    public static final String COL_ID = "id";
    public static final String COL_LOG_ID = "logId";
    public static final String COL_NAME = "name";
    public static final String COL_EXECUTION_STATUS = "executionStatus";
    public static final String COL_TEMPLATE_ID = "templateId";
    public static final String COL_TEMPLATE_NAME = "templateName";
    public static final String COL_PROCESS_TYPE = "processType";
    public static final String COL_TEMPLATE_VERSION = "templateVersion";
    public static final String COL_CREATION_TIME = "creationTime";
    public static final String COL_INITIATOR = "initiator";
    public static final String COL_SUPERVISOR = "supervisor";
    public static final String COL_PARENT_ID = "parentId";

    public InstanceReferenceListUIComponent(Composite parent, int style) {
        super(parent, style | 0x10000, new InstanceQuickSearchProvider());
    }

    @Override
    protected void registerColumns() {
        this.registerColumn(COL_ID, "ID", 0, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                return instance.getID().toString();
            }
        }, null);
        this.registerColumn(COL_LOG_ID, "Log ID", 0, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                return instance.getLogID().toString();
            }
        }, null);
        this.registerColumn(COL_NAME, "Name", 0, new ColumnData(1.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                return instance.getName();
            }
        }, null);
        this.registerColumn(COL_EXECUTION_STATUS, "Execution Status", 0, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                return instance.getExecutionStatus().readableName;
            }
        }, null);
        this.registerColumn(COL_TEMPLATE_ID, "Template ID", 0, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                return instance.getTemplate().getID().toString();
            }
        }, null);
        this.registerColumn(COL_TEMPLATE_NAME, "Template Name", 0, new ColumnData(1.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                return instance.getTemplate().getName();
            }
        }, null);
        this.registerColumn(COL_PROCESS_TYPE, "Process Type", 0, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                TemplateReference template = instance.getTemplate();
                String processType = template.getProcessType();
                if (processType == null || processType.equals("")) {
                    processType = "none";
                }
                return processType;
            }
        }, null);
        this.registerColumn(COL_TEMPLATE_VERSION, "Template Version", 0, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                TemplateReference template = instance.getTemplate();
                String version = template.getVersion();
                return version;
            }
        }, null);
        this.registerColumn(COL_CREATION_TIME, "Creation Time", 0, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return dateFormat.format(new Date(instance.getCreationTime()));
            }
        }, null);
        this.registerColumn(COL_INITIATOR, "Initiator", 0, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                QualifiedAgent agent = instance.getInitiatorAgent();
                return String.valueOf(agent.getAgentUserName()) + " @ " + agent.getOrgPositionName();
            }

            public boolean useNativeToolTip(Object object) {
                return true;
            }

            public String getToolTipText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                return instance.getInitiatorAgent().toString();
            }
        }, null);
        this.registerColumn(COL_SUPERVISOR, "Supervisor", 0, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                QualifiedAgent agent = instance.getSupervisorAgent();
                return String.valueOf(agent.getAgentUserName()) + " @ " + agent.getOrgPositionName();
            }

            public boolean useNativeToolTip(Object object) {
                return true;
            }

            public String getToolTipText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                return instance.getSupervisorAgent().toString();
            }
        }, null);
        this.registerColumn(COL_PARENT_ID, "Parent Instance ID", 0, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InstanceReference instance = (InstanceReference)element;
                UUID parentInstanceID = instance.getParentInstanceID();
                if (parentInstanceID == null) {
                    return null;
                }
                return parentInstanceID.toString();
            }
        }, null);
    }

    protected static class InstanceQuickSearchProvider
    implements QuickSearchFilterProvider {
        private final FilterFactory filterFac;
        private List<Attribute> attributes = new ArrayList<Attribute>();

        public InstanceQuickSearchProvider() {
            this.filterFac = Activator.getAdministrationService().getFilterFactory();
            AttributeFactory af = this.filterFac.createAttributeFactory(InstanceReference.class);
            this.attributes.add(af.selectAttribute("getID"));
            this.attributes.add(af.selectAttribute("getLogID"));
            this.attributes.add(af.selectAttribute("getName"));
            af.goDownAndCast("getSupervisorAgent", QualifiedAgent.class);
            this.attributes.add(af.selectAttribute("getAgentUserName"));
            this.attributes.add(af.selectAttribute("getOrgPositionName"));
            af.goUp();
            af.goDownAndCast("getInitiatorAgent", QualifiedAgent.class);
            this.attributes.add(af.selectAttribute("getAgentUserName"));
            this.attributes.add(af.selectAttribute("getOrgPositionName"));
            af.goUp();
        }

        @Override
        public ViewerFilter getQuickSearchFilter(String filterString) {
            StringBuilder filter = new StringBuilder("*");
            filter.append(filterString);
            filter.append("*");
            ArrayList<ComparisonFilter> filters = new ArrayList<ComparisonFilter>();
            for (Attribute attribute : this.attributes) {
                filters.add(this.filterFac.createComparisonFilter(attribute, ComparisonOperator.LIKE, (Comparable<?>)((Object)filter.toString())));
            }
            MultipleFilterFilter searchFilter = this.filterFac.createOrFilter(filters.toArray(new Filter[filters.size()]));
            return new AdeptFilterWrapper(searchFilter);
        }
    }
}

