/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.components;

import de.aristaflow.adept2.Activator;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.AttributeFactory;
import de.aristaflow.adept2.model.filter.ComparisonFilter;
import de.aristaflow.adept2.model.filter.ComparisonOperator;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.filter.MultipleFilterFilter;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.AdeptFilterWrapper;
import de.aristaflow.adept2.ui.util.list.FilteredListUIComponent;
import de.aristaflow.adept2.ui.util.list.QuickSearchFilterProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class TemplateReferenceListUIComponent
extends FilteredListUIComponent {
    public static final String COL_ID = "id";
    public static final String COL_NAME = "name";
    public static final String COL_DESCRIPTION = "description";
    public static final String COL_PROCESS_TYPE = "processType";
    public static final String COL_VERSION = "version";
    public static final String COL_OUTDATED = "outdated";
    public static final String COL_INSTANTIABLE = "instantiable";
    public static final String COL_SUPERVISOR = "supervisor";
    private ResourceBundle messages;

    public TemplateReferenceListUIComponent(Composite parent, int style) {
        super(parent, style | 0x10000, new TemplateQuickSearchProvider());
    }

    @Override
    protected void registerColumns() {
        this.messages = ResourceBundle.getBundle("de.aristaflow.adept2.ui.components.TRLBundle", Activator.getAdministrationService().getActiveAgent().getLocale());
        String columnKey = COL_ID;
        this.registerColumn(columnKey, this.messages.getString(columnKey), 16384, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TemplateReference template = (TemplateReference)element;
                return template.getID().toString();
            }
        }, null);
        columnKey = COL_NAME;
        this.registerColumn(columnKey, this.messages.getString(columnKey), 16384, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TemplateReference template = (TemplateReference)element;
                return template.getName();
            }
        }, null);
        columnKey = COL_DESCRIPTION;
        this.registerColumn(columnKey, this.messages.getString(columnKey), 16384, new ColumnData(100, 4.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TemplateReference template = (TemplateReference)element;
                return template.getDescription();
            }
        }, null);
        columnKey = COL_PROCESS_TYPE;
        this.registerColumn(columnKey, this.messages.getString(columnKey), 16384, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TemplateReference template = (TemplateReference)element;
                return template.getProcessType();
            }
        }, null);
        columnKey = COL_VERSION;
        this.registerColumn(columnKey, this.messages.getString(columnKey), 16384, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TemplateReference template = (TemplateReference)element;
                return template.getVersion();
            }
        }, null);
        columnKey = COL_OUTDATED;
        this.registerColumn(columnKey, this.messages.getString(columnKey), 0x1000000, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TemplateReference template = (TemplateReference)element;
                return String.valueOf(TemplateReferenceListUIComponent.this.yesNo(template.isOutdated(false))) + " / " + TemplateReferenceListUIComponent.this.yesNo(template.isOutdated(true));
            }
        }, null);
        columnKey = COL_INSTANTIABLE;
        this.registerColumn(columnKey, this.messages.getString(columnKey), 0x1000000, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TemplateReference template = (TemplateReference)element;
                return String.valueOf(TemplateReferenceListUIComponent.this.yesNo(template.isInstantiable(false))) + " / " + TemplateReferenceListUIComponent.this.yesNo(template.isInstantiable(true));
            }
        }, null);
        columnKey = COL_SUPERVISOR;
        this.registerColumn(columnKey, this.messages.getString(columnKey), 0, null, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TemplateReference template = (TemplateReference)element;
                QualifiedAgent agent = template.getSupervisorAgent();
                return String.valueOf(agent.getAgentUserName()) + " @ " + agent.getOrgPositionName();
            }

            public boolean useNativeToolTip(Object object) {
                return true;
            }

            public String getToolTipText(Object element) {
                TemplateReference template = (TemplateReference)element;
                return template.getSupervisorAgent().toString();
            }
        }, null);
    }

    String yesNo(boolean yesNo) {
        return yesNo ? this.messages.getString("yes") : this.messages.getString("no");
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    protected static class TemplateQuickSearchProvider
    implements QuickSearchFilterProvider {
        private final FilterFactory filterFac;
        private List<Attribute> attributes = new ArrayList<Attribute>();

        public TemplateQuickSearchProvider() {
            this.filterFac = Activator.getAdministrationService().getFilterFactory();
            AttributeFactory af = this.filterFac.createAttributeFactory(TemplateReference.class);
            this.attributes.add(af.selectAttribute("getID"));
            this.attributes.add(af.selectAttribute("getName"));
            this.attributes.add(af.selectAttribute("getDescription"));
            this.attributes.add(af.selectAttribute("getProcessType"));
            af.goDownAndCast("getSupervisorAgent", QualifiedAgent.class);
            this.attributes.add(af.selectAttribute("getAgentUserName"));
            this.attributes.add(af.selectAttribute("getOrgPositionName"));
            af.goUp();
        }

        @Override
        public ViewerFilter getQuickSearchFilter(String filterString) {
            StringBuilder filter = new StringBuilder("*");
            filter.append(filterString);
            filter.append("*");
            ArrayList<ComparisonFilter> filters = new ArrayList<ComparisonFilter>();
            for (Attribute attribute : this.attributes) {
                filters.add(this.filterFac.createComparisonFilter(attribute, ComparisonOperator.LIKE, (Comparable<?>)((Object)filter.toString())));
            }
            MultipleFilterFilter searchFilter = this.filterFac.createOrFilter(filters.toArray(new Filter[filters.size()]));
            return new AdeptFilterWrapper(searchFilter);
        }
    }
}

