/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.dialogues;

import de.aristaflow.adept2.util.CheckReport;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CheckReportDialogue
extends Dialog {
    private final CheckReport checkReport;
    private TableViewer checkReportTableViewer;
    private String message;
    private int icon;
    private CheckReport.ResultType level;

    public CheckReportDialogue(Shell parentShell, CheckReport checkReport, String message, int icon, CheckReport.ResultType level) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.checkReport = checkReport;
        this.message = message;
        this.icon = icon;
        this.level = level;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Check report for the template");
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Composite container = toolkit.createComposite(parent, 2048);
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.marginWidth = 20;
        containerLayout.marginHeight = 20;
        containerLayout.horizontalSpacing = 10;
        containerLayout.verticalSpacing = 7;
        container.setLayout((Layout)containerLayout);
        GridData data = new GridData(4, 4, true, true);
        if (this.checkReport.getReportEntries().size() > 15) {
            data.heightHint = 500;
        }
        data.widthHint = 700;
        container.setLayoutData((Object)data);
        Label label = toolkit.createLabel(container, "");
        label.setImage(this.getShell().getDisplay().getSystemImage(this.icon));
        label = toolkit.createLabel(container, this.message, 1);
        label.setFont(JFaceResources.getBannerFont());
        Label label_spacer = toolkit.createLabel(container, "", 258);
        GridData layoutData = new GridData(4, 4, false, false);
        layoutData.heightHint = 10;
        layoutData.horizontalSpan = 2;
        label_spacer.setLayoutData((Object)layoutData);
        Table table = toolkit.createTable(container, 65540);
        layoutData = new GridData(4, 4, true, true);
        layoutData.verticalSpan = 5;
        layoutData.widthHint = 500;
        layoutData.horizontalSpan = 2;
        table.setLayoutData((Object)layoutData);
        this.checkReportTableViewer = new TableViewer(table);
        TableColumn columnTypeIcon = new TableColumn(table, 0x1000000);
        columnTypeIcon.setText("Type");
        TableColumn columnCheckID = new TableColumn(table, 16384);
        columnCheckID.setText("Check ID");
        TableColumn columnMessage = new TableColumn(table, 16384);
        columnMessage.setText("Message");
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.checkReportTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.checkReportTableViewer.setLabelProvider((IBaseLabelProvider)new CheckReportTableLabelProvider());
        LinkedList<CheckReport.ReportEntry> criticalReportEntries = new LinkedList<CheckReport.ReportEntry>();
        for (CheckReport.ReportEntry entry : this.checkReport.getReportEntries()) {
            CheckReport.ResultType type = entry.getReportEntryType();
            if (type.ordinal() < this.level.ordinal()) continue;
            criticalReportEntries.add(entry);
        }
        this.checkReportTableViewer.setInput(criticalReportEntries);
        columnTypeIcon.pack();
        columnCheckID.pack();
        columnMessage.pack();
        return container;
    }

    class CheckReportTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        CheckReportTableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof CheckReport.ReportEntry)) {
                throw new RuntimeException("getColumnText: element is not of type ReportEntry!");
            }
            CheckReport.ReportEntry entry = (CheckReport.ReportEntry)element;
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return entry.getCheckID();
                }
                case 2: {
                    return entry.getMessage();
                }
            }
            return "Invalid column: " + columnIndex;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (!(element instanceof CheckReport.ReportEntry)) {
                throw new RuntimeException("getColumnText: element is not of type ReportEntry!");
            }
            CheckReport.ReportEntry entry = (CheckReport.ReportEntry)element;
            switch (columnIndex) {
                case 0: {
                    switch (entry.getReportEntryType()) {
                        case OK: {
                            Image icon = CheckReportDialogue.this.getShell().getDisplay().getSystemImage(16);
                            return new Image(icon.getDevice(), icon.getImageData().scaledTo(16, 16));
                        }
                        case INFO: {
                            Image icon = CheckReportDialogue.this.getShell().getDisplay().getSystemImage(2);
                            return new Image(icon.getDevice(), icon.getImageData().scaledTo(16, 16));
                        }
                        case WARNING: {
                            Image icon = CheckReportDialogue.this.getShell().getDisplay().getSystemImage(8);
                            return new Image(icon.getDevice(), icon.getImageData().scaledTo(16, 16));
                        }
                        case FAILURE: {
                            Image icon = CheckReportDialogue.this.getShell().getDisplay().getSystemImage(1);
                            return new Image(icon.getDevice(), icon.getImageData().scaledTo(16, 16));
                        }
                    }
                    return null;
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

