/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.dialogues;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.ui.util.columnsort.ColumnComparator;
import de.aristaflow.adept2.ui.util.columnsort.TableColumnSortManager;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class QualifiedAgentDialogue
extends Dialog {
    Set<QualifiedAgent> potentialRecipients;
    Set<QualifiedAgent> selectedRecipients = new HashSet<QualifiedAgent>();
    CheckboxTableViewer tableViewer;
    protected String textValue = null;
    protected Text commentText;
    private ResourceBundle messages = null;
    protected boolean multiSelection;
    protected boolean textField;
    protected boolean textMandatory;
    private final String prefix;
    private QualifiedAgent agent;

    public QualifiedAgentDialogue(Shell parentShell, Set<QualifiedAgent> potentialRecipients, ResourceBundle bundle, String bundlePrefix, boolean multiSelection, boolean textField, boolean textMandatory, QualifiedAgent agent) {
        super(parentShell);
        ArgChecks.checkForNulls(potentialRecipients, "potentialRecipients");
        this.potentialRecipients = potentialRecipients;
        this.messages = bundle;
        if (this.messages == null) {
            throw new RuntimeException("no ressource bundle given");
        }
        this.prefix = bundlePrefix == null ? "" : bundlePrefix;
        this.multiSelection = multiSelection;
        this.textField = textField;
        this.textMandatory = textMandatory;
        this.agent = agent;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.messages.getString(String.valueOf(this.prefix) + ".DlgTitle"));
        Composite dialogueArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)dialogueArea.getLayout();
        layout.marginWidth = 20;
        layout.marginHeight = 10;
        Label label = new Label(dialogueArea, 64);
        GridData layoutData = new GridData(4, 4, true, false);
        label.setLayoutData((Object)layoutData);
        label.setText(this.messages.getString(String.valueOf(this.prefix) + ".DlgLbl"));
        Label label_spacer = new Label(dialogueArea, 258);
        layoutData = new GridData(4, 4, false, false);
        layoutData.heightHint = 10;
        label_spacer.setLayoutData((Object)layoutData);
        Table table = this.multiSelection ? new Table(dialogueArea, 67616) : new Table(dialogueArea, 67584);
        table.setHeaderVisible(true);
        TableColumn columnAgentName = new TableColumn(table, 16384);
        columnAgentName.setText(this.messages.getString(String.valueOf(this.prefix) + ".AgentNameCol"));
        TableColumn columnAgentID = new TableColumn(table, 131072);
        columnAgentID.setText(this.messages.getString(String.valueOf(this.prefix) + ".AgentIDCol"));
        TableColumn columnOrgPositionName = new TableColumn(table, 16384);
        columnOrgPositionName.setText(this.messages.getString(String.valueOf(this.prefix) + ".OrgPosCol"));
        layoutData = new GridData(4, 4, false, false);
        layoutData.heightHint = 20 * table.getItemHeight();
        table.setLayoutData((Object)layoutData);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setComparator(new ViewerComparator());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new QualifiedAgentLabelProvider());
        this.tableViewer.setInput(this.potentialRecipients);
        if (this.agent != null) {
            StructuredSelection sel = new StructuredSelection((Object)this.agent);
            this.tableViewer.setSelection((ISelection)sel);
            this.tableViewer.setChecked((Object)this.agent, true);
        }
        if (this.multiSelection) {
            this.tableViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (QualifiedAgentDialogue.this.tableViewer.getCheckedElements().length > 0) {
                        if (QualifiedAgentDialogue.this.textMandatory) {
                            if (QualifiedAgentDialogue.this.commentText.getText().length() > 0) {
                                QualifiedAgentDialogue.this.getButton(0).setEnabled(true);
                            } else {
                                QualifiedAgentDialogue.this.getButton(0).setEnabled(false);
                            }
                        } else {
                            QualifiedAgentDialogue.this.getButton(0).setEnabled(true);
                        }
                    } else {
                        QualifiedAgentDialogue.this.getButton(0).setEnabled(false);
                    }
                }
            });
        } else {
            this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (!QualifiedAgentDialogue.this.tableViewer.getSelection().isEmpty()) {
                        if (QualifiedAgentDialogue.this.textMandatory) {
                            if (QualifiedAgentDialogue.this.commentText.getText().length() > 0) {
                                QualifiedAgentDialogue.this.getButton(0).setEnabled(true);
                            } else {
                                QualifiedAgentDialogue.this.getButton(0).setEnabled(false);
                            }
                        } else {
                            QualifiedAgentDialogue.this.getButton(0).setEnabled(true);
                        }
                    } else {
                        QualifiedAgentDialogue.this.getButton(0).setEnabled(false);
                    }
                }
            });
            this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (!QualifiedAgentDialogue.this.tableViewer.getSelection().isEmpty() && QualifiedAgentDialogue.this.textMandatory && QualifiedAgentDialogue.this.commentText.getText().length() > 0 || !QualifiedAgentDialogue.this.textMandatory) {
                        QualifiedAgentDialogue.this.okPressed();
                    }
                }
            });
        }
        TableColumnSortManager tableSortManager = new TableColumnSortManager((TableViewer)this.tableViewer);
        tableSortManager.addColumn((Item)columnAgentName, new QualifiedAgent_agentUserNameComparator());
        tableSortManager.addColumn((Item)columnAgentID, new QualifiedAgent_agentIDComparator());
        tableSortManager.addColumn((Item)columnOrgPositionName, new QualifiedAgent_agentOrgPositionNameComparator());
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        if (this.textField) {
            Label questionLabel = new Label(dialogueArea, 0);
            layoutData = new GridData(4, 4, true, true);
            questionLabel.setLayoutData((Object)layoutData);
            questionLabel.setText(this.messages.getString(String.valueOf(this.prefix) + ".TextLbl"));
            this.commentText = new Text(dialogueArea, 2624);
            layoutData = new GridData(4, 4, false, true);
            layoutData.heightHint = 60;
            this.commentText.setLayoutData((Object)layoutData);
            if (this.textMandatory) {
                this.commentText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (e.getSource() instanceof Text) {
                            Text text = (Text)e.getSource();
                            if (text.getText().length() > 0) {
                                if (QualifiedAgentDialogue.this.multiSelection) {
                                    if (QualifiedAgentDialogue.this.tableViewer.getCheckedElements().length != 0) {
                                        QualifiedAgentDialogue.this.getButton(0).setEnabled(true);
                                    } else {
                                        QualifiedAgentDialogue.this.getButton(0).setEnabled(false);
                                    }
                                } else if (!QualifiedAgentDialogue.this.tableViewer.getSelection().isEmpty()) {
                                    QualifiedAgentDialogue.this.getButton(0).setEnabled(true);
                                } else {
                                    QualifiedAgentDialogue.this.getButton(0).setEnabled(false);
                                }
                            } else {
                                QualifiedAgentDialogue.this.getButton(0).setEnabled(false);
                            }
                        }
                    }
                });
            }
        }
        return dialogueArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okBtn = this.createButton(parent, 0, this.messages.getString(String.valueOf(this.prefix) + ".StartBtn"), true);
        if (!this.tableViewer.getSelection().isEmpty() && !this.textMandatory) {
            okBtn.setEnabled(true);
        } else {
            okBtn.setEnabled(false);
        }
        this.createButton(parent, 1, this.messages.getString(String.valueOf(this.prefix) + ".CancelBtn"), false);
    }

    protected void okPressed() {
        this.selectedRecipients.clear();
        if (this.multiSelection) {
            Object[] elements;
            Object[] objectArray = elements = this.tableViewer.getCheckedElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.selectedRecipients.add((QualifiedAgent)element);
                ++n2;
            }
        } else {
            StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
            this.selectedRecipients.add((QualifiedAgent)selection.getFirstElement());
        }
        if (this.textField) {
            this.textValue = this.commentText.getText();
        }
        if (this.selectedRecipients.size() > 0) {
            super.okPressed();
        }
    }

    public Set<QualifiedAgent> getSelectedAgents() {
        return this.selectedRecipients;
    }

    public String getUserText() {
        return this.textValue;
    }

    static class QualifiedAgentLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        QualifiedAgentLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            QualifiedAgent agent = (QualifiedAgent)element;
            switch (columnIndex) {
                case 0: {
                    return agent.getAgentUserName();
                }
                case 1: {
                    return Long.toString(agent.getAgentID());
                }
                case 2: {
                    return agent.getOrgPositionName();
                }
                case 3: {
                    return Long.toString(agent.getOrgPositionID());
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    static class QualifiedAgent_agentIDComparator
    extends ColumnComparator {
        QualifiedAgent_agentIDComparator() {
        }

        @Override
        protected int compareAscending(ColumnViewer viewer, Object e1, Object e2) {
            QualifiedAgent agent1 = (QualifiedAgent)e1;
            QualifiedAgent agent2 = (QualifiedAgent)e2;
            long diff = agent2.getAgentID() - agent1.getAgentID();
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }

    static class QualifiedAgent_agentOrgPositionNameComparator
    extends ColumnComparator {
        QualifiedAgent_agentOrgPositionNameComparator() {
        }

        @Override
        protected int compareAscending(ColumnViewer viewer, Object e1, Object e2) {
            QualifiedAgent agent1 = (QualifiedAgent)e1;
            QualifiedAgent agent2 = (QualifiedAgent)e2;
            return agent1.getOrgPositionName().compareTo(agent2.getOrgPositionName());
        }
    }

    static class QualifiedAgent_agentUserNameComparator
    extends ColumnComparator {
        QualifiedAgent_agentUserNameComparator() {
        }

        @Override
        protected int compareAscending(ColumnViewer viewer, Object e1, Object e2) {
            QualifiedAgent agent1 = (QualifiedAgent)e1;
            QualifiedAgent agent2 = (QualifiedAgent)e2;
            return agent1.getAgentUserName().compareTo(agent2.getAgentUserName());
        }
    }
}

