/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.dialogues;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.AttributeFactory;
import de.aristaflow.adept2.model.filter.ComparisonFilter;
import de.aristaflow.adept2.model.filter.ComparisonOperator;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.filter.MultipleFilterFilter;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.AdeptFilterWrapper;
import de.aristaflow.adept2.ui.util.list.FilteredListUIComponent;
import de.aristaflow.adept2.ui.util.list.QuickSearchFilterProvider;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SelectIdentifierDialogue
extends Dialog {
    final FilterFactory filterFactory;
    Identifier identifier;
    private UUID identifierID;
    private boolean enableNoneEntry;
    final SessionToken session;
    String pluginID;
    List<Identifier> identifiers;
    final CreateNewIdentifierHandler actionOnCreateNew;

    public SelectIdentifierDialogue(SessionToken session, Shell parentShell, String pluginID, Collection<Identifier> identifiers, FilterFactory filterFactory, UUID identifierID, boolean enableNoneEntry, CreateNewIdentifierHandler actionOnCreateNew) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.actionOnCreateNew = actionOnCreateNew;
        this.session = session;
        this.pluginID = pluginID;
        this.filterFactory = filterFactory;
        this.identifierID = identifierID;
        this.enableNoneEntry = enableNoneEntry;
        this.identifiers = new LinkedList<Identifier>(identifiers);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Select parameter identifier");
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Composite container = toolkit.createComposite(parent, 2048);
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.marginWidth = 15;
        containerLayout.marginHeight = 15;
        containerLayout.horizontalSpacing = 10;
        containerLayout.verticalSpacing = 7;
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        final IdentifierListUIComponent viewer = new IdentifierListUIComponent(container, this.filterFactory);
        final Table columnControl = (Table)viewer.getColumnControl();
        columnControl.setLinesVisible(true);
        columnControl.setHeaderVisible(true);
        if (this.enableNoneEntry) {
            this.identifiers.add(new Identifier(){
                private static final long serialVersionUID = 3707072924098856398L;

                @Override
                public String getDescription() {
                    return "";
                }

                @Override
                public UUID getID() {
                    return null;
                }

                @Override
                public String getName() {
                    return "<none>";
                }

                @Override
                public void setDescription(String description) {
                }

                @Override
                public void setName(String name) {
                }

                @Override
                public String getUserAttributeValue(String attributeName) {
                    return null;
                }

                @Override
                public Map<String, String> getUserAttributes() {
                    return null;
                }

                @Override
                public void removeUserAttributeValue(String attributeName) {
                }

                @Override
                public void setUserAttributeValue(String attributeName, String attributeValue) {
                }

                @Override
                public long getRevision() {
                    return 0L;
                }

                @Override
                public State getState() {
                    return null;
                }

                @Override
                public PluginData getPluginData(String pluginID) {
                    return null;
                }

                @Override
                public Map<String, PluginData> getPluginDatas() {
                    return null;
                }

                @Override
                public Map<String, Set<String>> getSupportedPlugins() {
                    return null;
                }
            });
        }
        viewer.setInput(this.identifiers);
        for (Identifier identifier : this.identifiers) {
            if (identifier.getName().equals("<none>") || !identifier.getID().equals(this.identifierID)) continue;
            viewer.getColumnViewer().setSelection((ISelection)new StructuredSelection((Object)identifier));
            this.identifier = identifier;
            break;
        }
        GridData layout = new GridData(4, 4, true, true);
        layout.widthHint = 360;
        layout.heightHint = 300;
        viewer.getControl().setLayoutData((Object)layout);
        this.packTableColumns(columnControl);
        if (viewer.getColumnViewer().getSelection().isEmpty() && this.identifiers.size() > 0) {
            viewer.getColumnViewer().setSelection((ISelection)new StructuredSelection((Object)this.identifiers.get(0)));
            this.identifier = this.identifiers.get(0);
        }
        viewer.getColumnViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    SelectIdentifierDialogue.this.identifier = (Identifier)sel.getFirstElement();
                    SelectIdentifierDialogue.this.enableButton(0, true);
                } else {
                    SelectIdentifierDialogue.this.enableButton(0, false);
                }
            }
        });
        viewer.getColumnViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                SelectIdentifierDialogue.this.identifier = (Identifier)sel.getFirstElement();
                SelectIdentifierDialogue.this.setReturnCode(0);
                SelectIdentifierDialogue.this.close();
            }
        });
        if (this.actionOnCreateNew != null) {
            Button btnAdd = toolkit.createButton(container, "&Add new Identifier", 0x800000);
            layout = new GridData(131072, 1, false, false);
            layout.verticalIndent = 10;
            btnAdd.setLayoutData((Object)layout);
            btnAdd.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    Identifier newIdentifier;
                    try {
                        newIdentifier = SelectIdentifierDialogue.this.actionOnCreateNew.createNewIdentifier();
                    }
                    catch (Exception exp) {
                        StatusTools.handleErrorStatus(SelectIdentifierDialogue.this.pluginID, "Problems occurred while creating a new identifier in the activity repository.", exp);
                        return;
                    }
                    if (newIdentifier != null) {
                        SelectIdentifierDialogue.this.identifiers.add(newIdentifier);
                        viewer.getColumnViewer().refresh();
                        viewer.getColumnViewer().setSelection((ISelection)new StructuredSelection((Object)newIdentifier));
                        SelectIdentifierDialogue.this.packTableColumns(columnControl);
                        SelectIdentifierDialogue.this.identifier = newIdentifier;
                    }
                }
            });
        }
        toolkit.paintBordersFor(container);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void enableButton(int buttonID, boolean enable) {
        this.getButton(buttonID).setEnabled(enable);
    }

    public Identifier getIdentifier() {
        if (this.identifier.getName().equals("<none>")) {
            return null;
        }
        return this.identifier;
    }

    void packTableColumns(Table table) {
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumn(i).pack();
            ++i;
        }
    }

    public static interface CreateNewIdentifierHandler {
        public Identifier createNewIdentifier() throws Exception;
    }

    public class IdentifierListUIComponent
    extends FilteredListUIComponent {
        public static final String COL_IDENTIFIER_NAME = "name";
        public static final String COL_IDENTIFIER_DESCRIPTION = "description";

        public IdentifierListUIComponent(Composite parent, FilterFactory filterFactory) {
            super(Table.class, parent, 67584, new IdentifierQuickSearchProvider(filterFactory));
            this.initColumns(null, null, COL_IDENTIFIER_NAME, true);
        }

        @Override
        protected void registerColumns() {
            super.registerColumns();
            this.registerColumn(COL_IDENTIFIER_NAME, "Name", 16384, new ColumnData(1.0f), (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((Identifier)element).getName();
                }
            }, null);
            this.registerColumn(COL_IDENTIFIER_DESCRIPTION, "Description", 16384, new ColumnData(1.0f), (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((Identifier)element).getDescription();
                }
            }, null);
        }
    }

    protected class IdentifierQuickSearchProvider
    implements QuickSearchFilterProvider {
        private final FilterFactory filterFac;
        private final Attribute nameAttribute;
        private final Attribute descriptionAttribute;

        public IdentifierQuickSearchProvider(FilterFactory filterFactory) {
            this.filterFac = filterFactory;
            AttributeFactory afTempl = filterFactory.createAttributeFactory(Identifier.class);
            this.nameAttribute = afTempl.selectAttribute("getName");
            this.descriptionAttribute = afTempl.selectAttribute("getDescription");
        }

        @Override
        public ViewerFilter getQuickSearchFilter(String filterString) {
            StringBuilder filter = new StringBuilder("*");
            filter.append(filterString);
            filter.append("*");
            ComparisonFilter nameFilter = this.filterFac.createComparisonFilter(this.nameAttribute, ComparisonOperator.LIKE, (Comparable<?>)((Object)filter.toString()));
            ComparisonFilter descriptionFilter = this.filterFac.createComparisonFilter(this.descriptionAttribute, ComparisonOperator.LIKE, (Comparable<?>)((Object)filter.toString()));
            MultipleFilterFilter searchFilter = this.filterFac.createOrFilter(nameFilter, descriptionFilter);
            return new AdeptFilterWrapper(searchFilter);
        }
    }
}

